#include "maillist.h"
#include <stdio.h>
#include <stdlib.h>

@interface SmartList : MailList
@end

@implementation SmartList
- (BOOL) sendControlMessage:(id) persona
			   :(const char *) ctlmsg
			   :(const char *) data
{
  FILE *mailout;
  char subj[256];

  g_snprintf(subj, sizeof(subj), "%s %s",
	     ctlmsg,
	     data?data:"");
  mailout = [self sendMail:persona
		  :[self getControlAddress]
		  :subj];
  if(mailout) {
    fprintf(mailout,
	    "This subscription request was generated by the GNOME mailman for %s <%s>.\n",
	    [persona getFullName],
	    [persona getEmailAddress]);
    pclose(mailout);
    return TRUE;
  } else
    return FALSE;
}
@end
