/* vi:set ts=8 sts=0 sw=8:
 * $Id: randomtips.c,v 1.8 2000/01/19 17:31:50 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "main.h"
#ifdef USE_RANDOMTIPS
#include <stdlib.h>
#include <time.h>
#include "config.h"
#include "msgbar.h"
#include "prefs.h"
#include "win.h"
#include "randomtips.h"
#include "gnpintl.h"


/*** local function prototypes ***/
static int random_tips_print(gpointer cbdata);


/*** global function definitions ***/
/*
 * PUBLIC: random_tips_init
 *
 * initializes the timeout call for printing a random tip
 */
void
random_tips_init(win_t *w)
{
	if (!w->rtips_timeout && prefs.random_tips > 0) {
		w->rtips_timeout = gtk_timeout_add(prefs.random_tips * 1000,
					  (GtkFunction)random_tips_print, w);
		srand(time(NULL));
	}
} /* random_tips_init */


/*
 * PUBLIC: random_tips_reset
 *
 * resets the timeout call for printing a random tip
 */
void
random_tips_reset(void *data)
{
	win_t *w = (win_t *)data;

	if (w->rtips_timeout) {
		gtk_timeout_remove(w->rtips_timeout);
		w->rtips_timeout = 0;
	}

	random_tips_init(w);
} /* random_tips_reset */

#ifdef APP_GNP
/* this is dopey, but for now, these are hard coded */
static char *tips[] = {
	N_("Use the \"File Info\" button to Drag and Drop the current doc"),
	N_("Use Options->Preferences to select toolbar buttons"),
	N_("Use Edit->'Insert Shell Output' to insert the date"),
	N_("Set the Advanced HTML Toolbar option for superior HTML editing"),
	"gnotepad+ homepage: "APP_URL,
	NULL
};
#endif	/* APP_GNP */

/*
 * PRIVATE: random_tips_print
 *
 * prints a random tip!
 */
static int
random_tips_print(gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;
	int numtips = (sizeof(tips) / sizeof(tips[0])) - 1;
	int idx = rand() % numtips;

	msgbar_printf(w, "%s", gettext(tips[idx]));
	return 1;
} /* random_tips_print */

#endif	/* USE_RANDOMTIPS */

/* the end */
