/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "io_mpg123.h"

static GtkWidget     *mpg123_vbox = NULL;
static GtkWidget     *mpg123_device_entry;
static GtkAdjustment *mpg123_buffer_adjustment;
static GtkWidget     *mpg123_buffer_spinbutton;
static GtkAdjustment *mpg123_sample_adjustment;
static GtkWidget     *mpg123_sample_spinbutton;

static gint c_mpg123_buffer_enable;
static gint c_mpg123_buffer;
static gint c_mpg123_downsample;
static gint c_mpg123_custom_sample_size;
static gint c_mpg123_mono;
static gint c_mpg123_8bit;
static gint c_mpg123_device_enable;
static gint c_mpg123_aggressive;
static gint c_mpg123_use_freeamp;

static void buffer_enable_clicked(GtkWidget *w, gpointer data);
static void downsample_auto_selected(GtkWidget *w, gpointer data);
static void downsample_22_selected(GtkWidget *w, gpointer data);
static void downsample_11_selected(GtkWidget *w, gpointer data);
static void downsample_custom_selected(GtkWidget *w, gpointer data);
static void mono_enable_clicked(GtkWidget *w, gpointer data);
static void enable_8bit_clicked(GtkWidget *w, gpointer data);
static void device_enable_clicked(GtkWidget *w, gpointer data);
static void aggressive_clicked(GtkWidget *w, gpointer data);
static void freeamp_clicked(GtkWidget *w, gpointer data);

/*
 *----------------------------------------------------------------------------
 * load / save routines
 *----------------------------------------------------------------------------
 */

void mpg123_config_load(FILE *f, gchar *option, gchar *value, gchar *value_all)
{
	mpg123_buffer_enable = read_bool_option(f, option,
		"enable_buffer", value, mpg123_buffer_enable);
	mpg123_buffer = read_int_option(f, option,
		"buffer_size", value, mpg123_buffer);

	if (!strcasecmp(option,"downsample"))
		{
		if (!strcasecmp(value,"auto")) mpg123_downsample = MPG123_DOWNSAMPLE_AUTO;
		if (!strcasecmp(value,"2:1")) mpg123_downsample = MPG123_DOWNSAMPLE_22;
		if (!strcasecmp(value,"4:1")) mpg123_downsample = MPG123_DOWNSAMPLE_11;
		if (!strcasecmp(value,"custom")) mpg123_downsample = MPG123_DOWNSAMPLE_CUSTOM;
		}
	mpg123_custom_sample_size = read_int_option(f, option,
		"custom_sample_size", value, mpg123_custom_sample_size);

	mpg123_mono = read_bool_option(f, option,
		"enable_mono", value, mpg123_mono);
	mpg123_8bit = read_bool_option(f, option,
		"enable_8bit", value, mpg123_8bit);

	mpg123_device_enable = read_bool_option(f, option,
		"enable_specific_device", value, mpg123_device_enable);
	mpg123_device = read_char_option(f, option,
		"specific_device", value_all, mpg123_device);

	mpg123_aggressive = read_bool_option(f, option,
		"mpg123_aggressive", value, mpg123_aggressive);

	mpg123_use_freeamp = read_bool_option(f, option,
		"mpg123_use_freeamp", value, mpg123_use_freeamp);
}

void mpg123_config_save(FILE *f)
{
	fprintf(f,"\n##### MPG123 Output Options #####\n\n");

	write_bool_option(f, "enable_buffer", mpg123_buffer_enable);
	write_int_option(f, "buffer_size", mpg123_buffer);

	fprintf(f,"downsample: ");
	if (mpg123_downsample == MPG123_DOWNSAMPLE_AUTO) fprintf(f,"auto\n");
	if (mpg123_downsample == MPG123_DOWNSAMPLE_22) fprintf(f,"2:1\n");
	if (mpg123_downsample == MPG123_DOWNSAMPLE_11) fprintf(f,"4:1\n");
	if (mpg123_downsample == MPG123_DOWNSAMPLE_CUSTOM) fprintf(f,"custom\n");
	fprintf(f,"\n");
	write_int_option(f, "custom_sample_size", mpg123_custom_sample_size);

	write_bool_option(f, "enable_mono", mpg123_mono);
	write_bool_option(f, "enable_8bit", mpg123_8bit);

	write_bool_option(f, "enable_specific_device", mpg123_device_enable);
	write_char_option(f, "specific_device", mpg123_device);

	write_bool_option(f, "mpg123_aggressive", mpg123_aggressive);

	write_bool_option(f, "mpg123_use_freeamp", mpg123_use_freeamp);
}

/*
 *----------------------------------------------------------------------------
 * config window routines
 *----------------------------------------------------------------------------
 */

static void buffer_enable_clicked(GtkWidget *w, gpointer data)
{
	c_mpg123_buffer_enable = GTK_TOGGLE_BUTTON (w)->active;
}

static void downsample_auto_selected(GtkWidget *w, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(w)->active)
		c_mpg123_downsample = MPG123_DOWNSAMPLE_AUTO;
}

static void downsample_22_selected(GtkWidget *w, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(w)->active)
		c_mpg123_downsample = MPG123_DOWNSAMPLE_22;
}

static void downsample_11_selected(GtkWidget *w, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(w)->active)
		c_mpg123_downsample = MPG123_DOWNSAMPLE_11;
}

static void downsample_custom_selected(GtkWidget *w, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(w)->active)
		c_mpg123_downsample = MPG123_DOWNSAMPLE_CUSTOM;
}

static void mono_enable_clicked(GtkWidget *w, gpointer data)
{
	c_mpg123_mono = GTK_TOGGLE_BUTTON (w)->active;
}

static void enable_8bit_clicked(GtkWidget *w, gpointer data)
{
	c_mpg123_8bit = GTK_TOGGLE_BUTTON (w)->active;
}

static void device_enable_clicked(GtkWidget *w, gpointer data)
{
	c_mpg123_device_enable = GTK_TOGGLE_BUTTON (w)->active;
}

static void aggressive_clicked(GtkWidget *w, gpointer data)
{
	c_mpg123_aggressive = GTK_TOGGLE_BUTTON (w)->active;
}

static void freeamp_clicked(GtkWidget *w, gpointer data)
{
	c_mpg123_use_freeamp = GTK_TOGGLE_BUTTON (w)->active;
}

void mpg123_config_apply()
{
	gchar *buf;

	if (!mpg123_vbox) return;

	mpg123_buffer_enable = c_mpg123_buffer_enable;
	mpg123_buffer = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(mpg123_buffer_spinbutton));
	mpg123_downsample = c_mpg123_downsample;
	mpg123_custom_sample_size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(mpg123_sample_spinbutton));
	mpg123_mono = c_mpg123_mono;
	mpg123_8bit = c_mpg123_8bit;
	mpg123_device_enable = c_mpg123_device_enable;
	mpg123_aggressive = c_mpg123_aggressive;
	mpg123_use_freeamp = c_mpg123_use_freeamp;

	if (mpg123_device)
		{
		g_free(mpg123_device);
		mpg123_device = NULL;
		}
	buf = gtk_entry_get_text(GTK_ENTRY(mpg123_device_entry));
	if (buf && strlen(buf) > 0) mpg123_device = g_strdup(buf);

}

void mpg123_config_close()
{
	mpg123_vbox = NULL;
}

GtkWidget *mpg123_config_init()
{
	GtkWidget *vbox1;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *radiobutton;
	GtkWidget *label;
	GtkWidget *frame;

	mpg123_vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (mpg123_vbox), 5);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	c_mpg123_buffer_enable = mpg123_buffer_enable;
	button = gtk_check_button_new_with_label ("Enable output buffer of size(Kbytes):");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mpg123_buffer_enable);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) buffer_enable_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_mpg123_buffer = mpg123_buffer;
	mpg123_buffer_adjustment = (GtkAdjustment *)gtk_adjustment_new ((float)c_mpg123_buffer,0.0,8192.0,8.0,8.0,8.0);
	mpg123_buffer_spinbutton = gtk_spin_button_new (mpg123_buffer_adjustment, (float)8, 0);
	gtk_widget_set_usize(mpg123_buffer_spinbutton,60,-1);
	gtk_box_pack_start(GTK_BOX(hbox), mpg123_buffer_spinbutton, FALSE, FALSE, 0);
	gtk_widget_show(mpg123_buffer_spinbutton);

	/* downsampling */

	frame = gtk_frame_new("Downsampling");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	c_mpg123_downsample = mpg123_downsample;
	radiobutton = gtk_radio_button_new_with_label (NULL,"Auto or(1:1)");
	if (c_mpg123_downsample == MPG123_DOWNSAMPLE_AUTO) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radiobutton), 1);
	gtk_signal_connect (GTK_OBJECT(radiobutton),"clicked",(GtkSignalFunc) downsample_auto_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), radiobutton, FALSE, FALSE, 0);
	gtk_widget_show(radiobutton);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton)),"22Khz (2:1)");
	if (c_mpg123_downsample == MPG123_DOWNSAMPLE_22) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) downsample_22_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton)),"11Khz (4:1)");
	if (c_mpg123_downsample == MPG123_DOWNSAMPLE_11) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) downsample_11_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton)),"Custom (bits/sec):");
	if (c_mpg123_downsample == MPG123_DOWNSAMPLE_CUSTOM) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) downsample_custom_selected, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_mpg123_custom_sample_size = mpg123_custom_sample_size;
	mpg123_sample_adjustment = (GtkAdjustment *)gtk_adjustment_new ((float)c_mpg123_custom_sample_size,8000.0,49152.0,8.0,8.0,8.0);
	mpg123_sample_spinbutton = gtk_spin_button_new (mpg123_sample_adjustment, (float)8, 0);
	gtk_widget_set_usize(mpg123_sample_spinbutton,60,-1);
	gtk_box_pack_start(GTK_BOX(hbox), mpg123_sample_spinbutton, FALSE, FALSE, 0);
	gtk_widget_show(mpg123_sample_spinbutton);

	c_mpg123_mono = mpg123_mono;
	button = gtk_check_button_new_with_label ("Mix both channels into mono output");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mpg123_mono);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) mono_enable_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_mpg123_8bit = mpg123_8bit;
	button = gtk_check_button_new_with_label ("8-bit output");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mpg123_8bit);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) enable_8bit_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	c_mpg123_device_enable = mpg123_device_enable;
	button = gtk_check_button_new_with_label ("Specific output device:");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mpg123_device_enable);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) device_enable_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	mpg123_device_entry = gtk_entry_new_with_max_length(128);
	if (mpg123_device)
		{
		gtk_entry_set_text(GTK_ENTRY(mpg123_device_entry), mpg123_device);
		}
	gtk_box_pack_start(GTK_BOX(hbox), mpg123_device_entry,TRUE,FALSE,0);
	gtk_widget_show(mpg123_device_entry);

	c_mpg123_aggressive = mpg123_aggressive;
	button = gtk_check_button_new_with_label ("Attempt to get higher priority. (setuid root mpg123 helps here)");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mpg123_aggressive);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) aggressive_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_mpg123_use_freeamp = mpg123_use_freeamp;
	button = gtk_check_button_new_with_label ("Use Freeamp's mpg123 emulation (does not support all options)");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mpg123_use_freeamp);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) freeamp_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	label = gtk_label_new("mpg123 options do not take effect\n until the next song.");
	gtk_box_pack_start(GTK_BOX(mpg123_vbox), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	return mpg123_vbox;
}

