# include "stdio.h"
# define U(x) ((x)&0377)
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern unsigned char yytext[];
int yymorfg;
extern unsigned char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 * parser.l -- lex parser of algebraic chess moves for XBoard
 * $Id: parser.l,v 1.38 1999/02/13 05:49:59 mann Exp $
 *
 * Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
 * Enhancements Copyright 1992-95 Free Software Foundation, Inc.
 *
 * The following terms apply to Digital Equipment Corporation's copyright
 * interest in XBoard:
 * ------------------------------------------------------------------------
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * ------------------------------------------------------------------------
 *
 * The following terms apply to the enhanced version of XBoard distributed
 * by the Free Software Foundation:
 * ------------------------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * ------------------------------------------------------------------------
 */

/* This parser handles all forms of promotion.
 * The parser resolves ambiguous moves by searching and check-testing.
 * It also parses comments of the form [anything] or (anything).
 */

#include "config.h"

#define NO_CONSTRAINT	-1
#undef YYLMAX
#define YYLMAX			4096
#define UNPUT_BUF_SIZE		YYLMAX

#ifdef FLEX_SCANNER
/* yytext is probably a char*, but could be a char[].  yy_text is set
   in YY_DECL below, because if yytext is a char*, its value is not
   constant. */
char *yy_text;
#else /*!FLEX_SCANNER*/
/* yytext is definitely a char[], so yy_text can be set here, statically. */
char *yy_text = (char *) yytext;
#endif

#ifdef FLEX_SCANNER
/* This is flex */
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) my_yy_input(buf, &result, max_size)
#undef YY_DECL
#define YY_DECL                     \
    int _yylex YY_PROTO((void));    \
    int yylex YY_PROTO((void))      \
    {                               \
	int result = _yylex();      \
	yy_text = (char *) yytext;  \
	return(result);             \
    }                               \
    int _yylex YY_PROTO((void))
#else
/* This is lex */
#undef input
#undef output
#undef unput
#endif

/* The includes must be here, below the #undef input */

#include <ctype.h>

#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#else /* not STDC_HEADERS */
# if HAVE_STRING_H
#  include <string.h>
# else /* not HAVE_STRING_H */
#  include <strings.h>
# endif /* not HAVE_STRING_H */
#endif /* not STDC_HEADERS */

#if HAVE_UNISTD_H
# include <unistd.h>
#endif

#if defined(_amigados)
# include <errno.h>
# if HAVE_FCNTL_H
#  include <fcntl.h>    /*  isatty() prototype  */
# endif /*  HAVE_FCNTL_H        */
#endif  /*  defined(_amigados)  */

#include "common.h"
#include "backend.h"
#include "frontend.h"
#include "parser.h"
#include "moves.h"

extern int PosFlags P((int));

extern Board	boards[MAX_MOVES];
int		yyboardindex;
int             yyskipmoves = FALSE;
char		currentMoveString[YYLMAX];
#ifndef FLEX_SCANNER
char		unputBuffer[UNPUT_BUF_SIZE];
int		unputCount = 0;
#endif

#ifdef FLEX_SCANNER
void my_yy_input P((char *buf, int *result, int max_size));
#else /*!FLEX_SCANNER*/
static int input P((void));
static void output P((int ch));
static void unput P((int ch));
int yylook P((void));
int yyback P((int *, int));
#endif
#undef yywrap
int yywrap P((void));
extern void CopyBoard P((Board to, Board from));

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{
    /*
     * Fully-qualified algebraic move, possibly with promotion
     */
    int skip1 = 0, skip2 = 0;
    ChessSquare piece;
    ChessMove result;
    
    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the / */
    if (yytext[1] == '/') skip1 = 1;
    
    /* remove the [xX:-] */
    if ((yytext[3+skip1] == 'x') || (yytext[3+skip1] == 'X') ||
	(yytext[3+skip1] == '-') || (yytext[3+skip1] == ':')) skip2 = 1;
    
    currentMoveString[0] = yytext[1+skip1];
    currentMoveString[1] = yytext[2+skip1];
    currentMoveString[2] = yytext[3+skip1+skip2];
    currentMoveString[3] = yytext[4+skip1+skip2];
    currentMoveString[4] = NULLCHAR;
    
    if (yyleng-skip1-skip2 > 5) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    piece = boards[yyboardindex]
      [currentMoveString[1] - '1'][currentMoveString[0] - 'a'];
    if (ToLower(yytext[0]) != ToLower(PieceToChar(piece)))
      return (int) IllegalMove;

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 2:
{
    /*
     * Simple algebraic move, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[2] == 'x') || (yytext[2] == 'X') ||
	(yytext[2] == '-') || (yytext[2] == ':')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[1] = yytext[1];
    currentMoveString[2] = yytext[2+skip];
    currentMoveString[3] = yytext[3+skip];
    currentMoveString[4] = NULLCHAR;

    if (yyleng-skip > 4) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 3:
{
    /*
     * Pawn move, possibly with promotion
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the =() */
    if (yytext[2] == '=') skip++;
    if (yytext[2+skip] == '(') skip++;

    cl.pieceIn = WhiteOnMove(yyboardindex) ? WhitePawn : BlackPawn;
    cl.rfIn = -1;
    cl.ffIn = yytext[0] - 'a';
    cl.rtIn = yytext[1] - '1';
    cl.ftIn = yytext[0] - 'a';
    cl.promoCharIn = yytext[2+skip];
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 4:
{
    /*
     * Pawn capture, possibly with promotion, possibly ambiguous
     */
    DisambiguateClosure cl;
    int skip1 = 0, skip2 = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] and =() */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip1 = 1;
    if (yytext[2+skip1] == '=') skip2++;
    if (yytext[2+skip1+skip2] == '(') skip2++;

    cl.pieceIn = WhiteOnMove(yyboardindex) ? WhitePawn : BlackPawn;
    cl.rfIn = -1;
    cl.ffIn = yytext[0] - 'a';
    cl.rtIn = -1;
    cl.ftIn = yytext[1+skip1] - 'a';
    cl.promoCharIn = yytext[2+skip1+skip2];
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 5:
{
    /*
     * unambiguously abbreviated Pawn capture, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[2] = yytext[1+skip];
    currentMoveString[3] = yytext[2+skip];
    if (WhiteOnMove(yyboardindex)) {
	if (yytext[2+skip] == '1') return (int) ImpossibleMove;
	currentMoveString[1] = yytext[2+skip] - 1;
    } else {
	if (yytext[2+skip] == '8') return (int) ImpossibleMove;
	currentMoveString[1] = yytext[2+skip] + 1;
    }
    if (yyleng-skip > 3) {
	if (yytext[yyleng-1] == ')')
	  currentMoveString[4] = ToLower(yytext[yyleng-2]);
	else
	  currentMoveString[4] = ToLower(yytext[yyleng-1]);
	currentMoveString[5] = NULLCHAR;
    } else {
	currentMoveString[4] = NULLCHAR;
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    if (result != IllegalMove) return (int) result;

    /* Special case: improperly written en passant capture */
    if (WhiteOnMove(yyboardindex)) {
	if (currentMoveString[3] == '5') {
	    currentMoveString[1] = '5';
	    currentMoveString[3] = '6';
	} else {
	    return (int) IllegalMove;
	}
    } else {
	if (currentMoveString[3] == '4') {
	    currentMoveString[1] = '4';
	    currentMoveString[3] = '3';
	} else {
	    return (int) IllegalMove;
	}
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (result == WhiteCapturesEnPassant || result == BlackCapturesEnPassant)
      return (int) result;
    else
      return (int) IllegalMove;
}
break;
case 6:
 {
    /*
     * piece move, possibly ambiguous
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    if (WhiteOnMove(yyboardindex)) {
	cl.pieceIn = CharToPiece(ToUpper(yytext[0]));
    } else {
	cl.pieceIn = CharToPiece(ToLower(yytext[0]));
    }
    cl.rfIn = -1;
    cl.ffIn = -1;
    cl.rtIn = yytext[2+skip] - '1';
    cl.ftIn = yytext[1+skip] - 'a';
    cl.promoCharIn = NULLCHAR;
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 7:
{
    /*
     * piece move with rank or file disambiguator
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[2] == 'x') || (yytext[2] == 'X')
	|| (yytext[2] == ':') || (yytext[2] == '-')) skip = 1;

    if (WhiteOnMove(yyboardindex)) {
	cl.pieceIn = CharToPiece(ToUpper(yytext[0]));
    } else {
	cl.pieceIn = CharToPiece(ToLower(yytext[0]));
    }
    if (isalpha(yytext[1])) {
	cl.rfIn = -1;
	cl.ffIn = yytext[1] - 'a';
    } else {
	cl.rfIn = yytext[1] - '1';
	cl.ffIn = -1;
    }
    cl.rtIn = yytext[3+skip] - '1';
    cl.ftIn = yytext[2+skip] - 'a';
    cl.promoCharIn = NULLCHAR;
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 8:
{
    int rf, ff, rt, ft;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    if (WhiteOnMove(yyboardindex)) {
	if (boards[yyboardindex][0][3] == WhiteKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d1f1");
	    rf = 0;
	    ff = 3;
	    rt = 0;
	    ft = 5;
	} else {
	    strcpy(currentMoveString, "e1c1");
	    rf = 0;
	    ff = 4;
	    rt = 0;
	    ft = 2;
	}
    } else{ 
	if (boards[yyboardindex][7][3] == BlackKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d8f8");
	    rf = 7;
	    ff = 3;
	    rt = 7;
	    ft = 5;
	} else {
	    strcpy(currentMoveString, "e8c8");
	    rf = 7;
	    ff = 4;
	    rt = 7;
	    ft = 2;
	}
    }
    return (int) LegalityTest(boards[yyboardindex],
			      PosFlags(yyboardindex), EP_UNKNOWN,
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 9:
{
    int rf, ff, rt, ft;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    if (WhiteOnMove(yyboardindex)) {
	if (boards[yyboardindex][0][3] == WhiteKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d1b1");
	    rf = 0;
	    ff = 3;
	    rt = 0;
	    ft = 1;
	} else {
	    strcpy(currentMoveString, "e1g1");
	    rf = 0;
	    ff = 4;
	    rt = 0;
	    ft = 6;
	}
    } else {
	if (boards[yyboardindex][7][3] == BlackKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d8b8");
	    rf = 7;
	    ff = 3;
	    rt = 7;
	    ft = 1;
	} else {
	    strcpy(currentMoveString, "e8g8");
	    rf = 7;
	    ff = 4;
	    rt = 7;
	    ft = 6;
	}
    }
    return (int) LegalityTest(boards[yyboardindex],
			      PosFlags(yyboardindex), EP_UNKNOWN,
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 10:
{
    /* Bughouse piece drop.  No legality checking for now. */
    currentMoveString[1] = '@';
    currentMoveString[2] = yytext[2];
    currentMoveString[3] = yytext[3];
    currentMoveString[4] = NULLCHAR;
    if (WhiteOnMove(yyboardindex)) {
	currentMoveString[0] = ToUpper(yytext[0]);
	return (int) WhiteDrop;
    } else {
	currentMoveString[0] = ToLower(yytext[0]);
	return (int) BlackDrop;
    }
}
break;
case 11:
 {
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 12:
 {
    return (int) (ToUpper(yytext[0]) == 'W' ? BlackWins : WhiteWins);
}
break;
case 13:
 {
    return (int) GameUnfinished;
}
break;
case 14:
 {
    return (int) GameIsDrawn;
}
break;
case 15:
 {
    return (int) GameIsDrawn;
}
break;
case 16:
{
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 17:
 {
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 18:
 {
    return (int) GameIsDrawn;
}
break;
case 19:
 {
    return (int) GameIsDrawn;
}
break;
case 20:
 {
    return (int) (ToUpper(yytext[0]) == 'W' ? WhiteWins : BlackWins);
}
break;
case 21:
 {
    return (int) (ToUpper(yytext[0]) == 'W' ? BlackWins : WhiteWins);
}
break;
case 22:
{ 
    return (int) WhiteWins;
}
break;
case 23:
{ 
    return (int) BlackWins;
}
break;
case 24:
{
    return (int) GameIsDrawn;
}
break;
case 25:
{
    return (int) GameUnfinished;
}
break;
case 26:
   {
    /* move numbers */
    if ((yyleng == 1) && (yytext[0] == '1'))
      return (int) MoveNumberOne;
}
break;
case 27:
{
    /* elapsed time indication, e.g. (0:12) */ 
    return (int) ElapsedTime;
}
break;
case 28:
{
    /* position diagram enclosed in [-- --] */
    return (int) PositionDiagram;
}
break;
case 29:
{
    /* position diagram enclosed in {-- --} */
    return (int) PositionDiagram;
}
break;
case 30:
{
    return (int) PGNTag;
}
break;
case 31:
{
    return (int) GNUChessGame;
}
break;
case 32:
{
    return (int) XBoardGame;
}
break;
case 33:
{				/* numeric annotation glyph */
    return (int) NAG;
}
break;
case 34:
{        			/* anything in {} */
    return (int) Comment; 
}
break;
case 35:
{                                          /* ; to end of line */
    return (int) Comment;
}
break;
case 36:
{        			/* anything in [] */
    return (int) Comment; 
}
break;
case 37:
 { 	  	/* nested () */
    return (int) Comment; 
}
break;
case 38:
  { 				/* >=2 chars in () */
    return (int) Comment; 
}
break;
case 39:
 {
        /* Skip mail headers */
}
break;
case 40:
		{
        /* Skip random words */
}
break;
case 41:
			{
        /* Skip everything else */
}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */


static char *StringToLex;

#ifndef FLEX_SCANNER
static FILE *lexFP;

static int input()
{
    int ret;
    
    if (StringToLex != NULL) {
	ret = *StringToLex;
	if (ret == NULLCHAR)
	  ret = EOF;
	else
	  StringToLex++;
    } else if (unputCount > 0) {
	ret = unputBuffer[--unputCount];
    } else {
	ret = fgetc(lexFP);
    }    

    if (ret == EOF) 
      return 0;
    else
      return ret;
}

/*
 * Return offset of next pattern within current file
 */
int yyoffset()
{
    int offset = ftell(lexFP) - unputCount;

    if (offset < 0) {
	offset = 0;
    }
    return(offset);
}
 
static void output(ch)
     int ch;
{
    fprintf(stderr, "PARSER BUG: unmatched character '%c' (0%o)\n",
	    ch, ch);
}

static void unput(ch)
     int ch;
{
    if (ch == 0) return;
    if (StringToLex != NULL) {
	StringToLex--;
    } else {
	if (unputCount >= UNPUT_BUF_SIZE)
	  fprintf(stderr, "PARSER BUG: unput buffer overflow '%c' (0%o)\n",
		  ch, ch);
	unputBuffer[unputCount++] = ch;
    }
}

/* Get ready to lex from a new file.  Kludge below sticks
   an artificial newline at the front of the file, which the
   above grammar ignores, but which makes ^ at start of pattern
   match at the real start of the file.
*/
void yynewfile(f)
     FILE *f;
{
    lexFP = f;
    StringToLex = NULL;
    unputCount = 0;
    unput('\n'); /* kludge */
}

/* Get ready to lex from a string.  ^ at start of pattern WON'T
   match at the start of the string!
*/
void yynewstr(s)
     char *s;
{
    lexFP = NULL;
    StringToLex = s;
    unputCount = 0;
}
#endif /*!FLEX_SCANNER*/

#ifdef FLEX_SCANNER
void my_yy_input(buf, result, max_size)
     char *buf;
     int *result;
     int max_size;
{
    int count;

    if (StringToLex != NULL) {
	count = 0;
	while (*StringToLex != NULLCHAR) {
	    *buf++ = *StringToLex++;
	    count++;
	}
	*result = count;
	return;
    } else {
	count = fread(buf, 1, max_size, yyin);
	if (count == 0) {
	    *result = YY_NULL;
	} else {
	    *result = count;
	}
	return;
    }    
}

static YY_BUFFER_STATE my_file_buffer = NULL;

/*
    Return offset of next pattern in the current file.
*/
int yyoffset()
{
    int pos = yy_c_buf_p - yy_current_buffer->yy_ch_buf;

    return(ftell(yy_current_buffer->yy_input_file) -
         yy_n_chars + pos);
}


void yynewstr(s)
     char *s;
{
    if (my_file_buffer != NULL)
      yy_delete_buffer(my_file_buffer);
    StringToLex = s;
    my_file_buffer = yy_create_buffer(stdin, YY_BUF_SIZE);
    yy_switch_to_buffer(my_file_buffer);
}

void yynewfile(f)
     FILE *f;
{
    if (my_file_buffer != NULL)
      yy_delete_buffer(my_file_buffer);
    StringToLex = NULL;
    my_file_buffer = yy_create_buffer(f, YY_BUF_SIZE);
    yy_switch_to_buffer(my_file_buffer);
}
#endif /*FLEX_SCANNER*/

int yywrap()
{
    return TRUE;
}

/* Parse a move from the given string s */
/* ^ at start of pattern WON'T work here unless using flex */
ChessMove yylexstr(boardIndex, s)
     int boardIndex;
     char *s;
{
    ChessMove ret;
    char *oldStringToLex;
#ifdef FLEX_SCANNER
    YY_BUFFER_STATE buffer, oldBuffer;
#endif
    
    yyboardindex = boardIndex;
    oldStringToLex = StringToLex;
    StringToLex = s;
#ifdef FLEX_SCANNER
    buffer = yy_create_buffer(stdin, YY_BUF_SIZE);
    oldBuffer = YY_CURRENT_BUFFER;
    yy_switch_to_buffer(buffer);
#endif /*FLEX_SCANNER*/

    ret = (ChessMove) yylex();

#ifdef FLEX_SCANNER
    if (oldBuffer != NULL) 
      yy_switch_to_buffer(oldBuffer);
    yy_delete_buffer(buffer);
#endif /*FLEX_SCANNER*/
    StringToLex = oldStringToLex;

    return ret;
}
int yyvstop[] = {
0,

41,
0,

41,
0,

41,
0,

40,
41,
0,

41,
0,

25,
41,
0,

41,
0,

40,
41,
0,

40,
41,
-26,
0,

40,
41,
-26,
0,

41,
-35,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

41,
0,

41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
-26,
0,

40,
41,
-26,
0,

41,
-35,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

41,
0,

33,
0,

40,
0,

17,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
-26,
0,

26,
40,
0,

-35,
0,

35,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

36,
0,

40,
0,

3,
40,
0,

40,
0,

40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

4,
40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

34,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
-26,
0,

40,
0,

26,
40,
0,

-35,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

3,
40,
0,

40,
0,

40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

4,
40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

15,
0,

9,
40,
0,

23,
40,
0,

23,
0,

8,
40,
0,

26,
0,

26,
40,
0,

22,
40,
0,

22,
0,

24,
0,

40,
0,

40,
0,

40,
0,

6,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

3,
40,
0,

4,
0,

5,
40,
0,

4,
40,
0,

4,
40,
0,

40,
0,

40,
0,

3,
40,
0,

4,
0,

4,
40,
0,

5,
6,
40,
0,

4,
40,
0,

9,
40,
0,

34,
0,

39,
0,

9,
40,
0,

23,
40,
0,

8,
40,
0,

22,
40,
0,

26,
40,
0,

39,
0,

35,
0,

-35,
0,

40,
0,

40,
0,

40,
0,

6,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

3,
40,
0,

5,
40,
0,

4,
40,
0,

4,
40,
0,

40,
0,

40,
0,

3,
40,
0,

4,
40,
0,

5,
6,
40,
0,

4,
40,
0,

9,
40,
0,

38,
0,

38,
0,

37,
0,

25,
0,

25,
0,

40,
0,

6,
40,
0,

7,
40,
0,

6,
0,

10,
0,

40,
0,

40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

21,
40,
0,

16,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
0,

20,
40,
0,

36,
0,

3,
0,

3,
0,

2,
40,
0,

5,
0,

4,
0,

5,
40,
0,

4,
0,

2,
7,
40,
0,

5,
6,
0,

5,
6,
40,
0,

5,
40,
0,

40,
0,

25,
0,

40,
0,

26,
39,
0,

-35,
0,

-35,
0,

6,
40,
0,

7,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

21,
40,
0,

16,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
40,
0,

20,
0,

2,
40,
0,

5,
40,
0,

2,
7,
40,
0,

5,
6,
40,
0,

5,
40,
0,

40,
0,

7,
0,

1,
40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

40,
0,

21,
0,

21,
40,
0,

40,
0,

40,
0,

30,
36,
0,

2,
0,

2,
40,
0,

5,
0,

5,
0,

2,
7,
0,

39,
0,

39,
0,

-35,
0,

-35,
0,

1,
40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

40,
0,

21,
40,
0,

21,
0,

40,
0,

40,
0,

20,
39,
0,

2,
40,
0,

27,
38,
0,

23,
0,

23,
0,

22,
0,

22,
0,

24,
0,

24,
0,

20,
21,
0,

1,
0,

1,
40,
0,

40,
0,

40,
0,

40,
0,

11,
40,
0,

40,
0,

28,
36,
0,

30,
0,

2,
0,

2,
0,

27,
34,
0,

39,
0,

26,
39,
0,

-35,
0,

-35,
0,

1,
40,
0,

40,
0,

40,
0,

40,
0,

21,
39,
0,

11,
40,
0,

40,
0,

18,
0,

24,
0,

20,
21,
0,

1,
0,

1,
0,

19,
0,

40,
0,

40,
0,

40,
0,

11,
40,
0,

40,
0,

-35,
0,

-35,
0,

40,
0,

40,
0,

40,
0,

11,
40,
0,

40,
0,

12,
0,

40,
0,

40,
0,

-35,
0,

-35,
0,

40,
0,

40,
0,

12,
0,

40,
0,

14,
40,
0,

-35,
0,

-35,
0,

40,
0,

14,
40,
0,

40,
0,

40,
0,

-35,
0,

-35,
0,

39,
0,

40,
0,

40,
0,

40,
0,

40,
0,

-35,
0,

-35,
0,

39,
0,

40,
0,

40,
0,

31,
40,
0,

-32,
0,

-32,
-35,
0,

-35,
0,

39,
0,

39,
0,

31,
40,
0,

13,
0,

31,
0,

32,
0,

32,
35,
0,

-35,
0,

39,
0,

39,
0,

-35,
0,

31,
39,
0,

-35,
0,

34,
-29,
0,

29,
0,
0};
# define YYTYPE unsigned short
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,3,	1,3,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,4,	0,0,	1,3,	
1,3,	1,5,	1,3,	0,0,	
1,6,	1,7,	1,3,	1,8,	
1,9,	0,0,	1,6,	8,73,	
1,3,	1,10,	1,11,	1,12,	
1,12,	1,12,	1,12,	1,12,	
1,12,	1,12,	1,12,	1,3,	
1,13,	9,74,	1,3,	9,75,	
38,136,	43,148,	1,6,	1,14,	
1,15,	1,16,	1,6,	1,6,	
1,17,	66,182,	75,192,	4,67,	
1,18,	1,19,	1,20,	1,21,	
1,22,	1,23,	78,198,	1,24,	
1,25,	77,196,	77,197,	79,199,	
1,26,	1,6,	87,206,	85,206,	
1,27,	85,207,	1,3,	10,76,	
1,3,	105,226,	1,28,	1,29,	
1,30,	1,31,	1,32,	1,33,	
1,34,	1,35,	1,6,	4,67,	
10,77,	17,101,	10,78,	10,79,	
1,36,	20,104,	50,159,	98,220,	
1,25,	1,6,	2,38,	2,5,	
2,38,	10,80,	15,99,	22,105,	
1,37,	2,8,	1,3,	19,103,	
2,39,	16,100,	12,81,	2,40,	
2,41,	2,42,	2,42,	2,42,	
2,42,	2,42,	2,42,	2,42,	
2,42,	17,102,	2,43,	12,83,	
2,3,	12,81,	25,109,	45,154,	
2,39,	2,44,	2,45,	2,46,	
2,39,	2,39,	2,47,	36,130,	
12,81,	22,106,	2,48,	2,49,	
2,50,	2,51,	2,52,	2,53,	
46,155,	2,54,	2,55,	49,158,	
47,156,	52,160,	2,56,	2,39,	
55,164,	67,183,	2,27,	99,221,	
40,76,	100,222,	2,3,	101,223,	
2,57,	2,58,	2,59,	2,60,	
2,61,	2,62,	2,63,	2,64,	
2,39,	40,139,	73,190,	40,78,	
40,140,	102,223,	2,65,	103,224,	
104,225,	106,199,	2,55,	2,39,	
47,157,	109,229,	40,141,	52,161,	
65,180,	110,230,	2,66,	5,68,	
5,68,	5,68,	5,68,	5,68,	
5,68,	5,68,	5,68,	5,68,	
5,68,	6,69,	111,231,	113,112,	
130,257,	36,131,	131,199,	6,69,	
134,259,	135,260,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
138,262,	139,263,	139,264,	26,91,	
140,265,	56,91,	147,268,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	151,262,	65,181,	153,276,	
154,277,	73,191,	155,278,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	7,70,	141,262,	156,279,	
76,193,	157,279,	76,194,	144,268,	
72,0,	7,70,	7,70,	26,110,	
26,111,	56,165,	56,166,	72,188,	
72,188,	76,195,	26,111,	141,198,	
56,166,	132,132,	132,132,	144,206,	
72,188,	72,189,	158,280,	159,281,	
160,282,	82,201,	132,132,	82,202,	
7,70,	161,265,	7,70,	7,70,	
164,285,	7,70,	86,81,	7,70,	
7,71,	7,0,	82,203,	7,70,	
165,286,	7,70,	166,287,	7,70,	
7,72,	7,72,	169,262,	86,83,	
175,262,	86,81,	180,304,	181,265,	
183,306,	7,72,	7,70,	184,307,	
185,308,	193,315,	194,316,	195,317,	
86,81,	7,70,	7,70,	7,70,	
7,70,	7,70,	7,70,	7,70,	
196,318,	197,319,	198,319,	7,70,	
7,70,	7,70,	7,70,	7,70,	
7,70,	201,320,	7,70,	7,70,	
202,321,	203,322,	205,323,	7,70,	
7,70,	206,323,	208,326,	209,327,	
210,328,	7,70,	207,324,	211,329,	
220,339,	7,70,	7,70,	7,70,	
7,70,	7,70,	7,70,	7,70,	
7,70,	7,70,	221,340,	207,325,	
222,341,	11,81,	182,305,	7,70,	
225,345,	182,132,	182,132,	7,70,	
7,70,	11,81,	11,81,	226,346,	
207,325,	228,347,	182,132,	229,348,	
224,344,	7,70,	92,212,	92,212,	
92,212,	92,212,	92,212,	92,212,	
92,212,	92,212,	230,349,	115,233,	
115,233,	223,342,	224,344,	224,344,	
11,82,	239,236,	11,81,	11,81,	
240,357,	11,81,	246,245,	11,83,	
11,81,	11,81,	247,364,	11,81,	
257,370,	11,84,	261,375,	11,85,	
11,86,	11,86,	115,233,	263,378,	
115,234,	115,115,	264,319,	261,376,	
266,323,	11,86,	11,87,	273,262,	
276,388,	115,115,	277,389,	115,115,	
223,343,	11,83,	11,88,	11,83,	
11,83,	11,83,	11,83,	11,83,	
259,371,	259,371,	278,390,	11,88,	
11,83,	11,83,	11,88,	11,88,	
11,88,	259,371,	11,88,	11,83,	
260,372,	270,381,	281,393,	11,83,	
11,83,	282,394,	260,373,	260,374,	
284,395,	11,81,	270,382,	285,396,	
223,343,	11,88,	11,88,	11,88,	
11,88,	11,88,	11,88,	11,88,	
11,88,	11,83,	188,307,	286,397,	
290,262,	13,89,	291,357,	11,88,	
295,364,	188,188,	188,188,	11,83,	
11,83,	13,89,	13,90,	298,262,	
304,405,	306,407,	188,188,	188,189,	
280,392,	11,81,	93,213,	93,213,	
93,213,	93,213,	93,213,	93,213,	
93,213,	93,213,	309,0,	279,342,	
313,0,	314,0,	280,392,	280,392,	
13,89,	318,199,	13,89,	13,89,	
319,409,	13,89,	320,206,	13,89,	
13,89,	13,89,	325,415,	13,89,	
189,307,	13,89,	326,417,	13,89,	
13,89,	13,89,	327,418,	189,312,	
189,312,	321,206,	323,411,	321,207,	
312,307,	13,89,	13,89,	325,416,	
189,312,	328,419,	279,391,	312,408,	
312,408,	13,89,	13,89,	13,89,	
13,89,	13,89,	13,89,	13,89,	
312,408,	329,420,	339,424,	13,89,	
13,89,	13,89,	13,89,	13,89,	
13,89,	340,425,	13,89,	13,89,	
341,426,	342,428,	343,429,	13,89,	
13,89,	346,199,	347,433,	348,434,	
349,424,	13,89,	279,391,	351,0,	
355,357,	13,89,	13,89,	13,89,	
13,89,	13,89,	13,89,	13,89,	
13,89,	13,89,	360,364,	362,361,	
363,444,	14,91,	370,199,	13,89,	
371,446,	371,446,	375,452,	13,89,	
13,89,	342,428,	343,430,	319,410,	
376,453,	371,446,	14,92,	373,76,	
14,93,	13,89,	14,94,	14,94,	
14,94,	14,94,	14,94,	14,94,	
14,94,	14,94,	378,265,	14,95,	
373,447,	323,412,	373,78,	381,456,	
324,413,	14,96,	382,457,	386,262,	
388,459,	324,325,	18,92,	389,460,	
18,93,	373,80,	18,94,	18,94,	
18,94,	18,94,	18,94,	18,94,	
18,94,	18,94,	324,325,	18,95,	
390,426,	377,454,	341,427,	394,265,	
391,462,	14,92,	95,217,	95,217,	
95,217,	95,217,	95,217,	95,217,	
95,217,	95,217,	14,97,	14,97,	
14,97,	14,97,	14,97,	14,97,	
14,97,	14,97,	395,466,	305,406,	
377,454,	14,98,	305,132,	305,132,	
396,467,	18,92,	23,93,	397,459,	
401,444,	405,265,	407,471,	305,132,	
391,463,	14,92,	18,97,	18,97,	
18,97,	18,97,	18,97,	18,97,	
18,97,	18,97,	21,92,	23,96,	
21,93,	374,448,	21,94,	21,94,	
21,94,	21,94,	21,94,	21,94,	
21,94,	21,94,	408,472,	21,95,	
415,416,	18,92,	374,449,	324,414,	
374,450,	21,96,	96,218,	96,218,	
96,218,	96,218,	96,218,	96,218,	
96,218,	96,218,	379,455,	374,451,	
53,93,	416,479,	390,461,	417,481,	
23,107,	23,107,	23,107,	23,107,	
23,107,	23,107,	23,107,	23,107,	
418,482,	21,92,	419,483,	420,484,	
416,480,	53,96,	424,91,	427,426,	
429,495,	379,455,	21,97,	21,97,	
21,97,	21,97,	21,97,	21,97,	
21,97,	21,97,	24,92,	425,489,	
24,93,	428,493,	24,94,	24,94,	
24,94,	24,94,	24,94,	24,94,	
24,94,	24,94,	430,496,	24,95,	
433,497,	21,92,	434,498,	441,440,	
442,502,	24,96,	53,162,	53,162,	
53,162,	53,162,	53,162,	53,162,	
53,162,	53,162,	406,470,	443,444,	
27,112,	406,132,	406,132,	425,489,	
452,504,	428,494,	453,505,	456,508,	
27,113,	27,113,	406,132,	457,509,	
459,91,	24,92,	107,227,	107,227,	
107,227,	107,227,	107,227,	107,227,	
107,227,	107,227,	24,97,	24,97,	
24,97,	24,97,	24,108,	24,97,	
24,97,	24,97,	448,201,	27,113,	
448,202,	27,112,	27,112,	461,426,	
27,112,	462,512,	27,112,	27,112,	
27,112,	460,511,	27,112,	448,203,	
27,114,	24,92,	27,112,	27,115,	
27,115,	463,513,	466,515,	432,0,	
467,516,	469,502,	473,0,	474,0,	
27,115,	27,112,	475,0,	470,517,	
476,0,	477,0,	470,132,	470,132,	
27,115,	27,115,	27,115,	27,115,	
27,115,	27,115,	27,115,	470,132,	
478,0,	460,511,	27,115,	27,115,	
27,115,	27,115,	27,115,	27,115,	
471,518,	27,115,	27,115,	479,520,	
446,132,	446,132,	27,115,	27,115,	
480,521,	471,519,	481,522,	482,523,	
27,116,	446,132,	483,524,	484,526,	
27,115,	27,115,	27,115,	27,115,	
27,115,	27,115,	27,115,	27,115,	
27,115,	487,486,	488,528,	489,104,	
483,525,	491,530,	27,115,	492,531,	
28,117,	493,532,	27,115,	27,115,	
28,118,	28,118,	28,118,	28,118,	
28,118,	28,118,	28,118,	28,118,	
27,112,	28,119,	29,91,	117,235,	
117,235,	117,235,	117,235,	117,235,	
117,235,	117,235,	117,235,	494,533,	
495,534,	496,535,	498,538,	29,123,	
497,536,	29,93,	432,432,	29,124,	
29,124,	29,124,	29,124,	29,124,	
29,124,	29,124,	29,124,	501,502,	
29,125,	504,539,	497,537,	28,120,	
432,432,	432,432,	29,96,	505,540,	
508,541,	446,503,	509,542,	510,528,	
28,121,	28,122,	28,121,	28,121,	
28,121,	28,121,	28,121,	28,121,	
119,243,	119,243,	119,243,	119,243,	
119,243,	119,243,	119,243,	119,243,	
511,159,	512,543,	29,126,	513,544,	
516,547,	519,549,	515,545,	28,120,	
438,438,	438,438,	520,550,	29,127,	
29,128,	29,127,	29,128,	29,128,	
29,128,	29,128,	29,128,	30,117,	
515,546,	521,551,	29,98,	30,118,	
30,118,	30,118,	30,118,	30,118,	
30,118,	30,118,	30,118,	438,438,	
30,119,	522,552,	29,126,	120,122,	
120,122,	120,122,	120,122,	120,122,	
120,122,	120,122,	120,122,	31,117,	
523,553,	524,525,	526,554,	31,118,	
31,118,	31,118,	31,118,	31,118,	
31,118,	31,118,	31,118,	527,528,	
31,119,	529,0,	530,555,	531,556,	
532,557,	533,558,	30,120,	121,244,	
121,244,	121,244,	121,244,	121,244,	
121,244,	121,244,	121,244,	30,121,	
30,122,	30,121,	30,122,	30,121,	
30,121,	30,121,	30,129,	517,548,	
534,559,	535,559,	517,132,	517,132,	
536,537,	538,560,	31,120,	539,561,	
540,562,	541,563,	542,564,	517,132,	
438,500,	543,565,	30,120,	31,121,	
31,121,	31,122,	31,121,	31,122,	
31,121,	31,121,	31,121,	123,248,	
123,248,	123,248,	123,248,	123,248,	
123,248,	123,248,	123,248,	544,565,	
31,100,	545,546,	547,566,	32,117,	
549,568,	551,413,	31,120,	32,118,	
32,118,	32,118,	32,118,	32,118,	
32,118,	32,118,	32,118,	552,569,	
32,119,	125,253,	125,253,	125,253,	
125,253,	125,253,	125,253,	125,253,	
125,253,	553,554,	555,572,	33,117,	
554,570,	557,573,	558,573,	33,118,	
33,118,	33,118,	33,118,	33,118,	
33,118,	33,118,	33,118,	556,491,	
33,119,	560,575,	554,571,	561,576,	
562,577,	563,578,	32,120,	126,254,	
126,254,	126,254,	126,254,	126,254,	
126,254,	126,254,	126,254,	32,121,	
32,121,	32,121,	32,122,	32,121,	
32,122,	32,121,	32,121,	564,579,	
548,567,	566,582,	568,518,	548,132,	
548,132,	569,584,	33,120,	556,491,	
570,571,	572,585,	576,589,	426,490,	
548,132,	574,0,	32,120,	33,121,	
33,121,	33,121,	33,121,	33,122,	
33,121,	33,122,	33,121,	34,117,	
551,414,	577,590,	578,591,	34,118,	
34,118,	34,118,	34,118,	34,118,	
34,118,	34,118,	34,118,	579,592,	
34,119,	584,597,	33,120,	129,244,	
129,244,	129,244,	129,244,	129,244,	
129,244,	129,244,	129,244,	585,598,	
588,0,	589,603,	590,604,	591,605,	
592,606,	426,491,	35,117,	597,611,	
34,101,	598,612,	35,118,	35,118,	
35,118,	35,118,	35,118,	35,118,	
35,118,	35,118,	34,120,	35,119,	
574,587,	426,492,	603,616,	604,617,	
605,618,	602,0,	606,619,	34,121,	
34,121,	34,121,	34,121,	34,121,	
34,122,	34,121,	34,122,	567,583,	
37,132,	426,491,	567,132,	567,132,	
34,102,	611,624,	587,0,	129,221,	
37,132,	37,133,	612,626,	567,132,	
615,0,	35,120,	34,120,	617,629,	
574,588,	619,631,	621,593,	611,625,	
624,625,	626,635,	35,121,	35,121,	
35,121,	35,121,	35,121,	35,121,	
35,122,	35,121,	629,636,	37,132,	
631,637,	37,132,	37,132,	635,518,	
37,132,	636,640,	37,132,	37,132,	
37,132,	637,641,	37,132,	641,618,	
37,132,	35,120,	37,132,	37,134,	
37,134,	583,596,	621,633,	644,645,	
583,132,	583,132,	645,646,	646,647,	
37,134,	37,132,	647,648,	648,649,	
649,650,	583,132,	650,651,	588,602,	
37,132,	37,132,	37,132,	37,132,	
37,132,	37,132,	37,132,	651,652,	
652,653,	587,601,	37,132,	37,132,	
37,132,	37,132,	37,132,	37,132,	
602,615,	37,132,	37,132,	653,654,	
654,655,	655,656,	37,132,	37,132,	
656,657,	657,658,	658,659,	659,660,	
37,132,	0,0,	0,0,	0,0,	
37,132,	37,132,	37,132,	37,132,	
37,132,	37,132,	37,132,	37,132,	
37,132,	587,559,	0,0,	0,0,	
596,610,	0,0,	37,132,	596,132,	
596,132,	0,0,	37,132,	37,132,	
39,69,	0,0,	0,0,	0,0,	
596,132,	0,0,	39,137,	0,0,	
37,135,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,138,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
0,0,	0,0,	642,643,	0,0,	
0,0,	0,0,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
39,137,	39,137,	39,137,	39,137,	
41,142,	0,0,	610,623,	41,143,	
41,143,	610,132,	610,132,	623,634,	
642,132,	642,132,	623,132,	623,132,	
41,143,	41,144,	610,132,	0,0,	
0,0,	642,132,	0,0,	623,132,	
41,145,	41,146,	41,145,	41,145,	
41,145,	41,145,	41,145,	0,0,	
0,0,	0,0,	41,146,	41,145,	
41,145,	41,146,	41,146,	41,146,	
0,0,	41,146,	41,145,	0,0,	
0,0,	0,0,	41,145,	41,145,	
0,0,	0,0,	0,0,	0,0,	
42,81,	0,0,	0,0,	0,0,	
41,146,	41,146,	41,146,	41,146,	
41,146,	41,146,	41,146,	41,146,	
41,145,	42,145,	0,0,	42,81,	
42,143,	42,143,	41,146,	0,0,	
0,0,	0,0,	41,145,	41,145,	
0,0,	42,143,	42,147,	0,0,	
634,639,	0,0,	0,0,	634,132,	
634,132,	42,145,	42,146,	42,145,	
42,145,	42,145,	42,145,	42,145,	
634,132,	0,0,	0,0,	42,146,	
42,145,	42,145,	42,146,	42,146,	
42,146,	0,0,	42,146,	42,145,	
0,0,	0,0,	0,0,	42,145,	
42,145,	149,271,	149,271,	149,271,	
149,271,	149,271,	149,271,	149,271,	
149,271,	42,146,	42,146,	42,146,	
42,146,	42,146,	42,146,	42,146,	
42,146,	42,145,	44,91,	0,0,	
0,0,	0,0,	639,642,	42,146,	
0,0,	639,132,	639,132,	42,145,	
42,145,	0,0,	0,0,	44,149,	
0,0,	44,93,	639,132,	44,150,	
44,150,	44,150,	44,150,	44,150,	
44,150,	44,150,	44,150,	0,0,	
44,151,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,96,	0,0,	
0,0,	0,0,	0,0,	48,149,	
0,0,	48,93,	0,0,	48,150,	
48,150,	48,150,	48,150,	48,150,	
48,150,	48,150,	48,150,	0,0,	
48,151,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,149,	162,283,	
162,283,	162,283,	162,283,	162,283,	
162,283,	162,283,	162,283,	44,152,	
44,152,	44,152,	44,152,	44,152,	
44,152,	44,152,	44,152,	0,0,	
0,0,	0,0,	44,153,	0,0,	
0,0,	0,0,	48,149,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,149,	48,152,	
48,152,	48,152,	48,152,	48,152,	
48,152,	48,152,	48,152,	51,149,	
0,0,	51,93,	0,0,	51,150,	
51,150,	51,150,	51,150,	51,150,	
51,150,	51,150,	51,150,	0,0,	
51,151,	0,0,	48,149,	0,0,	
0,0,	0,0,	51,96,	0,0,	
0,0,	0,0,	0,0,	0,0,	
54,149,	0,0,	54,93,	0,0,	
54,150,	54,150,	54,150,	54,150,	
54,150,	54,150,	54,150,	54,150,	
0,0,	54,151,	0,0,	0,0,	
0,0,	0,0,	51,149,	54,96,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	51,152,	
51,152,	51,152,	51,152,	51,152,	
51,152,	51,152,	51,152,	167,288,	
167,288,	167,288,	167,288,	167,288,	
167,288,	167,288,	167,288,	54,149,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	51,149,	0,0,	
54,152,	54,152,	54,152,	54,152,	
54,163,	54,152,	54,152,	54,152,	
57,167,	0,0,	0,0,	0,0,	
57,168,	57,168,	57,168,	57,168,	
57,168,	57,168,	57,168,	57,168,	
58,91,	57,169,	0,0,	54,149,	
170,172,	170,172,	170,172,	170,172,	
170,172,	170,172,	170,172,	170,172,	
0,0,	58,173,	0,0,	58,93,	
0,0,	58,174,	58,174,	58,174,	
58,174,	58,174,	58,174,	58,174,	
58,174,	0,0,	58,175,	0,0,	
0,0,	0,0,	0,0,	57,170,	
58,96,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
57,171,	57,172,	57,171,	57,171,	
57,171,	57,171,	57,171,	57,171,	
171,294,	171,294,	171,294,	171,294,	
171,294,	171,294,	171,294,	171,294,	
58,176,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	57,170,	
0,0,	58,177,	58,178,	58,177,	
58,178,	58,178,	58,178,	58,178,	
58,178,	59,167,	0,0,	0,0,	
58,153,	59,168,	59,168,	59,168,	
59,168,	59,168,	59,168,	59,168,	
59,168,	0,0,	59,169,	0,0,	
58,176,	173,296,	173,296,	173,296,	
173,296,	173,296,	173,296,	173,296,	
173,296,	60,167,	0,0,	0,0,	
0,0,	60,168,	60,168,	60,168,	
60,168,	60,168,	60,168,	60,168,	
60,168,	0,0,	60,169,	0,0,	
0,0,	0,0,	0,0,	0,0,	
59,170,	176,301,	176,301,	176,301,	
176,301,	176,301,	176,301,	176,301,	
176,301,	59,171,	59,172,	59,171,	
59,172,	59,171,	59,171,	59,171,	
59,179,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
60,170,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
59,170,	60,171,	60,171,	60,172,	
60,171,	60,172,	60,171,	60,171,	
60,171,	179,294,	179,294,	179,294,	
179,294,	179,294,	179,294,	179,294,	
179,294,	0,0,	60,155,	0,0,	
0,0,	61,167,	0,0,	0,0,	
60,170,	61,168,	61,168,	61,168,	
61,168,	61,168,	61,168,	61,168,	
61,168,	0,0,	61,169,	212,330,	
212,330,	212,330,	212,330,	212,330,	
212,330,	212,330,	212,330,	0,0,	
0,0,	62,167,	0,0,	0,0,	
0,0,	62,168,	62,168,	62,168,	
62,168,	62,168,	62,168,	62,168,	
62,168,	0,0,	62,169,	0,0,	
0,0,	179,277,	0,0,	0,0,	
61,170,	213,331,	213,331,	213,331,	
213,331,	213,331,	213,331,	213,331,	
213,331,	61,171,	61,171,	61,171,	
61,172,	61,171,	61,172,	61,171,	
61,171,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
62,170,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
61,170,	62,171,	62,171,	62,171,	
62,171,	62,172,	62,171,	62,172,	
62,171,	63,167,	0,0,	0,0,	
0,0,	63,168,	63,168,	63,168,	
63,168,	63,168,	63,168,	63,168,	
63,168,	0,0,	63,169,	0,0,	
62,170,	214,216,	214,216,	214,216,	
214,216,	214,216,	214,216,	214,216,	
214,216,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,167,	0,0,	63,156,	0,0,	
64,168,	64,168,	64,168,	64,168,	
64,168,	64,168,	64,168,	64,168,	
63,170,	64,169,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	63,171,	63,171,	63,171,	
63,171,	63,171,	63,172,	63,171,	
63,172,	0,0,	70,184,	0,0,	
0,0,	0,0,	63,157,	0,0,	
0,0,	0,0,	70,184,	70,184,	
0,0,	0,0,	0,0,	64,170,	
63,170,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,171,	64,171,	64,171,	64,171,	
64,171,	64,171,	64,172,	64,171,	
0,0,	70,184,	0,0,	70,184,	
70,184,	0,0,	70,184,	0,0,	
70,184,	70,185,	70,0,	0,0,	
70,184,	0,0,	70,184,	64,170,	
70,184,	70,184,	70,184,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	70,184,	70,184,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	70,184,	70,184,	
70,184,	70,184,	70,184,	70,184,	
70,184,	0,0,	0,0,	0,0,	
70,184,	70,184,	70,184,	70,184,	
70,184,	70,184,	0,0,	70,184,	
70,184,	0,0,	0,0,	0,0,	
70,184,	70,184,	0,0,	0,0,	
0,0,	0,0,	70,184,	0,0,	
0,0,	0,0,	70,184,	70,184,	
70,184,	70,184,	70,184,	70,184,	
70,184,	70,184,	70,184,	0,0,	
0,0,	0,0,	71,185,	0,0,	
70,184,	0,0,	0,0,	0,0,	
70,184,	70,184,	71,185,	71,185,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	70,184,	215,332,	
215,332,	215,332,	215,332,	215,332,	
215,332,	215,332,	215,332,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	71,185,	0,0,	71,185,	
71,185,	0,0,	71,185,	0,0,	
71,185,	71,186,	71,187,	0,0,	
71,185,	0,0,	71,185,	0,0,	
71,185,	71,185,	71,185,	0,0,	
81,81,	81,81,	0,0,	0,0,	
0,0,	0,0,	71,185,	71,185,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	71,185,	71,185,	
71,185,	71,185,	71,185,	71,185,	
71,185,	0,0,	0,0,	81,81,	
71,185,	71,185,	71,185,	71,185,	
71,185,	71,185,	0,0,	71,185,	
71,185,	0,0,	0,0,	0,0,	
71,185,	71,185,	0,0,	0,0,	
83,81,	83,81,	71,185,	0,0,	
0,0,	0,0,	71,185,	71,185,	
71,185,	71,185,	71,185,	71,185,	
71,185,	71,185,	71,185,	0,0,	
0,0,	81,200,	0,0,	0,0,	
71,185,	0,0,	0,0,	83,81,	
71,185,	71,185,	81,200,	0,0,	
0,0,	81,200,	81,200,	81,200,	
81,200,	81,200,	71,185,	216,333,	
216,333,	216,333,	216,333,	216,333,	
216,333,	216,333,	216,333,	0,0,	
0,0,	0,0,	0,0,	0,0,	
81,200,	81,200,	81,200,	81,200,	
81,200,	81,200,	81,200,	81,200,	
0,0,	83,204,	81,200,	0,0,	
0,0,	81,200,	81,200,	81,200,	
81,200,	81,200,	83,204,	0,0,	
0,0,	83,204,	83,204,	83,204,	
83,204,	83,204,	84,81,	84,81,	
217,334,	217,334,	217,334,	217,334,	
217,334,	217,334,	217,334,	217,334,	
0,0,	0,0,	0,0,	0,0,	
83,204,	83,204,	83,204,	83,204,	
83,204,	83,204,	83,204,	83,204,	
0,0,	84,81,	83,204,	0,0,	
0,0,	83,204,	83,204,	83,204,	
83,204,	83,204,	0,0,	91,208,	
0,0,	91,209,	0,0,	0,0,	
0,0,	84,205,	88,81,	88,81,	
91,210,	0,0,	0,0,	0,0,	
0,0,	91,211,	218,335,	218,335,	
218,335,	218,335,	218,335,	218,335,	
218,335,	218,335,	0,0,	84,204,	
0,0,	0,0,	0,0,	0,0,	
0,0,	88,81,	94,214,	91,208,	
84,204,	91,209,	0,0,	84,204,	
84,204,	84,204,	84,204,	84,204,	
91,210,	0,0,	0,0,	94,215,	
0,0,	91,211,	237,241,	237,241,	
237,241,	237,241,	237,241,	237,241,	
237,241,	237,241,	84,204,	84,204,	
84,204,	84,204,	84,204,	84,204,	
84,204,	84,204,	0,0,	88,204,	
84,204,	0,0,	0,0,	84,204,	
84,204,	84,204,	84,204,	84,204,	
88,204,	94,214,	0,0,	88,204,	
88,204,	88,204,	88,204,	88,204,	
0,0,	0,0,	94,216,	94,216,	
94,216,	94,216,	94,216,	94,216,	
94,216,	94,216,	0,0,	0,0,	
0,0,	0,0,	88,204,	88,204,	
88,204,	88,204,	88,204,	88,204,	
88,204,	88,204,	0,0,	0,0,	
88,204,	94,214,	0,0,	88,204,	
88,204,	88,204,	88,204,	88,204,	
97,214,	0,0,	0,0,	0,0,	
97,219,	97,219,	97,219,	97,219,	
97,219,	97,219,	97,219,	97,219,	
0,0,	97,215,	238,356,	238,356,	
238,356,	238,356,	238,356,	238,356,	
238,356,	238,356,	0,0,	0,0,	
108,214,	0,0,	0,0,	0,0,	
108,219,	108,219,	108,219,	108,219,	
108,219,	108,219,	108,219,	108,219,	
0,0,	108,215,	0,0,	0,0,	
0,0,	0,0,	0,0,	97,214,	
0,0,	0,0,	0,0,	0,0,	
112,112,	112,112,	0,0,	0,0,	
97,216,	97,216,	97,216,	97,216,	
97,216,	97,216,	97,216,	97,216,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	108,214,	
0,0,	0,0,	0,0,	112,112,	
0,0,	0,0,	0,0,	97,214,	
108,216,	108,216,	108,216,	108,216,	
108,216,	108,216,	108,216,	108,216,	
112,112,	0,0,	0,0,	112,112,	
112,112,	0,0,	0,0,	0,0,	
0,0,	0,0,	108,228,	0,0,	
112,112,	0,0,	0,0,	108,214,	
0,0,	0,0,	0,0,	0,0,	
112,112,	112,112,	112,112,	112,112,	
112,112,	112,112,	112,112,	0,0,	
114,112,	114,112,	112,112,	112,112,	
112,112,	112,112,	112,112,	112,112,	
0,0,	112,112,	112,112,	0,0,	
0,0,	0,0,	112,112,	112,112,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	114,112,	
112,112,	112,112,	112,112,	112,112,	
112,112,	112,112,	112,112,	112,112,	
112,112,	0,0,	0,0,	0,0,	
114,232,	0,0,	112,112,	114,112,	
114,112,	0,0,	112,112,	112,112,	
0,0,	0,0,	0,0,	0,0,	
114,112,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
114,112,	114,112,	114,112,	114,112,	
114,112,	114,112,	114,112,	0,0,	
0,0,	0,0,	114,112,	114,112,	
114,112,	114,112,	114,112,	114,112,	
0,0,	114,112,	114,112,	0,0,	
0,0,	0,0,	114,112,	114,112,	
0,0,	0,0,	118,236,	0,0,	
0,0,	0,0,	0,0,	118,237,	
114,112,	114,112,	114,112,	114,112,	
114,112,	114,112,	114,112,	114,112,	
114,112,	0,0,	0,0,	0,0,	
118,238,	0,0,	114,112,	118,239,	
0,0,	0,0,	114,112,	114,112,	
118,240,	241,358,	241,358,	241,358,	
241,358,	241,358,	241,358,	241,358,	
241,358,	118,240,	0,0,	0,0,	
118,240,	0,0,	0,0,	118,240,	
118,240,	0,0,	0,0,	0,0,	
0,0,	0,0,	118,237,	249,251,	
249,251,	249,251,	249,251,	249,251,	
249,251,	249,251,	249,251,	118,241,	
118,242,	118,241,	118,241,	118,241,	
118,241,	118,241,	118,241,	0,0,	
0,0,	118,240,	0,0,	0,0,	
118,240,	0,0,	122,245,	118,240,	
118,240,	0,0,	0,0,	0,0,	
0,0,	0,0,	118,237,	122,244,	
122,244,	122,244,	122,244,	122,244,	
122,244,	122,244,	122,244,	0,0,	
124,236,	242,357,	0,0,	122,246,	
0,0,	124,249,	0,0,	0,0,	
122,247,	242,358,	242,358,	242,358,	
242,358,	242,358,	242,358,	242,358,	
242,358,	122,247,	124,250,	0,0,	
122,247,	124,239,	0,0,	122,247,	
122,247,	0,0,	124,240,	250,365,	
250,365,	250,365,	250,365,	250,365,	
250,365,	250,365,	250,365,	124,240,	
0,0,	0,0,	124,240,	0,0,	
122,247,	124,240,	124,240,	0,0,	
0,0,	0,0,	0,0,	0,0,	
124,249,	122,247,	0,0,	0,0,	
122,247,	0,0,	0,0,	122,247,	
122,247,	124,251,	124,252,	124,251,	
124,251,	124,251,	124,251,	124,251,	
124,251,	0,0,	0,0,	124,240,	
0,0,	0,0,	124,240,	0,0,	
127,245,	124,240,	124,240,	0,0,	
0,0,	127,214,	0,0,	0,0,	
124,249,	127,255,	127,255,	127,255,	
127,255,	127,255,	127,255,	127,255,	
127,255,	0,0,	127,215,	0,0,	
0,0,	127,246,	0,0,	0,0,	
236,355,	0,0,	127,247,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	236,355,	0,0,	127,247,	
236,355,	0,0,	127,247,	236,355,	
236,355,	127,247,	127,247,	0,0,	
0,0,	0,0,	0,0,	0,0,	
127,214,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
236,355,	127,216,	127,256,	127,216,	
127,216,	127,216,	127,216,	127,216,	
127,216,	236,355,	0,0,	127,247,	
236,355,	0,0,	127,247,	236,355,	
236,355,	127,247,	127,247,	0,0,	
0,0,	128,214,	0,0,	0,0,	
127,214,	128,255,	128,255,	128,255,	
128,255,	128,255,	128,255,	128,255,	
128,255,	0,0,	128,215,	251,366,	
251,366,	251,366,	251,366,	251,366,	
251,366,	251,366,	251,366,	253,367,	
253,367,	253,367,	253,367,	253,367,	
253,367,	253,367,	253,367,	133,133,	
0,0,	0,0,	0,0,	0,0,	
0,0,	252,357,	0,0,	133,133,	
0,0,	0,0,	0,0,	0,0,	
128,214,	252,366,	252,366,	252,366,	
252,366,	252,366,	252,366,	252,366,	
252,366,	128,216,	128,216,	128,216,	
128,216,	128,216,	128,216,	128,216,	
128,216,	0,0,	133,133,	0,0,	
133,133,	133,133,	0,0,	133,133,	
0,0,	133,133,	133,133,	133,133,	
0,0,	133,133,	0,0,	133,133,	
128,214,	133,133,	133,133,	133,133,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	133,133,	
133,133,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	0,0,	0,0,	
0,0,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	0,0,	
133,133,	133,133,	0,0,	0,0,	
0,0,	133,133,	133,133,	0,0,	
0,0,	0,0,	0,0,	133,133,	
0,0,	0,0,	0,0,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
0,0,	0,0,	0,0,	136,136,	
0,0,	133,133,	0,0,	0,0,	
0,0,	133,133,	133,133,	136,136,	
136,136,	0,0,	245,360,	0,0,	
0,0,	0,0,	0,0,	133,258,	
0,0,	0,0,	0,0,	245,360,	
0,0,	0,0,	245,360,	0,0,	
0,0,	245,360,	245,360,	0,0,	
0,0,	0,0,	136,261,	0,0,	
136,136,	136,136,	0,0,	136,136,	
0,0,	136,136,	136,136,	136,136,	
0,0,	136,136,	245,360,	136,136,	
0,0,	136,136,	136,136,	136,136,	
0,0,	142,81,	142,81,	245,360,	
0,0,	0,0,	245,360,	136,136,	
136,136,	245,360,	245,360,	0,0,	
0,0,	0,0,	0,0,	136,136,	
136,136,	136,136,	136,136,	136,136,	
136,136,	136,136,	0,0,	0,0,	
142,81,	136,136,	136,136,	136,136,	
136,136,	136,136,	136,136,	0,0,	
136,136,	136,136,	0,0,	0,0,	
0,0,	136,136,	136,136,	0,0,	
142,266,	0,0,	0,0,	136,136,	
0,0,	0,0,	0,0,	136,136,	
136,136,	136,136,	136,136,	136,136,	
136,136,	136,136,	136,136,	136,136,	
0,0,	0,0,	142,267,	0,0,	
0,0,	136,136,	0,0,	0,0,	
0,0,	136,136,	136,136,	142,267,	
256,364,	0,0,	142,267,	142,267,	
142,267,	142,267,	142,267,	136,136,	
256,333,	256,333,	256,333,	256,333,	
256,333,	256,333,	256,333,	256,333,	
0,0,	0,0,	0,0,	0,0,	
0,0,	142,267,	142,267,	142,267,	
142,267,	142,267,	142,267,	142,267,	
142,267,	143,81,	0,0,	142,267,	
0,0,	0,0,	142,267,	142,267,	
142,267,	142,267,	142,267,	0,0,	
0,0,	0,0,	143,145,	0,0,	
143,81,	143,143,	143,143,	0,0,	
145,81,	145,81,	0,0,	0,0,	
0,0,	0,0,	143,143,	143,147,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	143,145,	143,146,	
143,145,	143,145,	143,145,	143,145,	
143,145,	0,0,	0,0,	145,81,	
143,146,	143,145,	143,145,	143,146,	
143,146,	143,146,	0,0,	143,146,	
143,145,	0,0,	0,0,	0,0,	
143,145,	143,145,	0,0,	0,0,	
146,81,	146,81,	0,0,	0,0,	
0,0,	0,0,	143,146,	143,146,	
143,146,	143,146,	143,146,	143,146,	
143,146,	143,146,	143,145,	0,0,	
0,0,	145,267,	0,0,	0,0,	
143,146,	0,0,	0,0,	146,81,	
143,145,	143,145,	145,267,	0,0,	
0,0,	145,267,	145,267,	145,267,	
145,267,	145,267,	271,383,	271,383,	
271,383,	271,383,	271,383,	271,383,	
271,383,	271,383,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
145,267,	145,267,	145,267,	145,267,	
145,267,	145,267,	145,267,	145,267,	
0,0,	146,267,	145,267,	0,0,	
0,0,	145,267,	145,267,	145,267,	
145,267,	145,267,	146,267,	0,0,	
0,0,	146,267,	146,267,	146,267,	
146,267,	146,267,	0,0,	148,148,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	148,148,	
148,269,	0,0,	0,0,	0,0,	
146,267,	146,267,	146,267,	146,267,	
146,267,	146,267,	146,267,	146,267,	
0,0,	0,0,	146,267,	0,0,	
0,0,	146,267,	146,267,	146,267,	
146,267,	146,267,	148,270,	0,0,	
148,148,	148,148,	0,0,	148,148,	
0,0,	148,148,	148,148,	148,148,	
0,0,	148,148,	0,0,	148,148,	
0,0,	148,148,	148,148,	148,148,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	148,148,	
148,148,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	148,148,	
148,148,	148,148,	148,148,	148,148,	
148,148,	148,148,	0,0,	0,0,	
0,0,	148,148,	148,148,	148,148,	
148,148,	148,148,	148,148,	150,272,	
148,148,	148,148,	0,0,	0,0,	
0,0,	148,148,	148,148,	0,0,	
0,0,	0,0,	0,0,	148,148,	
150,273,	0,0,	0,0,	148,148,	
148,148,	148,148,	148,148,	148,148,	
148,148,	148,148,	148,148,	148,148,	
0,0,	0,0,	0,0,	0,0,	
0,0,	148,148,	0,0,	0,0,	
0,0,	148,148,	148,148,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	150,272,	148,148,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	150,274,	
150,274,	150,274,	150,274,	150,274,	
150,274,	150,274,	150,274,	152,272,	
0,0,	0,0,	0,0,	152,275,	
152,275,	152,275,	152,275,	152,275,	
152,275,	152,275,	152,275,	0,0,	
152,273,	0,0,	150,272,	272,274,	
272,274,	272,274,	272,274,	272,274,	
272,274,	272,274,	272,274,	163,272,	
0,0,	0,0,	0,0,	163,275,	
163,275,	163,275,	163,275,	163,275,	
163,275,	163,275,	163,275,	0,0,	
163,273,	0,0,	0,0,	0,0,	
0,0,	0,0,	152,272,	274,384,	
274,384,	274,384,	274,384,	274,384,	
274,384,	274,384,	274,384,	152,274,	
152,274,	152,274,	152,274,	152,274,	
152,274,	152,274,	152,274,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	168,236,	163,272,	0,0,	
0,0,	0,0,	168,289,	0,0,	
0,0,	0,0,	152,272,	163,274,	
163,274,	163,274,	163,274,	163,274,	
163,274,	163,274,	163,274,	168,290,	
0,0,	0,0,	168,239,	0,0,	
0,0,	0,0,	0,0,	168,291,	
0,0,	163,284,	0,0,	0,0,	
0,0,	0,0,	163,272,	0,0,	
168,291,	0,0,	0,0,	168,291,	
0,0,	0,0,	168,291,	168,291,	
0,0,	0,0,	0,0,	0,0,	
0,0,	168,289,	289,292,	289,292,	
289,292,	289,292,	289,292,	289,292,	
289,292,	289,292,	168,292,	168,293,	
168,292,	168,292,	168,292,	168,292,	
168,292,	168,292,	0,0,	0,0,	
168,291,	0,0,	0,0,	168,291,	
0,0,	172,245,	168,291,	168,291,	
0,0,	0,0,	0,0,	0,0,	
0,0,	168,289,	172,294,	172,294,	
172,294,	172,294,	172,294,	172,294,	
172,294,	172,294,	0,0,	174,236,	
0,0,	0,0,	172,246,	0,0,	
174,297,	0,0,	0,0,	172,295,	
292,400,	292,400,	292,400,	292,400,	
292,400,	292,400,	292,400,	292,400,	
172,295,	174,298,	293,357,	172,295,	
174,239,	0,0,	172,295,	172,295,	
0,0,	174,291,	293,400,	293,400,	
293,400,	293,400,	293,400,	293,400,	
293,400,	293,400,	174,291,	0,0,	
0,0,	174,291,	0,0,	172,295,	
174,291,	174,291,	0,0,	0,0,	
0,0,	0,0,	0,0,	174,297,	
172,295,	0,0,	0,0,	172,295,	
0,0,	0,0,	172,295,	172,295,	
174,299,	174,300,	174,299,	174,299,	
174,299,	174,299,	174,299,	174,299,	
0,0,	0,0,	174,291,	0,0,	
0,0,	174,291,	0,0,	177,245,	
174,291,	174,291,	0,0,	0,0,	
177,272,	0,0,	0,0,	174,297,	
177,302,	177,302,	177,302,	177,302,	
177,302,	177,302,	177,302,	177,302,	
0,0,	177,273,	0,0,	0,0,	
177,246,	0,0,	0,0,	0,0,	
0,0,	177,295,	297,299,	297,299,	
297,299,	297,299,	297,299,	297,299,	
297,299,	297,299,	177,295,	0,0,	
0,0,	177,295,	0,0,	0,0,	
177,295,	177,295,	0,0,	0,0,	
0,0,	0,0,	0,0,	177,272,	
299,402,	299,402,	299,402,	299,402,	
299,402,	299,402,	299,402,	299,402,	
177,274,	177,303,	177,274,	177,274,	
177,274,	177,274,	177,274,	177,274,	
0,0,	0,0,	177,295,	0,0,	
0,0,	177,295,	0,0,	0,0,	
177,295,	177,295,	0,0,	0,0,	
178,272,	0,0,	0,0,	177,272,	
178,302,	178,302,	178,302,	178,302,	
178,302,	178,302,	178,302,	178,302,	
300,357,	178,273,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
300,402,	300,402,	300,402,	300,402,	
300,402,	300,402,	300,402,	300,402,	
0,0,	0,0,	186,186,	0,0,	
0,0,	0,0,	0,0,	0,0,	
303,364,	0,0,	186,186,	186,186,	
0,0,	0,0,	0,0,	178,272,	
303,384,	303,384,	303,384,	303,384,	
303,384,	303,384,	303,384,	303,384,	
178,274,	178,274,	178,274,	178,274,	
178,274,	178,274,	178,274,	178,274,	
0,0,	186,186,	0,0,	186,186,	
186,186,	0,0,	186,186,	0,0,	
186,186,	0,0,	186,307,	0,0,	
186,186,	0,0,	186,186,	178,272,	
186,186,	186,186,	186,186,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	186,186,	186,186,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	186,186,	186,186,	
186,186,	186,186,	186,186,	186,186,	
186,186,	0,0,	0,0,	0,0,	
186,186,	186,186,	186,186,	186,186,	
186,186,	186,186,	0,0,	186,186,	
186,186,	0,0,	0,0,	0,0,	
186,186,	186,186,	0,0,	0,0,	
0,0,	0,0,	186,186,	0,0,	
0,0,	0,0,	186,186,	186,186,	
186,186,	186,186,	186,186,	186,186,	
186,186,	186,186,	186,186,	0,0,	
0,0,	0,0,	187,309,	0,0,	
186,186,	0,0,	0,0,	0,0,	
186,186,	186,186,	187,309,	187,309,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	186,186,	332,422,	
332,422,	332,422,	332,422,	332,422,	
332,422,	332,422,	332,422,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	187,309,	0,0,	187,309,	
187,309,	0,0,	187,309,	0,0,	
187,309,	187,310,	187,311,	0,0,	
187,309,	0,0,	187,309,	0,0,	
187,309,	187,309,	187,309,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	187,309,	187,309,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	187,309,	187,309,	
187,309,	187,309,	187,309,	187,309,	
187,309,	0,0,	0,0,	0,0,	
187,309,	187,309,	187,309,	187,309,	
187,309,	187,309,	0,0,	187,309,	
187,309,	0,0,	0,0,	0,0,	
187,309,	187,309,	0,0,	0,0,	
0,0,	0,0,	187,309,	0,0,	
0,0,	0,0,	187,309,	187,309,	
187,309,	187,309,	187,309,	187,309,	
187,309,	187,309,	187,309,	0,0,	
0,0,	0,0,	190,190,	0,0,	
187,309,	0,0,	0,0,	0,0,	
187,309,	187,309,	190,190,	190,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	187,309,	336,338,	
336,338,	336,338,	336,338,	336,338,	
336,338,	336,338,	336,338,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	190,190,	0,0,	190,190,	
190,190,	0,0,	190,190,	0,0,	
190,190,	190,190,	190,313,	0,0,	
190,190,	0,0,	190,190,	0,0,	
190,190,	190,190,	190,190,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	190,190,	190,190,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	190,190,	190,190,	
190,190,	190,190,	190,190,	190,190,	
190,190,	0,0,	0,0,	0,0,	
190,190,	190,190,	190,190,	190,190,	
190,190,	190,190,	0,0,	190,190,	
190,190,	0,0,	0,0,	0,0,	
190,190,	190,190,	0,0,	0,0,	
0,0,	0,0,	190,190,	0,0,	
0,0,	0,0,	190,190,	190,190,	
190,190,	190,190,	190,190,	190,190,	
190,190,	190,190,	190,190,	0,0,	
0,0,	0,0,	191,191,	0,0,	
190,190,	0,0,	0,0,	0,0,	
190,190,	190,190,	191,191,	191,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	190,190,	337,421,	
337,421,	337,421,	337,421,	337,421,	
337,421,	337,421,	337,421,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	191,191,	0,0,	191,191,	
191,191,	0,0,	191,191,	0,0,	
191,191,	191,191,	191,191,	0,0,	
191,191,	0,0,	191,191,	0,0,	
191,191,	191,191,	191,191,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	191,191,	191,191,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	191,191,	191,191,	
191,191,	191,191,	191,191,	191,191,	
191,191,	0,0,	0,0,	0,0,	
191,191,	191,191,	191,191,	191,191,	
191,191,	191,191,	219,336,	191,191,	
191,191,	0,0,	0,0,	0,0,	
191,191,	191,191,	0,0,	0,0,	
0,0,	0,0,	191,191,	219,337,	
0,0,	0,0,	191,191,	191,191,	
191,191,	191,191,	191,191,	191,191,	
191,191,	191,191,	191,191,	227,336,	
0,0,	0,0,	0,0,	0,0,	
191,191,	0,0,	0,0,	275,385,	
191,191,	191,191,	0,0,	0,0,	
227,337,	0,0,	0,0,	0,0,	
0,0,	219,336,	191,314,	0,0,	
275,386,	0,0,	0,0,	0,0,	
0,0,	0,0,	219,338,	219,338,	
219,338,	219,338,	219,338,	219,338,	
219,338,	219,338,	0,0,	0,0,	
0,0,	231,350,	0,0,	0,0,	
0,0,	0,0,	227,336,	0,0,	
0,0,	231,350,	231,0,	0,0,	
0,0,	219,336,	275,385,	227,338,	
227,338,	227,338,	227,338,	227,338,	
227,338,	227,338,	227,338,	275,387,	
275,387,	275,387,	275,387,	275,387,	
275,387,	275,387,	275,387,	0,0,	
231,350,	0,0,	231,350,	231,350,	
0,0,	231,350,	227,336,	231,351,	
231,350,	231,350,	0,0,	231,350,	
0,0,	231,351,	275,385,	231,350,	
231,351,	231,351,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	231,351,	231,350,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	231,351,	231,351,	231,351,	
231,351,	231,351,	231,351,	231,351,	
0,0,	0,0,	0,0,	231,351,	
231,351,	231,351,	231,351,	231,351,	
231,351,	0,0,	231,351,	231,351,	
0,0,	0,0,	0,0,	231,351,	
231,351,	0,0,	0,0,	0,0,	
0,0,	231,350,	0,0,	0,0,	
0,0,	231,351,	231,351,	231,351,	
231,351,	231,351,	231,351,	231,351,	
231,351,	231,351,	0,0,	0,0,	
0,0,	232,232,	0,0,	231,351,	
0,0,	0,0,	0,0,	231,351,	
231,351,	232,232,	232,232,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	231,350,	338,423,	338,423,	
338,423,	338,423,	338,423,	338,423,	
338,423,	338,423,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
232,232,	0,0,	232,232,	232,232,	
0,0,	232,232,	0,0,	232,232,	
232,232,	232,232,	0,0,	232,232,	
0,0,	232,352,	0,0,	232,232,	
232,232,	232,232,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	232,232,	232,232,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	232,232,	232,232,	232,232,	
232,232,	232,232,	232,232,	232,232,	
0,0,	0,0,	0,0,	232,232,	
232,232,	232,232,	232,232,	232,232,	
232,232,	0,0,	232,232,	232,232,	
233,233,	233,233,	0,0,	232,232,	
232,232,	356,439,	356,439,	356,439,	
356,439,	356,439,	356,439,	356,439,	
356,439,	232,232,	232,232,	232,232,	
232,232,	232,232,	232,232,	232,232,	
232,232,	232,232,	0,0,	233,233,	
0,0,	233,234,	0,0,	232,232,	
0,0,	0,0,	0,0,	232,232,	
232,232,	0,0,	0,0,	0,0,	
233,112,	0,0,	0,0,	233,112,	
233,112,	232,232,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
233,112,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
233,112,	233,112,	233,112,	233,112,	
233,112,	233,112,	233,112,	0,0,	
0,0,	0,0,	233,112,	233,112,	
233,112,	233,112,	233,112,	233,112,	
0,0,	233,112,	233,112,	0,0,	
0,0,	234,234,	233,112,	233,112,	
0,0,	0,0,	0,0,	0,0,	
0,0,	234,234,	234,234,	0,0,	
233,112,	233,112,	233,112,	233,112,	
233,112,	233,112,	233,112,	233,112,	
233,112,	0,0,	0,0,	0,0,	
0,0,	0,0,	233,112,	0,0,	
0,0,	0,0,	233,112,	233,112,	
234,234,	0,0,	234,353,	234,234,	
0,0,	234,234,	0,0,	234,234,	
234,234,	234,234,	0,0,	234,234,	
0,0,	234,234,	0,0,	234,234,	
234,234,	234,234,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	234,234,	234,234,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	234,234,	234,234,	234,234,	
234,234,	234,234,	234,234,	234,234,	
0,0,	0,0,	0,0,	234,234,	
234,234,	234,234,	234,234,	234,234,	
234,234,	0,0,	234,234,	234,234,	
0,0,	0,0,	235,245,	234,234,	
234,234,	0,0,	0,0,	0,0,	
0,0,	234,354,	0,0,	0,0,	
0,0,	234,234,	234,234,	234,234,	
234,234,	234,234,	234,234,	234,234,	
234,234,	234,234,	0,0,	235,246,	
0,0,	0,0,	0,0,	234,234,	
235,247,	0,0,	0,0,	234,234,	
234,234,	0,0,	0,0,	0,0,	
243,245,	235,247,	0,0,	0,0,	
235,247,	234,234,	0,0,	235,247,	
235,247,	243,359,	243,359,	243,359,	
243,359,	243,359,	243,359,	243,359,	
243,359,	0,0,	0,0,	0,0,	
0,0,	243,246,	244,361,	0,0,	
235,247,	0,0,	243,360,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	235,247,	0,0,	243,360,	
235,247,	0,0,	243,360,	235,247,	
235,247,	243,360,	243,360,	244,362,	
0,0,	0,0,	0,0,	0,0,	
244,363,	365,445,	365,445,	365,445,	
365,445,	365,445,	365,445,	365,445,	
365,445,	244,363,	243,360,	0,0,	
244,363,	0,0,	0,0,	244,363,	
244,363,	0,0,	0,0,	243,360,	
0,0,	0,0,	243,360,	0,0,	
248,245,	243,360,	243,360,	0,0,	
0,0,	0,0,	0,0,	0,0,	
244,363,	248,330,	248,330,	248,330,	
248,330,	248,330,	248,330,	248,330,	
248,330,	244,363,	254,245,	0,0,	
244,363,	248,246,	0,0,	244,363,	
244,363,	0,0,	248,247,	254,368,	
254,368,	254,368,	254,368,	254,368,	
254,368,	254,368,	254,368,	248,247,	
0,0,	0,0,	248,247,	254,246,	
0,0,	248,247,	248,247,	0,0,	
254,247,	255,361,	0,0,	0,0,	
0,0,	0,0,	255,336,	0,0,	
0,0,	254,247,	0,0,	0,0,	
254,247,	0,0,	248,247,	254,247,	
254,247,	0,0,	0,0,	255,337,	
0,0,	0,0,	255,362,	248,247,	
0,0,	0,0,	248,247,	255,363,	
0,0,	248,247,	248,247,	288,245,	
254,247,	0,0,	0,0,	0,0,	
255,363,	0,0,	0,0,	255,363,	
0,0,	254,247,	255,363,	255,363,	
254,247,	0,0,	262,262,	254,247,	
254,247,	255,336,	0,0,	0,0,	
288,246,	0,0,	262,262,	262,377,	
0,0,	288,295,	255,338,	255,369,	
255,338,	255,338,	255,338,	255,338,	
255,338,	255,338,	288,295,	0,0,	
255,363,	288,295,	0,0,	255,363,	
288,295,	288,295,	255,363,	255,363,	
0,0,	262,262,	0,0,	262,262,	
262,262,	255,336,	262,262,	0,0,	
262,262,	262,262,	262,262,	0,0,	
262,262,	288,295,	262,262,	0,0,	
262,262,	262,262,	262,262,	0,0,	
268,268,	268,379,	288,295,	0,0,	
0,0,	288,295,	262,262,	262,262,	
288,295,	288,295,	0,0,	0,0,	
0,0,	0,0,	262,262,	262,262,	
262,262,	262,262,	262,262,	262,262,	
262,262,	0,0,	0,0,	268,268,	
262,262,	262,262,	262,262,	262,262,	
262,262,	262,262,	0,0,	262,262,	
262,262,	0,0,	0,0,	0,0,	
262,262,	262,262,	0,0,	0,0,	
0,0,	0,0,	262,262,	0,0,	
0,0,	0,0,	262,262,	262,262,	
262,262,	262,262,	262,262,	262,262,	
262,262,	262,262,	262,262,	283,385,	
0,0,	268,380,	0,0,	0,0,	
262,262,	0,0,	0,0,	0,0,	
262,262,	262,262,	268,380,	0,0,	
283,386,	268,380,	268,380,	268,380,	
0,0,	268,380,	262,262,	0,0,	
0,0,	0,0,	0,0,	0,0,	
287,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
268,380,	268,380,	268,380,	268,380,	
268,380,	268,380,	268,380,	268,380,	
0,0,	0,0,	283,385,	0,0,	
0,0,	0,0,	268,380,	0,0,	
0,0,	0,0,	0,0,	283,387,	
283,387,	283,387,	283,387,	283,387,	
283,387,	283,387,	283,387,	287,398,	
0,0,	0,0,	287,398,	287,398,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	287,398,	
287,399,	0,0,	283,385,	0,0,	
0,0,	0,0,	0,0,	287,398,	
287,398,	287,398,	287,398,	287,398,	
287,398,	287,398,	0,0,	0,0,	
0,0,	287,398,	287,398,	287,398,	
287,398,	287,398,	287,398,	369,444,	
287,398,	287,398,	0,0,	0,0,	
294,361,	287,398,	287,398,	369,423,	
369,423,	369,423,	369,423,	369,423,	
369,423,	369,423,	369,423,	287,398,	
287,398,	287,398,	287,398,	287,398,	
287,398,	287,398,	287,398,	287,398,	
0,0,	294,362,	0,0,	0,0,	
0,0,	287,398,	294,401,	0,0,	
0,0,	287,398,	287,398,	0,0,	
0,0,	0,0,	296,245,	294,401,	
0,0,	0,0,	294,401,	0,0,	
0,0,	294,401,	294,401,	296,383,	
296,383,	296,383,	296,383,	296,383,	
296,383,	296,383,	296,383,	0,0,	
0,0,	0,0,	0,0,	296,246,	
0,0,	0,0,	294,401,	0,0,	
296,295,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	294,401,	
301,245,	296,295,	294,401,	0,0,	
296,295,	294,401,	294,401,	296,295,	
296,295,	301,403,	301,403,	301,403,	
301,403,	301,403,	301,403,	301,403,	
301,403,	0,0,	0,0,	0,0,	
0,0,	301,246,	0,0,	0,0,	
296,295,	0,0,	301,295,	302,361,	
0,0,	0,0,	0,0,	0,0,	
302,385,	296,295,	0,0,	301,295,	
296,295,	0,0,	301,295,	296,295,	
296,295,	301,295,	301,295,	0,0,	
0,0,	302,386,	0,0,	0,0,	
302,362,	0,0,	0,0,	0,0,	
0,0,	302,401,	0,0,	0,0,	
0,0,	358,440,	301,295,	0,0,	
0,0,	0,0,	302,401,	0,0,	
0,0,	302,401,	0,0,	301,295,	
302,401,	302,401,	301,295,	0,0,	
310,310,	301,295,	301,295,	302,385,	
0,0,	0,0,	358,441,	0,0,	
310,310,	310,310,	0,0,	358,442,	
302,387,	302,404,	302,387,	302,387,	
302,387,	302,387,	302,387,	302,387,	
358,442,	0,0,	302,401,	358,442,	
0,0,	302,401,	358,442,	358,442,	
302,401,	302,401,	0,0,	310,310,	
0,0,	310,310,	310,310,	302,385,	
310,310,	0,0,	310,310,	310,0,	
0,0,	0,0,	310,310,	358,442,	
310,310,	0,0,	310,310,	310,310,	
310,310,	0,0,	0,0,	0,0,	
358,442,	0,0,	0,0,	358,442,	
310,310,	310,310,	358,442,	358,442,	
0,0,	0,0,	0,0,	0,0,	
310,310,	310,310,	310,310,	310,310,	
310,310,	310,310,	310,310,	0,0,	
0,0,	0,0,	310,310,	310,310,	
310,310,	310,310,	310,310,	310,310,	
331,337,	310,310,	310,310,	0,0,	
0,0,	0,0,	310,310,	310,310,	
0,0,	0,0,	0,0,	0,0,	
310,310,	331,337,	0,0,	0,0,	
310,310,	310,310,	310,310,	310,310,	
310,310,	310,310,	310,310,	310,310,	
310,310,	0,0,	0,0,	0,0,	
0,0,	0,0,	310,310,	0,0,	
344,431,	0,0,	310,310,	310,310,	
0,0,	0,0,	0,0,	0,0,	
344,431,	344,0,	0,0,	331,337,	
310,310,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
331,421,	331,421,	331,421,	331,421,	
331,421,	331,421,	331,421,	331,421,	
0,0,	0,0,	0,0,	344,431,	
0,0,	344,431,	344,431,	0,0,	
344,431,	0,0,	344,432,	344,431,	
344,431,	0,0,	344,431,	331,337,	
344,432,	0,0,	344,431,	344,432,	
344,432,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
344,432,	344,431,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
344,432,	344,432,	344,432,	344,432,	
344,432,	344,432,	344,432,	0,0,	
0,0,	0,0,	344,432,	344,432,	
344,432,	344,432,	344,432,	344,432,	
0,0,	344,432,	344,432,	350,0,	
0,0,	0,0,	344,432,	344,432,	
0,0,	0,0,	0,0,	0,0,	
344,431,	0,0,	0,0,	0,0,	
344,432,	344,432,	344,432,	344,432,	
344,344,	344,432,	344,432,	344,432,	
344,432,	0,0,	0,0,	0,0,	
0,0,	0,0,	344,432,	0,0,	
350,350,	0,0,	344,344,	344,344,	
0,0,	0,0,	350,350,	0,0,	
0,0,	350,350,	350,350,	0,0,	
344,431,	0,0,	0,0,	0,0,	
0,0,	0,0,	350,350,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	350,350,	350,350,	
350,350,	350,350,	350,350,	350,350,	
350,350,	0,0,	0,0,	0,0,	
350,350,	350,350,	350,350,	350,350,	
350,350,	350,350,	0,0,	350,350,	
350,350,	0,0,	0,0,	352,232,	
350,350,	350,350,	0,0,	0,0,	
0,0,	0,0,	0,0,	352,232,	
352,232,	0,0,	350,350,	350,350,	
350,350,	350,350,	350,350,	350,350,	
350,350,	350,350,	350,350,	0,0,	
0,0,	0,0,	0,0,	0,0,	
350,350,	0,0,	0,0,	0,0,	
350,350,	350,350,	352,232,	0,0,	
352,232,	352,232,	0,0,	352,232,	
0,0,	352,232,	352,232,	352,232,	
0,0,	352,232,	0,0,	352,435,	
0,0,	352,232,	352,232,	352,232,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	352,232,	
352,232,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	352,232,	
352,232,	352,232,	352,232,	352,232,	
352,232,	352,232,	0,0,	353,353,	
353,353,	352,232,	352,232,	352,232,	
352,232,	352,232,	352,232,	0,0,	
352,232,	352,232,	0,0,	0,0,	
0,0,	352,232,	352,232,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	353,353,	352,232,	
352,232,	352,232,	352,232,	352,232,	
352,232,	352,232,	352,232,	352,232,	
0,0,	0,0,	0,0,	353,112,	
0,0,	352,232,	353,112,	353,112,	
0,0,	352,232,	352,232,	0,0,	
0,0,	0,0,	0,0,	353,112,	
0,0,	0,0,	0,0,	352,232,	
0,0,	0,0,	0,0,	353,112,	
353,112,	353,112,	353,112,	353,112,	
353,112,	353,112,	0,0,	0,0,	
0,0,	353,112,	353,112,	353,112,	
353,112,	353,112,	353,112,	0,0,	
353,112,	353,112,	0,0,	0,0,	
354,437,	353,112,	353,112,	0,0,	
0,0,	0,0,	0,0,	353,436,	
354,437,	354,437,	0,0,	353,112,	
353,112,	353,112,	353,112,	353,112,	
353,112,	353,112,	353,112,	353,112,	
0,0,	0,0,	0,0,	0,0,	
0,0,	353,112,	0,0,	0,0,	
0,0,	353,112,	353,112,	354,437,	
0,0,	354,438,	354,437,	0,0,	
354,437,	0,0,	354,437,	354,437,	
354,437,	0,0,	354,437,	0,0,	
354,437,	0,0,	354,437,	354,437,	
354,437,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
354,437,	354,437,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
354,437,	354,437,	354,437,	354,437,	
354,437,	354,437,	354,437,	0,0,	
0,0,	0,0,	354,437,	354,437,	
354,437,	354,437,	354,437,	354,437,	
0,0,	354,437,	354,437,	0,0,	
0,0,	359,361,	354,437,	354,437,	
0,0,	0,0,	0,0,	0,0,	
354,437,	0,0,	0,0,	366,440,	
354,437,	354,437,	354,437,	354,437,	
354,437,	354,437,	354,437,	354,437,	
354,437,	0,0,	359,362,	0,0,	
0,0,	0,0,	354,437,	359,443,	
0,0,	361,443,	354,437,	354,437,	
366,441,	0,0,	0,0,	0,0,	
359,443,	366,442,	361,443,	359,443,	
354,437,	361,443,	359,443,	359,443,	
361,443,	361,443,	366,442,	0,0,	
0,0,	366,442,	0,0,	0,0,	
366,442,	366,442,	0,0,	0,0,	
0,0,	0,0,	0,0,	359,443,	
0,0,	361,443,	368,361,	0,0,	
0,0,	0,0,	0,0,	0,0,	
359,443,	366,442,	361,443,	359,443,	
0,0,	361,443,	359,443,	359,443,	
361,443,	361,443,	366,442,	0,0,	
0,0,	366,442,	0,0,	368,362,	
366,442,	366,442,	392,0,	0,0,	
368,363,	385,387,	385,387,	385,387,	
385,387,	385,387,	385,387,	385,387,	
385,387,	368,363,	0,0,	0,0,	
368,363,	0,0,	0,0,	368,363,	
368,363,	387,458,	387,458,	387,458,	
387,458,	387,458,	387,458,	387,458,	
387,458,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
368,363,	392,464,	0,0,	0,0,	
392,464,	392,464,	0,0,	0,0,	
0,0,	368,363,	0,0,	0,0,	
368,363,	392,464,	392,465,	368,363,	
368,363,	0,0,	0,0,	0,0,	
0,0,	392,464,	392,464,	392,464,	
392,464,	392,464,	392,464,	392,464,	
0,0,	0,0,	398,0,	392,464,	
392,464,	392,464,	392,464,	392,464,	
392,464,	404,444,	392,464,	392,464,	
0,0,	0,0,	0,0,	392,464,	
392,464,	404,458,	404,458,	404,458,	
404,458,	404,458,	404,458,	404,458,	
404,458,	392,464,	392,464,	392,464,	
392,464,	392,392,	392,464,	392,464,	
392,464,	392,464,	0,0,	0,0,	
0,0,	398,398,	0,0,	392,464,	
398,398,	398,398,	0,0,	392,392,	
392,392,	0,0,	0,0,	0,0,	
0,0,	398,398,	398,399,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	398,398,	398,398,	398,398,	
398,398,	398,398,	398,398,	398,398,	
0,0,	0,0,	0,0,	398,398,	
398,398,	398,398,	398,398,	398,398,	
398,398,	0,0,	398,398,	398,398,	
399,0,	0,0,	0,0,	398,398,	
398,398,	421,485,	421,485,	421,485,	
421,485,	421,485,	421,485,	421,485,	
421,485,	398,398,	398,398,	398,398,	
398,398,	398,398,	398,398,	398,398,	
398,398,	398,398,	399,468,	0,0,	
0,0,	0,0,	0,0,	398,398,	
0,0,	399,350,	0,0,	398,398,	
398,398,	0,0,	0,0,	399,350,	
0,0,	0,0,	399,350,	399,350,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	399,350,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	399,350,	
399,350,	399,350,	399,350,	399,350,	
399,350,	399,350,	0,0,	0,0,	
0,0,	399,350,	399,350,	399,350,	
399,350,	399,350,	399,350,	0,0,	
399,350,	399,350,	0,0,	0,0,	
400,440,	399,350,	399,350,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	402,440,	399,350,	
399,350,	399,350,	399,350,	399,350,	
399,350,	399,350,	399,350,	399,350,	
0,0,	400,441,	0,0,	0,0,	
0,0,	399,350,	400,469,	0,0,	
0,0,	399,350,	399,350,	402,441,	
0,0,	0,0,	403,361,	400,469,	
402,469,	0,0,	400,469,	0,0,	
0,0,	400,469,	400,469,	0,0,	
0,0,	402,469,	0,0,	440,501,	
402,469,	0,0,	0,0,	402,469,	
402,469,	0,0,	0,0,	403,362,	
440,501,	0,0,	400,469,	440,501,	
403,401,	0,0,	440,501,	440,501,	
0,0,	0,0,	0,0,	400,469,	
402,469,	403,401,	400,469,	0,0,	
403,401,	400,469,	400,469,	403,401,	
403,401,	402,469,	409,409,	440,501,	
402,469,	0,0,	0,0,	402,469,	
402,469,	0,0,	409,409,	409,0,	
440,501,	0,0,	0,0,	440,501,	
403,401,	0,0,	440,501,	440,501,	
0,0,	0,0,	0,0,	0,0,	
0,0,	403,401,	0,0,	0,0,	
403,401,	0,0,	0,0,	403,401,	
403,401,	409,409,	0,0,	409,409,	
409,409,	0,0,	409,409,	0,0,	
409,409,	409,409,	409,473,	0,0,	
409,409,	0,0,	409,409,	0,0,	
409,409,	409,409,	409,409,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	409,409,	409,409,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	409,409,	409,409,	
409,409,	409,409,	409,409,	409,409,	
409,409,	0,0,	0,0,	0,0,	
409,409,	409,409,	409,409,	409,409,	
409,409,	409,409,	0,0,	409,409,	
409,409,	0,0,	0,0,	0,0,	
409,409,	409,409,	0,0,	0,0,	
0,0,	0,0,	409,409,	0,0,	
0,0,	0,0,	409,409,	409,409,	
409,409,	409,409,	409,409,	409,409,	
409,409,	409,409,	409,409,	0,0,	
0,0,	0,0,	410,410,	0,0,	
409,409,	0,0,	0,0,	0,0,	
409,409,	409,409,	410,410,	410,0,	
0,0,	486,527,	0,0,	0,0,	
0,0,	0,0,	409,409,	0,0,	
0,0,	0,0,	486,527,	0,0,	
0,0,	486,527,	0,0,	0,0,	
486,527,	486,527,	0,0,	0,0,	
0,0,	410,410,	0,0,	410,410,	
410,410,	0,0,	410,410,	0,0,	
410,410,	410,410,	410,410,	0,0,	
410,410,	486,527,	410,410,	0,0,	
410,410,	410,410,	410,410,	0,0,	
0,0,	0,0,	486,527,	0,0,	
0,0,	486,527,	410,410,	410,410,	
486,527,	486,527,	0,0,	0,0,	
0,0,	0,0,	410,410,	410,410,	
410,410,	410,410,	410,410,	410,410,	
410,410,	0,0,	0,0,	0,0,	
410,410,	410,410,	410,410,	410,410,	
410,410,	410,410,	0,0,	410,410,	
410,410,	0,0,	0,0,	0,0,	
410,410,	410,410,	0,0,	0,0,	
0,0,	0,0,	410,410,	0,0,	
0,0,	0,0,	410,410,	410,410,	
410,410,	410,410,	410,410,	410,410,	
410,410,	410,410,	410,410,	0,0,	
0,0,	0,0,	411,411,	0,0,	
410,410,	0,0,	0,0,	0,0,	
410,410,	410,410,	411,411,	411,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	410,474,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	411,411,	0,0,	411,411,	
411,411,	0,0,	411,411,	0,0,	
411,411,	411,411,	411,475,	0,0,	
411,411,	0,0,	411,411,	0,0,	
411,411,	411,411,	411,411,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	411,411,	411,411,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	411,411,	411,411,	
411,411,	411,411,	411,411,	411,411,	
411,411,	0,0,	0,0,	0,0,	
411,411,	411,411,	411,411,	411,411,	
411,411,	411,411,	0,0,	411,411,	
411,411,	0,0,	0,0,	0,0,	
411,411,	411,411,	0,0,	0,0,	
0,0,	0,0,	411,411,	0,0,	
0,0,	0,0,	411,411,	411,411,	
411,411,	411,411,	411,411,	411,411,	
411,411,	411,411,	411,411,	0,0,	
0,0,	0,0,	412,412,	0,0,	
411,411,	0,0,	0,0,	0,0,	
411,411,	411,411,	412,412,	412,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	411,411,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	412,412,	0,0,	412,412,	
412,412,	0,0,	412,412,	0,0,	
412,412,	412,412,	412,412,	0,0,	
412,412,	0,0,	412,412,	0,0,	
412,412,	412,412,	412,412,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	412,412,	412,412,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	412,412,	412,412,	
412,412,	412,412,	412,412,	412,412,	
412,412,	0,0,	0,0,	0,0,	
412,412,	412,412,	412,412,	412,412,	
412,412,	412,412,	0,0,	412,412,	
412,412,	0,0,	0,0,	0,0,	
412,412,	412,412,	0,0,	0,0,	
0,0,	0,0,	412,412,	0,0,	
0,0,	0,0,	412,412,	412,412,	
412,412,	412,412,	412,412,	412,412,	
412,412,	412,412,	412,412,	0,0,	
0,0,	0,0,	413,413,	0,0,	
412,412,	0,0,	0,0,	0,0,	
412,412,	412,412,	413,413,	413,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	412,476,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	413,413,	0,0,	413,413,	
413,413,	0,0,	413,413,	0,0,	
413,413,	413,413,	413,477,	0,0,	
413,413,	0,0,	413,413,	0,0,	
413,413,	413,413,	413,413,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	413,413,	413,413,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	413,413,	413,413,	
413,413,	413,413,	413,413,	413,413,	
413,413,	0,0,	0,0,	0,0,	
413,413,	413,413,	413,413,	413,413,	
413,413,	413,413,	0,0,	413,413,	
413,413,	0,0,	0,0,	0,0,	
413,413,	413,413,	0,0,	0,0,	
0,0,	0,0,	413,413,	0,0,	
0,0,	0,0,	413,413,	413,413,	
413,413,	413,413,	413,413,	413,413,	
413,413,	413,413,	413,413,	0,0,	
0,0,	0,0,	414,414,	0,0,	
413,413,	0,0,	0,0,	0,0,	
413,413,	413,413,	414,414,	414,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	413,413,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	414,414,	0,0,	414,414,	
414,414,	0,0,	414,414,	0,0,	
414,414,	414,414,	414,414,	0,0,	
414,414,	0,0,	414,414,	0,0,	
414,414,	414,414,	414,414,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	414,414,	414,414,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	414,414,	414,414,	
414,414,	414,414,	414,414,	414,414,	
414,414,	0,0,	0,0,	0,0,	
414,414,	414,414,	414,414,	414,414,	
414,414,	414,414,	0,0,	414,414,	
414,414,	0,0,	0,0,	423,486,	
414,414,	414,414,	0,0,	0,0,	
0,0,	0,0,	414,414,	0,0,	
0,0,	0,0,	414,414,	414,414,	
414,414,	414,414,	414,414,	414,414,	
414,414,	414,414,	414,414,	0,0,	
423,487,	431,0,	0,0,	0,0,	
414,414,	423,488,	0,0,	0,0,	
414,414,	414,414,	0,0,	0,0,	
0,0,	0,0,	423,488,	0,0,	
0,0,	423,488,	414,478,	0,0,	
423,488,	423,488,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	431,431,	0,0,	
0,0,	0,0,	0,0,	0,0,	
431,431,	423,488,	0,0,	431,431,	
431,431,	0,0,	0,0,	0,0,	
0,0,	0,0,	423,488,	0,0,	
431,431,	423,488,	0,0,	0,0,	
423,488,	423,488,	0,0,	0,0,	
431,431,	431,431,	431,431,	431,431,	
431,431,	431,431,	431,431,	0,0,	
0,0,	0,0,	431,431,	431,431,	
431,431,	431,431,	431,431,	431,431,	
0,0,	431,431,	431,431,	0,0,	
0,0,	435,232,	431,431,	431,431,	
0,0,	0,0,	0,0,	0,0,	
0,0,	435,232,	435,232,	0,0,	
431,431,	431,431,	431,431,	431,431,	
431,431,	431,431,	431,431,	431,431,	
431,431,	0,0,	0,0,	0,0,	
0,0,	0,0,	431,431,	0,0,	
0,0,	0,0,	431,431,	431,431,	
435,232,	0,0,	435,232,	435,232,	
0,0,	435,232,	0,0,	435,232,	
435,232,	435,232,	0,0,	435,232,	
0,0,	435,435,	0,0,	435,232,	
435,232,	435,232,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	435,232,	435,232,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	435,232,	435,232,	435,232,	
435,232,	435,232,	435,232,	435,232,	
0,0,	0,0,	0,0,	435,232,	
435,232,	435,232,	435,232,	435,232,	
435,232,	0,0,	435,232,	435,232,	
0,0,	0,0,	439,440,	435,232,	
435,232,	0,0,	0,0,	0,0,	
0,0,	435,499,	0,0,	0,0,	
0,0,	435,232,	435,232,	435,232,	
435,232,	435,232,	435,232,	435,232,	
435,232,	435,232,	0,0,	439,441,	
0,0,	0,0,	0,0,	435,232,	
439,501,	0,0,	0,0,	435,232,	
435,232,	0,0,	0,0,	0,0,	
0,0,	439,501,	0,0,	0,0,	
439,501,	435,232,	0,0,	439,501,	
439,501,	0,0,	454,506,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	454,454,	0,0,	
0,0,	0,0,	0,0,	0,0,	
439,501,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	439,501,	0,0,	0,0,	
439,501,	0,0,	0,0,	439,501,	
439,501,	454,454,	0,0,	454,506,	
454,506,	0,0,	454,506,	0,0,	
454,506,	454,506,	454,506,	0,0,	
454,506,	0,0,	454,506,	0,0,	
454,506,	454,506,	454,506,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	454,506,	454,506,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	454,506,	454,506,	
454,506,	454,506,	454,506,	454,506,	
454,506,	0,0,	0,0,	0,0,	
454,506,	454,506,	454,506,	454,506,	
454,506,	454,506,	0,0,	454,506,	
454,506,	0,0,	0,0,	0,0,	
454,506,	454,506,	0,0,	0,0,	
0,0,	0,0,	454,506,	0,0,	
0,0,	0,0,	454,506,	454,506,	
454,506,	454,506,	454,506,	454,506,	
454,506,	454,506,	454,506,	0,0,	
0,0,	0,0,	455,506,	0,0,	
454,506,	0,0,	0,0,	0,0,	
454,506,	454,506,	455,455,	455,379,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	454,506,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	455,455,	0,0,	455,506,	
455,506,	0,0,	455,506,	0,0,	
455,506,	455,506,	455,506,	0,0,	
455,506,	0,0,	455,506,	0,0,	
455,506,	455,506,	455,506,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	455,506,	455,506,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	455,506,	455,507,	
455,506,	455,506,	455,506,	455,506,	
455,506,	0,0,	0,0,	0,0,	
455,507,	455,506,	455,506,	455,507,	
455,507,	455,507,	0,0,	455,507,	
455,506,	0,0,	0,0,	458,486,	
455,506,	455,506,	0,0,	0,0,	
0,0,	0,0,	455,506,	0,0,	
0,0,	0,0,	455,507,	455,507,	
455,507,	455,507,	455,507,	455,507,	
455,507,	455,507,	455,506,	0,0,	
458,487,	0,0,	0,0,	464,0,	
455,507,	458,510,	0,0,	0,0,	
455,506,	455,506,	0,0,	0,0,	
0,0,	0,0,	458,510,	0,0,	
0,0,	458,510,	455,506,	0,0,	
458,510,	458,510,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	458,510,	464,464,	0,0,	
0,0,	464,464,	464,464,	0,0,	
0,0,	0,0,	458,510,	0,0,	
0,0,	458,510,	464,464,	464,465,	
458,510,	458,510,	0,0,	0,0,	
0,0,	0,0,	464,464,	464,464,	
464,464,	464,464,	464,464,	464,464,	
464,464,	0,0,	0,0,	0,0,	
464,464,	464,464,	464,464,	464,464,	
464,464,	464,464,	0,0,	464,464,	
464,464,	465,0,	0,0,	0,0,	
464,464,	464,464,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	464,464,	464,464,	
464,464,	464,464,	464,464,	464,464,	
464,464,	464,464,	464,464,	465,514,	
0,0,	0,0,	0,0,	0,0,	
464,464,	0,0,	465,431,	0,0,	
464,464,	464,464,	0,0,	0,0,	
465,431,	0,0,	0,0,	465,431,	
465,431,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
465,431,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
465,431,	465,431,	465,431,	465,431,	
465,431,	465,431,	465,431,	0,0,	
0,0,	0,0,	465,431,	465,431,	
465,431,	465,431,	465,431,	465,431,	
0,0,	465,431,	465,431,	0,0,	
0,0,	468,468,	465,431,	465,431,	
0,0,	0,0,	0,0,	0,0,	
0,0,	468,468,	0,0,	0,0,	
465,431,	465,431,	465,431,	465,431,	
465,431,	465,431,	465,431,	465,431,	
465,431,	0,0,	0,0,	0,0,	
0,0,	0,0,	465,431,	0,0,	
0,0,	0,0,	465,431,	465,431,	
468,468,	0,0,	468,468,	468,468,	
0,0,	468,468,	0,0,	468,468,	
468,468,	468,468,	0,0,	468,468,	
0,0,	468,468,	0,0,	468,468,	
468,468,	468,468,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	468,468,	468,468,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	468,468,	468,468,	468,468,	
468,468,	468,468,	468,468,	468,468,	
0,0,	0,0,	0,0,	468,468,	
468,468,	468,468,	468,468,	468,468,	
468,468,	0,0,	468,468,	468,468,	
0,0,	0,0,	485,486,	468,468,	
468,468,	0,0,	0,0,	0,0,	
0,0,	468,468,	0,0,	0,0,	
0,0,	468,468,	468,468,	468,468,	
468,468,	468,468,	468,468,	468,468,	
468,468,	468,468,	0,0,	485,487,	
0,0,	0,0,	0,0,	468,468,	
485,527,	0,0,	0,0,	468,468,	
468,468,	0,0,	0,0,	0,0,	
0,0,	485,527,	0,0,	0,0,	
485,527,	468,468,	0,0,	485,527,	
485,527,	0,0,	490,490,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	490,490,	490,0,	
0,0,	0,0,	0,0,	0,0,	
485,527,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	485,527,	0,0,	0,0,	
485,527,	0,0,	0,0,	485,527,	
485,527,	490,490,	0,0,	490,490,	
490,490,	0,0,	490,490,	0,0,	
490,490,	490,490,	490,529,	0,0,	
490,490,	0,0,	490,490,	0,0,	
490,490,	490,490,	490,490,	0,0,	
506,506,	506,377,	0,0,	0,0,	
0,0,	0,0,	490,490,	490,490,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	490,490,	490,490,	
490,490,	490,490,	490,490,	490,490,	
490,490,	0,0,	0,0,	506,506,	
490,490,	490,490,	490,490,	490,490,	
490,490,	490,490,	0,0,	490,490,	
490,490,	0,0,	0,0,	0,0,	
490,490,	490,490,	0,0,	507,506,	
507,377,	0,0,	490,490,	0,0,	
0,0,	0,0,	490,490,	490,490,	
490,490,	490,490,	490,490,	490,490,	
490,490,	490,490,	490,490,	0,0,	
0,0,	506,506,	0,0,	0,0,	
490,490,	0,0,	507,506,	0,0,	
490,490,	490,490,	506,506,	0,0,	
0,0,	506,506,	506,506,	506,506,	
0,0,	506,506,	490,490,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
506,506,	506,506,	506,506,	506,506,	
506,506,	506,506,	506,506,	506,506,	
507,506,	0,0,	0,0,	0,0,	
0,0,	0,0,	506,506,	0,0,	
0,0,	507,506,	514,514,	0,0,	
507,506,	507,506,	507,506,	0,0,	
507,506,	0,0,	514,514,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	507,506,	
507,506,	507,506,	507,506,	507,506,	
507,506,	507,506,	507,506,	0,0,	
0,0,	514,514,	0,0,	514,514,	
514,514,	507,506,	514,514,	0,0,	
514,514,	514,514,	514,514,	0,0,	
514,514,	0,0,	514,514,	0,0,	
514,514,	514,514,	514,514,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	514,514,	514,514,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	514,514,	514,514,	
514,514,	514,514,	514,514,	514,514,	
514,514,	0,0,	0,0,	0,0,	
514,514,	514,514,	514,514,	514,514,	
514,514,	514,514,	0,0,	514,514,	
514,514,	0,0,	0,0,	0,0,	
514,514,	514,514,	0,0,	0,0,	
0,0,	0,0,	514,514,	0,0,	
0,0,	0,0,	514,514,	514,514,	
514,514,	514,514,	514,514,	514,514,	
514,514,	514,514,	514,514,	0,0,	
0,0,	0,0,	559,573,	0,0,	
514,514,	0,0,	0,0,	0,0,	
514,514,	514,514,	559,573,	559,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	514,514,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	559,573,	0,0,	559,573,	
559,573,	0,0,	559,573,	0,0,	
559,559,	559,573,	559,573,	0,0,	
559,573,	0,0,	559,559,	0,0,	
559,573,	559,559,	559,559,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	559,559,	559,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	559,559,	559,559,	
559,559,	559,559,	559,559,	559,559,	
559,574,	0,0,	0,0,	565,0,	
559,559,	559,559,	559,559,	559,559,	
559,559,	559,559,	0,0,	559,559,	
559,559,	0,0,	0,0,	0,0,	
559,559,	559,559,	0,0,	0,0,	
0,0,	0,0,	559,573,	0,0,	
0,0,	0,0,	559,559,	559,559,	
559,559,	559,559,	559,559,	559,559,	
559,574,	559,559,	559,559,	0,0,	
0,0,	0,0,	565,565,	0,0,	
559,559,	565,565,	565,565,	0,0,	
559,559,	559,559,	0,0,	0,0,	
0,0,	0,0,	565,565,	565,580,	
0,0,	0,0,	559,573,	0,0,	
0,0,	0,0,	565,565,	565,565,	
565,565,	565,565,	565,565,	565,565,	
565,581,	0,0,	0,0,	0,0,	
565,565,	565,565,	565,565,	565,565,	
565,565,	565,565,	0,0,	565,565,	
565,565,	573,0,	0,0,	0,0,	
565,565,	565,565,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	565,565,	565,565,	
565,565,	565,565,	565,565,	565,565,	
565,581,	565,565,	565,565,	0,0,	
0,0,	0,0,	0,0,	0,0,	
565,565,	0,0,	573,573,	0,0,	
565,565,	565,565,	0,0,	0,0,	
573,573,	0,0,	0,0,	573,573,	
573,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
573,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
573,573,	573,573,	573,573,	573,573,	
573,573,	573,573,	573,586,	0,0,	
0,0,	0,0,	573,573,	573,573,	
573,573,	573,573,	573,573,	573,573,	
0,0,	573,573,	573,573,	580,0,	
0,0,	0,0,	573,573,	573,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
573,573,	573,573,	573,573,	573,573,	
573,573,	573,573,	573,586,	573,573,	
573,573,	580,593,	0,0,	0,0,	
0,0,	0,0,	573,573,	0,0,	
580,573,	0,0,	573,573,	573,573,	
0,0,	0,0,	580,573,	0,0,	
0,0,	580,573,	580,573,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	580,573,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	580,573,	580,573,	
580,573,	580,573,	580,573,	580,573,	
580,586,	0,0,	0,0,	581,0,	
580,573,	580,573,	580,573,	580,573,	
580,573,	580,573,	0,0,	580,573,	
580,573,	0,0,	0,0,	0,0,	
580,573,	580,573,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	580,573,	580,573,	
580,573,	580,573,	580,573,	580,573,	
580,586,	580,573,	580,573,	0,0,	
0,0,	0,0,	581,565,	0,0,	
580,573,	581,565,	581,565,	0,0,	
580,573,	580,573,	0,0,	0,0,	
0,0,	0,0,	581,565,	581,580,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	581,594,	581,565,	
581,565,	581,565,	581,565,	581,565,	
581,581,	0,0,	0,0,	0,0,	
581,565,	581,565,	581,565,	581,565,	
581,565,	581,565,	0,0,	581,565,	
581,565,	586,0,	0,0,	0,0,	
581,565,	581,565,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	581,595,	581,565,	
581,565,	581,565,	581,565,	581,565,	
581,581,	581,565,	581,565,	0,0,	
0,0,	0,0,	0,0,	0,0,	
581,565,	0,0,	586,573,	0,0,	
581,565,	581,565,	0,0,	0,0,	
586,573,	0,0,	0,0,	586,573,	
586,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
586,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
586,599,	586,573,	586,573,	586,573,	
586,573,	586,573,	586,586,	0,0,	
0,0,	0,0,	586,573,	586,573,	
586,573,	586,573,	586,573,	586,573,	
0,0,	586,573,	586,573,	0,0,	
0,0,	593,593,	586,573,	586,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	593,593,	0,0,	0,0,	
586,600,	586,573,	586,573,	586,573,	
586,573,	586,573,	586,586,	586,573,	
586,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	586,573,	0,0,	
0,0,	0,0,	586,573,	586,573,	
593,593,	0,0,	593,593,	593,593,	
0,0,	593,593,	0,0,	593,593,	
593,593,	593,593,	0,0,	593,593,	
0,0,	593,593,	0,0,	593,593,	
593,593,	593,593,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	593,593,	593,593,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	593,593,	593,593,	593,593,	
593,593,	593,593,	593,593,	593,607,	
0,0,	0,0,	594,0,	593,593,	
593,593,	593,593,	593,593,	593,593,	
593,593,	0,0,	593,593,	593,593,	
0,0,	0,0,	0,0,	593,593,	
593,593,	0,0,	0,0,	0,0,	
0,0,	593,593,	0,0,	0,0,	
0,0,	593,593,	593,593,	593,593,	
593,593,	593,593,	593,593,	593,607,	
593,593,	593,593,	0,0,	0,0,	
0,0,	594,565,	0,0,	593,593,	
594,565,	594,565,	0,0,	593,593,	
593,593,	0,0,	0,0,	0,0,	
0,0,	594,565,	594,580,	0,0,	
0,0,	593,593,	0,0,	0,0,	
0,0,	594,565,	594,565,	594,565,	
594,565,	594,565,	594,565,	594,581,	
0,0,	0,0,	0,0,	594,565,	
594,565,	594,608,	594,565,	594,565,	
594,565,	0,0,	594,565,	594,565,	
595,0,	0,0,	0,0,	594,565,	
594,565,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	594,565,	594,565,	594,565,	
594,565,	594,565,	594,565,	594,581,	
594,565,	594,565,	0,0,	0,0,	
0,0,	594,565,	0,0,	594,565,	
0,0,	0,0,	0,0,	594,565,	
594,565,	0,0,	0,0,	595,565,	
0,0,	0,0,	595,565,	595,565,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	595,565,	
595,580,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	595,565,	
595,565,	595,565,	595,565,	595,565,	
595,565,	595,581,	0,0,	0,0,	
0,0,	595,565,	595,565,	595,565,	
595,565,	595,565,	595,565,	0,0,	
595,565,	595,565,	599,0,	0,0,	
0,0,	595,565,	595,565,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	595,565,	
595,565,	595,565,	595,565,	595,565,	
595,565,	595,581,	595,565,	595,565,	
0,0,	0,0,	0,0,	595,609,	
0,0,	595,565,	0,0,	599,573,	
0,0,	595,565,	595,565,	0,0,	
0,0,	599,573,	0,0,	0,0,	
599,573,	599,573,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	599,573,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	599,573,	599,573,	599,573,	
599,573,	599,573,	599,573,	599,586,	
0,0,	0,0,	0,0,	599,573,	
599,573,	599,613,	599,573,	599,573,	
599,573,	0,0,	599,573,	599,573,	
600,0,	0,0,	0,0,	599,573,	
599,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	599,573,	599,573,	599,573,	
599,573,	599,573,	599,573,	599,586,	
599,573,	599,573,	0,0,	0,0,	
0,0,	599,573,	0,0,	599,573,	
0,0,	600,573,	0,0,	599,573,	
599,573,	0,0,	0,0,	600,573,	
0,0,	0,0,	600,573,	600,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	601,0,	0,0,	600,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	600,573,	
600,573,	600,573,	600,573,	600,573,	
600,573,	600,586,	0,0,	0,0,	
0,0,	600,573,	600,573,	600,573,	
600,573,	600,573,	600,573,	0,0,	
600,573,	600,573,	0,0,	0,0,	
0,0,	600,573,	600,573,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	600,573,	
600,573,	600,573,	600,573,	600,573,	
600,573,	600,586,	600,573,	600,573,	
0,0,	0,0,	0,0,	600,614,	
0,0,	600,573,	0,0,	0,0,	
601,615,	600,573,	600,573,	601,559,	
601,559,	601,559,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	601,559,	
601,559,	601,559,	0,0,	0,0,	
601,559,	601,559,	0,0,	607,593,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	607,593,	
0,0,	0,0,	0,0,	0,0,	
0,0,	601,559,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
601,559,	601,559,	0,0,	0,0,	
601,559,	601,559,	607,593,	0,0,	
607,593,	607,593,	0,0,	607,593,	
0,0,	607,593,	607,593,	607,593,	
0,0,	607,593,	0,0,	607,593,	
0,0,	607,593,	607,593,	607,593,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	607,593,	
607,593,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	607,620,	
607,593,	607,593,	607,593,	607,593,	
607,593,	607,607,	0,0,	0,0,	
0,0,	607,593,	607,593,	607,593,	
607,593,	607,593,	607,593,	0,0,	
607,593,	607,593,	0,0,	0,0,	
0,0,	607,593,	607,593,	0,0,	
0,0,	0,0,	0,0,	607,593,	
0,0,	0,0,	0,0,	607,621,	
607,593,	607,593,	607,593,	607,593,	
607,593,	607,607,	607,593,	607,593,	
0,0,	0,0,	0,0,	608,573,	
0,0,	607,593,	0,0,	0,0,	
0,0,	607,593,	607,593,	608,573,	
608,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	607,593,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	608,573,	0,0,	
608,573,	608,573,	0,0,	608,573,	
0,0,	608,559,	608,573,	608,573,	
0,0,	608,573,	0,0,	608,565,	
0,0,	608,573,	608,565,	608,565,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	608,565,	
608,580,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	608,565,	
608,565,	608,565,	608,565,	608,622,	
608,565,	608,581,	608,565,	608,565,	
608,565,	608,565,	608,565,	608,565,	
608,565,	608,565,	608,565,	0,0,	
608,565,	608,565,	608,565,	608,565,	
608,565,	608,565,	608,565,	608,565,	
608,565,	609,0,	0,0,	608,573,	
0,0,	0,0,	0,0,	608,565,	
608,565,	608,565,	608,565,	608,565,	
608,565,	608,581,	608,565,	608,565,	
608,565,	0,0,	0,0,	0,0,	
0,0,	608,565,	0,0,	0,0,	
0,0,	608,565,	608,565,	608,565,	
608,565,	0,0,	0,0,	608,565,	
608,565,	0,0,	0,0,	608,573,	
609,565,	0,0,	0,0,	609,565,	
609,565,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
609,565,	609,580,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
609,565,	609,565,	609,565,	609,565,	
609,565,	609,565,	609,581,	0,0,	
0,0,	0,0,	609,565,	609,565,	
609,565,	609,565,	609,565,	609,565,	
0,0,	609,565,	609,565,	613,0,	
0,0,	0,0,	609,565,	609,565,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
609,565,	609,565,	609,565,	609,565,	
609,622,	609,565,	609,581,	609,565,	
609,565,	0,0,	0,0,	0,0,	
0,0,	0,0,	609,565,	0,0,	
613,573,	0,0,	609,565,	609,565,	
0,0,	0,0,	613,573,	0,0,	
0,0,	613,573,	613,573,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	613,573,	613,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	613,573,	613,573,	
613,573,	613,573,	613,627,	613,573,	
613,586,	613,573,	613,573,	613,573,	
613,573,	613,573,	613,573,	613,573,	
613,573,	613,573,	0,0,	613,573,	
613,573,	613,573,	613,573,	613,573,	
613,573,	613,573,	613,573,	613,573,	
614,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	613,573,	613,573,	
613,573,	613,573,	613,573,	613,573,	
613,586,	613,573,	613,573,	613,573,	
0,0,	0,0,	0,0,	0,0,	
613,573,	0,0,	0,0,	0,0,	
613,573,	613,573,	613,573,	613,573,	
0,0,	614,573,	613,573,	613,573,	
0,0,	0,0,	0,0,	614,573,	
0,0,	0,0,	614,573,	614,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	614,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	614,573,	
614,573,	614,573,	614,573,	614,573,	
614,573,	614,586,	0,0,	0,0,	
0,0,	614,573,	614,573,	614,573,	
614,573,	614,573,	614,573,	0,0,	
614,573,	614,573,	0,0,	0,0,	
616,616,	614,573,	614,573,	0,0,	
0,0,	0,0,	0,0,	0,0,	
616,616,	616,628,	0,0,	614,573,	
614,573,	614,573,	614,573,	614,627,	
614,573,	614,586,	614,573,	614,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	614,573,	0,0,	0,0,	
0,0,	614,573,	614,573,	616,616,	
0,0,	616,616,	616,616,	0,0,	
616,616,	0,0,	616,616,	616,616,	
616,616,	0,0,	616,616,	0,0,	
616,616,	0,0,	616,616,	616,616,	
616,616,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
616,616,	616,616,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
616,616,	616,616,	616,616,	616,616,	
616,616,	616,616,	616,616,	0,0,	
0,0,	0,0,	616,616,	616,616,	
616,616,	616,616,	616,616,	616,616,	
0,0,	616,616,	616,616,	0,0,	
0,0,	0,0,	616,616,	616,616,	
0,0,	0,0,	0,0,	0,0,	
616,616,	0,0,	0,0,	0,0,	
616,616,	616,616,	616,616,	616,616,	
616,616,	616,616,	616,616,	616,616,	
616,616,	0,0,	0,0,	0,0,	
618,618,	0,0,	616,616,	0,0,	
0,0,	0,0,	616,616,	616,616,	
618,618,	618,630,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
616,616,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	618,618,	
0,0,	618,618,	618,618,	0,0,	
618,618,	0,0,	618,618,	618,618,	
618,618,	0,0,	618,618,	0,0,	
618,618,	0,0,	618,618,	618,618,	
618,618,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
618,618,	618,618,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
618,618,	618,618,	618,618,	618,618,	
618,618,	618,618,	618,618,	0,0,	
0,0,	0,0,	618,618,	618,618,	
618,618,	618,618,	618,618,	618,618,	
0,0,	618,618,	618,618,	0,0,	
0,0,	0,0,	618,618,	618,618,	
0,0,	0,0,	0,0,	0,0,	
618,618,	0,0,	0,0,	0,0,	
618,618,	618,618,	618,618,	618,618,	
618,618,	618,618,	618,618,	618,618,	
618,618,	0,0,	0,0,	0,0,	
620,593,	0,0,	618,618,	0,0,	
0,0,	0,0,	618,618,	618,618,	
620,593,	620,377,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
618,618,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	620,593,	
0,0,	620,593,	620,593,	0,0,	
620,593,	0,0,	620,593,	620,593,	
620,593,	0,0,	620,593,	0,0,	
620,593,	0,0,	620,593,	620,593,	
620,593,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
620,593,	620,593,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
620,593,	620,593,	620,593,	620,593,	
620,593,	620,593,	620,607,	0,0,	
0,0,	0,0,	620,593,	620,593,	
620,632,	620,593,	620,593,	620,593,	
0,0,	620,593,	620,593,	622,0,	
0,0,	0,0,	620,593,	620,593,	
0,0,	0,0,	0,0,	0,0,	
620,593,	0,0,	0,0,	0,0,	
620,593,	620,593,	620,593,	620,593,	
620,593,	620,593,	620,607,	620,593,	
620,593,	0,0,	0,0,	0,0,	
620,593,	0,0,	620,593,	0,0,	
0,0,	0,0,	620,593,	620,593,	
0,0,	0,0,	622,565,	0,0,	
0,0,	622,565,	622,565,	0,0,	
620,593,	0,0,	0,0,	0,0,	
0,0,	0,0,	622,565,	622,580,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	622,565,	622,565,	
622,565,	622,565,	622,565,	622,565,	
622,581,	0,0,	0,0,	0,0,	
622,565,	622,565,	622,565,	622,565,	
622,565,	622,565,	0,0,	622,565,	
622,565,	627,0,	0,0,	0,0,	
622,565,	622,565,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	622,565,	622,565,	
622,565,	622,565,	622,565,	622,565,	
622,581,	622,565,	622,565,	0,0,	
0,0,	0,0,	0,0,	0,0,	
622,565,	0,0,	627,573,	0,0,	
622,565,	622,565,	0,0,	0,0,	
627,573,	0,0,	0,0,	627,573,	
627,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
627,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
627,573,	627,573,	627,573,	627,573,	
627,573,	627,573,	627,586,	0,0,	
0,0,	0,0,	627,573,	627,573,	
627,573,	627,573,	627,573,	627,573,	
0,0,	627,573,	627,573,	0,0,	
0,0,	632,593,	627,573,	627,573,	
0,0,	0,0,	0,0,	0,0,	
0,0,	632,593,	632,377,	0,0,	
627,573,	627,573,	627,573,	627,573,	
627,573,	627,573,	627,586,	627,573,	
627,573,	0,0,	0,0,	0,0,	
0,0,	0,0,	627,573,	0,0,	
0,0,	0,0,	627,573,	627,573,	
632,593,	0,0,	632,593,	632,593,	
0,0,	632,593,	0,0,	632,593,	
632,593,	632,593,	0,0,	632,593,	
0,0,	632,593,	0,0,	632,593,	
632,593,	632,593,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	632,593,	632,593,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	632,593,	632,593,	632,593,	
632,593,	632,638,	632,593,	632,607,	
632,593,	632,593,	632,593,	632,593,	
632,593,	632,593,	632,593,	632,593,	
632,593,	0,0,	632,593,	632,593,	
632,593,	632,593,	632,593,	632,593,	
632,593,	632,593,	632,593,	0,0,	
0,0,	632,593,	0,0,	0,0,	
0,0,	632,593,	632,593,	632,593,	
632,593,	632,593,	632,593,	632,607,	
632,593,	632,593,	632,593,	0,0,	
0,0,	0,0,	0,0,	632,593,	
633,593,	0,0,	0,0,	632,593,	
632,593,	632,593,	632,593,	0,0,	
633,593,	632,593,	632,593,	0,0,	
0,0,	632,593,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	633,593,	
0,0,	633,593,	633,593,	0,0,	
633,593,	0,0,	633,593,	633,593,	
633,593,	0,0,	633,593,	0,0,	
633,593,	0,0,	633,593,	633,593,	
633,593,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
633,593,	633,593,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
633,593,	633,593,	633,593,	633,593,	
633,593,	633,593,	633,607,	0,0,	
0,0,	0,0,	633,593,	633,593,	
633,593,	633,593,	633,593,	633,593,	
0,0,	633,593,	633,593,	0,0,	
0,0,	0,0,	633,593,	633,593,	
0,0,	0,0,	0,0,	0,0,	
633,593,	0,0,	0,0,	0,0,	
633,593,	633,593,	633,593,	633,593,	
633,638,	633,593,	633,607,	633,593,	
633,593,	638,593,	0,0,	0,0,	
0,0,	0,0,	633,593,	0,0,	
0,0,	638,593,	633,593,	633,593,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
633,593,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
638,593,	0,0,	638,593,	638,593,	
0,0,	638,593,	0,0,	638,593,	
638,593,	638,593,	0,0,	638,593,	
0,0,	638,593,	0,0,	638,593,	
638,593,	638,593,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	638,593,	638,593,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	638,593,	638,593,	638,593,	
638,593,	638,593,	638,593,	638,607,	
0,0,	0,0,	0,0,	638,593,	
638,593,	638,593,	638,593,	638,593,	
638,593,	0,0,	638,593,	638,593,	
0,0,	0,0,	0,0,	638,593,	
638,593,	0,0,	0,0,	0,0,	
0,0,	638,593,	0,0,	0,0,	
0,0,	638,593,	638,593,	638,593,	
638,593,	638,593,	638,593,	638,607,	
638,593,	638,593,	0,0,	0,0,	
0,0,	643,643,	0,0,	638,593,	
0,0,	0,0,	0,0,	638,593,	
638,593,	643,643,	643,644,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	638,593,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
643,643,	0,0,	643,643,	643,643,	
0,0,	643,643,	0,0,	643,643,	
643,643,	643,643,	0,0,	643,643,	
0,0,	643,643,	0,0,	643,643,	
643,643,	643,643,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	643,643,	643,643,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	643,643,	643,643,	643,643,	
643,643,	643,643,	643,643,	643,643,	
0,0,	0,0,	0,0,	643,643,	
643,643,	643,643,	643,643,	643,643,	
643,643,	0,0,	643,643,	643,643,	
0,0,	0,0,	0,0,	643,643,	
643,643,	0,0,	0,0,	0,0,	
0,0,	643,643,	0,0,	0,0,	
0,0,	643,643,	643,643,	643,643,	
643,643,	643,643,	643,643,	643,643,	
643,643,	643,643,	0,0,	0,0,	
0,0,	0,0,	0,0,	643,643,	
0,0,	0,0,	0,0,	643,643,	
643,643,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	643,258,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-83,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+10,	0,		yyvstop+3,
yycrank+159,	0,		yyvstop+5,
yycrank+178,	0,		yyvstop+7,
yycrank+-300,	0,		yyvstop+10,
yycrank+15,	0,		yyvstop+12,
yycrank+18,	0,		yyvstop+15,
yycrank+63,	yysvec+6,	yyvstop+17,
yycrank+-408,	0,		yyvstop+20,
yycrank+-98,	yysvec+11,	yyvstop+24,
yycrank+-516,	0,		yyvstop+28,
yycrank+593,	yysvec+6,	yyvstop+31,
yycrank+18,	yysvec+6,	yyvstop+34,
yycrank+15,	yysvec+6,	yyvstop+37,
yycrank+31,	yysvec+6,	yyvstop+40,
yycrank+617,	yysvec+6,	yyvstop+43,
yycrank+16,	yysvec+6,	yyvstop+46,
yycrank+16,	yysvec+6,	yyvstop+49,
yycrank+677,	yysvec+6,	yyvstop+52,
yycrank+78,	yysvec+6,	yyvstop+55,
yycrank+659,	yysvec+6,	yyvstop+58,
yycrank+737,	yysvec+6,	yyvstop+61,
yycrank+30,	yysvec+6,	yyvstop+64,
yycrank+207,	yysvec+6,	yyvstop+67,
yycrank+-811,	0,		yyvstop+70,
yycrank+879,	yysvec+6,	yyvstop+72,
yycrank+906,	yysvec+6,	yyvstop+75,
yycrank+966,	yysvec+6,	yyvstop+78,
yycrank+990,	yysvec+6,	yyvstop+81,
yycrank+1062,	yysvec+6,	yyvstop+84,
yycrank+1086,	yysvec+6,	yyvstop+87,
yycrank+1146,	yysvec+6,	yyvstop+90,
yycrank+1177,	yysvec+6,	yyvstop+93,
yycrank+110,	yysvec+6,	yyvstop+96,
yycrank+-1251,	0,		yyvstop+99,
yycrank+32,	0,		yyvstop+101,
yycrank+1329,	0,		yyvstop+103,
yycrank+144,	yysvec+39,	yyvstop+106,
yycrank+-1407,	yysvec+11,	yyvstop+109,
yycrank+-1468,	yysvec+11,	yyvstop+113,
yycrank+-33,	yysvec+13,	yyvstop+117,
yycrank+1542,	yysvec+39,	yyvstop+120,
yycrank+43,	yysvec+39,	yyvstop+123,
yycrank+50,	yysvec+39,	yyvstop+126,
yycrank+90,	yysvec+39,	yyvstop+129,
yycrank+1566,	yysvec+39,	yyvstop+132,
yycrank+56,	yysvec+39,	yyvstop+135,
yycrank+17,	yysvec+39,	yyvstop+138,
yycrank+1626,	yysvec+39,	yyvstop+141,
yycrank+124,	yysvec+39,	yyvstop+144,
yycrank+705,	yysvec+39,	yyvstop+147,
yycrank+1651,	yysvec+39,	yyvstop+150,
yycrank+56,	yysvec+39,	yyvstop+153,
yycrank+209,	yysvec+39,	yyvstop+156,
yycrank+1711,	yysvec+39,	yyvstop+159,
yycrank+1736,	yysvec+39,	yyvstop+162,
yycrank+1796,	yysvec+39,	yyvstop+165,
yycrank+1820,	yysvec+39,	yyvstop+168,
yycrank+1892,	yysvec+39,	yyvstop+171,
yycrank+1916,	yysvec+39,	yyvstop+174,
yycrank+1976,	yysvec+39,	yyvstop+177,
yycrank+2007,	yysvec+39,	yyvstop+180,
yycrank+159,	yysvec+39,	yyvstop+183,
yycrank+-28,	yysvec+37,	yyvstop+186,
yycrank+70,	0,		0,	
yycrank+0,	yysvec+5,	yyvstop+188,
yycrank+0,	yysvec+6,	yyvstop+190,
yycrank+-2081,	0,		0,	
yycrank+-2189,	0,		0,	
yycrank+-267,	yysvec+70,	0,	
yycrank+150,	0,		0,	
yycrank+0,	0,		yyvstop+192,
yycrank+31,	0,		0,	
yycrank+259,	0,		0,	
yycrank+37,	yysvec+6,	yyvstop+194,
yycrank+33,	0,		0,	
yycrank+39,	yysvec+6,	yyvstop+196,
yycrank+0,	yysvec+78,	0,	
yycrank+2231,	0,		0,	
yycrank+284,	yysvec+81,	0,	
yycrank+2271,	yysvec+6,	yyvstop+199,
yycrank+2345,	yysvec+6,	yyvstop+201,
yycrank+43,	yysvec+81,	0,	
yycrank+-306,	yysvec+11,	yyvstop+203,
yycrank+42,	yysvec+81,	0,	
yycrank+2385,	yysvec+6,	yyvstop+206,
yycrank+0,	yysvec+13,	yyvstop+209,
yycrank+0,	0,		yyvstop+211,
yycrank+2319,	0,		0,	
yycrank+329,	yysvec+6,	yyvstop+213,
yycrank+437,	0,		0,	
yycrank+2373,	yysvec+6,	yyvstop+215,
yycrank+585,	0,		0,	
yycrank+645,	0,		0,	
yycrank+2455,	yysvec+6,	yyvstop+217,
yycrank+18,	yysvec+6,	yyvstop+219,
yycrank+74,	yysvec+6,	yyvstop+221,
yycrank+80,	yysvec+6,	yyvstop+223,
yycrank+94,	yysvec+6,	yyvstop+225,
yycrank+76,	yysvec+6,	yyvstop+227,
yycrank+80,	yysvec+6,	yyvstop+229,
yycrank+80,	yysvec+6,	yyvstop+231,
yycrank+18,	yysvec+6,	yyvstop+233,
yycrank+118,	yysvec+6,	yyvstop+235,
yycrank+777,	yysvec+6,	yyvstop+238,
yycrank+2479,	yysvec+6,	yyvstop+240,
yycrank+104,	yysvec+6,	yyvstop+242,
yycrank+100,	yysvec+6,	yyvstop+244,
yycrank+108,	yysvec+6,	yyvstop+246,
yycrank+-2539,	yysvec+27,	0,	
yycrank+-174,	yysvec+27,	0,	
yycrank+-2603,	yysvec+27,	0,	
yycrank+-426,	yysvec+27,	0,	
yycrank+0,	0,		yyvstop+248,
yycrank+842,	yysvec+6,	yyvstop+250,
yycrank+2654,	yysvec+6,	yyvstop+252,
yycrank+887,	0,		0,	
yycrank+930,	yysvec+6,	yyvstop+255,
yycrank+1006,	yysvec+6,	yyvstop+257,
yycrank+2726,	yysvec+6,	yyvstop+259,
yycrank+998,	yysvec+6,	yyvstop+262,
yycrank+2744,	yysvec+6,	yyvstop+264,
yycrank+1024,	0,		0,	
yycrank+1054,	yysvec+6,	yyvstop+267,
yycrank+2816,	yysvec+6,	yyvstop+269,
yycrank+2888,	yysvec+6,	yyvstop+272,
yycrank+1158,	yysvec+6,	yyvstop+274,
yycrank+109,	yysvec+6,	yyvstop+276,
yycrank+111,	yysvec+6,	yyvstop+278,
yycrank+-273,	yysvec+37,	0,	
yycrank+-2962,	yysvec+37,	0,	
yycrank+-166,	yysvec+37,	0,	
yycrank+193,	0,		yyvstop+281,
yycrank+-3070,	0,		0,	
yycrank+0,	yysvec+39,	yyvstop+283,
yycrank+204,	0,		0,	
yycrank+189,	yysvec+39,	yyvstop+285,
yycrank+192,	yysvec+39,	yyvstop+287,
yycrank+270,	0,		0,	
yycrank+3112,	yysvec+39,	yyvstop+290,
yycrank+-3185,	yysvec+11,	yyvstop+292,
yycrank+275,	yysvec+81,	0,	
yycrank+3227,	yysvec+39,	yyvstop+295,
yycrank+3267,	yysvec+39,	yyvstop+297,
yycrank+210,	yysvec+81,	0,	
yycrank+-3350,	0,		yyvstop+300,
yycrank+1460,	yysvec+39,	yyvstop+302,
yycrank+3386,	yysvec+39,	yyvstop+304,
yycrank+237,	yysvec+95,	0,	
yycrank+3446,	yysvec+39,	yyvstop+306,
yycrank+174,	yysvec+39,	yyvstop+308,
yycrank+171,	yysvec+39,	yyvstop+310,
yycrank+177,	yysvec+39,	yyvstop+312,
yycrank+218,	yysvec+39,	yyvstop+314,
yycrank+188,	yysvec+39,	yyvstop+316,
yycrank+211,	yysvec+39,	yyvstop+318,
yycrank+211,	yysvec+39,	yyvstop+320,
yycrank+249,	yysvec+39,	yyvstop+322,
yycrank+254,	yysvec+39,	yyvstop+324,
yycrank+1582,	yysvec+39,	yyvstop+327,
yycrank+3470,	yysvec+39,	yyvstop+329,
yycrank+239,	yysvec+39,	yyvstop+331,
yycrank+239,	yysvec+39,	yyvstop+333,
yycrank+236,	yysvec+39,	yyvstop+335,
yycrank+1634,	yysvec+39,	yyvstop+337,
yycrank+3517,	yysvec+39,	yyvstop+339,
yycrank+318,	yysvec+119,	0,	
yycrank+1675,	yysvec+39,	yyvstop+342,
yycrank+1767,	yysvec+39,	yyvstop+344,
yycrank+3589,	yysvec+39,	yyvstop+346,
yycrank+1760,	yysvec+39,	yyvstop+349,
yycrank+3607,	yysvec+39,	yyvstop+351,
yycrank+320,	yysvec+125,	0,	
yycrank+1788,	yysvec+39,	yyvstop+354,
yycrank+3679,	yysvec+39,	yyvstop+356,
yycrank+3751,	yysvec+39,	yyvstop+359,
yycrank+1876,	yysvec+39,	yyvstop+361,
yycrank+243,	yysvec+39,	yyvstop+363,
yycrank+244,	yysvec+39,	yyvstop+365,
yycrank+-365,	yysvec+37,	0,	
yycrank+242,	0,		0,	
yycrank+-318,	yysvec+70,	0,	
yycrank+-319,	yysvec+71,	0,	
yycrank+-3825,	yysvec+71,	0,	
yycrank+-3933,	0,		0,	
yycrank+-473,	yysvec+70,	0,	
yycrank+-519,	yysvec+70,	0,	
yycrank+-4041,	0,		0,	
yycrank+-4149,	0,		0,	
yycrank+0,	0,		yyvstop+368,
yycrank+329,	0,		0,	
yycrank+330,	0,		0,	
yycrank+331,	0,		0,	
yycrank+327,	yysvec+6,	yyvstop+370,
yycrank+341,	yysvec+6,	yyvstop+373,
yycrank+342,	0,		yyvstop+376,
yycrank+0,	yysvec+6,	yyvstop+378,
yycrank+0,	0,		yyvstop+381,
yycrank+349,	0,		0,	
yycrank+352,	0,		0,	
yycrank+353,	0,		0,	
yycrank+0,	yysvec+6,	yyvstop+383,
yycrank+354,	yysvec+6,	yyvstop+386,
yycrank+357,	0,		yyvstop+389,
yycrank+362,	0,		yyvstop+391,
yycrank+285,	0,		0,	
yycrank+280,	0,		0,	
yycrank+295,	0,		0,	
yycrank+294,	0,		0,	
yycrank+1902,	yysvec+6,	yyvstop+393,
yycrank+1932,	0,		0,	
yycrank+1940,	yysvec+6,	yyvstop+395,
yycrank+2110,	0,		0,	
yycrank+2266,	yysvec+6,	yyvstop+397,
yycrank+2307,	0,		0,	
yycrank+2353,	0,		0,	
yycrank+4185,	yysvec+6,	yyvstop+399,
yycrank+297,	yysvec+6,	yyvstop+402,
yycrank+307,	yysvec+6,	yyvstop+404,
yycrank+289,	yysvec+6,	yyvstop+406,
yycrank+405,	yysvec+6,	yyvstop+408,
yycrank+323,	yysvec+6,	yyvstop+410,
yycrank+311,	yysvec+6,	yyvstop+412,
yycrank+374,	yysvec+6,	yyvstop+414,
yycrank+4210,	yysvec+6,	yyvstop+417,
yycrank+316,	yysvec+6,	yyvstop+419,
yycrank+315,	yysvec+6,	yyvstop+421,
yycrank+318,	yysvec+6,	yyvstop+423,
yycrank+-4292,	0,		yyvstop+425,
yycrank+-4400,	yysvec+27,	0,	
yycrank+-4475,	yysvec+27,	0,	
yycrank+-4560,	0,		0,	
yycrank+4606,	yysvec+6,	yyvstop+428,
yycrank+2814,	0,		0,	
yycrank+2337,	yysvec+6,	yyvstop+431,
yycrank+2417,	0,		0,	
yycrank+401,	yysvec+236,	0,	
yycrank+403,	yysvec+6,	yyvstop+433,
yycrank+2672,	yysvec+6,	yyvstop+436,
yycrank+2744,	yysvec+6,	yyvstop+438,
yycrank+4640,	0,		yyvstop+441,
yycrank+4662,	yysvec+6,	yyvstop+443,
yycrank+3016,	0,		0,	
yycrank+406,	yysvec+245,	0,	
yycrank+409,	yysvec+6,	yyvstop+446,
yycrank+4712,	yysvec+6,	yyvstop+449,
yycrank+2646,	yysvec+6,	yyvstop+452,
yycrank+2714,	0,		0,	
yycrank+2898,	yysvec+6,	yyvstop+454,
yycrank+2928,	yysvec+6,	yyvstop+456,
yycrank+2906,	yysvec+243,	yyvstop+459,
yycrank+4730,	yysvec+6,	yyvstop+461,
yycrank+4757,	yysvec+6,	yyvstop+464,
yycrank+3147,	yysvec+6,	yyvstop+468,
yycrank+407,	yysvec+6,	yyvstop+471,
yycrank+0,	0,		yyvstop+474,
yycrank+-432,	yysvec+37,	0,	
yycrank+450,	0,		0,	
yycrank+351,	0,		0,	
yycrank+-4841,	0,		yyvstop+476,
yycrank+414,	yysvec+39,	yyvstop+478,
yycrank+430,	yysvec+39,	yyvstop+481,
yycrank+0,	yysvec+39,	yyvstop+484,
yycrank+432,	yysvec+39,	yyvstop+487,
yycrank+0,	yysvec+39,	yyvstop+490,
yycrank+-4883,	yysvec+262,	yyvstop+493,
yycrank+0,	yysvec+136,	yyvstop+495,
yycrank+-390,	yysvec+13,	yyvstop+497,
yycrank+3261,	yysvec+39,	yyvstop+499,
yycrank+3410,	yysvec+39,	yyvstop+501,
yycrank+435,	yysvec+215,	0,	
yycrank+3486,	yysvec+39,	yyvstop+503,
yycrank+4218,	yysvec+39,	yyvstop+505,
yycrank+369,	yysvec+39,	yyvstop+508,
yycrank+371,	yysvec+39,	yyvstop+510,
yycrank+363,	yysvec+39,	yyvstop+512,
yycrank+511,	yysvec+39,	yyvstop+514,
yycrank+431,	yysvec+39,	yyvstop+516,
yycrank+393,	yysvec+39,	yyvstop+518,
yycrank+452,	yysvec+39,	yyvstop+520,
yycrank+4902,	yysvec+39,	yyvstop+523,
yycrank+395,	yysvec+39,	yyvstop+525,
yycrank+395,	yysvec+39,	yyvstop+527,
yycrank+399,	yysvec+39,	yyvstop+529,
yycrank+-4962,	yysvec+231,	yyvstop+531,
yycrank+4787,	yysvec+39,	yyvstop+534,
yycrank+3509,	yysvec+39,	yyvstop+537,
yycrank+484,	yysvec+238,	0,	
yycrank+477,	yysvec+39,	yyvstop+539,
yycrank+3607,	yysvec+39,	yyvstop+542,
yycrank+3625,	yysvec+39,	yyvstop+544,
yycrank+5008,	yysvec+39,	yyvstop+547,
yycrank+479,	yysvec+39,	yyvstop+550,
yycrank+5042,	yysvec+39,	yyvstop+553,
yycrank+3649,	yysvec+39,	yyvstop+556,
yycrank+495,	yysvec+250,	0,	
yycrank+3719,	yysvec+39,	yyvstop+558,
yycrank+3767,	yysvec+39,	yyvstop+560,
yycrank+5076,	yysvec+39,	yyvstop+563,
yycrank+5103,	yysvec+39,	yyvstop+566,
yycrank+3791,	yysvec+39,	yyvstop+570,
yycrank+483,	yysvec+39,	yyvstop+573,
yycrank+-654,	yysvec+37,	0,	
yycrank+428,	0,		0,	
yycrank+0,	0,		yyvstop+576,
yycrank+0,	yysvec+187,	yyvstop+578,
yycrank+-502,	yysvec+187,	0,	
yycrank+-5187,	yysvec+71,	0,	
yycrank+0,	0,		yyvstop+580,
yycrank+-531,	yysvec+70,	0,	
yycrank+-534,	yysvec+190,	yyvstop+582,
yycrank+-535,	yysvec+191,	yyvstop+584,
yycrank+0,	yysvec+78,	0,	
yycrank+0,	yysvec+78,	0,	
yycrank+0,	yysvec+78,	0,	
yycrank+501,	yysvec+6,	yyvstop+586,
yycrank+512,	0,		0,	
yycrank+506,	0,		0,	
yycrank+521,	0,		0,	
yycrank+0,	yysvec+320,	0,	
yycrank+530,	0,		0,	
yycrank+616,	0,		0,	
yycrank+526,	0,		0,	
yycrank+447,	0,		0,	
yycrank+452,	0,		0,	
yycrank+461,	0,		0,	
yycrank+474,	0,		0,	
yycrank+0,	yysvec+6,	yyvstop+588,
yycrank+5223,	0,		0,	
yycrank+3902,	0,		0,	
yycrank+0,	yysvec+6,	yyvstop+591,
yycrank+0,	0,		yyvstop+594,
yycrank+0,	0,		yyvstop+596,
yycrank+3962,	yysvec+6,	yyvstop+598,
yycrank+4070,	0,		0,	
yycrank+4369,	yysvec+6,	yyvstop+600,
yycrank+483,	yysvec+6,	yyvstop+602,
yycrank+490,	yysvec+6,	yyvstop+604,
yycrank+568,	yysvec+6,	yyvstop+606,
yycrank+534,	0,		0,	
yycrank+530,	yysvec+6,	yyvstop+609,
yycrank+-5299,	0,		yyvstop+611,
yycrank+0,	yysvec+6,	yyvstop+614,
yycrank+526,	yysvec+6,	yyvstop+617,
yycrank+503,	yysvec+6,	yyvstop+619,
yycrank+506,	yysvec+6,	yyvstop+621,
yycrank+507,	yysvec+6,	yyvstop+623,
yycrank+-5373,	yysvec+231,	yyvstop+625,
yycrank+-601,	yysvec+231,	yyvstop+627,
yycrank+-5458,	yysvec+27,	0,	
yycrank+-5522,	yysvec+27,	0,	
yycrank+-5607,	0,		yyvstop+630,
yycrank+571,	0,		yyvstop+632,
yycrank+4440,	0,		0,	
yycrank+0,	0,		yyvstop+634,
yycrank+5133,	yysvec+6,	yyvstop+636,
yycrank+5653,	0,		yyvstop+639,
yycrank+581,	0,		yyvstop+641,
yycrank+5655,	0,		0,	
yycrank+583,	yysvec+361,	0,	
yycrank+583,	yysvec+6,	yyvstop+643,
yycrank+0,	0,		yyvstop+646,
yycrank+4680,	0,		0,	
yycrank+5663,	yysvec+6,	yyvstop+648,
yycrank+0,	yysvec+359,	yyvstop+652,
yycrank+5714,	yysvec+6,	yyvstop+655,
yycrank+5002,	yysvec+6,	yyvstop+659,
yycrank+515,	yysvec+6,	yyvstop+662,
yycrank+-580,	yysvec+37,	0,	
yycrank+0,	yysvec+8,	yyvstop+664,
yycrank+607,	0,		0,	
yycrank+693,	0,		0,	
yycrank+533,	0,		0,	
yycrank+525,	0,		0,	
yycrank+668,	0,		0,	
yycrank+602,	yysvec+39,	yyvstop+666,
yycrank+741,	yysvec+81,	0,	
yycrank+0,	yysvec+262,	yyvstop+668,
yycrank+-558,	yysvec+13,	yyvstop+671,
yycrank+-547,	yysvec+13,	yyvstop+673,
yycrank+0,	yysvec+39,	yyvstop+675,
yycrank+0,	yysvec+39,	yyvstop+678,
yycrank+5684,	yysvec+39,	yyvstop+681,
yycrank+627,	yysvec+337,	0,	
yycrank+5748,	yysvec+39,	yyvstop+683,
yycrank+553,	yysvec+39,	yyvstop+685,
yycrank+556,	yysvec+39,	yyvstop+687,
yycrank+644,	yysvec+39,	yyvstop+689,
yycrank+608,	yysvec+39,	yyvstop+692,
yycrank+-5768,	yysvec+344,	yyvstop+694,
yycrank+0,	yysvec+39,	yyvstop+697,
yycrank+600,	yysvec+39,	yyvstop+700,
yycrank+595,	yysvec+39,	yyvstop+702,
yycrank+603,	yysvec+39,	yyvstop+704,
yycrank+606,	yysvec+39,	yyvstop+706,
yycrank+-5832,	yysvec+231,	yyvstop+708,
yycrank+-5906,	yysvec+231,	yyvstop+711,
yycrank+5952,	yysvec+39,	yyvstop+713,
yycrank+667,	yysvec+39,	yyvstop+716,
yycrank+5962,	yysvec+39,	yyvstop+719,
yycrank+5986,	yysvec+39,	yyvstop+723,
yycrank+5808,	yysvec+39,	yyvstop+727,
yycrank+598,	yysvec+39,	yyvstop+730,
yycrank+-765,	yysvec+37,	0,	
yycrank+609,	0,		0,	
yycrank+-693,	yysvec+70,	0,	
yycrank+-6069,	0,		0,	
yycrank+-6177,	0,		0,	
yycrank+-6285,	0,		0,	
yycrank+-6393,	0,		0,	
yycrank+-6501,	0,		0,	
yycrank+-6609,	0,		0,	
yycrank+687,	0,		0,	
yycrank+721,	0,		0,	
yycrank+656,	0,		0,	
yycrank+662,	0,		0,	
yycrank+665,	0,		0,	
yycrank+662,	0,		0,	
yycrank+5872,	0,		0,	
yycrank+0,	0,		yyvstop+732,
yycrank+6655,	yysvec+6,	yyvstop+734,
yycrank+738,	yysvec+6,	yyvstop+737,
yycrank+706,	yysvec+6,	yyvstop+739,
yycrank+1139,	0,		0,	
yycrank+739,	yysvec+6,	yyvstop+741,
yycrank+713,	0,		0,	
yycrank+703,	yysvec+6,	yyvstop+744,
yycrank+693,	yysvec+6,	yyvstop+746,
yycrank+-6707,	yysvec+344,	yyvstop+748,
yycrank+-853,	yysvec+344,	yyvstop+750,
yycrank+686,	yysvec+6,	yyvstop+753,
yycrank+689,	yysvec+6,	yyvstop+755,
yycrank+-6792,	0,		0,	
yycrank+0,	0,		yyvstop+757,
yycrank+0,	yysvec+354,	0,	
yycrank+991,	0,		0,	
yycrank+6838,	0,		yyvstop+760,
yycrank+5973,	0,		0,	
yycrank+759,	yysvec+440,	0,	
yycrank+759,	yysvec+6,	yyvstop+762,
yycrank+770,	0,		yyvstop+765,
yycrank+0,	0,		yyvstop+767,
yycrank+0,	yysvec+439,	yyvstop+769,
yycrank+-848,	yysvec+37,	0,	
yycrank+0,	yysvec+78,	0,	
yycrank+797,	0,		0,	
yycrank+0,	yysvec+320,	0,	
yycrank+0,	yysvec+321,	0,	
yycrank+0,	yysvec+320,	0,	
yycrank+707,	0,		0,	
yycrank+703,	0,		0,	
yycrank+-6921,	yysvec+262,	yyvstop+772,
yycrank+-7029,	0,		yyvstop+774,
yycrank+-710,	yysvec+13,	yyvstop+776,
yycrank+-708,	yysvec+13,	yyvstop+778,
yycrank+7075,	yysvec+39,	yyvstop+780,
yycrank+792,	yysvec+39,	yyvstop+783,
yycrank+776,	yysvec+39,	yyvstop+785,
yycrank+815,	yysvec+39,	yyvstop+787,
yycrank+780,	yysvec+39,	yyvstop+790,
yycrank+760,	yysvec+39,	yyvstop+792,
yycrank+-7129,	yysvec+344,	yyvstop+794,
yycrank+-7203,	yysvec+344,	yyvstop+797,
yycrank+752,	yysvec+39,	yyvstop+799,
yycrank+755,	yysvec+39,	yyvstop+801,
yycrank+-7288,	yysvec+262,	yyvstop+803,
yycrank+824,	yysvec+39,	yyvstop+806,
yycrank+-826,	yysvec+37,	0,	
yycrank+792,	0,		0,	
yycrank+0,	0,		yyvstop+809,
yycrank+-856,	yysvec+409,	yyvstop+812,
yycrank+-857,	yysvec+410,	yyvstop+814,
yycrank+-860,	yysvec+411,	yyvstop+816,
yycrank+-862,	yysvec+412,	yyvstop+818,
yycrank+-863,	yysvec+413,	yyvstop+820,
yycrank+-874,	yysvec+414,	yyvstop+822,
yycrank+848,	0,		0,	
yycrank+850,	0,		0,	
yycrank+791,	0,		0,	
yycrank+802,	0,		0,	
yycrank+805,	0,		yyvstop+824,
yycrank+804,	0,		0,	
yycrank+7334,	0,		yyvstop+827,
yycrank+6123,	0,		0,	
yycrank+877,	yysvec+486,	0,	
yycrank+877,	yysvec+6,	yyvstop+829,
yycrank+822,	yysvec+6,	yyvstop+832,
yycrank+-7417,	0,		0,	
yycrank+820,	0,		0,	
yycrank+802,	0,		0,	
yycrank+856,	0,		0,	
yycrank+846,	0,		0,	
yycrank+865,	yysvec+6,	yyvstop+834,
yycrank+834,	yysvec+6,	yyvstop+836,
yycrank+851,	yysvec+6,	yyvstop+838,
yycrank+853,	yysvec+6,	yyvstop+841,
yycrank+0,	0,		yyvstop+843,
yycrank+0,	0,		yyvstop+846,
yycrank+922,	0,		yyvstop+848,
yycrank+0,	0,		yyvstop+850,
yycrank+0,	yysvec+135,	yyvstop+852,
yycrank+864,	0,		0,	
yycrank+866,	0,		0,	
yycrank+-7459,	yysvec+455,	yyvstop+855,
yycrank+-7498,	yysvec+455,	yyvstop+857,
yycrank+-871,	yysvec+13,	yyvstop+860,
yycrank+-869,	yysvec+13,	yyvstop+862,
yycrank+934,	yysvec+39,	yyvstop+864,
yycrank+895,	yysvec+39,	yyvstop+867,
yycrank+910,	yysvec+39,	yyvstop+869,
yycrank+880,	yysvec+39,	yyvstop+871,
yycrank+-7573,	yysvec+262,	yyvstop+873,
yycrank+897,	yysvec+39,	yyvstop+876,
yycrank+899,	yysvec+39,	yyvstop+879,
yycrank+-1026,	yysvec+37,	0,	
yycrank+0,	0,		yyvstop+881,
yycrank+896,	0,		0,	
yycrank+970,	0,		0,	
yycrank+981,	0,		yyvstop+883,
yycrank+915,	0,		0,	
yycrank+931,	0,		0,	
yycrank+937,	0,		0,	
yycrank+0,	0,		yyvstop+885,
yycrank+928,	0,		0,	
yycrank+1006,	0,		yyvstop+888,
yycrank+0,	0,		yyvstop+890,
yycrank+-1039,	yysvec+490,	yyvstop+892,
yycrank+938,	0,		0,	
yycrank+1019,	0,		0,	
yycrank+969,	0,		0,	
yycrank+938,	0,		0,	
yycrank+989,	yysvec+6,	yyvstop+894,
yycrank+958,	yysvec+6,	yyvstop+896,
yycrank+976,	yysvec+6,	yyvstop+898,
yycrank+0,	yysvec+6,	yyvstop+900,
yycrank+961,	yysvec+6,	yyvstop+903,
yycrank+1047,	0,		0,	
yycrank+964,	0,		0,	
yycrank+-1049,	yysvec+13,	yyvstop+905,
yycrank+-966,	yysvec+13,	yyvstop+907,
yycrank+1002,	yysvec+39,	yyvstop+909,
yycrank+988,	yysvec+39,	yyvstop+911,
yycrank+1005,	yysvec+39,	yyvstop+913,
yycrank+0,	yysvec+39,	yyvstop+915,
yycrank+990,	yysvec+39,	yyvstop+918,
yycrank+-1123,	yysvec+37,	0,	
yycrank+998,	0,		0,	
yycrank+0,	yysvec+480,	0,	
yycrank+1069,	0,		0,	
yycrank+1009,	0,		0,	
yycrank+1013,	0,		0,	
yycrank+1031,	0,		yyvstop+920,
yycrank+1029,	0,		0,	
yycrank+1061,	0,		0,	
yycrank+1050,	0,		0,	
yycrank+1019,	0,		0,	
yycrank+-7681,	0,		yyvstop+922,
yycrank+1044,	yysvec+6,	yyvstop+924,
yycrank+1045,	0,		0,	
yycrank+1043,	0,		0,	
yycrank+-1047,	yysvec+13,	yyvstop+926,
yycrank+-1062,	yysvec+13,	yyvstop+928,
yycrank+-7745,	yysvec+559,	yyvstop+930,
yycrank+1068,	yysvec+39,	yyvstop+932,
yycrank+-1206,	yysvec+37,	0,	
yycrank+1054,	0,		0,	
yycrank+1072,	0,		0,	
yycrank+1076,	0,		0,	
yycrank+0,	0,		yyvstop+934,
yycrank+1061,	0,		0,	
yycrank+-7819,	yysvec+559,	0,	
yycrank+-1171,	yysvec+559,	yyvstop+936,
yycrank+0,	yysvec+6,	yyvstop+938,
yycrank+1073,	0,		0,	
yycrank+1082,	0,		0,	
yycrank+-1089,	yysvec+13,	yyvstop+941,
yycrank+-1092,	yysvec+13,	yyvstop+943,
yycrank+-7893,	yysvec+559,	0,	
yycrank+-7957,	yysvec+559,	yyvstop+945,
yycrank+0,	yysvec+39,	yyvstop+947,
yycrank+-1256,	yysvec+37,	0,	
yycrank+1106,	0,		0,	
yycrank+1110,	0,		0,	
yycrank+-8031,	yysvec+559,	0,	
yycrank+-1248,	yysvec+559,	yyvstop+950,
yycrank+-1206,	yysvec+559,	yyvstop+952,
yycrank+1109,	0,		0,	
yycrank+1108,	0,		0,	
yycrank+-1111,	yysvec+13,	yyvstop+954,
yycrank+-1110,	yysvec+13,	yyvstop+956,
yycrank+-8116,	yysvec+262,	yyvstop+958,
yycrank+-8180,	yysvec+559,	yyvstop+960,
yycrank+-8254,	yysvec+559,	yyvstop+962,
yycrank+-1315,	yysvec+37,	0,	
yycrank+1107,	0,		0,	
yycrank+1109,	0,		0,	
yycrank+-8328,	yysvec+559,	0,	
yycrank+-8402,	yysvec+559,	0,	
yycrank+-8447,	yysvec+559,	yyvstop+964,
yycrank+-1231,	yysvec+559,	yyvstop+966,
yycrank+1137,	0,		0,	
yycrank+1207,	0,		0,	
yycrank+-1139,	yysvec+13,	yyvstop+968,
yycrank+-1210,	yysvec+13,	yyvstop+970,
yycrank+-8538,	yysvec+262,	yyvstop+972,
yycrank+-8646,	0,		yyvstop+974,
yycrank+-8727,	yysvec+559,	yyvstop+976,
yycrank+-1409,	yysvec+37,	0,	
yycrank+1156,	0,		0,	
yycrank+1157,	0,		0,	
yycrank+-8801,	yysvec+608,	0,	
yycrank+-8882,	yysvec+559,	0,	
yycrank+-1254,	yysvec+559,	yyvstop+978,
yycrank+-8967,	0,		yyvstop+981,
yycrank+1165,	0,		0,	
yycrank+-9075,	0,		yyvstop+983,
yycrank+-1167,	yysvec+13,	yyvstop+986,
yycrank+-9183,	0,		yyvstop+988,
yycrank+-1193,	yysvec+620,	yyvstop+990,
yycrank+-9257,	yysvec+559,	yyvstop+992,
yycrank+-1414,	yysvec+37,	0,	
yycrank+1172,	0,		0,	
yycrank+0,	0,		yyvstop+995,
yycrank+1162,	0,		0,	
yycrank+-9331,	yysvec+559,	yyvstop+997,
yycrank+0,	0,		yyvstop+999,
yycrank+1177,	0,		0,	
yycrank+0,	0,		yyvstop+1001,
yycrank+-1179,	yysvec+13,	yyvstop+1004,
yycrank+-9416,	0,		yyvstop+1006,
yycrank+-9527,	yysvec+262,	yyvstop+1008,
yycrank+-1483,	yysvec+37,	0,	
yycrank+1177,	0,		0,	
yycrank+1181,	0,		0,	
yycrank+-1185,	yysvec+13,	yyvstop+1010,
yycrank+-9632,	yysvec+262,	yyvstop+1012,
yycrank+-1533,	yysvec+37,	0,	
yycrank+0,	yysvec+603,	0,	
yycrank+-1194,	yysvec+13,	yyvstop+1015,
yycrank+-1412,	yysvec+37,	0,	
yycrank+-9740,	0,		0,	
yycrank+-1258,	yysvec+643,	0,	
yycrank+-1261,	yysvec+643,	0,	
yycrank+-1262,	yysvec+643,	0,	
yycrank+-1265,	yysvec+643,	0,	
yycrank+-1266,	yysvec+643,	0,	
yycrank+-1267,	yysvec+643,	0,	
yycrank+-1269,	yysvec+643,	0,	
yycrank+-1278,	yysvec+643,	0,	
yycrank+-1279,	yysvec+643,	0,	
yycrank+-1290,	yysvec+643,	0,	
yycrank+-1291,	yysvec+643,	0,	
yycrank+-1292,	yysvec+643,	0,	
yycrank+-1295,	yysvec+643,	0,	
yycrank+-1296,	yysvec+643,	0,	
yycrank+-1217,	yysvec+643,	0,	
yycrank+1333,	0,		yyvstop+1017,
yycrank+0,	0,		yyvstop+1020,
0,	0,	0};
struct yywork *yytop = yycrank+9865;
struct yysvf *yybgin = yysvec+1;
unsigned char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
' ' ,01  ,'"' ,'#' ,01  ,'%' ,01  ,047 ,
'(' ,')' ,01  ,'+' ,01  ,'-' ,01  ,'/' ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'1' ,'9' ,':' ,'%' ,01  ,'+' ,01  ,01  ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'E' ,'E' ,'E' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'N' ,'R' ,'S' ,'E' ,'E' ,'E' ,'W' ,
'X' ,'E' ,'E' ,01  ,01  ,']' ,01  ,'+' ,
01  ,'a' ,'b' ,'c' ,'d' ,'e' ,'f' ,'g' ,
'h' ,'i' ,'E' ,'K' ,'L' ,'M' ,'N' ,'o' ,
'P' ,'N' ,'R' ,'s' ,'t' ,'E' ,'E' ,'W' ,
'X' ,'E' ,'E' ,01  ,01  ,'}' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
unsigned char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,0,0,1,0,0,
1,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
*/
/*
#
# IBM CONFIDENTIAL
# Copyright International Business Machines Corp. 1989
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of IBM
#
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
# 
*/
/* @(#)ncform	1.3  com/lib/l,3.1,8951 9/7/89 18:48:47 */
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
unsigned char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
unsigned char yysbuf[YYLMAX];
unsigned char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	unsigned char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
            if (yylastch >= yytext + YYLMAX) {
                fprintf(yyout, "Maximum token length exceeded\n");
                yytext[YYLMAX] = 0;
                return 0;
            }
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( yyt > yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if(yyt < yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
                if (yyleng >= YYLMAX) {
                    fprintf(yyout, "Maximum token length exceeded\n");
                    yytext[YYLMAX] = 0;
                    return 0;
                }
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
