/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FILETRANS_H
#define FILETRANS_H


#include "toolbox.h"

#include <qdialog.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qcombobox.h>

#include <sys/types.h>

#include "sendqueue.h"


//class SendQueue;


class TransferItem : public QListViewItem
{
public:
	TransferItem( QListView *list, QListViewItem *last, const char *filename );
   ~TransferItem();

	const char * getLongname();
	const int getProtocol();
   const off_t getSize();
	void setProtocol( int prot );
	void set7plusData( const char *empf, const char *mbx, const char *titel, int lt, int size, int startwith, int sendcmd );
	const int getSize7pl();
	const int getSizeBS();
   const char * getEmpf();
   const char * getMbx();
   const char * getTitel();
   int getLifetime();
   int getStartWith();
   int getSendCmd();
	void getInfo( s_sqsendinfo *info, bool seven );

private:
	char *shortname;
	char *longname;
	off_t size;
	int protocol;

	char *empf, *titel, *mbx;
	int lt;
	int size7pl, sizeBS;
   int startwith;
   int sendcmd;
};


class DlgFiletransfer : public QDialog
{
	Q_OBJECT;
public:
	DlgFiletransfer( SendQueue *sq );
	~DlgFiletransfer();

	void resizeEvent(QResizeEvent *event);
   void addFile( QString & name );

public slots:
	void slotAddFile();
	void slotDelEntry();
	void slotSelectionChanged( QListViewItem *item );
	void slotDIDADIT( bool toggled );
	void slotABIN( bool toggled );
	void slot7plus( bool toggled );
	void slotBS( bool toggled );
	void slotYAPP( bool toggled );
	void slotText( bool toggled );
	void slotSendClicked();
	void slot7plCalcParts( int index );
	void slotToggleStartWith( bool enabled );

private:
	void saveFileData();
	void setupWindow();
	void enableProtocolSelection( bool enable );
	void showCurrentData();

	bool protocolSelection;

   QListViewItem *currentItem;
	SendQueue *sendqueue;

	QPushButton *btnDel, *btnAdd;
	QListView *listFName;
	QRadioButton *rdbtnAutoBIN, *rdbtnDIDADIT, *rdbtn7plus, *rdbtnBinSplit;
	QRadioButton *rdbtnYAPP, *rdbtnText;

	QButtonGroup *grp7plus;
	QLineEdit *edUser, *edMbx, *edTitle;
   KIntLineEdit *edLt;
	QComboBox *cmbSplitsize;
   QLabel *lParts;
   QButtonGroup *grpSend, *grpStartWith;
   QRadioButton *rdbtnS, *rdbtnSP, *rdbtnSB, *rdbtnSendAll, *rdbtnStartWith;
   KIntLineEdit *edStartWith;

	QPushButton *btnAbort, *btnSend, *btnHelp;
};


#endif

