/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef FILETRANSFER_H
#define FILETRANSFER_H
//---------------------------------------------------------------------------
#include "sendqueue.h"     // Fuer die SQTRSTAT_* - Variablen

#include <qobject.h>
#include <qstring.h>
#include <qwidget.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qtimer.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
//---------------------------------------------------------------------------
#define FTPROT_ABIN 1
#define FTPROT_DIDADIT 2
#define FTPROT_7PLUS 3
#define FTPROT_YAPP 4
//---------------------------------------------------------------------------
class Channel;
//---------------------------------------------------------------------------
class FileTransfer : public QObject
{
	Q_OBJECT;
public:
   FileTransfer( Channel *channel, const QString & filename );
   ~FileTransfer();

	virtual void getFileData() = 0;
   virtual void startSending() = 0;
   virtual int sentReady() = 0;

	void sendMessage( const char *str );

public slots:
	virtual void slotReceivedString( const char *data, int len ) = 0;
   virtual void abortTransmission() = 0;

signals:
	void sendString( const char *data, int len, bool show );
   void setLinemode( bool mode );
   void sendData();
   void showStatus( FileTransfer *, const QString &, long, long, int );
   void unshowStatus();
   void statusRxBytes( long );
   void newTXData();
	void deleteFTData();

protected:
	Channel *chan;
   QString longname, shortname;
};
//---------------------------------------------------------------------------
class TransferInfo : public QWidget
{
   Q_OBJECT;
public:
   TransferInfo( QWidget *parent, int art, const QString & filename, long size, long offset=0 );
   ~TransferInfo();

   void setReceivedBytes( int rxbytes );
   void setFilesizeBytes( int bytes );

public slots:
	void slotUpdate();
   void slotAbortClicked();

signals:
	void abortClicked();

private:
   long filesize;
   long bytes_got;
   time_t starttime;
   long startbytes;
   int art;

   QProgressBar *progressbar;
   QLabel *lBytes, *lBaudEff, *lFileName, *lTimeLeft;
   QPushButton *btnAbort;
   QTimer *timer;
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

