/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  As a special exception, you have permission to link this program
 *  with the Qt library and distribute executables, as long as you
 *  follow the requirements of the GNU GPL in regard to all of the
 *  software in the executable aside from Qt.
 */
//---------------------------------------------------------------------------
#ifndef USERDATA_H
#define USERDATA_H
//---------------------------------------------------------------------------
#include <qstring.h>
#include <qstringlist.h>
#include <qlist.h>
//---------------------------------------------------------------------------
// Hier werden alle Informationen ueber bekannte Benutzer gespeichert.
//---------------------------------------------------------------------------
class UDataUser
{
public:
	UDataUser( const QString & callsign, const QString & filename, int temp=false );
   ~UDataUser();

   bool isTemporary();

   // Methoden, die die Einstellungen zurueck geben
   const QString & getCall();
   const QString & getName();
   long getFlags();
   long getRemotes();
   int getSoftware();
   int getType();

   // Methoden, die die Einstellungen veraendern
   void setName( const QString & name );
   void setFlag( long flag, bool state );
   void setRemotes( long rem );
   void setSoftware( int soft );
   void setType( int type );

private:
	void readData();
	void saveSetting( const QString & id, QString & value );

	QString call, fname, name;
   long flags, remotes;
   int software, type;

   bool temporary, changed;
};
//---------------------------------------------------------------------------
class UserData
{
public:
	UserData();
   ~UserData();

   void readUserList();

   const QStringList & getUserList();
   UDataUser * getUserData( const QString & call );

private:
	void addUserGroup( const QString & directory );

   QStringList users;
	QString udataDir;
   QList<UDataUser> *userDataList;
};
//---------------------------------------------------------------------------
extern UserData *userdata;
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

