.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutFullScreen 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutFullScreen - requests that the current window be made full screen. 
.SH SYNTAX
.nf
.LP
void glutFullScreen(void);
.fi
.SH DESCRIPTION
glutFullScreen requests that the current window be made full screen.
The exact semantics of what full screen means may vary by window
system. The intent is to make the window as large as possible and disable
any window decorations or borders added the window system. The
window width and height are not guaranteed to be the same as the screen
width and height, but that is the intent of making a window full screen. 

glutFullScreen is defined to work only on top-level windows. 

The glutFullScreen requests are not processed immediately. The
request is executed after returning to the main event loop. This allows
multiple glutReshapeWindow, glutPositionWindow, and
glutFullScreen requests to the same window to be coalesced. 

Subsequent glutReshapeWindow and glutPositionWindow
requests on the window will disable the full screen status of the window.
.SH X IMPLEMENTATION NOTES
In the X implementation of GLUT, full screen is implemented by sizing
and positioning the window to cover the entire screen and posting the  
_MOTIF_WM_HINTS property on the window requesting absolutely no
decorations. Non-Motif window managers may not respond to
_MOTIF_WM_HINTS. 
.SH SEE ALSO
glutReshapeWindow, glutPositionWindow
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
