/*****************************
 Load XPMs into memory
 (c) 1999 Jeremy Wise
 GnomeICU
******************************/

/*** GnomeICU headers ***/
#include "common.h"
#include "loadpixmap.h"
#include <gdk-pixbuf/gdk-pixbuf.h>

/*** Local functions ***/
static void init_one_pixmap( gchar *icon_name, GdkPixmap **icon_pixmap,
                             GdkBitmap **icon_bitmap, int alpha_threshold );

/*** Global functions ***/
gchar *make_file_path_theme( gchar *file_name, gchar *theme_name )
{
    gchar *file;

    /* Local themes */
    file = g_strconcat( g_get_home_dir(), "/.icq/icons/", theme_name, "/", file_name, NULL );

    if( !g_file_exists( file ) ) /* Local theme does not exist */
    {
        /* Global themes */
        gchar *theme_path;
        theme_path = gnome_unconditional_datadir_file( "gnomeicu/icons/");

        g_free( file );
        file = g_strconcat( theme_path, theme_name, "/", file_name, NULL );

        if( !g_file_exists( file ) ) /* Theme does not exist, use Default */
        {
            g_free( file );
            file = g_strconcat( theme_path, "Default/", file_name, NULL );

            if( !g_file_exists( file ) ) /* Nothing exists */
            {
                g_free( file );
                file = NULL;
            }
        }

        g_free( theme_path );
    }
    
    return file;
}

gchar *make_file_path( gchar *file_name )
{
    return make_file_path_theme( file_name, toggles->theme_name );
}

static void init_one_pixmap( gchar *icon_name, GdkPixmap **icon_pixmap,
                             GdkBitmap **icon_bitmap, int alpha_threshold )
{
        GdkPixbuf *im;
        gchar *icon_filename;

        icon_filename = make_file_path( icon_name );

        im = gdk_pixbuf_new_from_file( icon_filename );
        gdk_pixbuf_render_pixmap_and_mask( im, icon_pixmap,
                                           icon_bitmap, alpha_threshold );
        gdk_pixbuf_finalize( im );

        g_free( icon_filename );
}

void init_pixmaps( GtkStyle *style, GtkWidget *main_window )
{
#ifdef TRACE_FUNCTION
    g_print( "init_pixmaps\n" );
#endif
    
    init_one_pixmap( "gnomeicu-blank.png",
                     &icon_blank_pixmap,	&icon_blank_bitmap, 	1 );
    init_one_pixmap( "gnomeicu-still.png",
                     &still_eyes_pixmap,	&still_eyes_bitmap,	    1 );
    init_one_pixmap( "gnomeicu-message.png",
                     &icon_message_pixmap,     &icon_message_bitmap,	1 );
    init_one_pixmap( "gnomeicu-url.png",
                     &icon_url_pixmap,	    &icon_url_bitmap,	    1 );
    init_one_pixmap( "gnomeicu-auth.png",
                     &icon_auth_pixmap,	    &icon_auth_bitmap,	    1 );
    init_one_pixmap( "gnomeicu-away.png",
                     &icon_away_pixmap,	    &icon_away_bitmap,  	50 );
    init_one_pixmap( "gnomeicu-occ.png",
                     &icon_occ_pixmap,  	&icon_occ_bitmap,   	50 );
    init_one_pixmap( "gnomeicu-na.png",
                     &icon_na_pixmap,	    &icon_na_bitmap,    	50 );
    init_one_pixmap( "gnomeicu-dnd.png",
                     &icon_dnd_pixmap,	    &icon_dnd_bitmap,   	50 );
    init_one_pixmap( "gnomeicu-ffc.png",
                     &icon_ffc_pixmap,	    &icon_ffc_bitmap,   	50 );
    init_one_pixmap( "gnomeicu-inv.png",
                     &icon_inv_pixmap,	    &icon_inv_bitmap,   	50 );
    init_one_pixmap( "gnomeicu-online.png",
                     &icon_online_pixmap,	&icon_online_bitmap,	50 );
    init_one_pixmap( "gnomeicu-offline.png",
                     &icon_offline_pixmap,	&icon_offline_bitmap,	50 );
    init_one_pixmap( "gnomeicu-chat.png",
                     &icon_chat_pixmap,	    &icon_chat_bitmap,  	1 );
    init_one_pixmap( "gnomeicu-file.png",
                     &icon_file_pixmap,	    &icon_file_bitmap,  	1 );
    init_one_pixmap( "gnomeicu-info.png",
                     &icon_info_pixmap,	    &icon_info_bitmap,  	1 );
    init_one_pixmap( "gnomeicu-contact.png",
                     &icon_contact_pixmap,	&icon_contact_bitmap,	1 );
    init_one_pixmap( "gnomeicu-hist.png",
                     &icon_hist_pixmap,	    &icon_hist_bitmap,  	1 );
    init_one_pixmap( "gnomeicu-rename.png",
                     &icon_rename_pixmap,	&icon_rename_bitmap,	1 );
    init_one_pixmap( "gnomeicu-cancel.png",
                     &icon_cancel_pixmap,	&icon_cancel_bitmap,	1 );
    init_one_pixmap( "gnomeicu-ok.png",
                     &icon_ok_pixmap,	    &icon_ok_bitmap,    	1 );
}
