.\" $XFree86: xc/programs/Xserver/hw/xfree86/XFree86.man,v 3.54 2002/01/17 17:10:37 dawes Exp $ 
.TH XFree86 1 __vendorversion__
.SH NAME
XFree86 - X11R6 X server
.SH SYNOPSIS
.B XFree86
[:display] [option ...]
.SH DESCRIPTION
XFree86 is an X server that was originally designed for UNIX and UNIX-like
operating systems running on Intel x86 hardware.  It now runs on a wider
range of hardware and OS platforms.
.PP
This work is derived from
.I "X386\ 1.2"
which was contributed to X11R5 by Snitily Graphics Consulting Service.
The current XFree86 release is based on X11R6.3.  The XFree86 X server
architecture was redesigned for the 4.0 release, and it includes among
other things a loadable module system donated by Metro Link, Inc.
.SH CONFIGURATIONS
.PP
.I XFree86
operates under a wide range of operating systems and hardware platforms.
The Intel x86 (IA32) architecture is the most widely supported hardware
platform.  Other hardware platforms include Compaq Alpha, Intel IA64,
SPARC and PowerPC.  The most widely supported operating systems are the
free/OpenSource UNIX-like systems such as Linux, FreeBSD, NetBSD and
OpenBSD.  Commercial UNIX operating systems such as Solaris (x86) and
UnixWare are also supported.  Other supported operating systems include
LynxOS, and GNU Hurd.  Darwin and Mac OS X are supported with the
XDarwin(1) X server.  Win32/Cygwin is supported with the XWin X server.
.PP
.SH "NETWORK CONNECTIONS"
\fIXFree86\fP supports connections made using the following reliable
byte-streams:
.TP 4
.I "Local"
On most platforms, the "Local" connection type is a UNIX-domain socket.
On some System V platforms, the "local" connection types also include
STREAMS pipes, named pipes, and some other mechanisms.
.TP 4
.I TCP\/IP
\fIXFree86\fP listens on port 6000+\fIn\fP, where \fIn\fP is the display
number.  This connection type can be disabled with the \fB\-nolisten\fP
option (see the Xserver(1) man page for details).
.SH "ENVIRONMENT VARIABLES"
For operating systems that support local connections other than Unix Domain
sockets (SVR3 and SVR4), there is a compiled-in list specifying the order 
in which local connections should be attempted.  This list can be overridden by
the \fIXLOCAL\fP environment variable described below.  If the display name 
indicates a best-choice connection should be made (e.g. \fI:0.0\fP), each 
connection mechanism is tried until a connection succeeds or no more 
mechanisms are available.  Note: for these OSs, the Unix Domain socket
connection is treated differently from the other local connection types.
To use it the connection must be made to \fIunix:0.0\fP.
.PP
The \fIXLOCAL\fP environment variable should contain a list of one more
more of the following:
.PP
.RS 8
.nf
NAMED
PTS
SCO
ISC
.fi
.RE
.PP
which represent SVR4 Named Streams pipe, Old-style USL
Streams pipe, SCO XSight Streams pipe, and ISC Streams pipe, respectively.
You can select a single mechanism (e.g. \fIXLOCAL=NAMED\fP), or an ordered
list (e.g. \fIXLOCAL="NAMED:PTS:SCO"\fP).  This variable overrides the
compiled-in defaults.  For SVR4 it is recommended that \fINAMED\fP be
the first preference connection.  The default setting is
\fIPTS:NAMED:ISC:SCO\fP.
.PP
To globally override the compiled-in defaults, you should define (and
export if using \fIsh\fP or \fIksh\fP) \fIXLOCAL\fP globally.  If you
use \fIstartx/xinit\fP, the definition should be at the top of
your \fI.xinitrc\fP file.  If you use \fIxdm\fP, the definitions should be
early on in the \fI<XRoot>/lib/X11/xdm/Xsession\fP script.
.SH OPTIONS
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXFree86\fP accepts the following command line switches:
.TP 8
.B vt\fIXX\fP
\fIXX\fP specifies the Virtual Terminal device number which \fIXFree86\fP
will use.  Without this option, \fIXFree86\fP will pick the first
available Virtual Terminal that it can locate.  This option applies only
to platforms such as Linux, BSD, SVR3 and SVR4, that have virtual terminal
support.
.TP
.B \-allowMouseOpenFail
Allow the server to start up even if the mouse device can't be opened
or initialised.  This is equivalent to the
.B AllowMouseOpenFail
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-allowNonLocalModInDev
Allow changes to keyboard and mouse settings from non-local clients.
By default, connections from non-local clients are not allowed to do
this.  This is equivalent to the
.B AllowNonLocalModInDev
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-allowNonLocalXvidtune
Make the VidMode extension available to remote clients.  This allows
the xvidtune client to connect from another host.  This is equivalent
to the
.B AllowNonLocalXvidtune
XF86Config(__filemansuffix__) file option.  By default non-local
connections are not allowed.
.TP 8
.B \-bgamma \fIvalue\fP
Set the blue gamma correction.  \fIvalue\fP must be between 0.1 and 10.
The default is 1.0.  Not all drivers support this.  See also the
.BR \-gamma ,
.BR \-rgamma ,
and
.B \-ggamma
options.
.TP 8
.B \-bpp \fIn\fP
No longer supported.  Use \fB\-depth\fP to set the color depth, and use
\fB\-fbbpp\fP if you really need to force a non-default framebuffer
(hardware) pixel format.
.TP
.B \-configure
When this option is specified, the X server loads all video driver
modules, probes for available hardware, and writes out an initial
XF86Config(__filemansuffix__) file based on what was detected.  This
option currently has some problems on some platforms, but in most cases
it is a good way to bootstrap the configuration process.  This option
is only available when the server is run as root (i.e, with real-uid
0).
.TP 8
.B \-crt /dev/tty\fIXX\fP
SCO only.  This is the same as the \fBvt\fP option, and is provided for
compatibility with the native SCO X server.
.TP 8
.B \-depth \fIn\fP
Sets the default color depth.  Legal values are 1, 4, 8, 15, 16, and
24.  Not all drivers support all values.
.TP 8
.B \-disableModInDev
Disable dynamic modification of input device settings.  This is equivalent
to the
.B DisableModInDev
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-disableVidMode
Disable the the parts of the VidMode extension (used by the xvidtune
client) that can be used to change the video modes.  This is equivalent
to the
.B DisableVidModeExtension
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-fbbpp \fIn\fP
Sets the number of framebuffer bits per pixel.  You should only set this
if you're sure it's necessary; normally the server can deduce the correct
value from \fB\-depth\fP above.  Useful if you want to run a depth 24
configuration with a 24 bpp framebuffer rather than the (possibly default)
32 bpp framebuffer (or vice versa).  Legal values are 1, 8, 16, 24, 32.
Not all drivers support all values.
.TP 8
.B \-flipPixels
Swap the default values for the black and white pixels.
.TP 8
.B \-gamma \fIvalue\fP
Set the gamma correction.  \fIvalue\fP must be between 0.1 and 10.  The
default is 1.0.  This value is applied equally to the R, G and B values.
Those values can be set independently with the
.BR \-rgamma ,
.BR \-bgamma ,
and
.B \-ggamma
options.  Not all drivers support this.
.TP 8
.B \-ggamma \fIvalue\fP
Set the green gamma correction.  \fIvalue\fP must be between 0.1 and
10.  The default is 1.0.  Not all drivers support this.  See also the
.BR \-gamma ,
.BR \-rgamma ,
and
.B \-bgamma
options.
.TP 8
.B \-ignoreABI
The X server checks the ABI revision levels of each module that it loads.
It will normally refuse to load modules with ABI revisions that are newer
than the server's.  This is because such modules might use interfaces that
the server does not have.  When this option is specified, mismatches like
this are downgraded from fatal errors to warnings.  This option should
be used with care.
.TP 8
.B \-keeptty
Prevent the server from detaching its initial controlling terminal.
This option is only useful when debugging the server.  Not all platforms
support (or can use) this option.
.TP 8
.B \-keyboard \fIkeyboard-name\fP
Use the XF86Config(__filemansuffix__) file
.B InputDevice
section called
.I keyboard-name
as the core keyboard.  This option is ignored when the
.B Layout
section specifies a core keyboard.
In the absence of both a Layout section and this option,
the first relevant
.B InputDevice
section is used for the core keyboard.
.TP 8
.B \-layout \fIlayout-name\fP
Use the XF86Config(__filemansuffix__) file
.B Layout
section called
.IR layout-name .
By default the first
.B Layout
section is used.
.TP 8
.B \-logfile \fIfilename\fP
Use the file called
.I filename
as the X server log file.  The default log file is
.B __logdir__/XFree86.\fIn\fP.log
on most platforms, where
.I n
is the display number of the X server.  The default may be in a different
directory on some platforms.  This option is only available when the
server is run as root (i.e, with real-uid 0).
.TP 8
.BR \-logverbose " [\fIn\fP]"
Sets the verbosity level for information printed to the X server log
file.  If the
.I n
value isn't supplied, each occurrance of this option increments the log
file verbosity level.  When the
.I n
value is supplied, the log file verbosity level is set to that value.
The default log file verbosity level is 3.
.TP 8
.B \-modulepath \fIsearchpath\fP
Set the module search path to
.IR searchpath .
.I searchpath
is a comma separated list of directories to search for X server modules.
This option is only available when the server is run as root (i.e, with
real-uid 0).
.TP 8
.B \-nosilk
Disable Silken Mouse support.
.TP 8
.B \-pixmap24
Set the internal pixmap format for depth 24 pixmaps to 24 bits per pixel.
The default is usually 32 bits per pixel.  There is normally little
reason to use this option.  Some client applications don't like this
pixmap format, even though it is a perfectly legal format.
This is equvalent to the
.B Pixmap
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-pixmap32
Set the internal pixmap format for depth 24 pixmaps to 32 bits per pixel.
This is usually the default.
This is equvalent to the
.B Pixmap
XF86Config(__filemansuffix__) file option.
.TP 8
.B \-pointer \fIpointer-name\fP
Use the XF86Config(__filemansuffix__) file
.B InputDevice
section called
.I pointer-name
as the core pointer.  This option is ignored when the
.B Layout
section specifies a core pointer.
In the absence of both a Layout section and this option,
the first relevant
.B InputDevice
section is used for the core pointer.
.TP 8
.B \-probeonly
Causes the server to exit after the device probing stage.  The XF86Config
file is still used when this option is given, so information that can
be auto-detected should be commented out.
.TP 8
.B \-quiet
Suppress most informational messages at startup.  The verbosity level
is set to zero.
.TP 8
.B \-rgamma \fIvalue\fP
Set the red gamma correction.  \fIvalue\fP must be between 0.1 and 10.
The default is 1.0.  Not all drivers support this.  See also the
.BR \-gamma ,
.BR \-bgamma ,
and
.B \-ggamma
options.
.TP 8
.B \-scanpci
When this option is specified, the X server scans the PCI bus, and prints
out some information about each device that was detected.  See also
scanpci(1) and pcitweak(1).
.TP 8
.B \-screen \fIscreen-name\fP
Use the XF86Config(__filemansuffix__) file
.B Screen
section called
.IR screen-name .
By default the screens referenced by the default
.B Layout
section are used, or the first
.B Screen
section when there are no
.B Layout
sections.
.TP 8
.B \-showconfig
This is the same as the
.B \-version
option, and is included for compatibilty reasons.  It may be removed in
a future release, so the
.B \-version
options hould be used instead.
.TP 8
.B \-weight \fInnn\fP
Set RGB weighting at 16 bpp.  The default is 565.  This applies only to
those drivers which support 16 bpp.
.TP 8
.BR \-verbose " [\fIn\fP]"
Sets the verbosity level for information printed on stderr.  If the
.I n
value isn't supplied, each occurrance of this option increments the
verbosity level.  When the
.I n
value is supplied, the verbosity level is set to that value.  The default
verbosity level is 0.
.TP 8
.B \-version
Print out the server version, patchlevel, release date, the operating
system/platform it was built on, and whether it includes module loader
support.
.TP 8
.B \-xf86config \fIfile\fP
Read the server configuration from \fIfile\fP.  This option will work
for any file when the server is run as root (i.e, with real-uid 0), or
for files relative to a directory in the config search path for all
other users.
.SH "KEYBOARD"
Multiple key presses recognized directly by \fIXFree86\fP are:
.TP 8
.B Ctrl+Alt+Backspace
Immediately kills the server -- no questions asked.  This can be disabled
with the
.B DontZap
XF86Config(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Plus
Change video mode to next one specified in the configuration file.
This can be disabled with the
.B DontZoom
XF86Config(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+Keypad-Minus
Change video mode to previous one specified in the configuration file.
This can be disabled with the
.B DontZoom
XF86Config(__filemansuffix__) file option.
.TP 8
.B Ctrl+Alt+F1...F12
For BSD and Linux systems with virtual terminal support, these keystroke
combinations are used to switch to Virtual Console 1 through 12.
.SH SETUP
.I XFree86
uses a configuration file called \fBXF86Config\fP for its initial setup.  
Refer to the
.I XF86Config(__filemansuffix__)
manual page for information about the
format of this file.
.SH FILES
The X server config file can be found in a range of locations.  These
are documented fully in the
.I XF86Config(__filemansuffix__)
manual page.  The most commonly used locations are shown here.
.TP 30
/etc/X11/XF86Config
Server configuration file
.TP 30
/etc/X11/XF86Config-4
Server configuration file
.TP 30
/etc/XF86Config
Server configuration file
.TP 30
__projectroot__/etc/XF86Config
Server configuration file
.TP 30
__projectroot__/lib/X11/XF86Config
Server configuration file
.TP 30
__logdir__/XFree86.\fIn\fP.log
Server log file for display \fIn\fP.
.TP 30
__projectroot__/bin/\(**
Client binaries
.TP 30
__projectroot__/include/\(**
Header files
.TP 30
__projectroot__/lib/\(**
Libraries
.TP 30
__projectroot__/lib/X11/fonts/\(**
Fonts
.TP 30
__projectroot__/lib/X11/rgb.txt
Color names to RGB mapping
.TP 30
__projectroot__/lib/X11/XErrorDB
Client error message database
.TP 30
__projectroot__/lib/X11/app-defaults/\(**
Client resource specifications
.TP 30
__projectroot__/man/man?/\(**
Manual pages
.TP 30
/etc/X\fIn\fP.hosts
Initial access control list for display \fIn\fP
.SH "SEE ALSO"
X(__miscmansuffix__), Xserver(1), xdm(1), xinit(1),
XF86Config(__filemansuffix__), xf86config(1), xf86cfg(1), xvidtune(1),
apm(__drivermansuffix__),
ati(__drivermansuffix__),
chips(__drivermansuffix__),
cirrus(__drivermansuffix__),
cyrix(__drivermansuffix__),
fbdev(__drivermansuffix__),
glide(__drivermansuffix__),
glint(__drivermansuffix__),
i128(__drivermansuffix__),
i740(__drivermansuffix__),
i810(__drivermansuffix__),
imstt(__drivermansuffix__),
mga(__drivermansuffix__),
neomagic(__drivermansuffix__),
nv(__drivermansuffix__),
r128(__drivermansuffix__),
rendition(__drivermansuffix__),
s3virge(__drivermansuffix__),
siliconmotion(__drivermansuffix__),
sis(__drivermansuffix__),
sunbw2(__drivermansuffix__),
suncg14(__drivermansuffix__),
suncg3(__drivermansuffix__),
suncg6(__drivermansuffix__),
sunffb(__drivermansuffix__),
sunleo(__drivermansuffix__),
suntcx(__drivermansuffix__),
tdfx(__drivermansuffix__),
tga(__drivermansuffix__),
trident(__drivermansuffix__),
tseng(__drivermansuffix__),
v4l(__drivermansuffix__),
vesa(__drivermansuffix__),
vga(__drivermansuffix__),
vmware(__drivermansuffix__),
.br
README
.IR <http://www.xfree86.org/current/README.html> ,
.br
RELNOTES
.IR <http://www.xfree86.org/current/RELNOTES.html> ,
.br
README.mouse
.IR <http://www.xfree86.org/current/mouse.html> ,
.br
README.DRI
.IR <http://www.xfree86.org/current/DRI.html> ,
.br
Status
.IR <http://www.xfree86.org/current/Status.html> ,
.br
Install
.IR <http://www.xfree86.org/current/Install.html> .

.SH AUTHORS
XFree86 has many contributors world wide.  The names of most of them
can be found in the documentation, CHANGELOG files in the source tree,
and in the actual source code.
.PP
XFree86 was originally based on \fIX386 1.2\fP by Thomas Roell, which
was contributed to the then X Consortium's X11R5 distribution by SGCS.
.PP
The project that became XFree86 was originally founded in 1992 by
David Dawes, Glenn Lai, Jim Tsillas and David Wexelblat.
.PP
XFree86 was later integrated in the then X Consortium's X11R6 release
by a group of dedicated XFree86 developers, including the following:
.PP
.RS 4
.nf
Stuart Anderson    \fIanderson@metrolink.com\fP
Doug Anson         \fIdanson@lgc.com\fP
Gertjan Akkerman   \fIakkerman@dutiba.twi.tudelft.nl\fP
Mike Bernson       \fImike@mbsun.mlb.org\fP
Robin Cutshaw      \fIrobin@XFree86.org\fP
David Dawes        \fIdawes@XFree86.org\fP
Marc Evans         \fImarc@XFree86.org\fP
Pascal Haible      \fIhaible@izfm.uni-stuttgart.de\fP
Matthieu Herrb     \fIMatthieu.Herrb@laas.fr\fP
Dirk Hohndel       \fIhohndel@XFree86.org\fP
David Holland      \fIdavidh@use.com\fP
Alan Hourihane     \fIalanh@fairlite.demon.co.uk\fP
Jeffrey Hsu        \fIhsu@soda.berkeley.edu\fP
Glenn Lai          \fIglenn@cs.utexas.edu\fP
Ted Lemon          \fImellon@ncd.com\fP
Rich Murphey       \fIrich@XFree86.org\fP
Hans Nasten        \fInasten@everyware.se\fP
Mark Snitily       \fImark@sgcs.com\fP
Randy Terbush      \fIrandyt@cse.unl.edu\fP
Jon Tombs          \fItombs@XFree86.org\fP
Kees Verstoep      \fIversto@cs.vu.nl\fP
Paul Vixie         \fIpaul@vix.com\fP
Mark Weaver        \fIMark_Weaver@brown.edu\fP
David Wexelblat    \fIdwex@XFree86.org\fP
Philip Wheatley    \fIPhilip.Wheatley@ColumbiaSC.NCR.COM\fP
Thomas Wolfram     \fIwolf@prz.tu-berlin.de\fP
Orest Zborowski    \fIorestz@eskimo.com\fP
.fi
.RE
.PP
The current XFree86 core team consists of:
.PP
.RS 4
.nf
Stuart Anderson    \fIanderson@metrolink.com\fP
Preston Brown      \fIpbrown@redhat.com\fP
Robin Cutshaw      \fIrobin@xfree86.org\fP
David Dawes        \fIdawes@xfree86.org\fP
Egbert Eich        \fIeich@xfree86.org\fP
Marc Evans         \fImarc@xfree86.org\fP
Dirk Hohndel       \fIhohndel@xfree86.org\fP
Alan Hourihane     \fIalanh@xfree86.org\fP
Harald Koenig      \fIkoenig@xfree86.org\fP
Marc La France     \fItsi@xfree86.org\fP
Kevin Martin       \fImartin@xfree86.org\fP
Rich Murphey       \fIrich@xfree86.org\fP
Takaaki Nomura     \fIamadeus@yk.rim.or.jp\fP
Keith Packard      \fIkeithp@xfree86.org\fP
Jon Tombs          \fIjon@gtex02.us.es\fP
Mark Vojkovich     \fImarkv@xfree86.org\fP
David Wexelblat    \fIdwex@xfree86.org\fP
.fi
.RE
.PP
\fIXFree86\fP source is available from the FTP server
\fI<ftp://ftp.XFree86.org/pub/XFree86/>\fP, among others.  Documentation
and other information can be found from the XFree86 web site
\fI<http://www.xfree86.org/>\fP.
