/*****************************************************************************\
   translator.h : Implimentation for the RasterSender class

   Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#include "header.h"
#include "halftoner.h"

APDK_BEGIN_NAMESPACE

RasterSender::RasterSender(Printer* pP, PrintContext* pPC,
                       Job* pJob,Halftoner* pHalftoner)
    : thePrinter(pP), thePrintContext(pPC), theJob(pJob),theHalftoner(pHalftoner)
{
    constructor_error=NO_ERROR;
    m_lNBlankRasters = 0;
}

RasterSender::~RasterSender()
{
}

////////////////////////////////////////////////////////////////////////
BOOL RasterSender::Process(BYTE* InputRaster, unsigned int size)
{
    DRIVER_ERROR err=NO_ERROR;
    BOOL bOutput=FALSE;
    if (InputRaster)
    {
        err=SendRaster(InputRaster,size);
        if (err==NO_ERROR)
            bOutput=TRUE;
    }
    else
    {

/*
 *      Replace CAP move command here with vertical raster move command.
 *      If buffering this causes code bloat, do send the command here.
 */

/*
             if ((err = thePrinter->Send ((const BYTE *) "\033*b1Y")) == NO_ERROR)
                bOutput = TRUE;
*/
//            m_lNBlankRasters++;
              err = theJob->SendCAPy ();

    }

    myphase->err = err;

  return bOutput;
}


DRIVER_ERROR RasterSender::SendRaster(BYTE* InputRaster,unsigned int size)
{
    DRIVER_ERROR err;
    BOOL lastplane,firstplane;


/*
 *  If there were any blank rasters counted, flush them now.
 */
/*
    if ((err = FlushRasterMove ()) != NO_ERROR)
        return err;
*/

    if (theHalftoner)
    {
        lastplane = theHalftoner->LastPlane();
        firstplane = theHalftoner->FirstPlane();
    }
    else lastplane=firstplane=TRUE;

// older code used to send regular CAPy move as part of text-synchronization scheme
    if (firstplane)
            err=theJob->SendCAPy();
/*
    if (lastplane)
        scratchLen = sprintf(scratch, "%c%c%c%d%c", '\033', '*', 'b', size, 'W');
    else
        scratchLen = sprintf(scratch, "%c%c%c%d%c", '\033', '*', 'b', size, 'V');

    err = thePrinter->Send((const BYTE*)scratch,scratchLen);
    ERRCHECK;

    err = thePrinter->Send(InputRaster,size);
 */

    err = thePrinter->Encapsulate (InputRaster, size, lastplane);
    ERRCHECK;

  return err;
}

#if 0
DRIVER_ERROR RasterSender::FlushRasterMove ()
{
    char scratch[12];
    DRIVER_ERROR err;

    if (!m_lNBlankRasters)
        return NO_ERROR;

/*
 *  MAX_Y_OFFSET is 32767. Currently, the highest resolution supported is 600
 *  and papersize is 8 1/2 x 11, this limit check is not necessary. This will
 *  be needed when APDK supports higher resolutions and larger papersizes.
 *
    while (m_lNBlankRasters > MAX_Y_OFFSET)
    {
        scratchLen = sprintf (scratch, "\033*b%dY", MAX_Y_OFFSET);
        err = thePrinter->Send ((const BYTE*) scratch, scratchLen);
        m_lNBlankRasters -= MAX_Y_OFFSET;
        ERRCHECK;
    }
 */

    sprintf (scratch, "\033*b%dY", m_lNBlankRasters);
    err = thePrinter->Send ((const BYTE*) scratch, strlen (scratch));
    m_lNBlankRasters = 0;
    ERRCHECK;
    return err;
}
#endif

APDK_END_NAMESPACE

