/*-
 * config.h --
 *	Configuration constants for the local site.
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 *	"$Id: config.h,v 1.37 1996/08/19 17:03:01 stolcke Exp $ ICSI (Berkeley)"
 */

/*
 * For customs, everything's the same except we tell the job module to use
 * the extended Rmt interfaces.
 */
#include "../unix/config.h"

/*
 * RMT_WILL_WATCH
 *	If defined, the job module will rely on the rmt module to pay attention
 *	to streams and to call Job_CatchChildren on a regular basis should any
 *	jobs be run locally. Defining this adds the following three functions
 *	to the Rmt interface requirements:
 *	    void    Rmt_Watch(stream, proc, data)
 *	    	Call proc(stream, data) whenever stream becomes READABLE.
 *	    void    Rmt_Ignore(stream)
 *	    	Stop paying attention to stream.
 *	    void    Rmt_Wait()
 *	    	Wait for something to happen, process it and return when
 *	    	done. During this time, Job_CatchChildren should be called
 *	    	regularly (if the Rmt module wishes to catch SIGCHLD, or its
 *	    	equivalent, and call Job_CatchChildren SYNCHRONOUSLY [e.g.
 *	    	by setting a flag for Rmt_Wait to watch for], that is fine).
 *	    	The Customs Rmt module does it by waking up every 200 ms
 *	    	and calling Job_CatchChildren(block = FALSE).
 *
 * RMT_WANTS_SIGNALS
 *	If defined, the job module will rely on the rmt module to transmit
 *	any signal to a remote job. If not defined, the pid in the job
 *	descriptor will be assumed to hold the id of a process that will
 *	transmit the signal. If signals cannot be sent at all, set the pid
 *	to 0 and don't define this.
 *	There are several places where a signal might be sent:
 *	    1) if pmake receives one of the four interrupt signals (SIGINT,
 *	    	SIGHUP, SIGTERM and SIGQUIT)
 *	    2) if pmake receives a terminal signal (SIGTSTP, SIGTTIN,
 *	    	SIGTTOU, SIGWINCH). Note these signals are only caught if
 *	    	RMT_WANT_SIGNALS or USE_PGRP are defined.
 *	    3) if something calls for an abort of all currently running jobs
 *	Defining this constant introduces another interface:
 *	    int	Rmt_Signal(job, signo)
 *	The function should return non-zero on success, zero if signal couldn't
 *	be delivered.
 *
 * RMT_NO_EXEC
 *	If defined, implies that a fork/exec is not required to export a
 *	job. When running in parallel mode, pmake will use the function
 *	    	int Rmt_Export(fileToExec, argv, job)
 *	in place of Rmt_Begin (Rmt_Begin, Rmt_Exec, Rmt_LastID and Rmt_Done
 *	will still be used if exporting in non-parallel mode, as the
 *	compatibility module doesn't use Job descriptors).
 */
/*
 * Turning off RMT_WANTS_SIGNALS, RMT_NO_EXEC, or RMT_WILL_WATCH (incrementally
 * in that order), should give working remote execution and a somewhat
 * smaller pmake binary, but job control may suffer.
 * For best performance and most reliable signal processing, define all three.
 */
#define RMT_WILL_WATCH
#define RMT_WANTS_SIGNALS
#define RMT_NO_EXEC

/*
 * CAN_EXPORT
 *	If defined, indicates that an export system is installed. This
 *	activates the -X and -x flags.
 * EXPORTDOC
 *	An name to identify the exportation facility used in this version
 *	of PMake.
 */
#define CAN_EXPORT
#define EXPORTDOC	"Customs"

/*
 * EXPORT_RETRY
 *	If defined will allow pmake to retry exporting jobs for which a
 *	suitable host couldn't be found at first, at regular intervals
 *	independent of termination of other jobs.
 *	Should be defined to the number of seconds between retries.
 *	Requires RMT_WILL_WATCH.
 */
#define EXPORT_RETRY	(10)

/*
 * If you're using something more reliable than NFS for your filesystem,
 * nuke this #undef line. Look at the note in ../unix/config.h for its
 * meaning.
 */
#undef RECHECK

/*
 * It is highly recommended to use process groups to reliably manage
 * child processes, except maybe on System V systems that don't allow
 * terminal stop signals to be sent to background jobs.
 */
#define USE_PGRP 

/*
 * Customs itself logs important information in one of three ways.
 * 1 - Using syslog(3), the preferred method.  Just define LOG_FACILITY
 *     to the facility name most appropriate at your site.
 * 2 - To a file that is private to each host.  Define LOG_FILE to the
 *     desired file name.
 * 3 - To a file with a path and prefix that is shared among all machines,
 *     and distinguished by tacking ".<hostname>" to the end of LOG_BASE.
 *     Define LOG_BASE.
 */
#define LOG_FACILITY	LOG_LOCAL6	/* the actual facility doesn't matter
					   on pre-4.3BSD systems */

#ifndef LOG_FACILITY
#define LOG_FILE	"/usr/adm/customs-log"
/* #define LOG_BASE	"/usr/local/etc/customs-log" */
#endif

/*
 * If INSECURE is defined, Customs will allow root to export things. This should
 * only be done in a very friendly environment, even if all the other security
 * features are enabled.
 */
#undef INSECURE

/*
 * Define USE_RESERVED_PORTS if customs should restrict certain critical RPCs
 * to peers on reserved ports (i.e., clients running as root).  This will
 * affect RPCs that change the state of the customs network (cctrl), alter
 * availability criteria (importquota), or request hosts for exportation
 * (export, pmake).  This also means that the latter two programs have to be
 * installed suid root, thus preventing unfriendly users from writing bougs
 * customs clients masquarading as someone else when exporting jobs.
 */
#define USE_RESERVED_PORTS

/*
 * ALLOW_EVICT_BY_USER enables non-root users to send eviction signals
 * to any job (not necessarily their own).
 */
#define ALLOW_EVICT_BY_USER

/*
 * Define NO_PRIORITY if you don't want the customs daemon to run at
 * above-normal scheduling priority.  Doing so helps response but some
 * sites don't like priviledged daemons.
 */
#undef NO_PRIORITY

/*
 * Define ORIG_CWD if you don't want to use the path normalization
 * feature that massages a current directory path prior to exportation.
 * The default path normalizer assumes you have the Sun automounter
 * (or equivalent) running.  If this is not true and your file name
 * space is not sufficiently uniform accross the customs network
 * you'll have to edit Customs_NormPath() in customslib.c.
 */
#undef ORIG_CWD

/*
 * If you do want path normalization you may have to edit the function
 * Customs_NormPath() in customslib.c to suit you local setup.
 * The standard version knows how to deal with a simple cross-mounting
 * scheme as implemented by the Sun automount(8) -hosts map.  The
 * pathnames used can be changed here if necessary.  Note the trailing
 * slashes, they are required.
 */
#define TMPMNT	"/tmp_mnt/"		/* Prefix for automount points */
#define NETMNT	"/n/"			/* Automount directory for host map 
					   -- some may prefer /net/ */

/*
 * The following are the default availability criteria.
 * There can be changed later either at customs startup or at run time
 * using importquota(8).
 */
#define DEF_CHECK_TIME	10		/* check availability every 10 secs */
#define DEF_LOCAL_JOBS  0		/* don't allow jobs from local clients */
#define DEF_MAX_LOAD	0.5		/* load > 0.5 => not available */
#define DEF_MIN_SWAP	25		/* 75% used swap => not available */
#define DEF_MIN_IDLE	15*60		/* Keyboard must have been idle at
                                           least 15 minutes */
#define DEF_IDLECRIT	(IDLECRIT_KBD|IDLECRIT_USER)
					/* Keyboard and console user activity
					   are checked for idle time */
#define DEF_MAX_IMPORTS	2		/* Largest number of imported jobs */
#define DEF_MIN_PROC	10		/* At least 10 free slots in process
					   table */
/*#define DEF_CPU_LIMIT	5*60 */		/* > 5 mins CPU time => abort job */
#define DEF_CPU_LIMIT	0		/* Unlimited time for imported jobs */
#define DEF_MEM_LIMIT	0		/* Unlimited memory for imported jobs */
#define DEF_NICE_LEVEL	4		/* nice 4 for imported jobs */
#define DEF_NPRI_LEVEL	0		/* no non-degrading priority */
/*#define DEF_EVICT_DELAY 0 */		/* Don't evict imported jobs */
#define DEF_EVICT_DELAY	2*60		/* Jobs are allowed 2 more minutes
					   once machine becomes non-idle */
#define DEF_CHECK_USER	SHELL_CHECK	/* no shell => no job */

/*
 * Timeout parameters for RPC calls.
 */
#define CUSTOMS_RETRY	2		/* Seconds ... */
#define CUSTOMS_URETRY	500000		/* + microseconds to timeout */
#define CUSTOMS_NRETRY	2		/* Number of retries before failure */
#define CUSTOMS_TIMEOUT	10		/* Total time allowed for job import */
/*#define DEBUG_TIMEOUT */		/* Log special info about import
					   timeouts */

/*
 * Sometimes CUSTOMS_IMPORT calls (via TCP) exceed the caller's CUSTOMS_TIMEOUT
 * while actually succeeding on the server side.  This means a remote
 * process is started without the caller knowing it.  This then leads to
 * unexpected exit codes being returned and scheduling of duplicate jobs.
 * There is no good way to completely prevent this unless you have your
 * clocks reasonably synchronized across machines (e.g., to a second
 * or so).  In that case the server can doublecheck that the import call
 * succeeded within the expected time, and abort otherwise.
 * For safety, the server checks that the import is within CUSTOMS_TIMEOUT/2 of
 * call initiation.
 */
#define DOUBLECHECK_TIMEOUT

/*
 * Another checking timeout... This one determines how often export and
 * pmake should check on the existence on a remote job they have spawned
 * by having a signal 0 delivered.  This prevents remote disasters (machine
 * crash, customs daemon killed) from going unnoticed.  Just leave this
 * undefined if you think it is not needed.  There is a drawback to checking
 * this very often, since it increases the chances of a CUSTOMS_KILL RPC
 * getting lost due to extraneous factors, which would make pmake/export
 * give up on a remote job while it is still running.  Because of this,
 * we also give CUSTOMS_KILL some more retries than the other RPCs.
 */
#define REMOTE_CHECK_INTERVAL	(10*60)	/* seconds */

#define CUSTOMS_KILL_NRETRY	(2*CUSTOMS_NRETRY)
					/* Retries for CUSTOMS_KILL RPCs
					   (should never time out unless
					   remote host is really down) */

/*
 * For testing under SaberC/CodeCenter.
 */
#ifdef SABER
#undef USE_RESERVED_PORTS
#define CUSTOMS_SERVICE_NAME "customs-test"
#endif

/*
 * Default ports if yellow pages f***s us over.
 * If we use reserved ports for critical RPCs, we might as well have customs
 * use reserved ports too, thus preventing users from running unauthorized
 * programs acting as customs agents.
 */
#ifdef USE_RESERVED_PORTS
#define DEF_CUSTOMS_UDP_PORT	1001	/* Should match customs/udp service */
#define DEF_CUSTOMS_TCP_PORT	1001	/* Should match customs/tcp service */
#else
#define DEF_CUSTOMS_UDP_PORT	8231	/* Should match customs/udp service */
#define DEF_CUSTOMS_TCP_PORT	8231	/* Should match customs/tcp service */
#endif

/*
 * Change the process title of child daemons to include the ID of the jobs
 * they are monitoring.  This makes it easier to use ps(1) to find out
 * what's going on.
 */
#define SETPROCTITLE

/*
 * On some systems UDP broadcasts to the local network number seem to exclude
 * the local host itself.  (Observed on HP-UX 8.x Snakes with lan interface
 * that didn't use all 1's in the host part of the broadcast address.)
 * Customs will work just fine if this is the case, because none of the vital
 * functions rely on self-broadcasts.  However, cctrl -all will not report the
 * local machine. Define NO_LOOPBACK_BROADCAST to enable a hack that deals
 * with this problem.
 */
#undef NO_LOOPBACK_BROADCAST

/*
 * This only needs to be increased if lots of machines (typically with
 * lots of host attributes) are on the customs network.  Reginfo will say
 * "Arguments/results too big" in this case.
 */
#define MAX_DATA_SIZE	    	(16*1024)	/* Largest RPC arg packet */

/*
 * Sometimes the Customs daemons fails to create its server sockets because
 * the port is temporarily in use by another process. Define this will
 * let it retry the socket creation after a waiting period.
 */
#define WAIT_FOR_FREE_ADDRESS	60 /* seconds */
