/*
 * sprite.h --
 *
 * Common constants and type declarations for Sprite.
 *
 * Copyright 1985 Regents of the University of California
 * All rights reserved.
 *
 *
 * $Id: sprite.h,v 1.10 1998/04/04 15:36:57 stolcke Exp $ SPRITE (Berkeley)
 */

#ifndef _SPRITE
#define _SPRITE

#if defined(__STDC__) || defined(SABER)
#   define _ANSI_ARGS_(x)       x
#   define CONST const
#else
#   define _ANSI_ARGS_(x)       ()
#   define CONST
#endif

/*
 * A boolean type is defined as an integer, not an enum. This allows a
 * boolean argument to be an expression that isn't strictly 0 or 1 valued.
 */

typedef int Boolean;
#ifndef TRUE
#define TRUE	1
#endif /* TRUE */
#ifndef FALSE
#define FALSE	0
#endif /* FALSE */

/*
 * Functions that must return a status can return a ReturnStatus to
 * indicate success or type of failure.
 */

typedef int  ReturnStatus;

/*
 * The following statuses overlap with the first 2 generic statuses 
 * defined in status.h:
 *
 * SUCCESS			There was no error.
 * FAILURE			There was a general error.
 */

#define	SUCCESS			0x00000000
#define	FAILURE			0x00000001


/*
 * A nil pointer must be something that will cause an exception if 
 * referenced.  There are two nils: the kernels nil and the nil used
 * by user processes.
 */

#define NIL 		(-1)
#define USER_NIL 	0
#ifndef NULL
#define NULL	 	0
#endif /* NULL */

/*
 * An address is just a pointer in C.  It is defined as a character pointer
 * so that address arithmetic will work properly, a byte at a time.
 */

typedef char *Address;

/*
 * ClientData is an uninterpreted word.  It is defined as an int so that
 * kdbx will not interpret client data as a string.  Unlike an "Address",
 * client data will generally not be used in arithmetic.
 */

typedef int *ClientData;

#ifdef notdef
#include "status.h"
#endif

/*
 * Generic functions defined in the compatibility library.
 */
#if defined(linux)
#include <string.h>
#include <stdlib.h>
#else
extern void	setenv();
extern char	*strerror();
extern char	*strsignal();
extern double	strtod();
extern long int	strtol();
extern unsigned long int strtoul();
extern void	*memmove();
#endif

/*
 * Things from the C library that are not always properly declared in headers.
 */
#if defined(sun) || defined(ultrix) || defined(hpux) || defined(sgi)
#include <malloc.h>
#else
#if defined(__STDC__) && !defined(__STRICT_BSD__)
extern void	*malloc();
extern void	*calloc();
extern void	*realloc();
extern void	free();
#else
extern char	*malloc();
extern char	*calloc();
extern char	*realloc();
extern int	free();
#endif
#endif

#ifndef atof
extern double	atof();
#endif

/*
 * Error-checking memory allocators.
 */
extern char	*emalloc();
extern char	*erealloc();
extern void	enomem();

#endif /* _SPRITE */
