/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __UTIL_MIME_H__
#define __UTIL_MIME_H__

#include <glib.h>
#include <gmime/gmime.h>

GMimeMessage*    pan_g_mime_parser_construct_message              (const char ** messages,
                                                                   int           message_qty);

GMimeMessage*    pan_g_mime_parser_construct_message_from_file    (FILE       ** messages,
                                                                   int           message_qty);

gboolean         pan_header_is_8bit_encoded                       (const gchar * header);

/**
***  YEnc Functions
**/

typedef struct
{
	char * filename;

	int line_len;
	int attach_size;
	int part;
	guint offset_begin;
	guint offset_end;
	guint crc;
	guint pcrc;
	size_t size;

	GMimeFilter * filter;
}
YencInfo;


/**
***  UU Functions
**/

int              uu_parse_begin_line                              (const gchar       * b,
                                                                   const gchar      ** file,
                                                                   gint              * mode);

gboolean         uu_is_beginning_line                             (const gchar       * line);

gboolean         uu_is_ending_line                                (const gchar       * line);

void             uu_get_file_info                                 (const gchar       * begin,
                                                                   gchar            ** setme_filename,
                                                                   gulong            * setme_mode);

int              uu_get_char_len                                  (gint                octet_len);

gboolean         is_uu_line                                       (const gchar       * line,
                                                                   gint                line_len);

#endif
