#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <glib.h>

#include <pan/base/article.h>
#include <pan/base/base-prefs.h>

#include <pan/filters/filter.h>
#include <pan/filters/filter-aggregate.h>
#include <pan/filters/filter-binary.h>
#include <pan/filters/filter-cached.h>
#include <pan/filters/filter-crosspost.h>
#include <pan/filters/filter-mine.h>
#include <pan/filters/filter-date.h>
#include <pan/filters/filter-linecount.h>
#include <pan/filters/filter-new.h>
#include <pan/filters/filter-phrase.h>
#include <pan/filters/filter-read.h>
#include <pan/filters/filter-saved.h>
#include <pan/filters/filter-score.h>
#include <pan/filters/filter-thread.h>

static void
init_pan (void)
{
	gchar * base;
	gchar * data_dir;

	base = getenv ("srcdir");
	base = g_strdup_printf ("%s/", base!=NULL ? base : getenv("PWD"));
	data_dir = g_strdup_printf ("%s/data/", base);
	base_prefs_init (data_dir, g_get_tmp_dir(), ">", 100, FALSE, FALSE);

	g_free (data_dir);
}

extern int server_saving_enabled;

static int
test_phrases (void)
{
	Article * article;
	GPtrArray * articles;
	Server * server;
	Group * group;
	static gulong number = 0;
	gint test = 0;
	Filter * f = filter_phrase_new ();

	filter_phrase_set (FILTER_PHRASE(f), FILTER_PHRASE_SUBJECT, "fillyjonk", FALSE);

	server = server_new ();
	server->name = "dummy_server";
	group = group_new (server, "dummy_group");
	group_set_is_folder (group, TRUE);
	articles = g_ptr_array_new ();

	article = article_new (group);
	article->number = ++number;
	article_init_header (article, HEADER_SUBJECT, "Can we find fillyjonk when it's by itself?", 0);
	article_init_header (article, HEADER_MESSAGE_ID, "<asdf@foobar.com>", 0);
	if (!filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	article_init_header (article, HEADER_SUBJECT, "Can we findfillyjonkwhen it's inside a string?", 0);
	if (!filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	article_init_header (article, HEADER_SUBJECT, "WTF is a fillyjonk?", 0);
	if (!filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	article_init_header (article, HEADER_SUBJECT, "fillyjon", 0);
	if (filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	filter_phrase_set (FILTER_PHRASE(f), FILTER_PHRASE_SUBJECT, "fillyjonk*", FALSE);

	article_init_header (article, HEADER_SUBJECT, "fillyjonk at the front", 0);
	if (!filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	article_init_header (article, HEADER_SUBJECT, "Fillyjonk at the front, in Caps", 0);
	if (!filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	article_init_header (article, HEADER_SUBJECT, "at the end comes the fillyjonk", 0);
	if (filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	article_init_header (article, HEADER_SUBJECT, "the fillyjonk comes before the mymble", 0);
	if (filter_test_article (f, article)) return 1;
	g_message ("PASS: filter-phrase %d", ++test);

	return 0;
}

int
main (void)
{
	gint val;
	g_thread_init (NULL);
	init_pan ();
	server_saving_enabled = FALSE;

	val = test_phrases ();
	if (val)
		return val;

	g_message ("All filter tests passed");
	return 0;
}
