/*****************************************************************

Copyright (c) 1996-2001 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qtooltip.h>
#include <qfile.h>

#include <kconfig.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <ksimpleconfig.h>

#include "service_mnu.h"

#include "servicemenubutton.h"
#include "servicemenubutton.moc"

ServiceMenuButton::ServiceMenuButton( const QString& label, const QString& relPath, QWidget* parent )
  : PanelPopupButton( parent, "ServiceMenuButton" )
  , topMenu( 0 )
{
    initialize( label, relPath );
}

ServiceMenuButton::ServiceMenuButton( const KConfigGroup& config, QWidget* parent )
  : PanelPopupButton( parent, "ServiceMenuButton" )
  , topMenu( 0 )
{
    initialize( config.readEntry("Label"), config.readEntry("RelPath") );
}

void ServiceMenuButton::initialize( const QString& label, const QString& relPath )
{
    topMenu = new PanelServiceMenu(label, relPath);
    setPopup(topMenu);

    QToolTip::add(this, i18n("Browse: %1").arg(label));
    setTitle(label);

    QString dirFile(locate("apps", topMenu->relPath()+"/.directory"));
    QString iconFile;
    if(QFile::exists(dirFile)){
        KSimpleConfig config(dirFile);
        config.setDesktopGroup();
        iconFile = config.readEntry("Icon", "folder");
    }
    if(iconFile.isEmpty())
        iconFile = "folder";

    setIcon(iconFile);
}

void ServiceMenuButton::saveConfig( KConfigGroup& config ) const
{
    config.writeEntry("Label", topMenu->path());
    config.writeEntry("RelPath", topMenu->relPath());
}

void ServiceMenuButton::initPopup()
{
    topMenu->initialize();
}
