/***************************************************************************
                            kde_AlsaOut.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_ALSAOUT
#define KDE_ALSAOUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**


 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to a MIDI devices using ALSA.
*/

/** 
 Constructor. After constructing a MidiOut device, you must open it
 (using @ref #openDev() ). Additionally you may want to initialize it
 (with @ref #initDev() ),
   
*/
kde_AlsaOut * kde_new_AlsaOut(int d, int client, int port, char* cname, char* pname);

/** 
 Destructor. It doesn't matter if you close the device (@ref closeDev() )
 before you destruct the object because in other case, it will be closed
 here.
   
*/
void kde_del_AlsaOut( kde_AlsaOut* p );

/** 
 Opens the device. This is generally called from @ref DeviceManager , so you
 shouldn't call this yourself (except if you created the MidiOut object
 yourself.

*/
void kde_AlsaOut_openDev(kde_AlsaOut* instPointer,int sqfd);

/** 
 Closes the device. It basically tells the device (the file descriptor)
 is going to be closed.

*/
void kde_AlsaOut_closeDev(kde_AlsaOut* instPointer);

/** 
 Initializes the device sending generic standard midi events and controllers,
 such as changing the patches of each channel to an Acoustic Piano (000),
 setting the volume to a normal value, etc.
   
*/
void kde_AlsaOut_initDev(kde_AlsaOut* instPointer);

/** 

 which are defined in midispec.h

*/
int kde_AlsaOut_deviceType(kde_AlsaOut* instPointer);

/** 
 Returns the name and type of this MIDI device.

*/
char* kde_AlsaOut_deviceName(kde_AlsaOut* instPointer);

/** 

   
*/
int kde_AlsaOut_rate(kde_AlsaOut* instPointer);

/** 
 See @ref DeviceManager::noteOn()
   
*/
void kde_AlsaOut_noteOn(kde_AlsaOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref DeviceManager::noteOff()
   
*/
void kde_AlsaOut_noteOff(kde_AlsaOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref DeviceManager::keyPressure()
   
*/
void kde_AlsaOut_keyPressure(kde_AlsaOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref DeviceManager::chnPatchChange()
   
*/
void kde_AlsaOut_chnPatchChange(kde_AlsaOut* instPointer,unsigned char chn, unsigned char patch);

/** 
 See @ref DeviceManager::chnPressure()
   
*/
void kde_AlsaOut_chnPressure(kde_AlsaOut* instPointer,unsigned char chn, unsigned char vel);

/** 
 See @ref DeviceManager::chnPitchBender()
   
*/
void kde_AlsaOut_chnPitchBender(kde_AlsaOut* instPointer,unsigned char chn, unsigned char lsb, unsigned char msb);

/** 
 See @ref DeviceManager::chnController()
   
*/
void kde_AlsaOut_chnController(kde_AlsaOut* instPointer,unsigned char chn, unsigned char ctl, unsigned char v);

/** 
 See @ref DeviceManager::sysex()
   
*/
void kde_AlsaOut_sysex(kde_AlsaOut* instPointer,unsigned char* data, unsigned long size);

/** 
 Mutes all notes being played on a given channel.
   
*/
void kde_AlsaOut_channelSilence(kde_AlsaOut* instPointer,unsigned char chn);

/** 
 Mute or "unmute" a given channel .

*/
void kde_AlsaOut_channelMute(kde_AlsaOut* instPointer,unsigned char chn, int a);

/** 
 Change all channel volume events multiplying it by this percentage correction
 Instead of forcing a channel to a fixed volume, this method allows to
 music to fade out even when it was being played softly.

*/
void kde_AlsaOut_setVolumePercentage(kde_AlsaOut* instPointer,int volper);

/** 
 Returns true if everything's ok and false if there has been any problem
   
*/
int kde_AlsaOut_ok(kde_AlsaOut* instPointer);
void kde_AlsaOut_wait(kde_AlsaOut* instPointer,double ticks);
void kde_AlsaOut_tmrSetTempo(kde_AlsaOut* instPointer,int v);
void kde_AlsaOut_tmrStart(kde_AlsaOut* instPointer,int tpcn);
void kde_AlsaOut_tmrStart1(kde_AlsaOut* instPointer);
void kde_AlsaOut_tmrStop(kde_AlsaOut* instPointer);
void kde_AlsaOut_tmrContinue(kde_AlsaOut* instPointer);

/** 

 If i==1 syncronizes by cleaning the buffer instead of sending it (in fact,
 this is what syncronizing really means :-) )
   
*/
void kde_AlsaOut_sync(kde_AlsaOut* instPointer,int i);
void kde_AlsaOut_seqbuf_dump(kde_AlsaOut* instPointer);
void kde_AlsaOut_seqbuf_clean(kde_AlsaOut* instPointer);
//void kde_AlsaOut_eventInit(kde_AlsaOut* instPointer,int* ev);
//void kde_AlsaOut_eventSend(kde_AlsaOut* instPointer,int* ep);
//void kde_AlsaOut_timerEventSend(kde_AlsaOut* instPointer,int type);

#endif
