/***************************************************************************
                            kde_KRegExp.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KREGEXP
#define KDE_KREGEXP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Regular expression (regexp) matching with back-references. 

 This was implemented
 because @ref QRegExp does not support back-references.

 Back-references are parts of a regexp grouped with parentheses. If a
 string matches the regexp, you can access the text that matched each
 group with the @ref group method. This is similar to regular expressions in Perl.

 Example:
 <pre>
  KRegExp ex( "([A-Za-z]+) (.+)" );
  ex.match( "42 Torben Weis" );
  kdDebug() << ex.group(0) << endl;
  kdDebug() << ex.group(1) << endl;
  kdDebug() << ex.group(2) << endl;
 </pre>
 Output:
 <pre>
  Torben Weis
  Torben
  Weis
 </pre>

 Please notice that KRegExp does @em not support unicode.

 @author Torben Weis <weis@kde.org>

 @version $Id: kde_KRegExp.h,v 1.3 2002/02/21 00:43:13 rdale Exp $
 
 @short 
 Regular expression (regexp) matching with back-references.
*/

/** 
 Creates a KRegExp object without a default pattern.
   
*/
kde_KRegExp * kde_new_KRegExp();

/** 
 Creates a KRegExp object.

*/
kde_KRegExp * kde_new_KRegExp1(char* _pattern, char* _mode);
void kde_del_KRegExp( kde_KRegExp* p );

/** 
 Prepare a regular expression for subsequent matches.

*/
int kde_KRegExp_compile(kde_KRegExp* instPointer,char* _pattern, char* _mode);

/** 
 Match a string to the last supplied regexp.

*/
int kde_KRegExp_match(kde_KRegExp* instPointer,char* _string);

/** 

*/
char* kde_KRegExp_group(kde_KRegExp* instPointer,int _grp);

/** 

*/
int kde_KRegExp_groupStart(kde_KRegExp* instPointer,int _grp);

/** 

*/
int kde_KRegExp_groupEnd(kde_KRegExp* instPointer,int _grp);

#endif
