/***************************************************************************
                            DCOPRef.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.

 @author Torben Weis <weis@kde.org>
 
 @short 
 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.
*/
public class  DCOPRef implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected DCOPRef(Class dummy){}

	private native void newDCOPRef();

/** 
 Creates a null reference.
     
*/
	public DCOPRef() {
		newDCOPRef();
	}
	private native void newDCOPRef( DCOPRef ref);

/** 
 Copy constructor.
     
*/
	public DCOPRef( DCOPRef ref) {
		newDCOPRef( ref);
	}
	private native void newDCOPRef( String app, String obj);

/** 
 Creates a reference to a certain object in a
 certain application.

*/
	public DCOPRef( String app, String obj) {
		newDCOPRef( app, obj);
	}
	private native void newDCOPRef( DCOPObjectInterface object);

/** 
 Creates a reference to a certain object in a
 certain application.

*/
	public DCOPRef( DCOPObjectInterface object) {
		newDCOPRef( object);
	}
	private native void newDCOPRef( String app, String obj, String type);

/** 
 Creates a reference to a certain object in a
 certain application.

*/
	public DCOPRef( String app, String obj, String type) {
		newDCOPRef( app, obj, type);
	}

/** 
 Tests wether it is a null reference.
     
*/
	public native boolean isNull();

/** 
 Name of the application in which the object resides.
     
*/
	public native String app();

/** 
 Object ID of the referenced object.
     
*/
	public native String object();

/** 
 type of the referenced object. May be null (i.e. unknown).
     
*/
	public native String type();

/** 
 Changes the referenced object. Resets the type to unknown (null).
     
*/
	public native void setRef( String app, String obj);

/** 
 Changes the referenced object
     
*/
	public native void setRef( String app, String obj, String type);

/** 
 Makes this a null reference.
     
*/
	public native void clear();
}
