/***************************************************************************
                            KActionCollection.java -  description
                             -------------------
    begin                : Fri Mar 15 15:14:30 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar 15 15:14:30 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A managed set of KAction objects.
 
 See {@link KActionCollectionSignals} for signals emitted by KActionCollection.

 See {@link KActionCollectionEventHandling} for event handlers to override in subclasses of KActionCollection.

 @short 
 A managed set of KAction objects.
*/
public class KActionCollection extends QObject  {
	protected KActionCollection(Class dummy){super((Class) null);}

	private native void newKActionCollection( QWidget parent, String name, KInstanceInterface instance);
	public KActionCollection( QWidget parent, String name, KInstanceInterface instance) {
		super((Class) null);
		newKActionCollection( parent, name, instance);
	}
	private native void newKActionCollection( QWidget parent);
	public KActionCollection( QWidget parent) {
		super((Class) null);
		newKActionCollection( parent);
	}
	private native void newKActionCollection( QWidget watch, QObject parent, String name, KInstanceInterface instance);

/** 
 Use this constructor if you want the collection's actions to restrict
 their accelerator keys to <code>watch</code> rather than the <code>parent.</code>  If
 you don't require shortcuts, you can pass a null to the <code>watch</code> parameter.
   
*/
	public KActionCollection( QWidget watch, QObject parent, String name, KInstanceInterface instance) {
		super((Class) null);
		newKActionCollection( watch, parent, name, instance);
	}
	private native void newKActionCollection( QWidget watch, QObject parent);
	public KActionCollection( QWidget watch, QObject parent) {
		super((Class) null);
		newKActionCollection( watch, parent);
	}
	private native void newKActionCollection( KActionCollection copy);
	public KActionCollection( KActionCollection copy) {
		super((Class) null);
		newKActionCollection( copy);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 This sets the widget to which the keyboard shortcuts should be attached.
 You only need to call this if a null pointer was passed in the constructor.
   
*/
	public native void setWidget( QWidget widget);

/** 
 Return the collection's KAccel object
   
*/
	public native KAccel accel();
//	public native KAccel accel();
	public native int count();
	public native boolean isEmpty();
	public native KAction action( int index);
	public native KAction action( String name, String classname);
	public native KAction action( String name);
	public native ArrayList groups();
//	public native KActionPtrList actions( String group);
//	public native KActionPtrList actions();

/** 
 Used for reading shortcut configuration from a non-XML rc file.
   
*/
	public native boolean readShortcutSettings( String sConfigGroup, KConfigBase pConfig);
	public native boolean readShortcutSettings();

/** 
 Used for writing shortcut configuration to a non-XML rc file.
   
*/
	public native boolean writeShortcutSettings( String sConfigGroup, KConfigBase pConfig);
	public native boolean writeShortcutSettings();
	public native void setInstance( KInstanceInterface instance);
	public native KInstanceInterface instance();

/** 
 Use this to tell the KActionCollection what rc file its configuration
 is stored in.
   
*/
	public native void setXMLFile( String arg1);
	public native String xmlFile();
	public native void setHighlightingEnabled( boolean enable);
	public native boolean highlightingEnabled();
	public native void connectHighlight( QWidget container, KAction action);
	public native void disconnectHighlight( QWidget container, KAction action);
	private native void newKActionCollection( QObject parent, String name, KInstanceInterface instance);
	public KActionCollection( QObject parent, String name, KInstanceInterface instance) {
		super((Class) null);
		newKActionCollection( parent, name, instance);
	}
	private native void newKActionCollection( QObject parent);
	public KActionCollection( QObject parent) {
		super((Class) null);
		newKActionCollection( parent);
	}
	public native void insert( KAction arg1);
	public native void remove( KAction arg1);
	public native KAction take( KAction arg1);
//	public native KActionCollection add( KActionCollection arg1);

/** 
 Clears the entire actionCollection, deleting all actions.

*/
	public native void clear();
	protected native void virtual_hook( int identifier, int data);
}
