/***************************************************************************
                            KArchive.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 @author David Faure <faure@kde.org>
 
 @short generic class for reading/writing archives.
*/
public class  KArchive implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KArchive(Class dummy){}


/** 
 Opens the archive for reading or writing.

*/
	public native boolean open( int mode);

/** 
 Closes the archive.
 Inherited classes might want to reimplement openArchive instead.

*/
	public native void close();

/** 

*/
	public native boolean isOpened();

/** 

*/
	public native int mode();

/** 
 The underlying device.
     
*/
	public native QIODeviceInterface device();

/** 
 If an archive is opened for reading, then the contents
 of the archive can be accessed via this function.
     
*/
	public native KArchiveDirectory directory();

/** 
 If an archive is opened for writing then you can add new directories
 using this function. KArchive won't write one directory twice.
     
*/
	public native boolean writeDir( String name, String user, String group);

/** 
 If an archive is opened for writing then you can add a new file
 using this function. If the file name is for example "mydir/test1" then
 the directory "mydir" is automatically appended first if that did not
 happen yet.
     
*/
	public native boolean writeFile( String name, String user, String group, int size, String data);

/** 
 Here's another way of writing a file into an archive:
 Call {@link prepareWriting}, then call write as many times as wanted,
 then call {@link #doneWriting}
 You need to know the size before hand, it is needed in the header!
     
*/
	public native boolean prepareWriting( String name, String user, String group, int size);

/** 
 Call {@link doneWriting} after writing the data.

*/
	public native boolean doneWriting( int size);
}
