/***************************************************************************
                            KCharSelect.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A Widget which allows the user to select a character of a
 specified font in a table

 You can specify the font whoes characters should be displayed via
 {@link #setFont}. Using {@link #enableFontCombo} you can allow the
 user to choose the font from a combob-box. As only 256 characters
 are displayed at once in the table, using the spinbox on the top
 the user can choose starting from which chracater the table
 displayes them. This spinbox also can be enabled or disabled using
 {@link #enableTableSpinBox}.

 KCharSelect supports keyboard and mouse navigation. Click+Move
 selects always the character below the mouse cursor. Using the
 arrow keys the focus mark is moved around and with pressing RETURN
 or SPACE the cell which contains the focus mark gets selected.

 To get the current selected character, use the {@link #chr}
 method. You can set the character which should be displayed with
 {@link #setChar} and the table number which should be displayed with
 {@link #setTableNum}.

 See {@link KCharSelectSignals} for signals emitted by KCharSelect.

 See {@link KCharSelectEventHandling} for event handlers to override in subclasses of KCharSelect.

 @author Reginald Stadlbauer <reggie@kde.org>
 
 @version $Id: KCharSelect.java,v 1.5 2002/01/31 04:48:55 rdale Exp $

 @short Character-Selection Widget.
*/
public class KCharSelect extends QVBox  {
	protected KCharSelect(Class dummy){super((Class) null);}

	private native void newKCharSelect( QWidget parent, String name, String font, char chr, int tableNum);

/** 
 Constructor. <code>font</code> specifies which font should be displayed, <code>chr</code> which character should be selected and <code>tableNum</code> specifies
 the number of the table which should be displayed.
     
*/
	public KCharSelect( QWidget parent, String name, String font, char chr, int tableNum) {
		super((Class) null);
		newKCharSelect( parent, name, font, chr, tableNum);
	}
	private native void newKCharSelect( QWidget parent, String name);
	public KCharSelect( QWidget parent, String name) {
		super((Class) null);
		newKCharSelect( parent, name);
	}

/** 
 Reimplemented.
     
*/
	public native QSize sizeHint();

/** 
 Sets the font which is displayed to <code>font</code>
     
*/
	public native void setFont( String font);

/** 
 Sets the currently selected character to <code>chr.</code>
     
*/
	public native void setChar( char chr);

/** 
 Sets the currently displayed table to <code>tableNum.</code>
     
*/
	public native void setTableNum( int tableNum);

/** 
 Returns the currently selected character.
     
*/
	public native char chr();

/** 
 Returns the currently displayed font.
     
*/
	public native QFont font();

/** 
 Returns the currently displayed table
     
*/
	public native int tableNum();

/** 
 If <code>e</code> is set to TRUE, the combobox which allows the user to
 select the font which should be displayed is enabled, else
 disabled.
     
*/
	public native void enableFontCombo( boolean e);

/** 

 If <code>e</code> is set to TRUE, the spinbox which allows the user to
 specify which characters of the font should be displayed, is
 enabled, else disabled.
     
*/
	public native void enableTableSpinBox( boolean e);

/** 
 Returns wether the font combobox on the top is enabled or
 disabled.

*/
	public native boolean isFontComboEnabled();

/** 
 Returns wether the table spinbox on the top is enabled or
 disabled.

*/
	public native boolean isTableSpinBoxEnabled();
	protected native void fillFontCombo();
	protected native void fontSelected( String _font);
	protected native void tableChanged( int _value);
	protected native void charHighlighted( char c);
	protected native void charHighlighted();
	protected native void charActivated( char c);
	protected native void charActivated();
	protected native void charFocusItemChanged();
	protected native void charFocusItemChanged( char c);
	protected native void charTableUp();
	protected native void charTableDown();
	protected native void slotDoubleClicked();
//	protected static native void cleanupFontDatabase();
}
