/***************************************************************************
                            KContextMenuManager.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


KContextMenuManager manages configurable context popup menus.  Instead
of reimplementing {@link QWidget#mousePressEvent} or
{@link QWidget#mouseReleaseEvent} and/or {@link QWidget#keyPressEvent}, simply
create the popup menu and insert it into the context menu manager with
the static function {@link #insert}.

Example:
<pre>
   #include <kcmenumngr.h>
   ...
   KContextMenuManager.insert( myWidget, myPopupMenu );
</pre>

Context menus are invoked with either a special shortcut key (usually
the menu key) or the right mouse button.

Menus are configurable in the [ContextMenus] group of the application's
configuration file, usually in kdeglobals:
<pre>
    [ContextMenus]
    ShowOnPress=true|false
</pre>

<code>ShowOnPress</code> defines whether the menu shall be shown on mouse
press or on mouse release.

The shortcut key to invoke the context menu is defined in the standard
[Keys] section of the application configuration:
<pre>
   [Keys]
   ...
   PopupContextMenu=Menu
   ...
</pre>
The key can be configured with the standard keys module in the KDE control center.

If the popup menu is invoked with the keyboard shortcut, it's shown at
the position of the micro focus hint of the widget ( {@link QWidget#microFocusHint} ).

 @author Matthias Ettrich <ettrich@kde.org>

 @version $Id: KContextMenuManager.java,v 1.5 2002/01/31 04:48:56 rdale Exp $

 @short Convenience class to mangage context menus.
*/
public class KContextMenuManager extends QObject  {
	protected KContextMenuManager(Class dummy){super((Class) null);}


/** 
       Makes <code>popup</code> a context popup menu for widget <code>widget.</code>

       Ownership of the popup menu is not transferred to the context
       menu manager.
    
*/
	public static native void insert( QWidget widget, QPopupMenu popup);

/** 
 Use this method to get information about when a popup menu
 should be activated. This can be useful if the popup menu is
 to be activated from a listview.

*/
	public static native boolean showOnButtonPress();
}
