/***************************************************************************
                            KProtocolInfo.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Information about I/O (Internet, etc.) protocols supported by KDE.

 This class is useful if you want to know which protocols
 KDE supports. In addition you can find out lots of information
 about a certain protocol. KProtocolInfo scans the .protocol
 files of all installed kioslaves to get this information.

 .protocol files are installed in the "services" resource.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Information about I/O (Internet, etc.
*/
public class KProtocolInfo extends KSycocaEntry  {
	protected KProtocolInfo(Class dummy){super((Class) null);}

	private native void newKProtocolInfo( String path);

/** 
 Read a protocol description file
   
*/
	public KProtocolInfo( String path) {
		super((Class) null);
		newKProtocolInfo( path);
	}

/** 

*/
	public native boolean isValid();

/** 

 This corresponds to the "protocol=" field in the protocol description file.

*/
	public native String name();
	private native void newKProtocolInfo( QDataStream _str, int offset);

/** 

   
*/
	public KProtocolInfo( QDataStream _str, int offset) {
		super((Class) null);
		newKProtocolInfo( _str, offset);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

 Load the protocol info from a stream.
   
*/
	public native void load( QDataStream arg1);

/** 

 Save the protocol info to a stream.
   
*/
	public native void save( QDataStream arg1);

/** 

*/
	public static native ArrayList protocols();

/** 

*/
	public static native boolean isKnownProtocol( KURL url);

/** 

 This corresponds to the "exec=" field in the protocol description file.

   
*/
	public static native String exec( String protocol);

/**  

 This corresponds to the "input=" field in the protocol description file.
 Valid values for this field are "filesystem", "stream" or "none" (default).

   
*/
	public static native int inputType( KURL url);

/**  

 This corresponds to the "output=" field in the protocol description file.
 Valid values for this field are "filesystem", "stream" or "none" (default).

   
*/
	public static native int outputType( KURL url);

/** 

 This corresponds to the "listing=" field in the protocol description file.
 The supported fields should be seperated with ',' in the protocol description file.
   
*/
	public static native ArrayList listing( KURL url);

/** 

 The "source=" field in the protocol description file determines
 whether a protocol is a source protocol or a filter protocol.
 Valid values for this field are "true" (default) for source protocol or 
 "false" for filter protocol.
   
*/
	public static native boolean isSourceProtocol( KURL url);

/** 

 This corresponds to the "helper=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean isHelperProtocol( KURL url);

/** 

 The "source=" field in the protocol description file determines
 whether a protocol is a source protocol or a filter protocol.
 Valid values for this field are "true" (default) for source protocol or 
 "false" for filter protocol.
   
*/
	public static native boolean isFilterProtocol( KURL url);

/** 

 Whether a protocol supports listing is determined by the "listing=" 
 field in the protocol description file.
 If the protocol support listing it should list the fields it provides in
 this field. If the protocol does not support listing this field should
 remain empty (default.)

*/
	public static native boolean supportsListing( KURL url);

/** 

 This corresponds to the "reading=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean supportsReading( KURL url);

/** 

 This corresponds to the "writing=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean supportsWriting( KURL url);

/** 

 This corresponds to the "makedir=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean supportsMakeDir( KURL url);

/** 

 This corresponds to the "deleting=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean supportsDeleting( KURL url);

/** 

 This corresponds to the "linking=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean supportsLinking( KURL url);

/** 

 This corresponds to the "moving=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean supportsMoving( KURL url);

/** 

 This corresponds to the "copyFromFile=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean canCopyFromFile( KURL url);

/** 

 This corresponds to the "copyToFile=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
	public static native boolean canCopyToFile( KURL url);

/** 

 This corresponds to the "defaultMimetype=" field in the protocol description file.
   
*/
	public static native String defaultMimetype( KURL url);

/** 

 This corresponds to the "Icon=" field in the protocol description file.
   
*/
	public static native String icon( String protocol);

/** 

 This corresponds to the "config=" field in the protocol description file.
 The default is the protocol name, see {@link #name}
   
*/
	public static native String config( String protocol);

/** 

 This corresponds to the "maxInstances=" field in the protocol description file.
 The default is 1.
   
*/
	public static native int maxSlaves( String protocol);

/** 

 This corresponds to the "determineMimetypeFromExtension=" field in the protocol description file.
 Valid values for this field are "true" (default) or "false".
   
*/
	public static native boolean determineMimetypeFromExtension( String protocol);
	public static native int inputType( String protocol);
	public static native int outputType( String protocol);

/** 

*/
	public static native ArrayList listing( String protocol);
	public static native boolean isSourceProtocol( String protocol);
	public static native boolean isHelperProtocol( String protocol);
	public static native boolean isFilterProtocol( String protocol);
	public static native boolean isKnownProtocol( String protocol);
	public static native boolean supportsListing( String protocol);
	public static native boolean supportsReading( String protocol);
	public static native boolean supportsWriting( String protocol);
	public static native boolean supportsMakeDir( String protocol);
	public static native boolean supportsDeleting( String protocol);
	public static native boolean supportsLinking( String protocol);
	public static native boolean supportsMoving( String protocol);
	public static native boolean canCopyFromFile( String protocol);
	public static native boolean canCopyToFile( String protocol);
	public static native String defaultMimetype( String protocol);
	public static final int T_STREAM = 0;
	public static final int T_FILESYSTEM = 1;
	public static final int T_NONE = 2;
	public static final int T_ERROR = 3;
}
