/***************************************************************************
                            KRuler.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A ruler widget.

 The vertical ruler looks similar to this:

<pre>
    meters                       inches

    ------   <--- end mark  --. ------
        --                            -
        --   <---little mark--.     --
        --                            -
        --                          ---
       ---   <---medium mark          -
        --                           --
        --        tiny mark---.      -
        --                         ----
        --                            -
      ----   <-----big mark          --
        --                            -
      |>--   <--ruler pointer-.   |>--

 </pre>

 There are tiny marks, little marks, medium marks, and big marks along the
  ruler.

 To receive mouse clicks or mouse moves,
 the class has to be overloaded.

 For performance reasons, the public methods don't call {@link QWidget#repaint}.
 (Slots do, see documentation below.)
 All the changed settings will be painted once after leaving
 to the main event loop.
 For performance painting the slot methods should be used,
 they do a fast {@link QWidget#repaint} call after changing the values.
 For setting multiple values like {@link #minValue}, {@link #maxValue}, {@link #offset} etc.
 using the public methods is recommended
 so the widget will be painted only once when entering the main event loop.

 See {@link KRulerSignals} for signals emitted by KRuler.

 See {@link KRulerEventHandling} for event handlers to override in subclasses of KRuler.

 @author Jrg Habenicht
 
 @short A ruler widget.

*/
public class KRuler extends QFrame  {
	protected KRuler(Class dummy){super((Class) null);}

	private native void newKRuler( QWidget parent, String name);

/** 
 Constructs a horizontal ruler.
   
*/
	public KRuler( QWidget parent, String name) {
		super((Class) null);
		newKRuler( parent, name);
	}
	private native void newKRuler();
	public KRuler() {
		super((Class) null);
		newKRuler();
	}
	private native void newKRuler( int orient, QWidget parent, String name, int f);

/** 
 Constructs a ruler with orientation <code>orient.</code>

 <code>parent</code>, <code>name</code> and <code>f</code> are passed to QFrame.
 The default look is a raised widget
 but may be changed with the inherited {@link QFrame} methods.

*/
	public KRuler( int orient, QWidget parent, String name, int f) {
		super((Class) null);
		newKRuler( orient, parent, name, f);
	}
	private native void newKRuler( int orient);
	public KRuler( int orient) {
		super((Class) null);
		newKRuler( orient);
	}
	private native void newKRuler( int orient, int widgetWidth, QWidget parent, String name, int f);

/** 
 Constructs a ruler with orientation <code>orient</code> and initial width <code>widgetWidth.</code>

 The width sets the fixed width of the widget. This is useful if you
 want to draw the ruler bigger or smaller than the default size.
 Note: The size of the marks doesn't change.
 <code>parent</code>, <code>name</code> and <code>f</code> are passed to {@link QFrame}.

   
*/
	public KRuler( int orient, int widgetWidth, QWidget parent, String name, int f) {
		super((Class) null);
		newKRuler( orient, widgetWidth, parent, name, f);
	}
	private native void newKRuler( int orient, int widgetWidth);
	public KRuler( int orient, int widgetWidth) {
		super((Class) null);
		newKRuler( orient, widgetWidth);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the minimal value of the ruler pointer (default is 0).

 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.

*/
	public native void setMinValue( int arg1);

/** 
 Returns the minimal value of the ruler pointer.

*/
	public native int minValue();

/** 
 Sets the maximum value of the ruler pointer (default is 100).

 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.
   
*/
	public native void setMaxValue( int arg1);

/** 
 Returns the maximal value of the ruler pointer.
   
*/
	public native int maxValue();

/** 
 Sets minimum and maximum values of the ruler pointer.

 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.
   
*/
	public native void setRange( int min, int max);

/** 
 Sets the value of the ruler pointer.

 The value is indicated by painting the ruler pointer at the
 corresponding position.
 This method calls {@link #update} so that the widget is painted after leaving
 to the main event loop.
   
*/
	public native void setValue( int arg1);
	public native int value();

/** 
 Sets the distance between tiny marks.

 This is mostly used in the English system (inches) with distance of 1. 
   
*/
	public native void setTinyMarkDistance( int arg1);

/** 
 Returns the distance between tiny marks.

*/
	public native int tinyMarkDistance();

/**  
 Sets the distance between little marks.

 The default value is 1 in the metric system and 2 in the English (inches) system.
   
*/
	public native void setLittleMarkDistance( int arg1);

/**  
 Returns the distance between little marks.
   
*/
	public native int littleMarkDistance();

/** 
 Sets the distance between medium marks.

 For English (inches) styles it defaults to twice the little mark distance.
 For metric styles it defaults to five times the little mark distance.

*/
	public native void setMediumMarkDistance( int arg1);
	public native int mediumMarkDistance();

/**  
 Sets distance between big marks.

 For English (inches) or metric styles it is twice the medium mark distance.

*/
	public native void setBigMarkDistance( int arg1);

/** 
 Returns the distance between big marks.

*/
	public native int bigMarkDistance();

/** 
 Shows/hides tiny marks.

*/
	public native void setShowTinyMarks( boolean arg1);
	public native boolean showTinyMarks();

/** 
 Shows/hides little marks.

*/
	public native void setShowLittleMarks( boolean arg1);
	public native boolean showLittleMarks();

/** 
 Shows/hides medium marks.

*/
	public native void setShowMediumMarks( boolean arg1);
	public native boolean showMediumMarks();

/** 
 Shows/hides big marks.

*/
	public native void setShowBigMarks( boolean arg1);
	public native boolean showBigMarks();

/** 
 Shows/hides end marks.

*/
	public native void setShowEndMarks( boolean arg1);
	public native boolean showEndMarks();

/** 
 Shows/hides the pointer.
   
*/
	public native void setShowPointer( boolean arg1);
	public native boolean showPointer();

/** 
 Sets the value that is shown per little mark.

 For metric systems this is 1 per mark.
 Note: If you set the value for little marks the values for 
 medium and big marks are updated according to the
 the values set in the setXXMarkDistance(int) methods.

*/
	public native void setValuePerLittleMark( int arg1);

/** 
 Sets the value that is shown per medium mark.

 For metric systems this is 5.
 Display of little marks is automatically disabled and
 big marks are updated according to 
 the values set in the {@link #setBigMarkDistance} method.

*/
	public native void setValuePerMediumMark( int arg1);

/** 
 Sets the value that is shown per big mark.

 For metric systems this is 1
 Display of little and medium marks marks is disabled.
   
*/
	public native void setValuePerBigMark( int arg1);

/** 
 Show/hide number values of the end marks.

 Default is <code>false.</code>

*/
	public native void setShowEndLabel( boolean arg1);
	public native boolean showEndLabel();

/** 
 Sets the label this is drawn at the beginning of the visible part
 of the ruler to <code>label</code>

*/
	public native void setEndLabel( String arg1);
	public native String endLabel();

/** 
 Sets up the necessary tasks for the provided styles.

 A convenience method.

*/
	public native void setRulerMetricStyle( int arg1);

/** 
 Sets the number of pixels between two base marks.

 Calling this method stretches or shrinks your ruler.

 For pixel display ({@link MetricStyle}) the value is 10.0 marks
 per pixel ;-)
 For English (inches) it is 9.0, and for centimetres ~2.835 . 3.0 .
 If you want to magnify your part of display, you have to
 adjust the mark distance <code>here.</code>
 Notice: The double type is only supported to give the possibility
         of having some double values.
         It should be used with care.  Using values below 10.0
         shows visible jumps of markpositions (e.g. 2.345).
         Using whole numbers is highly recommended.
 To use <code>int</code> values use setPixelPerMark((int)your_int_value);
 default: 1 mark per 10 pixels 
   
*/
	public native void setPixelPerMark( double rate);

/** 
 Returns the number of pixels between two base marks.

*/
	public native double pixelPerMark();

/** 
 Sets the length of the ruler, i.e. the difference between
 the begin mark and the end mark of the ruler.

 Same as (width() - offset())

 when the length is not locked, it gets adjusted with the
 length of the widget.
   
*/
	public native void setLength( int arg1);
	public native int length();

/** 
 Locks the length of the ruler, i.e. the difference between
 the two end marks doesn't change when the widget is resized.

*/
	public native void setLengthFixed( boolean fix);
	public native boolean lengthFixed();

/** 
 Sets the number of pixels by which the ruler may slide up or left.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
	public native void slideUp( int count);
	public native void slideUp();

/** 
 Sets the number of pixels by which the ruler may slide down or right.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
	public native void slideDown( int count);
	public native void slideDown();

/** 
 Sets the ruler slide offset.

 This is like {@link #slideup} or {@link #slidedown} with an absolute offset
 from the start of the ruler.

*/
	public native void setOffset( int offset);

/** 
 Returns the current ruler offset.

*/
	public native int offset();
	public native int endOffset();

/** 
 Sets the pointer to a new position.

 The offset is NOT updated.
 {@link QWidget#repaint} is called afterwards.

*/
	public native void slotNewValue( int arg1);

/** 
 Sets the ruler marks to a new position.

 The pointer is NOT updated.
 {@link QWidget#repaint} is called afterwards.

*/
	public native void slotNewOffset( int arg1);
	public native void slotEndOffset( int arg1);
	public static final int Custom = 0;
	public static final int Pixel = 0;
	public static final int Inch = 1;
	public static final int Millimetres = 2;
	public static final int Centimetres = 3;
	public static final int Metres = 4;
}
