/***************************************************************************
                            KServerSocket.java -  description
                             -------------------
    begin                : Fri Mar 15 15:14:30 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar 15 15:14:30 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 Please use the more powerful KExtendedSocket class.

 You can use a KServerSocket to listen on a port for incoming
 connections. When a connection arrived in the port, a KSocket
 is created and the signal accepted is raised. Make sure you
 always connect to this signal. If you don't the ServerSocket will
 create new KSocket's and no one will delete them!

 If socket() is -1 or less the socket was not created properly.

 See {@link KServerSocketSignals} for signals emitted by KServerSocket.

 See {@link KServerSocketEventHandling} for event handlers to override in subclasses of KServerSocket.

 @author Torben Weis <weis@stud.uni-frankfurt.de>

 @version $Id: KServerSocket.java,v 1.6 2002/03/15 20:47:32 rdale Exp $

 @short Monitors a port for incoming TCP/IP connections.

*/
public class KServerSocket extends QObject  {
	protected KServerSocket(Class dummy){super((Class) null);}

	private native void newKServerSocket( short _port, boolean _bind);

/** 
 Constructor.

*/
	public KServerSocket( short _port, boolean _bind) {
		super((Class) null);
		newKServerSocket( _port, _bind);
	}
	private native void newKServerSocket( short _port);
	public KServerSocket( short _port) {
		super((Class) null);
		newKServerSocket( _port);
	}
	private native void newKServerSocket( String _path, boolean _bind);

/** 
 Creates a UNIX domain server socket.

*/
	public KServerSocket( String _path, boolean _bind) {
		super((Class) null);
		newKServerSocket( _path, _bind);
	}
	private native void newKServerSocket( String _path);
	public KServerSocket( String _path) {
		super((Class) null);
		newKServerSocket( _path);
	}

/**  
 Destructor. Closes the socket if it was not already closed.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Binds the socket and start listening. This should only be called
 once when the constructor was called with _bind false.

*/
	public native boolean bindAndListen();

/**  
 Returns the file descriptor associated with the socket.
 Returns -1 when an error occured during construction or
 {@link bindAndListen}
     
*/
	public native int socket();

/**  
 Returns the port number which is being monitored.
     
*/
	public native short port();

/**  
 The address.
 This is dumb. Don't use it
 Refer to {@link KExtendedSocket#localAddress}

     
*/
	public native long ipv4_addr();

/**  
 Called when someone connected to our port.
     
*/
	public native void slotAccept( int arg1);
	protected native boolean init( short arg1);
	protected native boolean init( String _path);
}
