package org.kde.koala;
import org.kde.qt.*;


/** {@link KWinModule} emits these signals */
public interface KWinModuleSignals {

/** 
 A window has been removed.
     
*/
	void windowRemoved( int arg1 );

/** 
 Emitted when a dock window has been removed.
     
*/
	void systemTrayWindowRemoved( int arg1 );
	void destroyed( QObject obj );

/** 
 The window changed somehow.
     
*/
	void windowChanged( int arg1 );

/** 
 Switched to another virtual desktop.
     
*/
	void currentDesktopChanged( int arg1 );

/** 
 Emitted when a dock window has been added.
     
*/
	void systemTrayWindowAdded( int arg1 );

/** 
 Desktops have been renamed.
     
*/
	void desktopNamesChanged();

/** 
 A window has been added.
     
*/
	void windowAdded( int arg1 );

/**  
 Something changed with the struts, may or may not have changed
 the work area.
     
*/
	void strutChanged();

/** 
 Hint that <Window> is active (= has focus) now.
     
*/
	void activeWindowChanged( int arg1 );

/** 
 The workarea has changed.
     
*/
	void workAreaChanged();

/** 
 The number of desktops changed.
     
*/
	void numberOfDesktopsChanged( int arg1 );

/** 
 Emitted when the stacking order of the window changed. The new order
 can be obtained with {@link KWinModule#stackingOrder}.
     
*/
	void stackingOrderChanged();
}

