/***************************************************************************
                            Observer.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Observer for {@link KIO#Job} progress information
 This class, of which there is always only one instance,
 "observes" what jobs do and forwards this information
 to the progress-info server.

 It is a DCOP object so that the UI server can call the
 kill method when the user presses Cancel.

 See {@link ObserverSignals} for signals emitted by Observer.

 See {@link ObserverEventHandling} for event handlers to override in subclasses of Observer.

 @author David Faure <faure@kde.org>
 
 @short Observer for @ref KIO::Job progress information.
*/
public class Observer extends QObject implements  DCOPObjectInterface {
	protected Observer(Class dummy){super((Class) null);}


/** 
 Called by the job constructor, to signal its presence to the
 UI Server.

*/
	public native int newJob( Job job, boolean showProgress);

/** 
 Called by the job destructor, to tell the UI Server that
 the job ended
   
*/
	public native void jobFinished( int progressId);

/** 

   
*/
	public native boolean openPassDlg( String prompt, String user, String pass, boolean readOnly);
	public native boolean openPassDlg( int info);

/** 
 Popup a message box. See {@link KIO#SlaveBase}.
   
*/
	public native int messageBox( int progressId, int type, String text, String caption, String buttonYes, String buttonNo);

/** 
 See renamedlg.h
   
*/
//	public native int open_RenameDlg( Job job, String caption, String src, String dest, int mode, String newDest, int arg1, int arg2, time_t ctimeSrc  -1 arg3, time_t ctimeDest  -1 arg4, time_t mtimeSrc  -1 arg5, time_t mtimeDest  -1 arg6);
	public native int open_RenameDlg( Job job, String caption, String src, String dest, int mode, String newDest);

/** 
 See skipdlg.h
   
*/
	public native int open_SkipDlg( Job job, boolean multi, String error_text);
//	public native k_dcop: /** * Called by the UI Server( using DCOP) if the user presses cancel* / void killJob( int progressId);

/** 
 Called by the UI Server (using DCOP) to get all the metadata of the job
   
*/
	public native int metadata( int progressId);
	public native void stating( Job arg1, KURL url);
	public native void mounting( Job arg1, String dev, String point);
	public native void unmounting( Job arg1, String point);
	public native void slotTotalSize( Job arg1, int size);
	public native void slotTotalFiles( Job arg1, long files);
	public native void slotTotalDirs( Job arg1, long dirs);
	public native void slotProcessedSize( Job arg1, int size);
	public native void slotProcessedFiles( Job arg1, long files);
	public native void slotProcessedDirs( Job arg1, long dirs);
	public native void slotSpeed( Job arg1, long bytes_per_second);
	public native void slotPercent( Job arg1, long percent);
	public native void slotInfoMessage( Job arg1, String msg);
	public native void slotCopying( Job arg1, KURL from, KURL to);
	public native void slotMoving( Job arg1, KURL from, KURL to);
	public native void slotDeleting( Job arg1, KURL url);
	public native void slotCreatingDir( Job arg1, KURL dir);
	public native void slotCanResume( Job arg1, int offset);

/** 

*/
	public static native Observer self();
	private native void newObserver();
	public Observer() {
		super((Class) null);
		newObserver();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	
	// From DCOPObjectInterface
	public native String objId();

/**
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

 The new name is <code>objId</code>

*/
	public native boolean setObjId( String objId);

/**
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns <code>false</code>, then {@link #processDynamic}
 is called.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #functions} but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
	public native ArrayList functionsDynamic();

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #interfaces} but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
	public native ArrayList interfacesDynamic();

/**
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/**
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();

/**
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);

/**
 Connects to a DCOP signal.

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/**
 Disconnects a DCOP signal.

 A special case is when both sender & signal are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/**

 {@link DCOPObjectProxy}

*/
	public static native boolean hasObject( String objId);

/**

 This function does not query the {@link DCOPObjectProxy}.

*/
	public static native DCOPObjectInterface find( String objId);

/**

 This function is used for multicasting a DCOP message to
 several objects inside a single process.

*/
//	public static native QPtrList<DCOPObject> match( String partialId);

/**
 Creates an object id for the QObject <code>obj.</code> This is done
 using the {@link QObject#name} function.

*/
	public static native String objectName( QObject obj);

}
