/***************************************************************************
                            KDoubleNumInput.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDOUBLENUMINPUT_H
#define KDOUBLENUMINPUT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KNumInput.h>

/**

 KDoubleNumInput combines a @ref QSpinBox and optionally a @ref QSlider
 with a label to make an easy to use control for setting some float
 parameter. This is especially nice for configuration dialogs,
 which can have many such combinated controls.

 The slider is created only when the user specifies a range
 for the control using the setRange function with the slider
 parameter set to "true".

 A special feature of KDoubleNumInput, designed specifically for
 the situation when there are several KDoubleNumInputs in a column,
 is that you can specify what portion of the control is taken by the
 QSpinBox (the remaining portion is used by the slider). This makes
 it very simple to have all the sliders in a column be the same size.

 It uses @ref KFloatValidator validator class. KDoubleNumInput enforces the
 value to be in the given range.

 @short An input control for real numbers, consisting of a spinbox and a slider.
 
*/
@interface KDoubleNumInput : KNumInput 

/** 
 Constructs an input control for double values
 with initial value 0.0.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructor

*/
- initWithDouble: (double)value parent: (QWidget *)parent name: (NSString *)name;
- initWithDouble: (double)value ;

/** 
 destructor
     
*/
- (void) dealloc;

/** 
 Constructor

 put it below other KNumInput

*/
- initWithNumInput: (KNumInput*)below value: (double)value parent: (QWidget *)parent name: (NSString *)name;
- initWithNumInput: (KNumInput*)below value: (double)value ;

/** 

*/
- (double) value;

/** 

*/
- (NSString *) suffix;

/** 

*/
- (NSString *) prefix;

/** 

*/
- (int) precision;

/** 

*/
- (NSString *) specialValueText;

/** 

*/
- setRange: (double)min max: (double)max step: (double)step slider: (BOOL)slider;
- setRange: (double)min max: (double)max ;

/** 
 Sets the minimum value.
     
*/
- setMinValue: (double)min;

/** 

*/
- (double) minValue;

/** 
 Sets the maximum value.
     
*/
- setMaxValue: (double)max;

/** 

*/
- (double) maxValue;

/** 
 Specifies the number of digits to use.
     
*/
- setPrecision: (int)precision;

/** 
 Sets the special value text. If set, the spin box will display
 this text instead of the numeric value whenever the current
 value is equal to @ref  #--minVal. Typically this is used for indicating
 that the choice has a special (default) meaning.
     
*/
- setSpecialValueText: (NSString *)text;

/** 
 Sets the value of the control.
     
*/
- setValue: (double)arg1;

/** 
 Sets the suffix to be displayed to @p suffix. Use -[QString null]to disable
 this feature. Note that the suffix is attached to the value without any
 spacing. So if you prefer to display a space separator, set suffix
 to something like " cm".

*/
- setSuffix: (NSString *)suffix;

/** 
 Sets the prefix to be displayed to @p prefix. Use -[QString null]to disable
 this feature. Note that the prefix is attached to the value without any
 spacing.

*/
- setPrefix: (NSString *)prefix;
- resetEditBox;
@end

/** Override these methods in subclasses of KDoubleNumInput to customise event handling behaviour */
@protocol KDoubleNumInputEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 

     
*/
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
