/***************************************************************************
                            KLocale.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLOCALE_H
#define KLOCALE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 KLocale provides support for country specific stuff like
 the national language.

 KLocale supports translating, as well as specifying the format
 for numbers, currency, time, and date.

 @author Stephan Kulow <coolo@kde.org>, Preston Brown <pbrown@kde.org>, Hans Petter Bieker <bieker@kde.org>

 @short class for supporting locale settings and national language.
*/

@class KConfig;
@class QTextCodec;

@interface  KLocale : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Constructs a KLocale with the given catalogue name.
 The constructor looks for an entry Locale/Language in the
 configuration file.
 If no config file is specified, it will also look for languages
 using the environment variables (KDE_LANG, LC_MESSAGES, LC_ALL, LANG),
 as well as the global configuration fie. If we were not able to use
 non of the specified languages, the default language (en_US) will be
 used.

 If you specify a configuration file, it has to be valid until
 the KLocale object is destroyed.

*/
- initWithText: (NSString *)catalogue config: (KConfig*)config;
- initWithText: (NSString *)catalogue ;

/** 
 Copy constructor.
   
*/
- copyWithZone: (NSZone *) zone;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Translates the string into the corresponding string in
 the national language, if available. If not, returns
 the string itself.
 There is a KDE wide message file that contains the most
 often used phrases, so we can avoid duplicating the
 translation of these phrases. If a phrase is not found
 in the catalogue given to the constructor, it will search
 in the system catalog. This makes it possible to override
 some phrases for your needs.

  The argument must be an UTF-8 encoded string (If you only use
  characters that are in US-ASCII you're on the safe side. But
  for e.g. german umlauts or french accents should be recoded to
  UTF-8)

*/
- (NSString *) translate: (NSString *)index;

/** 
 Translates the string into the corresponding string in the
 national language, if available.

 The real contents of the string is in the argument fallback,
 but the meaning of it is coded into the argument index.
 In some cases you'll need this function, when english is
 too ambiguous to express it.

 Most of the times the translators will tell you if it can't
 be translated as it, but think of cases as "New", where the
 translations differs depending on what is New.
 Or simple cases as "Open", that can be used to express something
 is open or it can be used to express that you want something to
 open... There are tons of such examples.

 If translate("Open") is not enough to translate it well, use
 translate("To Open", "Open") or translate("Is Open", "Open").
 The english user will see "Open" in both cases, but the translated
 version may vary. Of course you can also use -i18n

*/
- (NSString *) translate: (NSString *)index fallback: (NSString *)fallback;
- (NSString *) translate: (NSString *)singular plural: (NSString *)plural n: (unsigned long)n;

/** 

*/
- (BOOL) setCharset: (NSString *)charset;

/** 
 Changes the current encoding.

*/
- (BOOL) setEncoding: (int)mibEnum;

/** 
 Changes the current language. The current language will be left
 unchanged if failed. It will force a reload of the country specific
 configuration as well.

*/
- (BOOL) setLanguage: (NSString *)language;

/** 
 Changes the list of prefed languages for the locale. The first valid
 language in the list will be used, or the default (en_US) language
 will be used if non of the specified languages were available.

*/
- (BOOL) setLanguages: (NSArray *)languages;

/** 
 Changes the current country. The current country will be left
 unchanged if failed. It will force a reload of the country specific
 configuration.

*/
- (BOOL) setCountry: (NSString *)country;

/** 
 Returns what a decimal point should look like ("." or "," etc.)
 according to the current locale or user settings.

*/
- (NSString *) decimalSymbol;

/** 
 Returns what the thousands separator should look
 like ("," or "." etc.)
 according to the current locale or user settings.

*/
- (NSString *) thousandsSeparator;

/** 
 Returns what the symbol denoting currency in the current locale
 as as defined by user settings should look like.

*/
- (NSString *) currencySymbol;

/** 
 Returns what a decimal point should look like ("." or "," etc.)
 for monetary values, according to the current locale or user
 settings.

*/
- (NSString *) monetaryDecimalSymbol;

/** 
 Returns what a thousands separator for monetary values should
 look like ("," or " " etc.) according to the current locale or
 user settings.

*/
- (NSString *) monetaryThousandsSeparator;

/** 
 Returns what a positive sign should look like ("+", " ", etc.)
 according to the current locale or user settings.

*/
- (NSString *) positiveSign;

/** 
 Returns what a negative sign should look like ("-", etc.)
 according to the current locale or user settings.

*/
- (NSString *) negativeSign;

/** 
 The number of fractional digits to include in numeric/monetary
 values (usually 2).

*/
- (int) fracDigits;

/** 
 If and only if the currency symbol precedes a positive value,
 this will be true.

*/
- (BOOL) positivePrefixCurrencySymbol;

/** 
 If and only if the currency symbol precedes a negative value,
 this will be true.

*/
- (BOOL) negativePrefixCurrencySymbol;

/** 
 Returns the position of a positive sign in relation to a
 monetary value.

*/
- (int) positiveMonetarySignPosition;

/** 
 Denotes where to place a negative sign in relation to a
 monetary value.

*/
- (int) negativeMonetarySignPosition;

/** 
 Given a double, converts that to a numeric string containing
 the localized monetary equivalent.

 e.g. given 123456, return "$ 123,456.00".

*/
- (NSString *) formatMoney: (double)num currency: (NSString *)currency digits: (int)digits;

/** 

 a QString as the argument for convenience.

*/
- (NSString *) formatMoney: (NSString *)numStr;

/** 
 Given a double, converts that to a numeric string containing
 the localized numeric equivalent.

 e.g. given 123456.78, return "123,456.78" (for some European country).
 If precision isn't specified, 2 is used.

*/
- (NSString *) formatNumber: (double)num precision: (int)precision;

/** 

 a QString as the argument for convenience.

*/
- (NSString *) formatNumber: (NSString *)numStr;

/** 
 Returns a string formatted to the current locale's conventions
 regarding dates.

*/
- (NSString *) formatDate: (NSDate *)pDate shortFormat: (BOOL)shortFormat;

/** 
 Returns a string formatted to the current locale's conventions
 regarding times.

*/
- (NSString *) formatTime: (NSDate *)pTime includeSecs: (BOOL)includeSecs;

/** 
 Use this to determine if the user wants a 12 hour clock.

*/
- (BOOL) use12Clock;

/** 
 Use this to determine if the user wants the week to start on Monday.

*/
- (BOOL) weekStartsMonday;

/** 
 Returns a string containing the name of the month name.

*/
- (NSString *) monthName: (int)i shortName: (BOOL)shortName;

/** 
 Returns a string containing the name of the week day.

*/
- (NSString *) weekDayName: (int)i shortName: (BOOL)shortName;

/** 
 Returns a string formated to the current locale's conventions
 regarding both date and time.

*/
- (NSString *) formatDateTime: (NSDate *)pDateTime shortFormat: (BOOL)shortFormat includeSecs: (BOOL)includeSecs;

/** 
 Converts a localized monetary string to a double.

*/
- (double) readMoney: (NSString *)numStr ok: (int*)ok;
- (double) readMoney: (NSString *)numStr ;

/** 
 Converts a localized numeric string to a double.

*/
- (double) readNumber: (NSString *)numStr ok: (int*)ok;
- (double) readNumber: (NSString *)numStr ;

/** 
 Converts a localized date string to a QDate.
 The bool pointed by ok will be invalid if the date entered was not valid.

*/
- (NSDate *) readDate: (NSString *)str ok: (int*)ok;

/** 
 Converts a localized date string to a QDate, using the specified format.
 You will usually not want to use this method.
   
*/
- (NSDate *) readDate: (NSString *)intstr fmt: (NSString *)fmt ok: (int*)ok;

/** 
 Converts a localized time string to a QTime.
 The bool pointed by ok will be false if the time entered was not valid.

*/
- (NSDate *) readTime: (NSString *)str ok: (int*)ok;

/** 
 Returns the language used by this object. The domain AND the
 library translation must be available in this language.
 "en_US" is default, if no other available.

*/
- (NSString *) language;

/** 
 Returns the country code of the country where the user lives.
 "C" is default, if no other available

*/
- (NSString *) country;

/** 

*/
- (NSString *) languages;

/** 
 Returns the preferred languages as ISO 639-1 codes. This means
 that information about country is removed. If the internal language
 code might be represented by more than one 639-1 code, they will all be
 listed (but only once).

 If the selected languages are "nn, nb, pt_BR", you will get:
 "nn, no, nb, pt".

*/
- (NSArray *) languagesTwoAlpha;

/** 
 Returns the languages selected by user. The codes returned here is the
 internal language codes.

*/
- (NSArray *) languageList;

/** 

 This will be the charset defined in the config file.
 NOTE: This is no longer the same as encoding.
 "iso-8859-1" is default

*/
- (NSString *) charset;

/** 
 Returns the user's preferred encoding.

*/
- (NSString *) encoding;

/** 
 Returns the user's preferred encoding.

*/
- (int) encodingMib;

/** 
 Returns the user's preferred encoding. Should never be NULL.

*/
- (QTextCodec*) codecForEncoding;

/** 
 Changes the current date format.

*/
- setDateFormat: (NSString *)format;

/** 
 Changes the current short date format.

*/
- setDateFormatShort: (NSString *)format;

/** 
 Changes the current time format.

*/
- setTimeFormat: (NSString *)format;

/** 
 Changes how KLocale defines the first day in week.

*/
- setWeekStartsMonday: (BOOL)start;

/** 
 Returns the currently selected date format.

*/
- (NSString *) dateFormat;

/** 
 Returns the currently selected short date format.

*/
- (NSString *) dateFormatShort;

/** 
 Returns the currently selected time format.

*/
- (NSString *) timeFormat;

/** 
 Changes the symbol used to identify the decimal pointer.

*/
- setDecimalSymbol: (NSString *)symbol;

/** 
 Changes the separator used to group digits when formating numbers.

*/
- setThousandsSeparator: (NSString *)separator;

/** 
 Changes the sign used to identify a positive number. Normally this is
 left blank.

*/
- setPositiveSign: (NSString *)sign;

/** 
 Changes the sign used to identify a negative number.

*/
- setNegativeSign: (NSString *)sign;

/** 
 Changes the sign position used for positive monetary values.

*/
- setPositiveMonetarySignPosition: (int)signpos;

/** 
 Changes the sign position used for negative monetary values.

*/
- setNegativeMonetarySignPosition: (int)signpos;

/** 
 Changes the position where the currency symbol should be printed for
 positive monetary values.

*/
- setPositivePrefixCurrencySymbol: (BOOL)prefix;

/** 
 Changes the position where the currency symbol should be printed for
 negative monetary values.

*/
- setNegativePrefixCurrencySymbol: (BOOL)prefix;

/** 
 Changes the number of digits used when formating numbers.

*/
- setFracDigits: (int)digits;

/** 
 Changes the separator used to group digits when formating monetary values.

*/
- setMonetaryThousandsSeparator: (NSString *)separator;

/** 
 Changes the symbol used to identify the decimal pointer for monetary
 values.

*/
- setMonetaryDecimalSymbol: (NSString *)symbol;

/** 
 Changes the current currency symbol.

*/
- setCurrencySymbol: (NSString *)symbol;

/** 
 Returns the preferred page size for printing.

*/
- (int) pageSize;

/** 
 Changes the preferred page size when printing.

*/
- setPageSize: (int)paperFormat;

/** 
 Returns which measuring system we use.

*/
- (int) measureSystem;

/** 
 Changes the preferred measuring system.

*/
- setMeasureSystem: (int)value;

/** 
 Adds another catalogue to search for translation lookup.
 This function is useful for extern libraries and/or code,
 that provides its own messages.

 If the catalogue does not exist for the chosen language,
 it will be ignored and en_US will be used.

*/
- insertCatalogue: (NSString *)catalogue;
- removeCatalogue: (NSString *)catalogue;
- setActiveCatalogue: (NSString *)catalogue;

/** 
 Translates a message as a QTranslator is supposed to.
 The parameters are similar to -i18n, but the result
 value has other semantics (it can be -[QString null])

*/
- (NSString *) translateQt: (NSString *)context sourceText: (NSString *)sourceText message: (NSString *)message;

/** 
 Returns the parts of the parameter str understood as language setting
 the format is language_COUNTRY.charset

*/
+ splitLocale: (NSString *)str language: (NSString *)language country: (NSString *)country charset: (NSString *)charset;

/** 
 Use this to as main catalogue for *all* KLocales, if not the appname
 will be used.

*/
+ setMainCatalogue: (NSString *)catalogue;

/** 
 Finds localized resource in resourceDir( rtype ) + <lang> + fname.

*/
+ (NSString *) langLookup: (NSString *)fname rtype: (NSString *)rtype;

/** 
 Returns the name of the internal language.

*/
+ (NSString *) defaultLanguage;

/** 
 Returns the name of the default country.

*/
+ (NSString *) defaultCountry;

/** 

 pointer.
   
*/
+ initInstance;
+ (int) ParensAround;
+ (int) BeforeQuantityMoney;
+ (int) AfterQuantityMoney;
+ (int) BeforeMoney;
+ (int) AfterMoney;
+ (int) Metric;
+ (int) Imperial;
@end

#endif
