/***************************************************************************
                            KSharedPixmap.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHAREDPIXMAP_H
#define KSHAREDPIXMAP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KPixmap.h>
#include <qtobjc/QWidget.h>

/**

 Shared pixmap client.

 A shared pixmap is a pixmap that resides on the X server, is referenced
 by a global id string, and can be accessed by all X clients.

 This class is a client class to shared pixmaps in KDE. You can use it
 to copy (a part of) a shared pixmap into. KSharedPixmap inherits KPixmap
 for that purpose.

 The server part of shared pixmaps is not implemented here. 
 That part is provided by KPixmapServer, in the source file:
 kdebase/kdesktop/pixmapserver.cc.

 An example: copy from a shared pixmap:
 <pre>
   KSharedPixmap *pm = new KSharedPixmap;
   connect(pm, SIGNAL(done(bool)), SLOT(slotDone(bool)));
   -[pm loadFromShared]("My Pixmap");
 </pre>

 
 @author Geert Jansen <jansen@kde.org>

 @version $Id: KSharedPixmap.h,v 1.3 2002/03/15 02:12:23 rdale Exp $

 @short 
 Shared pixmap client.
*/
@interface KSharedPixmap : KPixmap 

/** 
 Construct an empty pixmap.
     
*/
- init;

/** 
 Destroys the pixmap.
     
*/
- (void) dealloc;

/** 
 Load from a shared pixmap reference. The signal -done is emitted
 when the operation has finished.

*/
- (BOOL) loadFromShared: (NSString *)name rect: (QRect*)rect;
- (BOOL) loadFromShared: (NSString *)name ;

/** 
 Check whether a shared pixmap is available.

*/
- (BOOL) isAvailable: (NSString *)name;
@end

/** Override these methods in subclasses of KSharedPixmap to customise event handling behaviour */
@protocol KSharedPixmapEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
