/***************************************************************************
                            KStdAction.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTDACTION_H
#define KSTDACTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Convenience methods to access all standard KDE actions.

 These actions should be used instead of hardcoding menubar and
 toolbar items.  Using these actions helps your application easily
 conform to the KDE UI Style Guide

 All of the documentation for @ref KAction holds for KStdAction
 also.  When in doubt on how things work, check the @ref KAction
 documention first.

 In general, using standard actions should be a drop in replacement
 for regular actions.  For example, if you previously had:

 <PRE>
 static KAction *newAct = new KAction(i18n("&New"), QIconSet(BarIcon("filenew")),
                               -[KStdAccel key](-[KStdAccel New]), this,
                               SLOT(-fileNew), -actionCollection);
 </PRE>

 You could drop that and replace it with:

 <PRE>
 static KAction *newAct = -[KStdAction openNew](this, SLOT(-fileNew),
                                       -actionCollection);
 </PRE>

 It is possible to use the standard actions in various
 non-recommended ways.  Say, for instance, you wanted to have a
 standard action (with the associated correct text and icon and
 accelerator, etc) but you didn't want it to go in the standard
 place (this is not recommended, by the way).  One way to do this is
 to simply not use the XML UI framework and plug it into wherever
 you want.  If you do want to use the XML UI framework (good!), then
 it is still possible.

 Basically, the XML building code matches names in the XML code with
 the internal names of the actions.  You can find out the internal
 names of each of the standard actions by using the @ref stdName
 action like so: @ref -[KStdAction stdName](-[KStdAction Cut]) would return
 'edit_cut'.  The XML building code will match 'edit_cut' to the
 attribute in the global XML file and place your action there.

 However, you can change the internal name.  In this example, just
 do something like:

 <PRE>
 (void)-[KStdAction cut](this, SLOT(-editCut), -actionCollection, "my_cut");
 </PRE>

 Now, in your local XML resource file (e.g., yourappui.rc), simply
 put 'my_cut' where you want it to go.

 Another non-standard usage concerns getting a pointer to an
 existing action if, say, you want to enable or disable the action.
 You could do it the recommended way and just grab a pointer when
 you instantiate it as in the the 'openNew' example above... or you
 could do it the hard way:

 <pre>
 static KAction *cut = -actionCollection->action(-[KStdAction stdName](-[KStdAction Cut]));
 </pre>

 Another non-standard usage concerns instantiating the action in the
 first place.  Usually, you would use the member functions as
 shown above (e.g., -[KStdAction cut](this, SLOT, parent)).  You
 may, however, do this using the enums provided.  This author can't
 think of a reason why you would want to, but, hey, if you do,
 here's how:

 <pre>
 (void)-[KStdAction action](-[KStdAction New], this, SLOT(-fileNew), -actionCollection);
 (void)-[KStdAction action](-[KStdAction Cut], this, SLOT(-editCut), -actionCollection);
 </pre>

 @author Kurt Granroth <granroth@kde.org>
 
 @short 
 Convenience methods to access all standard KDE actions.
*/

@class KAction;
@class KRecentFilesAction;
@class KToggleAction;
@class QObject;
@class KActionCollection;

@interface  KStdAction : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates an action corresponding to the
 @ref -[KStdAction StdAction]enum.
	 
*/
+ (KAction*) create: (int)identifier name: (NSString *)name recvr: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent;
+ (KAction*) create: (int)identifier recvr: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent;

/** 
 @obsolete. Creates an action corresponding to the
 @ref -[KStdAction StdAction]enum.
	
*/
+ (KAction*) action: (int)act_enum recvr: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) action: (int)act_enum recvr: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 This will return the internal name of a given standard action.
	 
*/
+ (NSString *) name: (int)identifier;
+ (NSString *) stdName: (int)act_enum;

/** 
 Create a new document or window.
	 
*/
+ (KAction*) openNew: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) openNew: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Open an existing file.
	 
*/
+ (KAction*) open: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) open: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Open a recently used document.

*/
+ (KRecentFilesAction*) openRecent: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KRecentFilesAction*) openRecent: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Save the current document.
	 
*/
+ (KAction*) save: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) save: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Save the current document under a different name.
	
*/
+ (KAction*) saveAs: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) saveAs: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Revert the current document to the last saved version
 (essentially will undo all changes).
	
*/
+ (KAction*) revert: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) revert: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Close the current document.
	
*/
+ (KAction*) close: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) close: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Print the current document.
	
*/
+ (KAction*) print: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) print: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Show a print preview of the current document.
	
*/
+ (KAction*) printPreview: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) printPreview: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Mail this document.
	
*/
+ (KAction*) mail: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) mail: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Quit the program.
	
*/
+ (KAction*) quit: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) quit: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Undo the last operation.
	
*/
+ (KAction*) undo: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) undo: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Redo the last operation.
	
*/
+ (KAction*) redo: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) redo: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Cut selected area and store it in the clipboard.
	
*/
+ (KAction*) cut: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) cut: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Copy the selected area into the clipboard.
	
*/
+ (KAction*) copy: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) copy: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Paste the contents of clipboard at the current mouse or cursor
 position.
	
*/
+ (KAction*) paste: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) paste: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Select all elements in the current document.
	
*/
+ (KAction*) selectAll: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) selectAll: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Deselect any selected elements in the current document.
	
*/
+ (KAction*) deselect: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) deselect: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Initiate a 'find' request in the current document.
	
*/
+ (KAction*) find: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) find: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Find the next instance of a stored 'find'.
	
*/
+ (KAction*) findNext: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) findNext: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Find a previous instance of a stored 'find'.
	
*/
+ (KAction*) findPrev: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) findPrev: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Find and replace matches.
	
*/
+ (KAction*) replace: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) replace: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 View the document at its actual size.
	
*/
+ (KAction*) actualSize: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) actualSize: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Fit the document view to the size of the current window.
	
*/
+ (KAction*) fitToPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) fitToPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Fit the document view to the width of the current window.
	
*/
+ (KAction*) fitToWidth: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) fitToWidth: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Fit the document view to the height of the current window.
	
*/
+ (KAction*) fitToHeight: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) fitToHeight: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Zoom in.
	
*/
+ (KAction*) zoomIn: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) zoomIn: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Zoom out.
	
*/
+ (KAction*) zoomOut: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) zoomOut: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Popup a zoom dialog.
	
*/
+ (KAction*) zoom: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) zoom: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Redisplay or redraw the document.
	
*/
+ (KAction*) redisplay: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) redisplay: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Move up (web style menu).
	
*/
+ (KAction*) up: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) up: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Move back (web style menu).
	
*/
+ (KAction*) back: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) back: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Move forward (web style menu).
	
*/
+ (KAction*) forward: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) forward: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Go to the "Home" position or document.
	
*/
+ (KAction*) home: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) home: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Scroll up one page.
	
*/
+ (KAction*) prior: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) prior: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Scroll down one page.
	
*/
+ (KAction*) next: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) next: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Go to somewhere in general.
	
*/
+ (KAction*) goTo: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) goTo: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Go to a specific page (dialog).
	
*/
+ (KAction*) gotoPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) gotoPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Go to a specific line (dialog).
	
*/
+ (KAction*) gotoLine: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) gotoLine: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Jump to the first page.
	
*/
+ (KAction*) firstPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) firstPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Jump to the last page.
	
*/
+ (KAction*) lastPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) lastPage: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Add the current page to the bookmarks tree.
	
*/
+ (KAction*) addBookmark: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) addBookmark: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Edit the application bookmarks.
	
*/
+ (KAction*) editBookmarks: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) editBookmarks: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Pop up the spell checker.
	
*/
+ (KAction*) spelling: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) spelling: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Show/Hide the menubar.
	
*/
+ (KToggleAction*) showMenubar: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KToggleAction*) showMenubar: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Show/Hide the primary toolbar.
	
*/
+ (KToggleAction*) showToolbar: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KToggleAction*) showToolbar: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Show/Hide the statusbar.
	
*/
+ (KToggleAction*) showStatusbar: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KToggleAction*) showStatusbar: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Display the save options dialog.
	
*/
+ (KAction*) saveOptions: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) saveOptions: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Display the configure key bindings dialog.
	
*/
+ (KAction*) keyBindings: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) keyBindings: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Display the preferences/options dialog.
	
*/
+ (KAction*) preferences: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) preferences: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 The Customize Toolbar dialog.
	
*/
+ (KAction*) configureToolbars: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) configureToolbars: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Display the help.
	
*/
+ (KAction*) help: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) help: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Display the help contents.
	
*/
+ (KAction*) helpContents: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) helpContents: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Trigger the What's This cursor.
	
*/
+ (KAction*) whatsThis: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) whatsThis: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Open up the Report Bug dialog.
	
*/
+ (KAction*) reportBug: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) reportBug: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Display the application's About box.
	
*/
+ (KAction*) aboutApp: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) aboutApp: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;

/** 
 Display the About KDE dialog.
	
*/
+ (KAction*) aboutKDE: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;
+ (KAction*) aboutKDE: (QObject *)recvr slot: (NSString *)slot parent: (KActionCollection*)parent ;
+ (int) ActionNone;
+ (int) New;
+ (int) Open;
+ (int) OpenRecent;
+ (int) Save;
+ (int) SaveAs;
+ (int) Revert;
+ (int) Close;
+ (int) Print;
+ (int) PrintPreview;
+ (int) Mail;
+ (int) Quit;
+ (int) Undo;
+ (int) Redo;
+ (int) Cut;
+ (int) Copy;
+ (int) Paste;
+ (int) SelectAll;
+ (int) Deselect;
+ (int) Find;
+ (int) FindNext;
+ (int) FindPrev;
+ (int) Replace;
+ (int) ActualSize;
+ (int) FitToPage;
+ (int) FitToWidth;
+ (int) FitToHeight;
+ (int) ZoomIn;
+ (int) ZoomOut;
+ (int) Zoom;
+ (int) Redisplay;
+ (int) Up;
+ (int) Back;
+ (int) Forward;
+ (int) Home;
+ (int) Prior;
+ (int) Next;
+ (int) Goto;
+ (int) GotoPage;
+ (int) GotoLine;
+ (int) FirstPage;
+ (int) LastPage;
+ (int) AddBookmark;
+ (int) EditBookmarks;
+ (int) Spelling;
+ (int) ShowMenubar;
+ (int) ShowToolbar;
+ (int) ShowStatusbar;
+ (int) SaveOptions;
+ (int) KeyBindings;
+ (int) Preferences;
+ (int) ConfigureToolbars;
+ (int) Help;
+ (int) HelpContents;
+ (int) WhatsThis;
+ (int) ReportBug;
+ (int) AboutApp;
+ (int) AboutKDE;
@end

#endif
