/***************************************************************************
                            KTextBrowser.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTEXTBROWSER_H
#define KTEXTBROWSER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QTextBrowser.h>

/**

 An extended @ref QTextBrowser.

 By default it will
 invoke the system mailer or the system browser when a link is
 activated, or it can emit the signal @ref -urlClick or @ref -mailClick
 when a link is activated.

 @author Espen Sand (espensa@online.no)

 @version $Id: KTextBrowser.h,v 1.3 2002/03/15 02:12:23 rdale Exp $
 
 @short Extended QTextBrowser.

*/
@interface KTextBrowser : QTextBrowser 

/** 
 Constructor.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name notifyClick: (BOOL)notifyClick;
- init;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 Decide whether a click on a link should be handled internally
 or if a signal should be emitted.

*/
- setNotifyClick: (BOOL)notifyClick;

/** 
 Returns whether a click on a link should be handled internally
 or if a signal should be emitted.
     
*/
- (BOOL) isNotifyClick;

/** 
       Reimplemented to NOT set the source but to do the special handling.
       Do not call.
     
*/
- setSource: (NSString *)name;
@end

/** Override these methods in subclasses of KTextBrowser to customise event handling behaviour */
@protocol KTextBrowserEventHandling

/** 
 Makes sure Key_Escape is ignored
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;

/** 
 Reimplemented to support Qt2 behavior (Ctrl-Wheel = fast scroll)
     
*/
- contentsWheelEvent:(QWheelEvent*) e;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;

/** 
 Make sure we use our own hand cursor
     
*/
- viewportMouseMoveEvent:(QMouseEvent*) e;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) e;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) e;
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
