
import org.kde.qt.*;

class MoveMe  extends QWidget
{
public    MoveMe( QWidget parent, String name, int f)
{
	super(parent,name, f);
}

private    QPoint clickPos;

void mousePressEvent( QMouseEvent e )
{
    //    if ( e.button() == LeftButton )
	clickPos = e.pos();
}

void mouseMoveEvent( QMouseEvent e )
{
    //    if ( e.state() & LeftButton )
	move( new QPoint( e.globalPos().x() - clickPos.x(),
	                  e.globalPos().y() - clickPos.y() ) );
}



public static void main(String[] args)
{
    QApplication a = new QApplication( args );

    String fn="tux.png";

    if ( args.length >= 1 )
	fn = args[0];

    if ( ! QFile.exists( fn ) )
	System.exit( 1 );

    QImage img = new QImage( fn );
    QPixmap p = new QPixmap();
    p.convertFromImage( img );
    if ( p.mask() == null )
	if ( img.hasAlphaBuffer() ) {
	    QBitmap bm = new QBitmap(img.createAlphaMask());
	    p.setMask( bm );
	} else {
	    QBitmap bm = new QBitmap(img.createHeuristicMask());
	    p.setMask( bm );
	}
    MoveMe w = new MoveMe(null,null,Qt.WStyle_Customize|Qt.WStyle_NoBorder);
    w.setBackgroundPixmap( p );
    w.setFixedSize( p.size() );
    if ( p.mask() != null )
	w.setMask( p.mask() );
    w.show();
    a.setMainWidget(w);


    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}

}
