#include "highscores.h"

#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>
#include <kapplication.h>
#include <kconfig.h>

#include "base/defines.h"


namespace KExtHighscores
{

ExtHighscores::ExtHighscores(const MainData &md)
    : Highscores(VERSION, md.homepage)
{
    setItem("level", new Item((uint)1, i18n("Level"), Qt::AlignRight));
    setItem("removed", new Item((uint)0, i18n(md.removedLabel),
                                Qt::AlignRight));
}

void ExtHighscores::convertLegacy(uint)
{
    KConfigGroupSaver cg(kapp->config(), "High Scores");
    for (uint i=0; i<10; i++) {
        QString name
            = cg.config()->readEntry(QString("name%1").arg(i), QString::null);
        if ( name.isNull() ) break;
        if ( name.isEmpty() ) name = i18n("anonymous");
        uint score
            = cg.config()->readUnsignedNumEntry(QString("score%1").arg(i), 0);
        uint level
            = cg.config()->readUnsignedNumEntry(QString("level%1").arg(i), 1);
        Score s(Won);
        s.setData("score", score);
        s.setData("name", name);
        s.setData("level", level);
        submitLegacyScore(s);
    }
}

bool ExtHighscores::isStrictlyLess(const Score &s1, const Score &s2) const
{
    uint l1 = s1.data("level").toUInt();
    uint r1 = s1.data("removed").toUInt();
    uint l2 = s2.data("level").toUInt();
    uint r2 = s2.data("removed").toUInt();

    if ( s1.score()==s2.score() ) {
        if ( l1==l2 ) return r1<r2;
        else return l1<l2;
    } else return Highscores::isStrictlyLess(s1, s2);
}

void ExtHighscores::additionnalQueryItems(KURL &url, const Score &s) const
{
    uint l = s.data("level").toUInt();
    addToQueryURL(url, "scoreLevel", QString::number(l));
    uint r = s.data("removed").toUInt();
    addToQueryURL(url, "scoreRemoved", QString::number(r));
}

}; // namespace
