    /*

    Copyright (C) 2000 Stefan Westerfeld
                       stefan@space.twc.de
                  2001 Matthias Kretz
                       kretz@kde.org

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
  
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
   
    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

    */

#include "kcombobox_impl.h"
#include "kcombobox_impl.moc"
#include "anyref.h"
#include "stdio.h"

#include <qstring.h>

using namespace Arts;
using namespace std;

ComboBoxIntMapper::ComboBoxIntMapper(KComboBox_impl *impl, KComboBox *co)
	:impl(impl)
{
	connect(co, SIGNAL(activated(const QString &)), this, SLOT(activated(const QString &)));
}

void ComboBoxIntMapper::activated(const QString & newValue)
{
	impl->value(string(newValue.local8Bit()));
}

KComboBox_impl::KComboBox_impl(KComboBox *newKComboBox)
	: KWidget_impl(m_combobox = (newKComboBox?newKComboBox:new KComboBox))
{
	//m_combobox->setRange(0,100);
	new ComboBoxIntMapper(this, m_combobox);
}

string KComboBox_impl::caption()
{
	return m_caption;
}

void KComboBox_impl::caption(const string& newCaption)
{
	m_caption = newCaption;
	// FIXME: do something with the caption here
}

vector<string> * KComboBox_impl::choices()
{
	return new vector<string>(m_choices);
}

void KComboBox_impl::choices(const vector<string> & newChoices)
{
	if(newChoices != m_choices)
	{
		m_choices = newChoices;
		m_combobox->clear();
		for(vector<string>::const_iterator it = m_choices.begin(); it != m_choices.end(); ++it)
		{
			m_combobox->insertItem(QString(it->c_str()));
		}
		if(visible())
			choices_changed(newChoices);
	}
}

string KComboBox_impl::value()
{
	return m_value;
}

void KComboBox_impl::value(const string & newValue)
{
	if(newValue != m_value)
	{
		m_value = newValue;
		for(unsigned int i = 0; i < m_choices.size(); ++i)
		{
			if(m_choices[i] == newValue)
				m_combobox->setCurrentItem(i);
		}
		if(visible())
			value_changed(newValue);
	}
}
	
REGISTER_IMPLEMENTATION(KComboBox_impl);
