/* 
   Copyright (c) 2001 Nikolas Zimmermann <wildfox@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.


   This is a modified version of QXEmbed from Troll Tech.  It's been modified
   to work better with ActiveX controls.
*/

#ifndef VIDEOEMBED_H
#define VIDEOEMBED_H

#include <qwidget.h>

class QLabel;

class VideoEmbed : public QWidget
{
Q_OBJECT
public:
	VideoEmbed(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~VideoEmbed();

	void embed(WId w);
	bool embedded() { if(window != 0) return true; else return false; }

	QSize sizeHint() const;
	QSize minimumSizeHint() const;
	QSizePolicy sizePolicy() const;

	bool eventFilter(QObject *, QEvent *);

protected:
	bool event(QEvent *);

	void focusInEvent(QFocusEvent *);
	void focusOutEvent(QFocusEvent *);
	void resizeEvent(QResizeEvent *);

	bool x11Event(XEvent *);

	bool focusNextPrevChild(bool next);

private:
	WId window;
};


#endif
