/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef PROCESSOUTPUT_H
#define PROCESSOUTPUT_H

#include <qvariant.h>
#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QGroupBox;
class QLabel;
class QProgressBar;
class QPushButton;
class QTextEdit;

class ProcessOutput : public QDialog {
    Q_OBJECT

public:
    ProcessOutput( QWidget* parent = 0, const char* name = 0, bool modal = true, WFlags fl = 0 );
    ~ProcessOutput();

    QGroupBox* GroupBox;
    QLabel* StatusLabel;
    QProgressBar* WriteProgress;
    QLabel* BufferLabel;
    QProgressBar* BufferProgress;
    QTextEdit* Output;
    QPushButton* QPushButton_OK;


protected:
    QVBoxLayout* ProcessOutputLayout;
    QVBoxLayout* GroupBoxLayout;
    QHBoxLayout* Layout17;
    QHBoxLayout* Layout18;
    QHBoxLayout* Layout20;
    QVBoxLayout* Layout19;
    QHBoxLayout* Layout8;
    QHBoxLayout* Layout1;
};

#endif // PROCESSOUTPUT_H
