#ifndef MESSAGEEDITOR_H
#define MESSAGEEDITOR_H

#include <kdialogbase.h>

class QComboBox;
class QTextEdit;

class MessageEditor : public KDialogBase {
    Q_OBJECT
  public:
    MessageEditor( QWidget *parent );

  protected slots:
    void slotOk();

  private slots:
    void addButton();
    void removeButton();
    void changeMessage();
    void saveMessage();
    void updateMessage();
    void updateConfig();
    
  private:
    QComboBox *mSelectionCombo;
    QTextEdit *mMessageEdit;
    
    QString mCurrentButton;
    QMap <QString,QString> mMessageButtons;
};

#endif
