#include "kaphorism.h"
#include <qapplication.h>
#include <qfontdialog.h>
#include <qcursor.h>

class spruch_child : public QLabel
{
  friend class spruch_widget;
  private:
    spruch_widget *parent;
  public:
    spruch_child(spruch_widget *); 
   ~spruch_child();
  protected:
    virtual void mouseReleaseEvent(QMouseEvent *e);
  public:
    void spruchMouse(QMouseEvent *e) { mouseReleaseEvent(e); }
};  

spruch_child::spruch_child(spruch_widget *p)
  : QLabel(p)
{
  parent=p;
}

spruch_child::~spruch_child()
{
}

void spruch_child::mouseReleaseEvent(QMouseEvent *e)
{
  if (e->button()==1) {
    parent->mouseClose(e);
  }
  else {QString face;
        int     size,weight;
        bool    italic;

    {KSimpleConfig conf("kaphorism.rc");
     conf.setGroup("font");
     face=conf.readEntry("face","times");
     size=conf.readNumEntry("size",24);
     weight=conf.readNumEntry("weight",QFont::Normal);
     italic=conf.readBoolEntry("italic",false);
    }

    {bool ok;
     QFont font(face,size,weight,italic);
       font=QFontDialog::getFont(&ok,font,this);
       if (ok) {
          face=font.family();
          size=font.pointSize();
          weight=font.weight();
          italic=font.italic();
          {KSimpleConfig conf("kaphorism.rc");
           conf.setGroup("font");
           conf.writeEntry("face",face);
           conf.writeEntry("size",size);
           conf.writeEntry("weight",weight);
           conf.writeEntry("italic",italic);
          }
          {QString s,a;
            s=text().stripWhiteSpace();
            a=parent->author->text();
            parent->layoutSpreuk(s,a);
            parent->update();
          }
       }
    }
  }
}

spruch_widget::spruch_widget(QWidget *parent, QString spreuk, QString auth,kaphorism_widget *w)
   : 
   QLabel(parent, "Spreuk", WStyle_Customize | WStyle_StaysOnTop |
                            WStyle_NoBorderEx
         )
{
  aphorism=w;
  author=NULL;
  spruch=NULL;
  font=NULL;
  authorFont=NULL;
  layoutSpreuk(spreuk,auth);
}

spruch_widget::~spruch_widget()
{
  delete font;
  delete authorFont;
  delete author;
  delete spruch;
}

void spruch_widget::layoutSpreuk(QString & spreuk,QString & auth)
{
int     size,weight;
QString face;
bool    italic;

  KSimpleConfig conf("kaphorism.rc");
  conf.setGroup("font");
  face=conf.readEntry("face","times");
  size=conf.readNumEntry("size",24);
  weight=conf.readNumEntry("weight",QFont::Normal);
  italic=conf.readBoolEntry("italic",false);

  setFrameStyle(QFrame::Panel| QFrame::Raised);
  setLineWidth(4);

  spreuk+="\n";
  if (spruch==NULL) { spruch=new spruch_child(this); }
  if (font!=NULL) { delete font; }
  font=new QFont(face,size,weight,italic);
  spruch->setFont(*font);
  spruch->setMargin(15);
  spruch->setText(spreuk);
  spruch->setBackgroundColor(colorGroup().base());
  spruch->adjustSize();
  spruch->move(6,6);

  setText(spreuk);
  setFont(*font);
  setMargin(17);
  adjustSize();

  QRect desk = QApplication::desktop()->screenGeometry(QApplication::desktop()->screenNumber(QCursor::pos()));
  move(desk.center().x() - width()/2, desk.center().y() - height()/2);

  if (author==NULL) { author=new QLabel(this); }
  author->setText(auth);
  if (authorFont!=NULL) { delete authorFont; }
  authorFont=new QFont(face,(size*3)/4,weight,!italic);
  author->setFont(*authorFont);
  author->setBackgroundColor(colorGroup().base());
  author->adjustSize();

  author->move(width()-author->width()-15,height()-author->height()-20);
}

void spruch_widget::mouseClose(QMouseEvent *e)
{
  if (e->button()==1) {
    aphorism->closed=true;
    close();
  }
}

void spruch_widget::mouseReleaseEvent(QMouseEvent *e)
{
  spruch->spruchMouse(e);
}
