/*
 * main.cpp
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "kfortunewindow.h"

int main(int argc, char **argv)
{
	KAboutData aboutData("kfortune", I18N_NOOP("KFortune"), "0.1",
	                     I18N_NOOP("Shows your daily fortune"),
	                     KAboutData::License_BSD, "(c) 2001 Frerich Raabe");
	aboutData.addAuthor("Frerich Raabe", I18N_NOOP("Original author"), "raabe@kde.org");
	aboutData.addCredit("Pieter Eendebak", I18N_NOOP("Original version for KDE 1"), "pte@ddsw.nl");
	aboutData.addCredit("Ian Reinhart Geiser", I18N_NOOP("Initial idea, little fixes."), "geiseri@kde.org");
	
	KCmdLineArgs::init(argc, argv, &aboutData);

	KApplication app;
	app.dcopClient()->attach();
	app.dcopClient()->registerAs("kfortune");
	
	KFortuneWindow *view = new KFortuneWindow;
	app.setMainWidget(view);

	view->show();
	
	return app.exec();
}
// vim:ts=4:sw=4:noet
