#include <kconfig.h>
#include <klineedit.h>
#include <kcolorbutton.h>
#include <kpushbutton.h>
#include <kfontcombo.h>
#include <knuminput.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <kglobalsettings.h>
#include "mainwidget.h"
#include "../kab_mkIII/kab3global.h"


KcmKabMainWidget::KcmKabMainWidget(QWidget *parent, const char *name)
    : KcmKabMainWidgetBase(parent, name)
{
}

void KcmKabMainWidget::configure(KConfig* config)
{
    // @todo: save and load font settings
    config->setGroup(ConfigGeneral);
    cbRememberLastEntry->setChecked
        (config->readBoolEntry(ConfigGeneral_RememberLastContact, true));
    cbContactInHeader->setChecked
        (config->readBoolEntry(ConfigGeneral_ShowContactInHeader, true));

    config->setGroup(ConfigView);
    kleBGTile->setText(config->readEntry(
        ConfigView_DefaultBackgroundImage, "konqueror/tiles/kenwimer.png"));
    rbBGPattern->setChecked
        (config->readBoolEntry(ConfigView_UseDefaultBackground, true));
    rbBGColor->setChecked(!rbBGPattern->isChecked());
    kcbBGColor->setColor
        (config->readColorEntry(ConfigView_DefaultBackgroundColor, &white));
    cbHeadlineColor->setChecked
        (config->readBoolEntry(ConfigView_UseHeadlineBGColor, true));
    kcbHeadlineBGColor->setColor
        (config->readColorEntry(ConfigView_HeadlineBGColor, &darkBlue));
    kcbHeadlineBGColor->setEnabled(cbHeadlineColor->isChecked());
    cbStandardFonts->setChecked
        (config->readBoolEntry(ConfigView_UseKDEDefaultFonts, true));\
    kcbBGColor->setEnabled(rbBGColor->isChecked());
    kleBGTile->setEnabled(rbBGPattern->isChecked());
    kpbBGTile->setEnabled(rbBGPattern->isChecked());
    kcbHeadlineTextColor->setColor
        (config->readColorEntry(ConfigView_HeadlineTextColor, &yellow));
    kcbHeadlineTextColor->setEnabled(cbHeadlineColor->isChecked());
    // ---- the fonts:
    QFont qfontHeadline=KGlobalSettings::windowTitleFont();
    QFont qfontBody=KGlobalSettings::generalFont();
    QFont qfontDetails=KGlobalSettings::generalFont();
    kfcHeadlineFont->setFont
        (config->readFontEntry(ConfigView_HeadlineFont, &qfontHeadline));
    kisbHeadlineFontSize->setValue(kfcHeadlineFont->font().pointSize());
    kfcBodyFont->setFont
        (config->readFontEntry(ConfigView_BodyFont, &qfontBody));
    kisbBodyFontSize->setValue(kfcBodyFont->font().pointSize());
    kfcDetailsFont->setFont
        (config->readFontEntry(ConfigView_DetailsFont, &qfontDetails));
    kisbDetailsFontSize->setValue(kfcDetailsFont->font().pointSize());
}

void KcmKabMainWidget::commit(KConfig* config)
{
    // we save in the view group here:
    config->setGroup(ConfigView);
    config->writeEntry(ConfigView_DefaultBackgroundImage, kleBGTile->text());
    config->writeEntry(ConfigView_UseDefaultBackground, rbBGPattern->isChecked());
    config->writeEntry(ConfigView_DefaultBackgroundColor, kcbBGColor->color());
    config->writeEntry(ConfigView_HeadlineBGColor, kcbHeadlineBGColor->color());
    config->writeEntry(ConfigView_UseHeadlineBGColor, cbHeadlineColor->isChecked());
    config->writeEntry(ConfigView_UseKDEDefaultFonts,cbStandardFonts->isChecked());
    config->writeEntry(ConfigView_HeadlineTextColor, kcbHeadlineTextColor->color());
    // the fonts:
    QFont qfontHeadline=kfcHeadlineFont->currentFont();
    qfontHeadline.setPointSize(kisbHeadlineFontSize->value());
    QFont qfontBody=kfcBodyFont->currentFont();
    qfontBody.setPointSize(kisbBodyFontSize->value());
    QFont qfontDetails=kfcDetailsFont->currentFont();
    qfontDetails.setPointSize(kisbDetailsFontSize->value());
    config->writeEntry(ConfigView_HeadlineFont, qfontHeadline);
    config->writeEntry(ConfigView_BodyFont, qfontBody);
    config->writeEntry(ConfigView_DetailsFont, qfontDetails);
}

#include "mainwidget.moc"

