#ifndef PIECE_H
#define PIECE_H

#include "base/piece.h"


class FEPieceInfo : public GPieceInfo
{
 public:
	FEPieceInfo() {}

	uint nbBlocks() const { return NB_BLOCKS; }
	uint nbForms()  const { return 1; }
	uint nbTypes()  const { return NB_NORM_BLOCK_TYPES * NB_NORM_BLOCK_TYPES; }

	const int *i(uint, uint rot) const            { return FORM.i[rot]; }
	const int *j(uint, uint rot) const            { return FORM.j[rot]; }
	uint value(uint type, uint n) const { return (n%2 ? type/4 : type%4); }
	uint form(uint) const               { return 0; }
	uint nbConfigurations(uint type) const
		{ return ((type%4)==(type/4) ? 2 : 4);}

	uint nbNormalBlockTypes() const  { return NB_NORM_BLOCK_TYPES; }
    uint nbGarbageBlockTypes() const { return 1; }
	uint nbBlockModes() const        { return NB_BLOCK_MODES; }

 private:
    void draw(QPixmap *, uint blockType, uint blockMode, bool lighted) const;
    void setMask(QPixmap *, uint blockMode) const;

    enum { NB_BLOCKS = 2,
           NB_NORM_BLOCK_TYPES = 4, 
           NB_BLOCK_MODES = 1+4+6+4+1 };  // all possible connections

    struct Form {
        int i[4][NB_BLOCKS];
        int j[4][NB_BLOCKS];
    };
    static const Form FORM;
    static const QColor COLORS[NB_NORM_BLOCK_TYPES + 1];
};

#endif
