/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "editcmd.h"
#include <qregexp.h>

EditCommand::EditCommand()
           :_part(Undef),
            _index(-1)
{
}


BeginCommand::BeginCommand()
             : EditCommand()
{
}

EndCommand::EndCommand()
           : EditCommand()
{
}

   // have to handle deletion of current selection
DelTextCmd::DelTextCmd(int _offset, const QString &_str )
	  : EditCommand(),
	  offset( _offset ),
	  str ( _str )
{
}

bool DelTextCmd::merge( EditCommand* other)
{
   if(other->terminator()!=0)
      return false;

   DelTextCmd* o = (DelTextCmd*)other;

   if ( o->index() == index() && o->part() == part()
            && o->type() == type() )
   {
      DelTextCmd* o = (DelTextCmd*) other;
      if ( offset + int(str.length()) == o->offset && !str.contains(QRegExp("^\\s$")) )
      {
	 o->str.prepend( str );
	 o->offset = offset;
	 return true;
      }
   }
   return false;
}



InsTextCmd::InsTextCmd(int offset,const QString &str )
	  : DelTextCmd( offset, str )
{
}

bool InsTextCmd::merge( EditCommand* other)
{
   if(other->terminator()!=0)
      return false;

   DelTextCmd* o = (DelTextCmd*)other;

   if ( o->index()==index() && o->part() == part()
           && o->type() == type() )
   {
      if ( offset == o->offset + int(o->str.length()) && !str.contains(QRegExp("^\\s$")) )
      {
	 o->str += str;
	 return true;
      }
   }
   return false;
}

