
#include "buglistjob.h"
#include "bug.h"
#include "bugimpl.h"
#include "packageimpl.h"
#include "bugserver.h"
#include "domprocessor.h"

#include <assert.h>
#include <kdebug.h>

BugListJob::BugListJob( BugServer *server )
  : XmlBugJob( server )
{
}

BugListJob::~BugListJob()
{
}

void BugListJob::start( const Package &pkg, const QString &component )
{
    m_package = pkg;
    m_component = component;

    XmlBugJob::start( server()->bugListUrl( pkg, component ) );
}

void BugListJob::process( const QByteArray &data )
{
    QDomDocument doc;
    if ( !doc.setContent( data ) ) {
      kdDebug() << "Error parsing xml response for package "
                << m_package.name() << "." << endl;
      return;
    }
    
    QDomElement bugzilla = doc.documentElement();

    if ( bugzilla.isNull() ) {
      kdDebug() << "No document in xml response." << endl;
      return;
    }

    Bug::List bugs = dom()->parseBugList( bugzilla );
    
    emit bugListAvailable( m_package, m_component, bugs );
}

#include "buglistjob.moc"

/*
 * vim:sw=4:ts=4:et
 */
