/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: IBM Corporation
 *
 *  Copyright: 2008 by IBM Corporation
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
/*************************************************************************
 * @file
 * Global functions or include files that are needed.
 * It's all for the full filter.
 ************************************************************************/
#include <xfilter/xfglobal.hxx>
#include <xfilter/xffontfactory.hxx>
#include <xfilter/xfstylemanager.hxx>

int XFGlobal::s_nFrameID = 1;
int XFGlobal::s_nGraphID = 1;
int XFGlobal::s_nSectionID = 1;
int XFGlobal::s_nTableID = 1;
int XFGlobal::s_nNoteID = 1;
int XFGlobal::s_nStrokeDashID = 1;
int XFGlobal::s_nAreaID = 1;

//For chart object, /2005/2
int XFGlobal::s_nObjID = 1;

int XFGlobal::s_nImageID = 1;

OUString XFGlobal::GenSectionName()
{
    //give it a initial name:
    OUString sResult = "sect" + OUString::number(s_nSectionID++);
    return sResult;
}

OUString XFGlobal::GenFrameName()
{
    //give it a initial name:
    OUString sResult = "frame" + OUString::number(s_nFrameID++);
    return sResult;
}

OUString XFGlobal::GenTableName()
{
    OUString sResult = "table" + OUString::number(s_nFrameID++);
    return sResult;
}

OUString XFGlobal::GenNoteName()
{
    OUString sResult = "ftn" + OUString::number(s_nNoteID++);
    return sResult;
}

OUString XFGlobal::GenStrokeDashName()
{
    OUString sResult = "stroke dash " + OUString::number(s_nStrokeDashID++);
    return sResult;
}

OUString XFGlobal::GenAreaName()
{
    OUString sResult = "draw area" + OUString::number(s_nAreaID++);
    return sResult;
}

OUString XFGlobal::GenImageName()
{
    OUString sResult = "Graphic" + OUString::number(s_nImageID++);
    return sResult;
}

void    XFGlobal::Reset()
{
    s_nSectionID = 1;
    s_nFrameID = 1;
    s_nTableID = 1;
    s_nNoteID = 1;
    s_nStrokeDashID = 1;
    s_nAreaID = 1;
    s_nObjID = 1;
}

void    XFGlobalReset()
{
//  XFFontFactory::Reset();
//  XFStyleManager::Reset();
    XFGlobal::Reset();
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
