package charactermanaj.ui;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;

/**
 * 最後に使用したキャラクターデータディレクトリと、その履歴情報.<br>
 * @author seraphy
 */
public class RecentCharactersDir implements Serializable {
	
	private static final long serialVersionUID = -5274310741380875405L;
	
	/**
	 * ファイル名
	 */
	public static final String FILENAME = "recent-characterdirs.ser";

	/**
	 * 最後に使用したディレクトリ
	 */
	private File lastUseCharacterDir;
	
	/**
	 * 過去に使用したディレクトリ情報
	 */
	private ArrayList<File> recentCharacterDirs = new ArrayList<File>();
	
	/**
	 * ディレクトリの問い合わせ不要フラグ.
	 */
	private boolean doNotAskAgain;

	
	public ArrayList<File> getRecentCharacterDirs() {
		return recentCharacterDirs;
	}
	
	public void setLastUseCharacterDir(File lastUseCharacterDir) {
		this.lastUseCharacterDir = lastUseCharacterDir;
	}
	
	public File getLastUseCharacterDir() {
		return lastUseCharacterDir;
	}

	public void clrar() {
		doNotAskAgain = false;
		lastUseCharacterDir = null;
		recentCharacterDirs.clear();
	}
	
	public boolean isDoNotAskAgain() {
		return doNotAskAgain;
	}
	
	public void setDoNotAskAgain(boolean doNotAskAgain) {
		this.doNotAskAgain = doNotAskAgain;
	}

	public static RecentCharactersDir load() throws IOException {
		UserDataFactory factory = UserDataFactory.getInstance();
		UserData recentCharDirs =  factory.getUserData(FILENAME);
		if (recentCharDirs.exists()) {
			return (RecentCharactersDir) recentCharDirs.load();
		}
		return null;
	}
	
	public void saveRecents() throws IOException {
		if (lastUseCharacterDir != null) {
			// 既存のリストに現在の選択があれば、一旦削除する.
			Iterator<File> ite = recentCharacterDirs.iterator();
			while (ite.hasNext()) {
				File file = ite.next();
				if (lastUseCharacterDir.equals(file)) {
					ite.remove();
				}
			}
			// 現在の選択を先頭にする.
			recentCharacterDirs.add(0, lastUseCharacterDir);
		}
		UserDataFactory factory = UserDataFactory.getInstance();
		UserData recentCharDirs =  factory.getUserData(FILENAME);
		recentCharDirs.save(this);
	}
}