// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

static class Sve2Tests
{
    public static (string templateFileName, Dictionary<string, string> templateData)[] Sve2Inputs =
    {
        ("SveSimpleVecOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsSaturate_sbyte",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.AbsSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.AbsSaturate(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsSaturate_short",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.AbsSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.AbsSaturate(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsSaturate_int",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.AbsSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.AbsSaturate(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsSaturate_long",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.AbsSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.AbsSaturate(leftOp[i])"}),

        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_sbyte",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(SByte)  Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_short",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(Int16)  Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_int",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(Int32)  Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_long",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(Int64)  Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_byte",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(Byte)   Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_ushort",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_uint",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceAdd_ulong",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i])"}),

        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddEven_short_sbyte",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddEven",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddEven_int_short",                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddEven",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddEven_long_int",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddEven",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddEven_ushort_byte",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddEven",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddEven_uint_ushort",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddEven",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddEven_ulong_uint",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddEven",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AbsoluteDifferenceWideningLowerAndAddEven(first, second, third, i)"}),

        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddOdd_short_sbyte",                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddOdd",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddOdd_int_short",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddOdd",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddOdd_long_int",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddOdd",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddOdd_ushort_byte",                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddOdd",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddOdd_uint_ushort",                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddOdd",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningLowerAndAddOdd_ulong_uint",                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningLowerAndAddOdd",                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AbsoluteDifferenceWideningLowerAndAddOdd(first, second, third, i)"}),

        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningEven_short_sbyte",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningEven(left, right, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AbsoluteDifferenceWideningEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningEven_int_short",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningEven(left, right, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AbsoluteDifferenceWideningEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningEven_long_int",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningEven(left, right, i) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AbsoluteDifferenceWideningEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningEven_ushort_byte",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningEven(left, right, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AbsoluteDifferenceWideningEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningEven_uint_ushort",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningEven(left, right, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AbsoluteDifferenceWideningEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningEven_ulong_uint",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningEven(left, right, i) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AbsoluteDifferenceWideningEven(left, right, i)"}),

        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningOdd_short_sbyte",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningOdd(left, right, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AbsoluteDifferenceWideningOdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningOdd_int_short",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningOdd(left, right, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AbsoluteDifferenceWideningOdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningOdd_long_int",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningOdd(left, right, i) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AbsoluteDifferenceWideningOdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningOdd_ushort_byte",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningOdd(left, right, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AbsoluteDifferenceWideningOdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningOdd_uint_ushort",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningOdd(left, right, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AbsoluteDifferenceWideningOdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",      new Dictionary<string, string> {["TestName"] = "Sve2_AbsoluteDifferenceWideningOdd_ulong_uint",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AbsoluteDifferenceWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningOdd(left, right, i) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AbsoluteDifferenceWideningOdd(left, right, i)"}),

        ("SveVecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "Sve2_AddCarryWideningEven_uint",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddCarryWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddCarryWideningEven(firstOp, secondOp, thirdOp, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddCarryWideningEven(first, second, third, i)"}),
        ("SveVecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "Sve2_AddCarryWideningEven_ulong",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddCarryWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddCarryWideningEven(firstOp, secondOp, thirdOp, i) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AddCarryWideningEven(first, second, third, i)"}),
        ("SveVecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "Sve2_AddCarryWideningOdd_uint",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddCarryWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddCarryWideningOdd(firstOp, secondOp, thirdOp, i) != result[i]",  ["GetIterResult"] = "(UInt32) Helpers.AddCarryWideningOdd(first, second, third, i)"}),
        ("SveVecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "Sve2_AddCarryWideningOdd_ulong",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddCarryWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddCarryWideningOdd(firstOp, secondOp, thirdOp, i) != result[i]",  ["GetIterResult"] = "(UInt64) Helpers.AddCarryWideningOdd(first, second, third, i)"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingEven_sbyte_short",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingEven",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "(SByte) Helpers.AddHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingEven_short_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingEven",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingEven_int_long",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingEven",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingEven_byte_ushort",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingEven",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "(Byte) Helpers.AddHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingEven_ushort_uint",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingEven",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingEven_uint_ulong",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingEven",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddHighNarrowingEven(left, right, i)"}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingOdd_sbyte_short",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(SByte) Helpers.AddHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingOdd_short_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingOdd_int_long",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingOdd_byte_ushort",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(Byte) Helpers.AddHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingOdd_ushort_uint",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_AddHighNarrowingOdd_uint_ulong",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddHighNarrowingOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddHighNarrowingOdd(first, second, third, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddHighNarrowingOdd(first, second, third, i)"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_float",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(Single) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_double",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(Double) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_sbyte",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(SByte) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_short",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_int",                                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_long",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_byte",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(Byte) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_ushort",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_uint",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwise_ulong",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AddPairwiseSve(left, right, i)"}),

        ("SveVecBinOpDifferentRetType.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwiseWideningAndAdd_short_sbyte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwiseWideningAndAdd",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddPairwiseWideningAndAdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwiseWideningAndAdd_int_short",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwiseWideningAndAdd",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddPairwiseWideningAndAdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwiseWideningAndAdd_long_int",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwiseWideningAndAdd",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AddPairwiseWideningAndAdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwiseWideningAndAdd_ushort_byte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwiseWideningAndAdd",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddPairwiseWideningAndAdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwiseWideningAndAdd_uint_ushort",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwiseWideningAndAdd",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddPairwiseWideningAndAdd(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_AddPairwiseWideningAndAdd_ulong_uint",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddPairwiseWideningAndAdd",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AddPairwiseWideningAndAdd(left, right, i)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_sbyte_0",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",   ["NextValueMask"] = "Helpers.getMaskSByte()",    ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<sbyte>(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddRotateComplex<sbyte>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_sbyte_1",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",   ["NextValueMask"] = "Helpers.getMaskSByte()",    ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<sbyte>(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddRotateComplex<sbyte>(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_short_0",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",   ["NextValueMask"] = "Helpers.getMaskInt16()",    ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<short>(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddRotateComplex<short>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_short_1",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",   ["NextValueMask"] = "Helpers.getMaskInt16()",    ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<short>(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddRotateComplex<short>(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_int_0",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",   ["NextValueMask"] = "Helpers.getMaskInt32()",    ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<int>(firstOp, secondOp, Imm))",    ["GetVectorResult"] = "Helpers.AddRotateComplex<int>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_int_1",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",   ["NextValueMask"] = "Helpers.getMaskInt32()",    ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<int>(firstOp, secondOp, Imm))",    ["GetVectorResult"] = "Helpers.AddRotateComplex<int>(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_long_0",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["NextValueMask"] = "Helpers.getMaskInt64()",    ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<long>(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddRotateComplex<long>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_long_1",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["NextValueMask"] = "Helpers.getMaskInt64()",    ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<long>(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddRotateComplex<long>(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_byte_0",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",    ["NextValueMask"] = "Helpers.getMaskByte()",     ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<byte>(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddRotateComplex<byte>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_byte_1",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",    ["NextValueMask"] = "Helpers.getMaskByte()",     ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<byte>(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddRotateComplex<byte>(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_ushort_0",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueMask"] = "Helpers.getMaskUInt16()",   ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<ushort>(firstOp, secondOp, Imm))", ["GetVectorResult"] = "Helpers.AddRotateComplex<ushort>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_ushort_1",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueMask"] = "Helpers.getMaskUInt16()",   ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<ushort>(firstOp, secondOp, Imm))", ["GetVectorResult"] = "Helpers.AddRotateComplex<ushort>(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_uint_0",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueMask"] = "Helpers.getMaskUInt32()",   ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<uint>(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddRotateComplex<uint>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_uint_1",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueMask"] = "Helpers.getMaskUInt32()",   ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<uint>(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddRotateComplex<uint>(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_ulong_0",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueMask"] = "Helpers.getMaskUInt64()",   ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<ulong>(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddRotateComplex<ulong>(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddRotateComplex_ulong_1",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRotateComplex",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",  ["NextValueMask"] = "Helpers.getMaskUInt64()",   ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddRotateComplex<ulong>(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddRotateComplex<ulong>(first, second, Imm)"}),

        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingEven_sbyte_short",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingEven<Int16,   SByte>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                             ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingEven<Int16,   SByte>(leftOp[Helpers.NarrowIdx(i)], rightOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingEven_short_int",                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingEven<Int32,   Int16>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                             ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingEven<Int32,   Int16>(leftOp[Helpers.NarrowIdx(i)], rightOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingEven_int_long",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                        ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingEven<Int64,   Int32>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                             ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingEven<Int64,   Int32>(leftOp[Helpers.NarrowIdx(i)], rightOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingEven_byte_ushort",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                       ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingEven<UInt16,   Byte>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                             ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingEven<UInt16,   Byte>(leftOp[Helpers.NarrowIdx(i)], rightOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingEven_ushort_uint",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                       ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingEven<UInt32, UInt16>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                             ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingEven<UInt32, UInt16>(leftOp[Helpers.NarrowIdx(i)], rightOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingEven_uint_ulong",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                       ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingEven<UInt64, UInt32>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                             ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingEven<UInt64, UInt32>(leftOp[Helpers.NarrowIdx(i)], rightOp[Helpers.NarrowIdx(i)], i)"}),

        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingOdd_sbyte_short",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingOdd",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                      ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<Int16,   SByte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",            ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<Int16,   SByte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingOdd_short_int",                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingOdd",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                      ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<Int32,   Int16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",            ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<Int32,   Int16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingOdd_int_long",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingOdd",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                      ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<Int64,   Int32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",            ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<Int64,   Int32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingOdd_byte_ushort",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingOdd",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                     ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<UInt16,   Byte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",            ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<UInt16,   Byte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingOdd_ushort_uint",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingOdd",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                     ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<UInt32, UInt16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",            ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<UInt32, UInt16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_AddRoundedHighNarrowingOdd_uint_ulong",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddRoundedHighNarrowingOdd",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                     ["ConvertFunc"] = "",               ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<UInt64, UInt32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",            ["GetIterResult"] = "Helpers.AddRoundedHighNarrowingOdd<UInt64, UInt32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_sbyte",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(SByte) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_short",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Int16) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_int",                                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Int32) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_long",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Int64) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_byte",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Byte) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_ushort",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(UInt16) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_uint",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(UInt32) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_AddSaturate_ulong",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(UInt64) Helpers.AddSaturate(left[i], right[i])"}),

        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_sbyte_0",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",   ["NextValueMask"] = "Helpers.getMaskSByte()",                        ["Imm"] = "0", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_sbyte_1",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",   ["NextValueMask"] = "Helpers.getMaskSByte()",                        ["Imm"] = "1", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_short_0",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",   ["NextValueMask"] = "Helpers.getMaskInt16()",                        ["Imm"] = "0", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_short_1",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",   ["NextValueMask"] = "Helpers.getMaskInt16()",                        ["Imm"] = "1", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",  ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_int_0",                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",   ["NextValueMask"] = "Helpers.getMaskInt32()",                        ["Imm"] = "0", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",    ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_int_1",                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",   ["NextValueMask"] = "Helpers.getMaskInt32()",                        ["Imm"] = "1", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",    ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),

        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_long_0",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["NextValueMask"] = "Helpers.getMaskInt64()",                        ["Imm"] = "0", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),
        ("SveVecImmBinOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateRotateComplex_long_1",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateRotateComplex",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["NextValueMask"] = "Helpers.getMaskInt64()",                        ["Imm"] = "1", ["InvalidImm"] = "2",               ["ConvertFunc"] = "",    ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.AddSaturateRotateComplex(firstOp, secondOp, Imm))",   ["GetVectorResult"] = "Helpers.AddSaturateRotateComplex(first, second, Imm)"}),

        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithSignedAddend_byte_sbyte",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithSignedAddend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Byte) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithSignedAddend_ushort_short",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithSignedAddend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(UInt16) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithSignedAddend_uint_int",                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithSignedAddend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(UInt32) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithSignedAddend_ulong_long",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithSignedAddend",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(UInt64) Helpers.AddSaturate(left[i], right[i])"}),

        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithUnsignedAddend_sbyte_byte",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithUnsignedAddend",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(SByte) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithUnsignedAddend_short_ushort",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithUnsignedAddend",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Int16) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithUnsignedAddend_int_uint",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithUnsignedAddend",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Int32) Helpers.AddSaturate(left[i], right[i])"}),
        ("SveVecBinOpDifferentRetType.template",            new Dictionary<string, string> {["TestName"] = "Sve2_AddSaturateWithUnsignedAddend_long_ulong",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddSaturateWithUnsignedAddend",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]",              ["GetIterResult"] = "(Int64) Helpers.AddSaturate(left[i], right[i])"}),

        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_short_short_sbyte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2]) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_int_int_short",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2]) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_long_long_int",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2]) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AddWidening(left[i], right[i * 2])",}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_ushort_ushort_byte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2])!= result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_uint_uint_ushort",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2]) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_ulong_ulong_uint",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2]) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AddWidening(left[i], right[i * 2])"}),

        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_short_sbyte_sbyte",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2]) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_int_short_short",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2]) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_long_int_int",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2]) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AddWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_ushort_byte_byte",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2]) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_uint_ushort_ushort",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2]) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEven_ulong_uint_uint",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEven",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2]) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AddWidening(left[i * 2], right[i * 2])"}),

        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEvenOdd_short_sbyte",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEvenOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddWidening(left[i * 2], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEvenOdd_int_short",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEvenOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddWidening(left[i * 2], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningEvenOdd_long_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningEvenOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AddWidening(left[i * 2], right[i * 2 + 1])"}),

        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_short_short_sbyte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_int_int_short",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_long_long_int",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AddWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_ushort_ushort_byte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_uint_uint_ushort",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_ulong_ulong_uint",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AddWidening(left[i], right[i * 2 + 1])"}),

        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_short_sbyte_sbyte",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int16) Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_int_short_short",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int32) Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_long_int_int",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(Int64) Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_ushort_byte_byte",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(UInt16) Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_uint_ushort_ushort",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(UInt32) Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_AddWideningOdd_ulong_uint_uint",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "AddWideningOdd",                                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "(UInt64) Helpers.AddWidening(left[i * 2 + 1], right[i * 2 + 1])"}),

        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_sbyte",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(SByte) (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_short",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(Int16) (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_int",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(Int32) (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_long",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(Int64) (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_byte",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(Byte)  (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_ushort",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(UInt16)(firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_uint",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(UInt32)(firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),
        ("SveVecTernOpTest.template",      new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseClearXor_ulong",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseClearXor",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ConvertFunc"] = "",                                   ["ValidateIterResult"] = "result[i] != (firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))",              ["GetIterResult"] = "(UInt64)(firstOp[i] ^ (secondOp[i] &~ thirdOp[i]))"}),

        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_sbyte",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",           ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_short",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",           ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_int",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",           ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_long",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",           ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_byte",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",            ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_ushort",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",          ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_uint",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",          ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelect_ulong",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",          ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])",              ["GetIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_sbyte",                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_short",                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_int",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_long",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_byte",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_ushort",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",             ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_uint",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",             ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectLeftInverted_ulong",                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectLeftInverted",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",             ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectLeftInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_sbyte",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_short",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_int",                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_long",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_byte",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_ushort",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_uint",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_BitwiseSelectRightInverted_ulong",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "BitwiseSelectRightInverted",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.BitwiseSelectRightInverted(firstOp[i], secondOp[i], thirdOp[i])"}),

        ("SveSimpleVecOpDiffRetTypeTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ConvertToDoubleOdd_double_float",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ConvertToDoubleOdd",                                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",     ["ConvertFunc"] = "",                 ["ValidateIterResult"] = "Helpers.ConvertToDouble(firstOp[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.ConvertToDouble(left[i * 2 + 1])"}),

        ("SveSimpleVecOpDiffRetTypeTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ConvertToSingleEvenRoundToOdd_float_double",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ConvertToSingleEvenRoundToOdd",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",     ["ConvertFunc"] = "",                 ["ValidateIterResult"] = "Helpers.ConvertToSingleEvenRoundToOdd(firstOp, i) != result[i]", ["GetIterResult"] = "Helpers.ConvertToSingleEvenRoundToOdd(left, i)"}),

        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_int_sbyte_0",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_int_sbyte_1",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_int_sbyte_2",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["Imm"] = "2", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_int_sbyte_3",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["Imm"] = "3", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),

        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_long_short_0",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["Imm"] = "0", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_long_short_1",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["Imm"] = "1", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_long_short_2",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["Imm"] = "2", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),
        ("SveVecImmTernOpFirstArgTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplex_long_short_3",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplex",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["Imm"] = "3", ["InvalidImm"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplex(first[i], second, 4 * i, third, Imm)"}),

        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_0_0",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "0", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_0_1",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "1", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_0_2",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "2", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_0_3",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "3", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_1_0",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "0", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_1_1",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "1", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_1_2",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "2", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_1_3",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "3", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_2_0",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "2", ["Imm2"] = "0", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_2_1",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "2", ["Imm2"] = "1", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_2_2",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "2", ["Imm2"] = "2", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_2_3",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "2", ["Imm2"] = "3", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_3_0",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "3", ["Imm2"] = "0", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_3_1",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "3", ["Imm2"] = "1", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_3_2",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "3", ["Imm2"] = "2", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_int_sbyte_3_3",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "SByte", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "3", ["Imm2"] = "3", ["InvalidImm1"] = "4", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),

        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_0_0",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "0", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_0_1",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "1", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_0_2",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "2", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_0_3",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "0", ["Imm2"] = "3", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_1_0",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "0", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_1_1",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "1", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_1_2",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "2", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),
        ("SveVecTernOpImm2Test.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_DotProductRotateComplexBySelectedIndex_long_short_1_3",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "DotProductRotateComplexBySelectedIndex",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector", ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte", ["Op5BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskSingle()", ["Imm1"] = "1", ["Imm2"] = "3", ["InvalidImm1"] = "2", ["InvalidImm2"] = "4", ["ConvertFunc"] = "",       ["ValidateIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(firstOp[i], secondOp, 4 * i, thirdOp, Imm1 * 4, Imm2) != result[i]", ["GetIterResult"] = "Helpers.DotProductRotateComplexBySelectedIndex(first[i], second, 4 * i, third, Imm1 * 4, Imm2)"}),

        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_sbyte",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_short",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_int",                                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_long",                                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_byte",                                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_ushort",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_uint",                                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddHalving_ulong",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddHalving",                                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedAddHalving(left[i], right[i])"}),

        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_sbyte",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                          ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_short",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                          ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_int",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                          ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_long",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                          ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_byte",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                           ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_ushort",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_uint",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),
        ("SveVecBinOpTest.template",           new Dictionary<string, string> { ["TestName"] = "Sve2_FusedSubtractHalving_ulong",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedSubtractHalving",                                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ConvertFunc"] = "",                              ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i])"}),

        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_sbyte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                      ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_short",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                      ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_int",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                      ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_long",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                      ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_byte",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                       ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_ushort",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                     ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_uint",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                     ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_FusedAddRoundedHalving_ulong",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "FusedAddRoundedHalving",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                     ["ConvertFunc"] = "",                          ["ValidateIterResult"] = "result[i] != Helpers.FusedAddRoundedHalving(left[i], right[i])",                  ["GetIterResult"] = "Helpers.FusedAddRoundedHalving(leftOp[i], rightOp[i])",}),

        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_byte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_short",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_long",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_sbyte",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_uint",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorEvenOdd_ulong",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorEvenOdd",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorEvenOdd(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorEvenOdd(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_byte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_short",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_long",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_sbyte",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",               ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_uint",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),
        ("SveVecTernOpTest.template",        new Dictionary<string, string> { ["TestName"] = "Sve2_InterleavingXorOddEven_ulong",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "InterleavingXorOddEven",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",              ["ConvertFunc"] = "",        ["ValidateIterResult"] = "result[i] != Helpers.InterleavingXorOddEven(firstOp, secondOp, thirdOp)[i]",              ["GetIterResult"] = "Helpers.InterleavingXorOddEven(first, second, third)[i]"}),

        ("SveSimpleVecOpDiffRetTypeTest.template",                 new Dictionary<string, string> { ["TestName"] = "Sve2_Log2_int_float",                                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Log2",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.Log2(firstOp[i]) != result[i]",   ["GetIterResult"] = "Helpers.Log2(left[i])"}),
        ("SveSimpleVecOpDiffRetTypeTest.template",                 new Dictionary<string, string> { ["TestName"] = "Sve2_Log2_long_double",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Log2",                                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.Log2(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.Log2(left[i])"}),

        ("SveVecBinOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_MaxNumberPairwise_float",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxNumberPairwise",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxNumberPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxNumberPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_MaxNumberPairwise_double",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxNumberPairwise",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxNumberPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxNumberPairwiseSve(left, right, i)"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_float",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_double",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_sbyte",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_short",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_int",                                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_long",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_byte",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_ushort",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_uint",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MaxPairwise_ulong",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MaxPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MaxPairwiseSve(left, right, i)"}),

        ("SveVecBinOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_MinNumberPairwise_float",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinNumberPairwise",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinNumberPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinNumberPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",    new Dictionary<string, string> { ["TestName"] = "Sve2_MinNumberPairwise_double",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinNumberPairwise",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinNumberPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinNumberPairwiseSve(left, right, i)"}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_float",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_double",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_sbyte",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_short",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_int",                                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_long",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_byte",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_ushort",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_uint",                                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_MinPairwise_ulong",                                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ConvertFunc"] = "",        ["ValidateIterResult"] = "Helpers.MinPairwiseSve(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.MinPairwiseSve(left, right, i)"}),

        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddBySelectedScalar_short",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["NextValueMask"] = "Helpers.getMaskInt16()",              ["ConvertFunc"] = "",          ["Imm"] = "3",              ["InvalidImm"] = "8",            ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",                 ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddBySelectedScalar_int",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["NextValueMask"] = "Helpers.getMaskInt32()",              ["ConvertFunc"] = "",          ["Imm"] = "2",              ["InvalidImm"] = "4",            ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",                 ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddBySelectedScalar_long",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",         ["NextValueMask"] = "Helpers.getMaskInt64()",              ["ConvertFunc"] = "",          ["Imm"] = "1",              ["InvalidImm"] = "2",            ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",                 ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddBySelectedScalar_ushort",                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",     ["NextValueMask"] = "Helpers.getMaskUInt16()",             ["ConvertFunc"] = "",          ["Imm"] = "7",              ["InvalidImm"] = "8",            ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",                 ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddBySelectedScalar_uint",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueMask"] = "Helpers.getMaskUInt32()",             ["ConvertFunc"] = "",          ["Imm"] = "3",              ["InvalidImm"] = "4",            ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",                 ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddBySelectedScalar_ulong",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",     ["NextValueMask"] = "Helpers.getMaskUInt64()",             ["ConvertFunc"] = "",          ["Imm"] = "0",              ["InvalidImm"] = "2",            ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",                 ["GetIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm])",}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_sbyte_0",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskSByte()",   ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<sbyte>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<sbyte>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_sbyte_1",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskSByte()",   ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<sbyte>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<sbyte>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_sbyte_2",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskSByte()",   ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<sbyte>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<sbyte>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_sbyte_3",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskSByte()",   ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<sbyte>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<sbyte>(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_short_0",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskInt16()",   ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<short>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<short>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_short_1",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskInt16()",   ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<short>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<short>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_short_2",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskInt16()",   ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<short>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<short>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_short_3",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskInt16()",   ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<short>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<short>(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_int_0",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskInt32()",   ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<int>(firstOp, secondOp, thirdOp, Imm))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<int>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_int_1",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskInt32()",   ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<int>(firstOp, secondOp, thirdOp, Imm))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<int>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_int_2",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskInt32()",   ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<int>(firstOp, secondOp, thirdOp, Imm))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<int>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_int_3",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskInt32()",   ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<int>(firstOp, secondOp, thirdOp, Imm))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<int>(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_long_0",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskInt64()",   ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<long>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<long>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_long_1",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskInt64()",   ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<long>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<long>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_long_2",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskInt64()",   ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<long>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<long>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_long_3",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskInt64()",   ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<long>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<long>(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_byte_0",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                      ["NextValueMask"] = "Helpers.getMaskByte()",    ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<byte>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<byte>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_byte_1",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                      ["NextValueMask"] = "Helpers.getMaskByte()",    ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<byte>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<byte>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_byte_2",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                      ["NextValueMask"] = "Helpers.getMaskByte()",    ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<byte>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<byte>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_byte_3",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                      ["NextValueMask"] = "Helpers.getMaskByte()",    ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<byte>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<byte>(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ushort_0",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueMask"] = "Helpers.getMaskUInt16()",  ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ushort>(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ushort>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ushort_1",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueMask"] = "Helpers.getMaskUInt16()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ushort>(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ushort>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ushort_2",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueMask"] = "Helpers.getMaskUInt16()",  ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ushort>(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ushort>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ushort_3",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                    ["NextValueMask"] = "Helpers.getMaskUInt16()",  ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ushort>(firstOp, secondOp, thirdOp, Imm))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ushort>(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_uint_0",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueMask"] = "Helpers.getMaskUInt32()",  ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<uint>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<uint>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_uint_1",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueMask"] = "Helpers.getMaskUInt32()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<uint>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<uint>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_uint_2",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueMask"] = "Helpers.getMaskUInt32()",  ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<uint>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<uint>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_uint_3",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                    ["NextValueMask"] = "Helpers.getMaskUInt32()",  ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<uint>(firstOp, secondOp, thirdOp, Imm))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<uint>(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ulong_0",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ulong>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ulong>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ulong_1",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ulong>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ulong>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ulong_2",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ulong>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ulong>(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplex_ulong_3",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplex",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["Op4BaseType"] = "Byte", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                    ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRotateComplex<ulong>(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplex<ulong>(first, second, third, Imm)"}),

        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_0_0",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_0_1",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_0_2",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_0_3",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_1_0",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_1_1",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_1_2",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_1_3",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_2_0",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_2_1",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_2_2",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_2_3",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_3_0",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_3_1",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_3_2",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_short_3_3",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",  ["NextValueMask"] = "Helpers.getMaskInt16()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<short>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",  ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<short>(first, second, third, Imm1, Imm2)"}),

        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_0_0",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_0_1",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "0", ["Imm2"] = "1",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_0_2",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "0", ["Imm2"] = "2",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_0_3",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "0", ["Imm2"] = "3",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_1_0",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "1", ["Imm2"] = "0",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_1_1",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "1", ["Imm2"] = "1",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_1_2",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "1", ["Imm2"] = "2",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_int_1_3",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",   ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",  ["NextValueMask"] = "Helpers.getMaskInt32()",  ["Imm1"] = "1", ["Imm2"] = "3",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<int>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",    ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<int>(first, second, third, Imm1, Imm2)"}),

        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_0_0",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_0_1",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "0", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_0_2",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "0", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_0_3",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "0", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_1_0",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "1", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_1_1",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "1", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_1_2",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "1", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_1_3",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "1", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_2_0",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "2", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_2_1",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "2", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_2_2",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "2", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_2_3",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "2", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_3_0",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "3", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_3_1",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "3", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_3_2",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "3", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_ushort_3_3",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()", ["NextValueMask"] = "Helpers.getMaskUInt16()", ["Imm1"] = "3", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<ushort>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))", ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<ushort>(first, second, third, Imm1, Imm2)"}),

        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_0_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_0_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "0", ["Imm2"] = "1",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_0_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "0", ["Imm2"] = "2",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_0_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "0", ["Imm2"] = "3",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_1_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "1", ["Imm2"] = "0",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_1_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "1", ["Imm2"] = "1",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_1_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "1", ["Imm2"] = "2",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRotateComplexBySelectedScalar_uint_1_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()", ["NextValueMask"] = "Helpers.getMaskUInt32()", ["Imm1"] = "1", ["Imm2"] = "3",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual<uint>(Helpers.MultiplyAddRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRotateComplexBySelectedScalar<uint>(first, second, third, Imm1, Imm2)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_sbyte_0",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_sbyte_1",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_sbyte_2",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_sbyte_3",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_short_0",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_short_1",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_short_2",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_short_3",     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_int_0",       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_int_1",       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_int_2",       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_int_3",       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),

        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_long_0",      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "0", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_long_1",      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_long_2",      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),
        ("SveVecImmTernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplex_long_3",      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplex",               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",  ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(firstOp, secondOp, thirdOp, Imm))",  ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplex(first, second, third, Imm)"}),

        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_0_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_0_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "0", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_0_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "0", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_0_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "0", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_1_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_1_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "1", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_1_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "1", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_1_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "1", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_2_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "1", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_2_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "2", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_2_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "2", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_2_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "2", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_3_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "3", ["Imm2"] = "0",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_3_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "3", ["Imm2"] = "1",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_3_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "3", ["Imm2"] = "2",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_short_3_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm1"] = "3", ["Imm2"] = "3",  ["InvalidImm1"] = "4", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),

        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_0_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "0", ["Imm2"] = "0",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_0_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "0", ["Imm2"] = "1",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_0_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "0", ["Imm2"] = "2",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_0_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "0", ["Imm2"] = "3",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_1_0",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "1", ["Imm2"] = "0",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_1_1",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "1", ["Imm2"] = "1",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_1_2",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "1", ["Imm2"] = "2",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),
        ("SveVecImm2TernOpVecTest.template",          new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar_int_1_3",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32", ["Op4BaseType"] = "Byte",  ["Op5BaseType"] = "Byte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm1"] = "1", ["Imm2"] = "3",  ["InvalidImm1"] = "2", ["InvalidImm2"] = "4",  ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(firstOp, secondOp, thirdOp, Imm1, Imm2))",   ["GetVectorResult"] = "Helpers.MultiplyAddRoundedDoublingSaturateHighRotateComplexBySelectedScalar(first, second, third, Imm1, Imm2)"}),

        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndAdd_short_sbyte",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndAdd_int_short",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndAdd_long_int",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndAdd_ushort_byte",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                      ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndAdd_uint_ushort",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                    ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndAdd_ulong_uint",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                    ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",}),

        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndAdd_int_short",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",      ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "1",         ["InvalidImm"] = "8",        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndAdd_long_int",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "2",         ["InvalidImm"] = "4",        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndAdd_uint_ushort",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",  ["NextValueMask"] = "Helpers.getMaskUInt32()",    ["Imm"] = "7",         ["InvalidImm"] = "8",        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndAdd_ulong_uint",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueMask"] = "Helpers.getMaskUInt64()",    ["Imm"] = "3",         ["InvalidImm"] = "4",        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",}),

        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndAdd_short_sbyte",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndAdd_int_short",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndAdd_long_int",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndAdd_ushort_byte",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndAdd_uint_ushort",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndAdd_ulong_uint",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",}),

        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndAdd_int_short",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",       ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "3",         ["InvalidImm"] = "8",    ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndAdd_long_int",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",       ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "1",         ["InvalidImm"] = "4",    ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndAdd_uint_ushort",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",   ["NextValueMask"] = "Helpers.getMaskUInt32()",    ["Imm"] = "6",         ["InvalidImm"] = "8",    ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndAdd_ulong_uint",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndAdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["NextValueMask"] = "Helpers.getMaskUInt64()",    ["Imm"] = "2",         ["InvalidImm"] = "4",    ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalar_short",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",      ["NextValueMask"] = "Helpers.getMaskInt16()",        ["ConvertFunc"] = "",          ["Imm"] = "1",        ["InvalidImm"] = "8",               ["ValidateIterResult"] = "result[i] != Helpers.Multiply(firstOp[i], secondOp[Imm])",            ["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalar_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",      ["NextValueMask"] = "Helpers.getMaskInt32()",        ["ConvertFunc"] = "",          ["Imm"] = "3",        ["InvalidImm"] = "4",               ["ValidateIterResult"] = "result[i] != Helpers.Multiply(firstOp[i], secondOp[Imm])",            ["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalar_long",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",      ["NextValueMask"] = "Helpers.getMaskInt64()",        ["ConvertFunc"] = "",          ["Imm"] = "1",        ["InvalidImm"] = "2",               ["ValidateIterResult"] = "result[i] != Helpers.Multiply(firstOp[i], secondOp[Imm])",            ["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalar_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",     ["NextValueMask"] = "Helpers.getMaskUInt16()",       ["ConvertFunc"] = "",          ["Imm"] = "7",        ["InvalidImm"] = "8",               ["ValidateIterResult"] = "result[i] != Helpers.Multiply(firstOp[i], secondOp[Imm])",            ["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalar_uint",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueMask"] = "Helpers.getMaskUInt32()",       ["ConvertFunc"] = "",          ["Imm"] = "3",        ["InvalidImm"] = "4",               ["ValidateIterResult"] = "result[i] != Helpers.Multiply(firstOp[i], secondOp[Imm])",            ["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalar_ulong",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",     ["NextValueMask"] = "Helpers.getMaskUInt64()",       ["ConvertFunc"] = "",          ["Imm"] = "1",        ["InvalidImm"] = "2",               ["ValidateIterResult"] = "result[i] != Helpers.Multiply(firstOp[i], secondOp[Imm])",            ["GetIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm])"}),

        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplySubtractBySelectedScalar_short",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",              ["NextValueMask"] = "Helpers.getMaskInt16()",                  ["ConvertFunc"] = "",          ["Imm"] = "1",        ["InvalidImm"] = "8",               ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])",            ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplySubtractBySelectedScalar_int",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",              ["NextValueMask"] = "Helpers.getMaskInt32()",                  ["ConvertFunc"] = "",          ["Imm"] = "3",        ["InvalidImm"] = "4",               ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])",            ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplySubtractBySelectedScalar_long",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",              ["NextValueMask"] = "Helpers.getMaskInt64()",                  ["ConvertFunc"] = "",          ["Imm"] = "1",        ["InvalidImm"] = "2",               ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])",            ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplySubtractBySelectedScalar_ushort",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",          ["NextValueMask"] = "Helpers.getMaskUInt16()",                 ["ConvertFunc"] = "",          ["Imm"] = "7",        ["InvalidImm"] = "8",               ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])",            ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplySubtractBySelectedScalar_uint",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",          ["NextValueMask"] = "Helpers.getMaskUInt32()",                 ["ConvertFunc"] = "",          ["Imm"] = "3",        ["InvalidImm"] = "4",               ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])",            ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplySubtractBySelectedScalar_ulong",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64",["Op4BaseType"] = "Byte",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",          ["NextValueMask"] = "Helpers.getMaskUInt64()",                 ["ConvertFunc"] = "",          ["Imm"] = "1",        ["InvalidImm"] = "2",               ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])",            ["GetIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm])"}),

        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndSubtract_short_sbyte",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["NextValueMask"] = "Helpers.getMaskInt16()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndSubtract_int_short",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["NextValueMask"] = "Helpers.getMaskInt32()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndSubtract_long_int",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["NextValueMask"] = "Helpers.getMaskInt64()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndSubtract_ushort_byte",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["NextValueMask"] = "Helpers.getMaskUInt16()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndSubtract_uint_ushort",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["NextValueMask"] = "Helpers.getMaskUInt32()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningEvenAndSubtract_ulong_uint",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["NextValueMask"] = "Helpers.getMaskUInt64()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[2 * i])"}),

        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndSubtract_int_short",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                   ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "3",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndSubtract_long_int",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                   ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "1",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndSubtract_uint_ushort",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",               ["NextValueMask"] = "Helpers.getMaskUInt32()",    ["Imm"] = "6",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEvenAndSubtract_ulong_uint",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEvenAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",               ["NextValueMask"] = "Helpers.getMaskUInt64()",    ["Imm"] = "2",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i], thirdOp[Imm])"}),

        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndSubtract_short_sbyte",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["NextValueMask"] = "Helpers.getMaskInt16()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndSubtract_int_short",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["NextValueMask"] = "Helpers.getMaskInt32()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndSubtract_long_int",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["NextValueMask"] = "Helpers.getMaskInt64()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndSubtract_ushort_byte",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["NextValueMask"] = "Helpers.getMaskUInt16()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndSubtract_uint_ushort",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["NextValueMask"] = "Helpers.getMaskUInt32()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])"}),
        ("SveVecTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyWideningOddAndSubtract_ulong_uint",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["NextValueMask"] = "Helpers.getMaskUInt64()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[2 * i + 1])"}),

        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndSubtract_int_short",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                   ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "3",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndSubtract_long_int",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                   ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "1",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndSubtract_uint_ushort",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",               ["NextValueMask"] = "Helpers.getMaskUInt32()",    ["Imm"] = "6",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])"}),
        ("SveVecImmTernOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOddAndSubtract_ulong_uint",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOddAndSubtract",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32",["Op4BaseType"] = "UInt64",["LargestVectorSize"] = "64",["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",               ["NextValueMask"] = "Helpers.getMaskUInt64()",    ["Imm"] = "2",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplySubtractWidening(firstOp[i], secondOp[2 * i + 1], thirdOp[Imm])"}),

        ("SveVecImmBinOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingBySelectedScalarSaturateHigh_short",                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                          ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "6",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm])", ["GetIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingBySelectedScalarSaturateHigh_int",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                          ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "2",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm])", ["GetIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingBySelectedScalarSaturateHigh_long",                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                          ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "1",         ["InvalidImm"] = "2",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm])", ["GetIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm])"}),

        ("SveVecBinOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingSaturateHigh_sbyte",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",              ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingSaturateHigh(left[i], right[i])",   ["GetIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingSaturateHigh_short",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",              ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingSaturateHigh(left[i], right[i])",   ["GetIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingSaturateHigh_int",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",              ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingSaturateHigh(left[i], right[i])",   ["GetIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",    new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingSaturateHigh_long",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",              ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingSaturateHigh(left[i], right[i])",   ["GetIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(leftOp[i], rightOp[i])"}),

        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningEven_short_sbyte",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                   ["NextValueMask"] = "Helpers.getMaskInt16()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i], right[2 * i])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningEven_int_short",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                   ["NextValueMask"] = "Helpers.getMaskInt32()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i], right[2 * i])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningEven_long_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                   ["NextValueMask"] = "Helpers.getMaskInt64()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i], right[2 * i])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningEven_ushort_byte",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                    ["NextValueMask"] = "Helpers.getMaskUInt16()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i], right[2 * i])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningEven_uint_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                  ["NextValueMask"] = "Helpers.getMaskUInt32()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i], right[2 * i])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningEven_ulong_uint",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                  ["NextValueMask"] = "Helpers.getMaskUInt64()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i], right[2 * i])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEven_int_short",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                          ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "3",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEven_long_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                          ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "1",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEven_uint_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                         ["NextValueMask"] = "Helpers.getMaskUInt32()",    ["Imm"] = "6",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningEven_ulong_uint",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                         ["NextValueMask"] = "Helpers.getMaskUInt64()",    ["Imm"] = "2",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i], secondOp[Imm])"}),

        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningOdd_short_sbyte",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                   ["NextValueMask"] = "Helpers.getMaskInt16()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i + 1], right[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningOdd_int_short",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                   ["NextValueMask"] = "Helpers.getMaskInt32()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i + 1], right[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningOdd_long_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                   ["NextValueMask"] = "Helpers.getMaskInt64()",                  ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i + 1], right[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningOdd_ushort_byte",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                    ["NextValueMask"] = "Helpers.getMaskUInt16()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i + 1], right[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningOdd_uint_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                  ["NextValueMask"] = "Helpers.getMaskUInt32()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i + 1], right[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyWideningOdd_ulong_uint",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                  ["NextValueMask"] = "Helpers.getMaskUInt64()",                 ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(left[2 * i + 1], right[2 * i + 1])",            ["GetIterResult"] = "Helpers.MultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOdd_int_short",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                      ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "3",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOdd_long_int",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                      ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "1",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOdd_uint_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                     ["NextValueMask"] = "Helpers.getMaskUInt32()",    ["Imm"] = "6",         ["InvalidImm"] = "8",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyBySelectedScalarWideningOdd_ulong_uint",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyBySelectedScalarWideningOdd",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                     ["NextValueMask"] = "Helpers.getMaskUInt64()",    ["Imm"] = "2",         ["InvalidImm"] = "4",     ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])",                    ["GetIterResult"] = "Helpers.MultiplyWidening(firstOp[2 * i + 1], secondOp[Imm])"}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateEven_short",                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateEven",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateEven_int",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateEven",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateEven_long",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateEven",                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2])", ["ConvertFunc"] = ""}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateEvenOdd_short",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateEvenOdd",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateEvenOdd_int",                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateEvenOdd",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateEvenOdd_long",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateEvenOdd",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[i * 2 + 1])", ["ConvertFunc"] = ""}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateOdd_short",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateOdd",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateOdd_int",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateOdd",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndAddSaturateOdd_long",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndAddSaturateOdd",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1])", ["ConvertFunc"] = ""}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateEven_short",                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateEven",                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateEven_int",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateEven",                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateEven_long",                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateEven",                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2])", ["ConvertFunc"] = ""}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateEvenOdd_short",                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateEvenOdd",                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateEvenOdd_int",                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateEvenOdd",                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateEvenOdd_long",                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateEvenOdd",                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[i * 2 + 1])", ["ConvertFunc"] = ""}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateOdd_short",                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateOdd",                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateOdd_int",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateOdd",                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningAndSubtractSaturateOdd_long",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningAndSubtractSaturateOdd",                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[i * 2 + 1])", ["ConvertFunc"] = ""}),

        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndAddSaturateEven_int",                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndAddSaturateEven",           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["Imm"] = "5", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndAddSaturateEven_long",                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndAddSaturateEven",           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["Imm"] = "1", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2], third[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndAddSaturateOdd_int",                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndAddSaturateOdd",            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["Imm"] = "6", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndAddSaturateOdd_long",                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndAddSaturateOdd",            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["Imm"] = "3", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(first[i], second[i * 2 + 1], third[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateEven_int",                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateEven",      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["Imm"] = "4", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateEven_long",                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateEven",      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2], third[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateOdd_int",                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateOdd",       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["Imm"] = "4", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateOdd_long",                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningBySelectedScalarAndSubtractSaturateOdd",       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(first[i], second[i * 2 + 1], third[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateEven_short",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateEven",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueMask"] = "Helpers.getMaskInt16()",         ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingWideningSaturate(left[i * 2], right[i * 2])",           ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2], rightOp[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateEven_int",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateEven",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueMask"] = "Helpers.getMaskInt32()",         ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingWideningSaturate(left[i * 2], right[i * 2])",           ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2], rightOp[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateEven_long",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateEven",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueMask"] = "Helpers.getMaskInt64()",         ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingWideningSaturate(left[i * 2], right[i * 2])",           ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2], rightOp[i * 2])"}),

        ("SveVecImmBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateEvenBySelectedScalar_int",                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateEvenBySelectedScalar",                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                ["Imm"] = "5", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i * 2], right[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2], rightOp[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateEvenBySelectedScalar_long",                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateEvenBySelectedScalar",                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i * 2], right[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2], rightOp[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateOdd_short",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateOdd",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueMask"] = "Helpers.getMaskInt16()",         ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingWideningSaturate(left[i * 2 + 1], right[i * 2 + 1])",   ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2 + 1], rightOp[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateOdd_int",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateOdd",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueMask"] = "Helpers.getMaskInt32()",         ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingWideningSaturate(left[i * 2 + 1], right[i * 2 + 1])",   ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2 + 1], rightOp[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateOdd_long",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateOdd",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector",     ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueMask"] = "Helpers.getMaskInt64()",         ["ConvertFunc"] = "",   ["ValidateIterResult"] = "result[i] != Helpers.MultiplyDoublingWideningSaturate(left[i * 2 + 1], right[i * 2 + 1])",   ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2 + 1], rightOp[i * 2 + 1])"}),

        ("SveVecImmBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateOddBySelectedScalar_int",                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateOddBySelectedScalar",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                ["Imm"] = "5", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i * 2 + 1], right[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2 + 1], rightOp[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmBinOpDifferentRetType.template", new Dictionary<string, string> {["TestName"] = "Sve2_MultiplyDoublingWideningSaturateOddBySelectedScalar_long",                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyDoublingWideningSaturateOddBySelectedScalar",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i * 2 + 1], right[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(leftOp[i * 2 + 1], rightOp[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingBySelectedScalarSaturateHigh_short",                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueMask"] = "Helpers.getMaskInt16()",          ["Imm"] = "4",                              ["InvalidImm"] = "8",                        ["ValidateIterResult"] = "result[i] != Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm])",                          ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingBySelectedScalarSaturateHigh_int",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueMask"] = "Helpers.getMaskInt32()",          ["Imm"] = "3",                              ["InvalidImm"] = "4",                        ["ValidateIterResult"] = "result[i] != Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm])",                          ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm])"}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingBySelectedScalarSaturateHigh_long",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueMask"] = "Helpers.getMaskInt64()",          ["Imm"] = "1",                              ["InvalidImm"] = "2",                        ["ValidateIterResult"] = "result[i] != Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm])",                          ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm])"}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndAddHigh_sbyte",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndAddHigh",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndAddHigh_short",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndAddHigh",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndAddHigh_int",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndAddHigh",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndAddHigh_long",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndAddHigh",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),

        ("SveVecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateBySelectedScalarAndAddHigh_short",                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateBySelectedScalarAndAddHigh",            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm"] = "5", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateBySelectedScalarAndAddHigh_int",                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateBySelectedScalarAndAddHigh",            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateBySelectedScalarAndAddHigh_long",                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateBySelectedScalarAndAddHigh",            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()", ["NextValueMask"] = "Helpers.getMaskInt64()", ["Imm"] = "1", ["InvalidImm"] = "2", ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndAddSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndSubtractHigh_sbyte",                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndSubtractHigh",                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndSubtractHigh_short",                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndSubtractHigh",                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndSubtractHigh_int",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndSubtractHigh",                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateAndSubtractHigh_long",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateAndSubtractHigh",                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(first[i], second[i], third[i])", ["ConvertFunc"] = ""}),
    
        ("SveVecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateBySelectedScalarAndSubtractHigh_short",                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateBySelectedScalarAndSubtractHigh",       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()", ["NextValueMask"] = "Helpers.getMaskInt16()", ["Imm"] = "5", ["InvalidImm"] = "8", ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateBySelectedScalarAndSubtractHigh_int",                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateBySelectedScalarAndSubtractHigh",       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()", ["NextValueMask"] = "Helpers.getMaskInt32()", ["Imm"] = "2", ["InvalidImm"] = "4", ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = ""}),
        ("SveVecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateBySelectedScalarAndSubtractHigh_long",                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateBySelectedScalarAndSubtractHigh",       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()", ["NextValueMask"] = "Helpers.getMaskInt64()", ["Imm"] = "1", ["InvalidImm"] = "2", ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingAndSubtractSaturateHigh(firstOp[i], secondOp[i], thirdOp[Imm])", ["ConvertFunc"] = ""}),

        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateHigh_sbyte",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ConvertFunc"] = "",                                  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateHigh_short",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ConvertFunc"] = "",                                  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateHigh_int",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ConvertFunc"] = "",                                  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Sve2_MultiplyRoundedDoublingSaturateHigh_long",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ConvertFunc"] = "",                                  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]", ["GetIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(leftOp[i], rightOp[i])"}),

        ("SveSimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_NegateSaturate_sbyte",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != Helpers.NegateSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.NegateSaturate(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_NegateSaturate_short",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != Helpers.NegateSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.NegateSaturate(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_NegateSaturate_int",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != Helpers.NegateSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.NegateSaturate(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_NegateSaturate_long",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "64",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                                    ["ValidateIterResult"] = "result[i] != Helpers.NegateSaturate(firstOp[i])", ["GetIterResult"] = "Helpers.NegateSaturate(leftOp[i])"}),

        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_PolynomialMultiply_byte",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "PolynomialMultiply",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                           ["NextValueMask"] = "Helpers.getMaskByte()",            ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.PolynomialMultiply(left[i], right[i])",                    ["GetIterResult"] = "Helpers.PolynomialMultiply(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_PolynomialMultiply_sbyte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "PolynomialMultiply",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                          ["NextValueMask"] = "Helpers.getMaskSByte()",           ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != Helpers.PolynomialMultiply(left[i], right[i])",                    ["GetIterResult"] = "Helpers.PolynomialMultiply(leftOp[i], rightOp[i])"}),

        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_PolynomialMultiplyWideningEven_ushort_byte",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "PolynomialMultiplyWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                        ["NextValueMask"] = "Helpers.getMaskUInt16()",         ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.PolynomialMultiplyWidening(left[2 * i], right[2 * i])",           ["GetIterResult"] = "Helpers.PolynomialMultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_PolynomialMultiplyWideningEven_ulong_uint",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "PolynomialMultiplyWideningEven",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                      ["NextValueMask"] = "Helpers.getMaskUInt64()",         ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.PolynomialMultiplyWidening(left[2 * i], right[2 * i])",           ["GetIterResult"] = "Helpers.PolynomialMultiplyWidening(leftOp[2 * i], rightOp[2 * i])"}),

        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_PolynomialMultiplyWideningOdd_ushort_byte",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "PolynomialMultiplyWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                        ["NextValueMask"] = "Helpers.getMaskUInt16()",         ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.PolynomialMultiplyWidening(left[2 * i + 1], right[2 * i + 1])",           ["GetIterResult"] = "Helpers.PolynomialMultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_PolynomialMultiplyWideningOdd_ulong_uint",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "PolynomialMultiplyWideningOdd",                                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                      ["NextValueMask"] = "Helpers.getMaskUInt64()",         ["ConvertFunc"] = "",          ["ValidateIterResult"] = "result[i] != Helpers.PolynomialMultiplyWidening(left[2 * i + 1], right[2 * i + 1])",           ["GetIterResult"] = "Helpers.PolynomialMultiplyWidening(leftOp[2 * i + 1], rightOp[2 * i + 1])"}),

        ("SveSimpleVecOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ReciprocalEstimate_uint",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ReciprocalEstimate",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                    ["ConvertFunc"] = "",          ["ValidateIterResult"] = "Helpers.UnsignedReciprocalEstimate(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.UnsignedReciprocalEstimate(leftOp[i])"}),
        ("SveSimpleVecOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ReciprocalSqrtEstimate_uint",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ReciprocalSqrtEstimate",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                    ["ConvertFunc"] = "",          ["ValidateIterResult"] = "Helpers.UnsignedReciprocalSqrtEstimate(firstOp[i]) != result[i]", ["GetIterResult"] = "Helpers.UnsignedReciprocalSqrtEstimate(leftOp[i])"}),

        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRounded_sbyte",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRounded",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (sbyte)Helpers.SveShiftArithmeticRounded(left[i], right[i])",               ["GetIterResult"] = "(sbyte)Helpers.SveShiftArithmeticRounded(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRounded_short",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRounded",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (short)Helpers.SveShiftArithmeticRounded(left[i], right[i])",               ["GetIterResult"] = "(short)Helpers.SveShiftArithmeticRounded(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRounded_int",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRounded",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (int)  Helpers.SveShiftArithmeticRounded(left[i], right[i])",               ["GetIterResult"] = "(int)  Helpers.SveShiftArithmeticRounded(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRounded_long",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRounded",                                               ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (long) Helpers.SveShiftArithmeticRounded(left[i], right[i])",               ["GetIterResult"] = "(long) Helpers.SveShiftArithmeticRounded(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRoundedSaturate_sbyte",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRoundedSaturate",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (sbyte)Helpers.SveShiftArithmeticRoundedSaturate(left[i], right[i])",       ["GetIterResult"] = "(sbyte)Helpers.SveShiftArithmeticRoundedSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRoundedSaturate_short",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRoundedSaturate",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (short)Helpers.SveShiftArithmeticRoundedSaturate(left[i], right[i])",       ["GetIterResult"] = "(short)Helpers.SveShiftArithmeticRoundedSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRoundedSaturate_int",                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRoundedSaturate",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (int)  Helpers.SveShiftArithmeticRoundedSaturate(left[i], right[i])",       ["GetIterResult"] = "(int)  Helpers.SveShiftArithmeticRoundedSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticRoundedSaturate_long",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticRoundedSaturate",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (long) Helpers.SveShiftArithmeticRoundedSaturate(left[i], right[i])",       ["GetIterResult"] = "(long) Helpers.SveShiftArithmeticRoundedSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticSaturate_sbyte",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticSaturate",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (sbyte)Helpers.SveShiftArithmeticSaturate(left[i], right[i])",              ["GetIterResult"] = "(sbyte)Helpers.SveShiftArithmeticSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticSaturate_short",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticSaturate",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (short)Helpers.SveShiftArithmeticSaturate(left[i], right[i])",              ["GetIterResult"] = "(short)Helpers.SveShiftArithmeticSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticSaturate_int",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticSaturate",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (int)  Helpers.SveShiftArithmeticSaturate(left[i], right[i])",              ["GetIterResult"] = "(int)  Helpers.SveShiftArithmeticSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpTest.template",       new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftArithmeticSaturate_long",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftArithmeticSaturate",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                        ["ConvertFunc"] = "",                    ["ValidateIterResult"] = "result[i] != (long) Helpers.SveShiftArithmeticSaturate(left[i], right[i])",              ["GetIterResult"] = "(long) Helpers.SveShiftArithmeticSaturate(leftOp[i], rightOp[i])"}),

        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_sbyte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",          ["NextValueMask"] = "Helpers.getMaskSByte()",        ["Imm"] = "5",        ["InvalidImm"] = "8",             ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_short",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",          ["NextValueMask"] = "Helpers.getMaskInt16()",        ["Imm"] = "12",       ["InvalidImm"] = "16",            ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_int",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",          ["NextValueMask"] = "Helpers.getMaskInt32()",        ["Imm"] = "23",       ["InvalidImm"] = "32",            ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_long",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",          ["NextValueMask"] = "Helpers.getMaskInt64()",        ["Imm"] = "63",       ["InvalidImm"] = "64",            ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_byte",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",    ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                     ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",           ["NextValueMask"] = "Helpers.getMaskByte()",         ["Imm"] = "3",        ["InvalidImm"] = "8",             ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_ushort",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",         ["NextValueMask"] = "Helpers.getMaskUInt16()",       ["Imm"] = "9",        ["InvalidImm"] = "16",            ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_uint",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",         ["NextValueMask"] = "Helpers.getMaskUInt32()",       ["Imm"] = "17",       ["InvalidImm"] = "32",            ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLeftAndInsert_ulong",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftAndInsert",                                                   ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",         ["NextValueMask"] = "Helpers.getMaskUInt64()",       ["Imm"] = "45",       ["InvalidImm"] = "64",            ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.ShiftLeftAndInsert(firstOp[i], secondOp[i], Imm)"}),

        ("SveVecBinOpDifferentTypesTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturate_byte_sbyte",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturate",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturate(left[i], right[i])",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpDifferentTypesTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturate_ushort_short",                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturate",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturate(left[i], right[i])",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpDifferentTypesTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturate_uint_int",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturate",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturate(left[i], right[i])",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturate(leftOp[i], rightOp[i])"}),
        ("SveVecBinOpDifferentTypesTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturate_ulong_long",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturate",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturate(left[i], right[i])",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturate(leftOp[i], rightOp[i])"}),

        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturateUnsigned_byte_sbyte",                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturateUnsigned",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                   ["Imm"] = "2",                             ["InvalidImm"] = "8",                                                        ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)"}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturateUnsigned_ushort_short",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturateUnsigned",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                   ["Imm"] = "14",                            ["InvalidImm"] = "16",                                                       ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)"}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturateUnsigned_uint_int",                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturateUnsigned",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                   ["Imm"] = "19",                            ["InvalidImm"] = "32",                                                       ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)"}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalSaturateUnsigned_ulong_long",                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalSaturateUnsigned",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                   ["Imm"] = "39",                            ["InvalidImm"] = "64",                                                       ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)",                           ["GetIterResult"] = "Helpers.SveShiftLeftLogicalSaturateUnsigned(firstOp[i], Imm)"}),

        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningEven_short_sbyte",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                   ["Imm"] = "7",                             ["InvalidImm"] = "8",                                                        ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",                           ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningEven_int_short",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                   ["Imm"] = "10",                            ["InvalidImm"] = "16",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",                           ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningEven_long_int",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                   ["Imm"] = "31",                            ["InvalidImm"] = "32",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",                           ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningEven_ushort_byte",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                    ["Imm"] = "2",                             ["InvalidImm"] = "8",                                                        ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",                           ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningEven_uint_ushort",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                  ["Imm"] = "2",                             ["InvalidImm"] = "16",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",                           ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningEven_ulong_uint",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningEven",                                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                  ["Imm"] = "2",                             ["InvalidImm"] = "32",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",                           ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningOdd_short_sbyte",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningOdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                   ["Imm"] = "5",                             ["InvalidImm"] = "8",                                                        ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",                         ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningOdd_int_short",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningOdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                   ["Imm"] = "15",                            ["InvalidImm"] = "16",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",                         ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningOdd_long_int",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningOdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                   ["Imm"] = "23",                            ["InvalidImm"] = "32",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",                         ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningOdd_ushort_byte",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningOdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                    ["Imm"] = "6",                             ["InvalidImm"] = "8",                                                        ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",                         ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningOdd_uint_ushort",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningOdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                  ["Imm"] = "13",                            ["InvalidImm"] = "16",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",                         ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",}),
        ("SveVecImmUnOpTest.template",                 new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLeftLogicalWideningOdd_ulong_uint",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLeftLogicalWideningOdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                  ["Imm"] = "20",                            ["InvalidImm"] = "32",                                                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",                         ["GetIterResult"] = "Helpers.ShiftLeftLogicalWidening(firstOp[2*i+1], Imm)",}),

        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLogicalRounded_byte_sbyte",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRounded",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                          ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRounded(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRounded(left[i], right[i])",}),
        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLogicalRounded_ushort_short",                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRounded",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                          ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRounded(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRounded(left[i], right[i])",}),
        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLogicalRounded_uint_int",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRounded",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                          ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRounded(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRounded(left[i], right[i])",}),
        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftLogicalRounded_ulong_long",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRounded",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                          ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRounded(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRounded(left[i], right[i])",}),

        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLogicalRoundedSaturate_byte_sbyte",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRoundedSaturate",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                      ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",}),
        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLogicalRoundedSaturate_ushort_short",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRoundedSaturate",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                      ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",}),
        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLogicalRoundedSaturate_uint_int",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRoundedSaturate",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                      ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",}),
        ("SveVecBinOpDifferentTypesTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftLogicalRoundedSaturate_ulong_long",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftLogicalRoundedSaturate",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                      ["ValidateIterResult"] = "result[i] != Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",                          ["GetIterResult"] = "Helpers.SveShiftLogicalRoundedSaturate(left[i], right[i])",}),

        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_sbyte",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",      ["NextValueMask"] = "Helpers.getMaskSByte()",             ["Imm"] = "4",                              ["InvalidImm"] = "9",                        ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_short",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",      ["NextValueMask"] = "Helpers.getMaskInt16()",             ["Imm"] = "15",                             ["InvalidImm"] = "17",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_int",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",      ["NextValueMask"] = "Helpers.getMaskInt32()",             ["Imm"] = "22",                             ["InvalidImm"] = "33",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_long",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",      ["NextValueMask"] = "Helpers.getMaskInt64()",             ["Imm"] = "40",                             ["InvalidImm"] = "65",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_byte",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",       ["NextValueMask"] = "Helpers.getMaskByte()",              ["Imm"] = "3",                              ["InvalidImm"] = "9",                        ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_ushort",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",     ["NextValueMask"] = "Helpers.getMaskUInt16()",            ["Imm"] = "13",                             ["InvalidImm"] = "17",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_uint",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["NextValueMask"] = "Helpers.getMaskUInt32()",            ["Imm"] = "29",                             ["InvalidImm"] = "33",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightAndInsert_ulong",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightAndInsert",                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",     ["NextValueMask"] = "Helpers.getMaskUInt64()",            ["Imm"] = "54",                             ["InvalidImm"] = "65",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightAndInsert(firstOp[i], secondOp[i], Imm)",}),

        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticAdd_sbyte",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticAdd",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",        ["NextValueMask"] = "Helpers.getMaskSByte()",             ["Imm"] = "4",                              ["InvalidImm"] = "9",                        ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticAdd_short",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticAdd",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",        ["NextValueMask"] = "Helpers.getMaskInt16()",             ["Imm"] = "15",                             ["InvalidImm"] = "17",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticAdd_int",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticAdd",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",        ["NextValueMask"] = "Helpers.getMaskInt32()",             ["Imm"] = "22",                             ["InvalidImm"] = "33",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",  new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticAdd_long",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticAdd",                                              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",        ["NextValueMask"] = "Helpers.getMaskInt64()",             ["Imm"] = "40",                             ["InvalidImm"] = "65",                       ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",                          ["GetIterResult"] = "Helpers.ShiftRightArithmeticAdd(firstOp[i], secondOp[i], Imm)",}),

        ("SveVecImmUnOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateEven_sbyte_short",                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateEven",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                            ["Imm"] = "4",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",                          ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateEven_short_int",                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateEven",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                            ["Imm"] = "15",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateEven<int, short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",                            ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateEven<int, short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template", new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateEven_int_long",                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateEven",                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                            ["Imm"] = "22",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateEven<long, int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",                             ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateEven<long, int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateOdd_sbyte_short",                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateOdd",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",       ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "4",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateOdd_short_int",                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateOdd",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",       ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "15",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateOdd_int_long",                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateOdd",                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",       ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "22",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string>  {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateUnsignedEven_byte_short",          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateUnsignedEven",                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",    ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "4",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedEven<short, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedEven<short, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string>  {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateUnsignedEven_ushort_int",          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateUnsignedEven",                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",    ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "12",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedEven<int, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedEven<int, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string>  {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateUnsignedEven_uint_long",           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateUnsignedEven",                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",    ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "27",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedEven<long, uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",                ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedEven<long, uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateUnsignedOdd_byte_short",           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateUnsignedOdd",                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",               ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "8",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateUnsignedOdd_ushort_int",           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateUnsignedOdd",                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",               ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "15",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticNarrowingSaturateUnsignedOdd_uint_long",            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticNarrowingSaturateUnsignedOdd",                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",               ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "12",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRounded_sbyte",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRounded",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                    ["NextValueMask"] = "Helpers.getMaskSByte()",     ["Imm"] = "8",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRounded_short",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRounded",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                    ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "8",                              ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRounded_int",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRounded",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                    ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "15",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRounded_long",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRounded",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                    ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "12",                             ["InvalidImm"] = "65",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRounded(firstOp[i], Imm)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedAdd_sbyte",                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedAdd",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",             ["NextValueMask"] = "Helpers.getMaskSByte()",     ["Imm"] = "2",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedAdd_short",                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedAdd",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",             ["NextValueMask"] = "Helpers.getMaskInt16()",     ["Imm"] = "13",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedAdd_int",                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedAdd",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",             ["NextValueMask"] = "Helpers.getMaskInt32()",     ["Imm"] = "29",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedAdd_long",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedAdd",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",             ["NextValueMask"] = "Helpers.getMaskInt64()",     ["Imm"] = "64",                             ["InvalidImm"] = "65",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedAdd(firstOp[i], secondOp[i], Imm)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateEven_sbyte_short",           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateEven",                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                ["NextValueMask"] = "Helpers.getMaskInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateEven_short_int",             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateEven",                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                ["NextValueMask"] = "Helpers.getMaskInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateEven<int,   short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateEven<int,   short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateEven_int_long",              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateEven",                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                ["NextValueMask"] = "Helpers.getMaskInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateEven<long,  int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",                 ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateEven<long,  int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateOdd_sbyte_short",             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateOdd",                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",          ["NextValueMask"] = "Helpers.getMaskInt16()",             ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateOdd_short_int",               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateOdd",                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",          ["NextValueMask"] = "Helpers.getMaskInt32()",             ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateOdd_int_long",                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateOdd",                      ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",          ["NextValueMask"] = "Helpers.getMaskInt64()",             ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven_byte_short",["Isa"] = "Sve2",      ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven",             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                      ["NextValueMask"] = "Helpers.getMaskInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven<short, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven<short, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven_ushort_int",["Isa"] = "Sve2",      ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven",             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                      ["NextValueMask"] = "Helpers.getMaskInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven<int, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven<int, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven_uint_long",["Isa"] = "Sve2",       ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven",             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                      ["NextValueMask"] = "Helpers.getMaskInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven<long,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedEven<long,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd_byte_short",["Isa"] = "Sve2",        ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd",              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                        ["NextValueMask"] = "Helpers.getMaskInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd_ushort_int",["Isa"] = "Sve2",        ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd",              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                        ["NextValueMask"] = "Helpers.getMaskInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd_uint_long",["Isa"] = "Sve2",         ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd",              ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                        ["NextValueMask"] = "Helpers.getMaskInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightArithmeticRoundedNarrowingSaturateUnsignedOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightLogicalAdd_byte",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalAdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                          ["NextValueMask"] = "Helpers.getMaskByte()",       ["Imm"] = "2",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightLogicalAdd_ushort",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalAdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                        ["NextValueMask"] = "Helpers.getMaskUInt16()",     ["Imm"] = "13",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightLogicalAdd_uint",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalAdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                        ["NextValueMask"] = "Helpers.getMaskUInt32()",     ["Imm"] = "29",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_ShiftRightLogicalAdd_ulong",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalAdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                        ["NextValueMask"] = "Helpers.getMaskUInt64()",     ["Imm"] = "64",                             ["InvalidImm"] = "65",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalAdd(firstOp[i], secondOp[i], Imm)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingEven_sbyte_short",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingEven",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                        ["NextValueMask"] = "Helpers.getMaskInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingEven_short_int",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingEven",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                        ["NextValueMask"] = "Helpers.getMaskInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingEven<int,   short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingEven<int,   short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingEven_int_long",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingEven",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                        ["NextValueMask"] = "Helpers.getMaskInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingEven<long,    int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingEven<long,    int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingEven_byte_ushort",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingEven",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                       ["NextValueMask"] = "Helpers.getMaskUInt16()",               ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingEven<ushort, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingEven<ushort, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingEven_ushort_uint",                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingEven",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                       ["NextValueMask"] = "Helpers.getMaskUInt32()",               ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingEven<uint, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingEven<uint, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingEven_uint_ulong",                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingEven",                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                       ["NextValueMask"] = "Helpers.getMaskUInt64()",               ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingEven<ulong,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingEven<ulong,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingOdd_sbyte_short",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingOdd",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",          ["NextValueMask"] = "Helpers.getMaskInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingOdd_short_int",                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingOdd",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",          ["NextValueMask"] = "Helpers.getMaskInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingOdd_int_long",                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingOdd",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",          ["NextValueMask"] = "Helpers.getMaskInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingOdd_byte_ushort",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingOdd",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",         ["NextValueMask"] = "Helpers.getMaskUInt16()",               ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingOdd_ushort_uint",                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingOdd",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",         ["NextValueMask"] = "Helpers.getMaskUInt32()",               ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalNarrowingOdd_uint_ulong",                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalNarrowingOdd",                                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",         ["NextValueMask"] = "Helpers.getMaskUInt64()",               ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRounded_byte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRounded",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",                                    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                        ["NextValueMask"] = "Helpers.getMaskByte()",                      ["Imm"] = "2",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRounded_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRounded",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                      ["NextValueMask"] = "Helpers.getMaskUInt16()",                    ["Imm"] = "13",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRounded_uint",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRounded",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                      ["NextValueMask"] = "Helpers.getMaskUInt32()",                    ["Imm"] = "29",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRounded_ulong",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRounded",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                      ["NextValueMask"] = "Helpers.getMaskUInt64()",                    ["Imm"] = "64",                             ["InvalidImm"] = "65",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRounded(firstOp[i], Imm)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedAdd_byte",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedAdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                        ["NextValueMask"] = "Helpers.getMaskByte()",                      ["Imm"] = "2",                              ["InvalidImm"] = "9",                               ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedAdd_ushort",                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedAdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                      ["NextValueMask"] = "Helpers.getMaskUInt16()",                    ["Imm"] = "13",                             ["InvalidImm"] = "17",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedAdd_uint",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedAdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                      ["NextValueMask"] = "Helpers.getMaskUInt32()",                    ["Imm"] = "29",                             ["InvalidImm"] = "33",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedAdd_ulong",                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedAdd",                                          ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                      ["NextValueMask"] = "Helpers.getMaskUInt64()",                    ["Imm"] = "64",                             ["InvalidImm"] = "65",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedAdd(firstOp[i], secondOp[i], Imm)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingEven_sbyte_short",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingEven",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",            ["NextValueMask"] = "Helpers.getMaskInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingEven<short, sbyte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingEven_short_int",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingEven",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",            ["NextValueMask"] = "Helpers.getMaskInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingEven<int,   short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingEven<int,   short>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingEven_int_long",                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingEven",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",            ["NextValueMask"] = "Helpers.getMaskInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingEven<long,    int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingEven<long,    int>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingEven_byte_ushort",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingEven",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",           ["NextValueMask"] = "Helpers.getMaskUInt16()",               ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingEven<ushort, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingEven<ushort, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingEven_ushort_uint",                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingEven",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",           ["NextValueMask"] = "Helpers.getMaskUInt32()",               ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingEven<uint, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingEven<uint, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingEven_uint_ulong",                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingEven",                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",           ["NextValueMask"] = "Helpers.getMaskUInt64()",               ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingEven<ulong,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingEven<ulong,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingOdd_sbyte_short",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingOdd",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                ["NextValueMask"] = "Helpers.getMaskInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingOdd_short_int",                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingOdd",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                ["NextValueMask"] = "Helpers.getMaskInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingOdd_int_long",                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingOdd",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                ["NextValueMask"] = "Helpers.getMaskInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingOdd_byte_ushort",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingOdd",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",               ["NextValueMask"] = "Helpers.getMaskUInt16()",               ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingOdd_ushort_uint",                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingOdd",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",               ["NextValueMask"] = "Helpers.getMaskUInt32()",               ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingOdd_uint_ulong",                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingOdd",                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",               ["NextValueMask"] = "Helpers.getMaskUInt64()",               ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingSaturateEven_byte_ushort",                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingSaturateEven",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                   ["NextValueMask"] = "Helpers.getMaskUInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingSaturateEven<ushort, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingSaturateEven<ushort, byte>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingSaturateEven_ushort_uint",                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingSaturateEven",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                   ["NextValueMask"] = "Helpers.getMaskUInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingSaturateEven<uint, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingSaturateEven<uint, ushort>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmUnOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingSaturateEven_uint_ulong",                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingSaturateEven",                        ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                   ["NextValueMask"] = "Helpers.getMaskUInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingSaturateEven<ulong,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingSaturateEven<ulong,  uint>(firstOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingSaturateOdd_byte_ushort",                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingSaturateOdd",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                           ["NextValueMask"] = "Helpers.getMaskUInt16()",                ["Imm"] = "3",                              ["InvalidImm"] = "9",                              ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingSaturateOdd_ushort_uint",                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingSaturateOdd",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                           ["NextValueMask"] = "Helpers.getMaskUInt32()",                ["Imm"] = "13",                             ["InvalidImm"] = "17",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),
        ("SveVecImmBinOpTest.template",new Dictionary<string, string> {["TestName"] = "Sve2_ShiftRightLogicalRoundedNarrowingSaturateOdd_uint_ulong",                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "ShiftRightLogicalRoundedNarrowingSaturateOdd",                         ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                           ["NextValueMask"] = "Helpers.getMaskUInt64()",                ["Imm"] = "28",                             ["InvalidImm"] = "33",                             ["ValidateIterResult"] = "result[i] != Helpers.ShiftRightLogicalRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",               ["GetIterResult"] = "Helpers.ShiftRightLogicalRoundedNarrowingSaturateOdd(firstOp[i], secondOp[Helpers.NarrowIdx(i)], Imm, i)",}),

        ("SveVecTernOpVecTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractBorrowWideningEven_uint",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractBorrowWideningEven",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.SubtractBorrowWideningEven(firstOp, secondOp, thirdOp))", ["GetVectorResult"] = "Helpers.SubtractBorrowWideningEven(first, second, third)"}), 
        ("SveVecTernOpVecTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractBorrowWideningEven_ulong",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractBorrowWideningEven",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.SubtractBorrowWideningEven(firstOp, secondOp, thirdOp))", ["GetVectorResult"] = "Helpers.SubtractBorrowWideningEven(first, second, third)"}),
        ("SveVecTernOpVecTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractBorrowWideningOdd_uint",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractBorrowWideningOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.SubtractBorrowWideningOdd(firstOp, secondOp, thirdOp))", ["GetVectorResult"] = "Helpers.SubtractBorrowWideningOdd(first, second, third)"}),
        ("SveVecTernOpVecTest.template",         new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractBorrowWideningOdd_ulong",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractBorrowWideningOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                          ["ValidateVectorResult"] = "!result.SequenceEqual(Helpers.SubtractBorrowWideningOdd(firstOp, secondOp, thirdOp))", ["GetVectorResult"] = "Helpers.SubtractBorrowWideningOdd(first, second, third)"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingEven_sbyte_short",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingEven",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingEven_short_int",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingEven",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingEven_int_long",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingEven",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingEven_byte_ushort",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingEven",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingEven_ushort_uint",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingEven",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i)"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingEven_uint_ulong",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingEven",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i) != result[i]", ["GetIterResult"] = "Helpers.SubtractHighNarrowingEven(left, right, i)"}),

        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingOdd_sbyte_short",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingOdd",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",       ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",    ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i) != result[i]",  ["GetIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingOdd_short_int",                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingOdd",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",       ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",    ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i) != result[i]",  ["GetIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingOdd_int_long",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingOdd",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",       ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",    ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i) != result[i]",  ["GetIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingOdd_byte_ushort",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingOdd",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",   ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i) != result[i]",  ["GetIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingOdd_ushort_uint",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingOdd",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",   ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i) != result[i]",  ["GetIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i)"}),
        ("SveVecTernOpFirstArgTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractHighNarrowingOdd_uint_ulong",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractHighNarrowingOdd",                                            ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",      ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",   ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i) != result[i]",  ["GetIterResult"] = "Helpers.SubtractHighNarrowingOdd(first, second, third, i)"}),

        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingEven_sbyte_short",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingEven",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                            ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<Int16,   SByte>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<Int16,   SByte>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingEven_short_int",                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingEven",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                            ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<Int32,   Int16>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<Int32,   Int16>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingEven_int_long",                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingEven",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                            ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<Int64,   Int32>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<Int64,   Int32>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingEven_byte_ushort",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingEven",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                           ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<UInt16,   Byte>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<UInt16,   Byte>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingEven_ushort_uint",                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingEven",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                           ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<UInt32, UInt16>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<UInt32, UInt16>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecBinOpDifferentRetType.template",new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingEven_uint_ulong",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingEven",                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                           ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<UInt64, UInt32>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingEven<UInt64, UInt32>(left[Helpers.NarrowIdx(i)], right[Helpers.NarrowIdx(i)], i)",}),

        ("SveVecTernOpTest.template",           new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingOdd_sbyte_short",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",             ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<Int16,   SByte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<Int16,   SByte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingOdd_short_int",                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",             ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<Int32,   Int16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<Int32,   Int16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingOdd_int_long",                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",             ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<Int64,   Int32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<Int64,   Int32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingOdd_byte_ushort",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",            ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<UInt16,   Byte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<UInt16,   Byte>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingOdd_ushort_uint",                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",            ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<UInt32, UInt16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<UInt32, UInt16>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)",}),
        ("SveVecTernOpTest.template",           new Dictionary<string, string> {["TestName"] = "Sve2_SubtractRoundedHighNarrowingOdd_uint_ulong",                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractRoundedHighNarrowingOdd",                                     ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",            ["ConvertFunc"] = "",            ["ValidateIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<UInt64, UInt32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i) != result[i]",                        ["GetIterResult"] = "Helpers.SubtractRoundedHighNarrowingOdd<UInt64, UInt32>(firstOp[i], secondOp[Helpers.NarrowIdx(i)], thirdOp[Helpers.NarrowIdx(i)], i)",}),

        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_sbyte",                                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_short",                                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_int",                                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_long",                                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_byte",                                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                  ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_ushort",                                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_uint",                                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),
        ("SveVecBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractSaturate_ulong",                                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractSaturate",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractSaturate(left[i], right[i]) != result[i]",                ["GetIterResult"] = "Helpers.SubtractSaturate(left[i], right[i])"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_short_short_sbyte",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2]) != result[i]",            ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_int_int_short",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2]) != result[i]",            ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_long_long_int",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2]) != result[i]",            ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_ushort_ushort_byte",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                  ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2]) != result[i]",            ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_uint_uint_ushort",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2]) != result[i]",            ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_ulong_ulong_uint",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2]) != result[i]",            ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2])"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_short_sbyte_sbyte",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_int_short_short",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_long_int_int",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_ushort_byte_byte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                  ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_uint_ushort_ushort",                                                                ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEven_ulong_uint_uint",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEven",                                                ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2])"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEvenOdd_short_sbyte",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEvenOdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEvenOdd_int_short",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEvenOdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningEvenOdd_long_int",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningEvenOdd",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2], right[i * 2 + 1])"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_short_short_sbyte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_int_int_short",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_long_long_int",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_ushort_ushort_byte",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                  ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_uint_uint_ushort",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_ulong_ulong_uint",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1]) != result[i]",        ["GetIterResult"] = "Helpers.SubtractWidening(left[i], right[i * 2 + 1])"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_short_sbyte_sbyte",                                                                  ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_int_short_short",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_long_int_int",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_ushort_byte_byte",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                  ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_uint_ushort_ushort",                                                                 ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOdd_ulong_uint_uint",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOdd",                                                 ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2 + 1])"}),

        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOddEven_short_sbyte",                                                                    ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOddEven",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOddEven_int_short",                                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOddEven",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2])"}),
        ("SveVecBinOpDifferentRetType.template", new Dictionary<string, string> { ["TestName"] = "Sve2_SubtractWideningOddEven_long_int",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "SubtractWideningOddEven",                                             ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                 ["ConvertFunc"] = "",  ["ValidateIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2]) != result[i]", ["GetIterResult"] = "Helpers.SubtractWidening(left[i * 2 + 1], right[i * 2])"}),

        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_byte",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",    ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                 ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                             ["ValidateEntry"] = "(third[i] < (Byte) RetElementCount * 2) ? ((third[i] < (Byte) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(Byte) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_ushort",                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt16) RetElementCount * 2) ? ((third[i] < (UInt16) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt16) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_uint",                                                                           ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt32) RetElementCount * 2) ? ((third[i] < (UInt32) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt32) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_ulong",                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt64) RetElementCount * 2) ? ((third[i] < (UInt64) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt64) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_float_uint",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt32) RetElementCount * 2) ? ((third[i] < (UInt32) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt32) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_double_ulong",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",       ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt64) RetElementCount * 2) ? ((third[i] < (UInt64) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt64) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_sbyte_byte",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                                                 ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                             ["ValidateEntry"] = "(third[i] < (Byte) RetElementCount * 2) ? ((third[i] < (Byte) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(Byte) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_short_ushort",                                                                   ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt16) RetElementCount * 2) ? ((third[i] < (UInt16) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt16) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_int_uint",                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt32) RetElementCount * 2) ? ((third[i] < (UInt32) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt32) RetElementCount])) : (result[i] != 0)"}),
        ("SveVecBinOpTupleTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookup_long_ulong",                                                                     ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookup",                                                    ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                                               ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                           ["ValidateEntry"] = "(third[i] < (UInt64) RetElementCount * 2) ? ((third[i] < (UInt64) RetElementCount) ? (result[i] != first[third[i]]) : (result[i] != second[third[i]-(UInt64) RetElementCount])) : (result[i] != 0)"}),

        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_byte",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",    ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                               ["ValidateEntry"] = "(third[i] < (Byte) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_ushort",                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16",  ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                             ["ValidateEntry"] = "(third[i] < (UInt16) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_uint",                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32",  ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                             ["ValidateEntry"] = "(third[i] < (UInt32) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_ulong",                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64",  ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                             ["ValidateEntry"] = "(third[i] < (UInt64) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_float_uint",                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Single",  ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                             ["ValidateEntry"] = "(third[i] < (UInt32) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_double_ulong",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Double",  ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                             ["ValidateEntry"] = "(third[i] < (UInt64) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_sbyte_byte",                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",   ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                               ["ValidateEntry"] = "(third[i] < (Byte) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_short_ushort",                                                      ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",   ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                             ["ValidateEntry"] = "(third[i] < (UInt16) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_int_uint",                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",   ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                             ["ValidateEntry"] = "(third[i] < (UInt32) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),
        ("SveVecTernOpValidateTest.template", new Dictionary<string, string> { ["TestName"] = "Sve2_VectorTableLookupExtension_long_ulong",                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "VectorTableLookupExtension",                                           ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",   ["Op2VectorType"] = "Vector",   ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                             ["ValidateEntry"] = "(third[i] < (UInt64) RetElementCount) ? (result[i] != second[third[i]]) : (result[i] != first[i])"}),

        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_sbyte",                                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",         ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),
        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_short",                                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),
        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_int",                                                                                          ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),
        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_long",                                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",         ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),
        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_byte",                                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",          ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),
        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_ushort",                                                                                       ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),
        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_uint",                                                                                         ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),
        ("SveVecTernOpTest.template",     new Dictionary<string, string> { ["TestName"] = "Sve2_Xor_ulong",                                                                                        ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "Xor",                                                                  ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector",    ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",        ["ConvertFunc"] = "",               ["ValidateIterResult"] = "result[i] != Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",          ["GetIterResult"] = "Helpers.Xor(firstOp[i], secondOp[i], thirdOp[i])",}),

        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_sbyte",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "SByte",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",          ["NextValueMask"] = "Helpers.getMaskSByte()",                          ["Imm"] = "8",              ["InvalidImm"] = "9",                       ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_short",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int16",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",          ["NextValueMask"] = "Helpers.getMaskInt16()",                          ["Imm"] = "12",             ["InvalidImm"] = "17",                      ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_int",                                                                               ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int32",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",          ["NextValueMask"] = "Helpers.getMaskInt32()",                          ["Imm"] = "26",             ["InvalidImm"] = "33",                      ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_long",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Int64",                                   ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",          ["NextValueMask"] = "Helpers.getMaskInt64()",                          ["Imm"] = "55",             ["InvalidImm"] = "65",                      ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_byte",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "Byte",                                    ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",           ["NextValueMask"] = "Helpers.getMaskByte()",                           ["Imm"] = "3" ,             ["InvalidImm"] = "9" ,                      ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_ushort",                                                                            ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt16",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",         ["NextValueMask"] = "Helpers.getMaskUInt16()",                         ["Imm"] = "11",             ["InvalidImm"] = "17",                      ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_uint",                                                                              ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt32",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",         ["NextValueMask"] = "Helpers.getMaskUInt32()",                         ["Imm"] = "22",             ["InvalidImm"] = "33",                      ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
        ("SveVecImmBinOpTest.template",   new Dictionary<string, string> { ["TestName"] = "Sve2_XorRotateRight_ulong",                                                                             ["Isa"] = "Sve2",          ["LoadIsa"] = "Sve2",    ["Method"] = "XorRotateRight",                                                       ["RetVectorType"] = "Vector",    ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector",    ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector",    ["Op2BaseType"] = "UInt64",                                  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",         ["NextValueMask"] = "Helpers.getMaskUInt64()",                         ["Imm"] = "45",             ["InvalidImm"] = "65",                      ["ValidateIterResult"] = "result[i] != Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",          ["GetIterResult"] = "Helpers.XorRotateRight(firstOp[i], secondOp[i], Imm)",}),
    };
}
