# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class CellArrayIterator(Object):
    r"""
    CellArrayIterator - Encapsulate traversal logic for CellArray.
    
    Superclass: Object
    
    This is iterator for thread-safe traversal of a CellArray. It
    provides random access and forward iteration. Typical usage for
    forward iteration looks like:
    
    ``` auto iter = vtk::TakeSmartPointer(cellArray->NewIterator()); for
    (iter->go_to_first_cell(); !iter->is_done_with_traversal();
    iter->go_to_next_cell()) {
      // do work with iter
      iter->get_current_cell(numcell_pts, cellPts); } ```
    
    Typical usage for random access looks like:
    
    ``` auto iter = vtk::TakeSmartPointer(cellArray->NewIterator());
    iter->get_cell_at_id(cellId, numcell_pts, cellPts); ```
    
    Here cellId is the id of the ith cell in the CellArray;numCellPts
    is the number of points defining the cell represented as IdType;
    and cellPts is a pointer to the point ids defined as IdType
    const*&.
    
    Internally the iterator may copy data from the CellArray, or
    reference the internal CellArray storage. This depends on the
    relationship of IdType to the type and structure of internal
    storage. If the type of storage is the same as IdType, and the
    storage is a single-component AOS array (i.e., a 1D array), then
    shared access to the CellArray storage is provided. Otherwise, the
    data from storage is copied into an internal iterator buffer. (Of
    course copying is slower and can result in 3-4x reduction in
    traversal performance. On the other hand, the CellArray can use
    the appropriate storage to save memory, perform zero-copy, and/or
    efficiently represent the cell connectivity information.) Note that
    referencing internal CellArray storage has implications on the
    validity of the iterator. If the underlying CellArray storage
    changes while iterating, and the iterator is referencing this
    storage, unpredictable and catastrophic results are likely - hence do
    not modify the CellArray while iterating.
    
    @sa
    CellArray
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellArrayIterator, obj, update, **traits)
    
    def _get_cell_array(self):
        return wrap_vtk(self._vtk_obj.GetCellArray())
    cell_array = traits.Property(_get_cell_array, desc=\
        r"""
        Return the CellArray object over which iteration is occurring.
        """
    )

    def get_cell_at_id(self, *args):
        """
        get_cell_at_id(self, cellId:int, numCellPts:int, cellPts:(int, ...))
            -> None
        C++: void get_cell_at_id(IdType cellId, IdType &numCellPts,
            IdType const *&cellPts)
        get_cell_at_id(self, cellId:int, cellIds:IdList) -> None
        C++: void get_cell_at_id(IdType cellId, IdList *cellIds)
        get_cell_at_id(self, cellId:int) -> IdList
        C++: IdList *get_cell_at_id(IdType cellId)
        Initialize the iterator to a specific cell and return the cell.
        Note that methods passing IdLists always copy data from the
        CellArray storage buffer into the IdList. Otherwise, a
        fastpath returning (numcell_pts,cellPts) which may return a
        pointer to internal CellArray storage is possible, if
        IdType is the same as the CellArray buffer (which is
        typical).
        """
        my_args = deref_array(args, [('int', 'int', ('int', Ellipsis)), ('int', 'vtkIdList'), ['int']])
        ret = self._wrap_call(self._vtk_obj.GetCellAtId, *my_args)
        return wrap_vtk(ret)

    def _get_current_cell(self):
        return wrap_vtk(self._vtk_obj.GetCurrentCell())
    current_cell = traits.Property(_get_current_cell, desc=\
        r"""
        Returns the definition of the current cell during forward
        traversal. Note that methods passing IdLists always copy data
        from the CellArray storage buffer into the IdList.
        Otherwise, a fastpath returning (numcell_pts,cellPts) - which may
        return a pointer to internal CellArray storage - is possible,
        if IdType is the same as the CellArray storage (which is
        typical).
        """
    )

    def get_current_cell(self, *args):
        """
        get_current_cell(self, cellSize:int, cellPoints:(int, ...)) -> None
        C++: void get_current_cell(IdType &cellSize,
            IdType const *&cellPoints)
        get_current_cell(self, ids:IdList) -> None
        C++: void get_current_cell(IdList *ids)
        get_current_cell(self) -> IdList
        C++: IdList *get_current_cell()
        Returns the definition of the current cell during forward
        traversal. Note that methods passing IdLists always copy data
        from the CellArray storage buffer into the IdList.
        Otherwise, a fastpath returning (numcell_pts,cellPts) - which may
        return a pointer to internal CellArray storage - is possible,
        if IdType is the same as the CellArray storage (which is
        typical).
        """
        my_args = deref_array(args, [('int', ('int', Ellipsis)), ['vtkIdList'], None])
        ret = self._wrap_call(self._vtk_obj.GetCurrentCell, *my_args)
        return wrap_vtk(ret)

    def _get_current_cell_id(self):
        return self._vtk_obj.GetCurrentCellId()
    current_cell_id = traits.Property(_get_current_cell_id, desc=\
        r"""
        Returns the id of the current cell during forward iteration.
        """
    )

    def go_to_cell(self, *args):
        """
        go_to_cell(self, cellId:int) -> None
        C++: void go_to_cell(IdType cellId)
        Initialize the iterator to a specific cell. This will revalidate
        the iterator if the underlying CellArray has been modified.
        This method can always be used to set the starting location for
        forward iteration, and it is also used to support random access.
        """
        ret = self._wrap_call(self._vtk_obj.GoToCell, *args)
        return ret

    def go_to_first_cell(self):
        """
        go_to_first_cell(self) -> None
        C++: void go_to_first_cell()
        The following are methods supporting forward iteration.
        
        Initialize the iterator for forward iteration. This will
        revalidate the iterator if the underlying CellArray has been
        modified.
        """
        ret = self._vtk_obj.GoToFirstCell()
        return ret
        

    def go_to_next_cell(self):
        """
        go_to_next_cell(self) -> None
        C++: void go_to_next_cell()
        Advance the forward iterator to the next cell.
        """
        ret = self._vtk_obj.GoToNextCell()
        return ret
        

    def is_done_with_traversal(self):
        """
        is_done_with_traversal(self) -> bool
        C++: bool is_done_with_traversal()
        Returns true if the iterator has completed the traversal.
        """
        ret = self._vtk_obj.IsDoneWithTraversal()
        return ret
        

    def replace_current_cell(self, *args):
        """
        replace_current_cell(self, list:IdList) -> None
        C++: void replace_current_cell(IdList *list)
        replace_current_cell(self, npts:int, pts:(int, ...)) -> None
        C++: void replace_current_cell(IdType npts, const IdType *pts)
        Specialized methods for performing operations on the
        CellArray.
        
        Replace the current cell with the ids in `list`. Note that this
        method CANNOT change the number of points in the cell, it can
        only redefine the ids (e.g. `list` must contain the same number
        of entries as the current cell's points).
        """
        my_args = deref_array(args, [['vtkIdList'], ('int', ('int', Ellipsis))])
        ret = self._wrap_call(self._vtk_obj.ReplaceCurrentCell, *my_args)
        return ret

    def reverse_current_cell(self):
        """
        reverse_current_cell(self) -> None
        C++: void reverse_current_cell()
        Reverses the order of the point ids in the current cell.
        """
        ret = self._vtk_obj.ReverseCurrentCell()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellArrayIterator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellArrayIterator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit CellArrayIterator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellArrayIterator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

