# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class LightRepresentation(WidgetRepresentation):
    r"""
    LightRepresentation - represent a Light
    
    Superclass: WidgetRepresentation
    
    The LightRepresentation is a representation for the Light. This
    representation consists of a light_position sphere with an
    automatically resized radius so it is always visible, a line between
    the light_position and the focal_point and a cone of angle cone_angle
    when using Positional.
    
    @sa
    LightWidget SphereWidget SphereRepresentation
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLightRepresentation, obj, update, **traits)
    
    positional = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get the positional flag. When set to on, a cone will be
        visible.
        """
    )

    def _positional_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPositional,
                        self.positional_)

    cone_angle = traits.Float(30.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the cone angle, in degrees, for the light. Used only when
        positional.
        """
    )

    def _cone_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConeAngle,
                        self.cone_angle)

    focal_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get the coordinates of the focal point of the light
        representation.
        """
    )

    def _focal_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFocalPoint,
                        self.focal_point)

    interaction_state = traits.Trait(0, traits.Range(0, 4, enter_set=True, auto_set=False), desc=\
        r"""
        The interaction state may be set from a widget (e.g.,
        LightWidget) or other object. This controls how the
        interaction with the widget proceeds. Normally this method is
        used as part of a handshaking process with the widget: First
        compute_interaction_state() is invoked that returns a state based
        on geometric considerations (i.e., cursor near a widget feature),
        then based on events, the widget may modify this further.
        """
    )

    def _interaction_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractionState,
                        self.interaction_state)

    light_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Set/Get the light color.
        """
    )

    def _light_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightColor,
                        self.light_color, False)

    light_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the coordinates of the position of the light
        representation.
        """
    )

    def _light_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightPosition,
                        self.light_position)

    def _get_property(self):
        return wrap_vtk(self._vtk_obj.GetProperty())
    property = traits.Property(_get_property, desc=\
        r"""
        Get the property used for all the actors
        """
    )

    _updateable_traits_ = \
    (('positional', 'GetPositional'), ('need_to_render',
    'GetNeedToRender'), ('picking_managed', 'GetPickingManaged'),
    ('dragable', 'GetDragable'), ('pickable', 'GetPickable'),
    ('use_bounds', 'GetUseBounds'), ('visibility', 'GetVisibility'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('cone_angle', 'GetConeAngle'),
    ('focal_point', 'GetFocalPoint'), ('interaction_state',
    'GetInteractionState'), ('light_color', 'GetLightColor'),
    ('light_position', 'GetLightPosition'), ('handle_size',
    'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'global_warning_display', 'need_to_render',
    'pickable', 'picking_managed', 'positional', 'use_bounds',
    'visibility', 'cone_angle', 'estimated_render_time', 'focal_point',
    'handle_size', 'interaction_state', 'light_color', 'light_position',
    'object_name', 'place_factor', 'render_time_multiplier'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LightRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LightRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['need_to_render', 'picking_managed', 'positional',
            'use_bounds', 'visibility'], [], ['cone_angle',
            'estimated_render_time', 'focal_point', 'handle_size',
            'interaction_state', 'light_color', 'light_position', 'object_name',
            'place_factor', 'render_time_multiplier']),
            title='Edit LightRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LightRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

